/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Amazon File Cache configuration for the cache that you are creating.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateFileCacheLustreConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<CreateFileCacheLustreConfiguration.Builder, CreateFileCacheLustreConfiguration> {
    private static final SdkField<Integer> PER_UNIT_STORAGE_THROUGHPUT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("PerUnitStorageThroughput")
            .getter(getter(CreateFileCacheLustreConfiguration::perUnitStorageThroughput))
            .setter(setter(Builder::perUnitStorageThroughput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerUnitStorageThroughput").build())
            .build();

    private static final SdkField<String> DEPLOYMENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeploymentType").getter(getter(CreateFileCacheLustreConfiguration::deploymentTypeAsString))
            .setter(setter(Builder::deploymentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentType").build()).build();

    private static final SdkField<String> WEEKLY_MAINTENANCE_START_TIME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("WeeklyMaintenanceStartTime")
            .getter(getter(CreateFileCacheLustreConfiguration::weeklyMaintenanceStartTime))
            .setter(setter(Builder::weeklyMaintenanceStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WeeklyMaintenanceStartTime").build())
            .build();

    private static final SdkField<FileCacheLustreMetadataConfiguration> METADATA_CONFIGURATION_FIELD = SdkField
            .<FileCacheLustreMetadataConfiguration> builder(MarshallingType.SDK_POJO).memberName("MetadataConfiguration")
            .getter(getter(CreateFileCacheLustreConfiguration::metadataConfiguration))
            .setter(setter(Builder::metadataConfiguration)).constructor(FileCacheLustreMetadataConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PER_UNIT_STORAGE_THROUGHPUT_FIELD, DEPLOYMENT_TYPE_FIELD, WEEKLY_MAINTENANCE_START_TIME_FIELD,
            METADATA_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer perUnitStorageThroughput;

    private final String deploymentType;

    private final String weeklyMaintenanceStartTime;

    private final FileCacheLustreMetadataConfiguration metadataConfiguration;

    private CreateFileCacheLustreConfiguration(BuilderImpl builder) {
        this.perUnitStorageThroughput = builder.perUnitStorageThroughput;
        this.deploymentType = builder.deploymentType;
        this.weeklyMaintenanceStartTime = builder.weeklyMaintenanceStartTime;
        this.metadataConfiguration = builder.metadataConfiguration;
    }

    /**
     * <p>
     * Provisions the amount of read and write throughput for each 1 tebibyte (TiB) of cache storage capacity, in
     * MB/s/TiB. The only supported value is <code>1000</code>.
     * </p>
     * 
     * @return Provisions the amount of read and write throughput for each 1 tebibyte (TiB) of cache storage capacity,
     *         in MB/s/TiB. The only supported value is <code>1000</code>.
     */
    public final Integer perUnitStorageThroughput() {
        return perUnitStorageThroughput;
    }

    /**
     * <p>
     * Specifies the cache deployment type, which must be <code>CACHE_1</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentType}
     * will return {@link FileCacheLustreDeploymentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #deploymentTypeAsString}.
     * </p>
     * 
     * @return Specifies the cache deployment type, which must be <code>CACHE_1</code>.
     * @see FileCacheLustreDeploymentType
     */
    public final FileCacheLustreDeploymentType deploymentType() {
        return FileCacheLustreDeploymentType.fromValue(deploymentType);
    }

    /**
     * <p>
     * Specifies the cache deployment type, which must be <code>CACHE_1</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentType}
     * will return {@link FileCacheLustreDeploymentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #deploymentTypeAsString}.
     * </p>
     * 
     * @return Specifies the cache deployment type, which must be <code>CACHE_1</code>.
     * @see FileCacheLustreDeploymentType
     */
    public final String deploymentTypeAsString() {
        return deploymentType;
    }

    /**
     * Returns the value of the WeeklyMaintenanceStartTime property for this object.
     * 
     * @return The value of the WeeklyMaintenanceStartTime property for this object.
     */
    public final String weeklyMaintenanceStartTime() {
        return weeklyMaintenanceStartTime;
    }

    /**
     * <p>
     * The configuration for a Lustre MDT (Metadata Target) storage volume.
     * </p>
     * 
     * @return The configuration for a Lustre MDT (Metadata Target) storage volume.
     */
    public final FileCacheLustreMetadataConfiguration metadataConfiguration() {
        return metadataConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(perUnitStorageThroughput());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(weeklyMaintenanceStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(metadataConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFileCacheLustreConfiguration)) {
            return false;
        }
        CreateFileCacheLustreConfiguration other = (CreateFileCacheLustreConfiguration) obj;
        return Objects.equals(perUnitStorageThroughput(), other.perUnitStorageThroughput())
                && Objects.equals(deploymentTypeAsString(), other.deploymentTypeAsString())
                && Objects.equals(weeklyMaintenanceStartTime(), other.weeklyMaintenanceStartTime())
                && Objects.equals(metadataConfiguration(), other.metadataConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateFileCacheLustreConfiguration").add("PerUnitStorageThroughput", perUnitStorageThroughput())
                .add("DeploymentType", deploymentTypeAsString()).add("WeeklyMaintenanceStartTime", weeklyMaintenanceStartTime())
                .add("MetadataConfiguration", metadataConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PerUnitStorageThroughput":
            return Optional.ofNullable(clazz.cast(perUnitStorageThroughput()));
        case "DeploymentType":
            return Optional.ofNullable(clazz.cast(deploymentTypeAsString()));
        case "WeeklyMaintenanceStartTime":
            return Optional.ofNullable(clazz.cast(weeklyMaintenanceStartTime()));
        case "MetadataConfiguration":
            return Optional.ofNullable(clazz.cast(metadataConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateFileCacheLustreConfiguration, T> g) {
        return obj -> g.apply((CreateFileCacheLustreConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CreateFileCacheLustreConfiguration> {
        /**
         * <p>
         * Provisions the amount of read and write throughput for each 1 tebibyte (TiB) of cache storage capacity, in
         * MB/s/TiB. The only supported value is <code>1000</code>.
         * </p>
         * 
         * @param perUnitStorageThroughput
         *        Provisions the amount of read and write throughput for each 1 tebibyte (TiB) of cache storage
         *        capacity, in MB/s/TiB. The only supported value is <code>1000</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder perUnitStorageThroughput(Integer perUnitStorageThroughput);

        /**
         * <p>
         * Specifies the cache deployment type, which must be <code>CACHE_1</code>.
         * </p>
         * 
         * @param deploymentType
         *        Specifies the cache deployment type, which must be <code>CACHE_1</code>.
         * @see FileCacheLustreDeploymentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileCacheLustreDeploymentType
         */
        Builder deploymentType(String deploymentType);

        /**
         * <p>
         * Specifies the cache deployment type, which must be <code>CACHE_1</code>.
         * </p>
         * 
         * @param deploymentType
         *        Specifies the cache deployment type, which must be <code>CACHE_1</code>.
         * @see FileCacheLustreDeploymentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileCacheLustreDeploymentType
         */
        Builder deploymentType(FileCacheLustreDeploymentType deploymentType);

        /**
         * Sets the value of the WeeklyMaintenanceStartTime property for this object.
         *
         * @param weeklyMaintenanceStartTime
         *        The new value for the WeeklyMaintenanceStartTime property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder weeklyMaintenanceStartTime(String weeklyMaintenanceStartTime);

        /**
         * <p>
         * The configuration for a Lustre MDT (Metadata Target) storage volume.
         * </p>
         * 
         * @param metadataConfiguration
         *        The configuration for a Lustre MDT (Metadata Target) storage volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataConfiguration(FileCacheLustreMetadataConfiguration metadataConfiguration);

        /**
         * <p>
         * The configuration for a Lustre MDT (Metadata Target) storage volume.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link FileCacheLustreMetadataConfiguration.Builder} avoiding the need to create one manually via
         * {@link FileCacheLustreMetadataConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FileCacheLustreMetadataConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #metadataConfiguration(FileCacheLustreMetadataConfiguration)}.
         * 
         * @param metadataConfiguration
         *        a consumer that will call methods on {@link FileCacheLustreMetadataConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadataConfiguration(FileCacheLustreMetadataConfiguration)
         */
        default Builder metadataConfiguration(Consumer<FileCacheLustreMetadataConfiguration.Builder> metadataConfiguration) {
            return metadataConfiguration(FileCacheLustreMetadataConfiguration.builder().applyMutation(metadataConfiguration)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Integer perUnitStorageThroughput;

        private String deploymentType;

        private String weeklyMaintenanceStartTime;

        private FileCacheLustreMetadataConfiguration metadataConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFileCacheLustreConfiguration model) {
            perUnitStorageThroughput(model.perUnitStorageThroughput);
            deploymentType(model.deploymentType);
            weeklyMaintenanceStartTime(model.weeklyMaintenanceStartTime);
            metadataConfiguration(model.metadataConfiguration);
        }

        public final Integer getPerUnitStorageThroughput() {
            return perUnitStorageThroughput;
        }

        public final void setPerUnitStorageThroughput(Integer perUnitStorageThroughput) {
            this.perUnitStorageThroughput = perUnitStorageThroughput;
        }

        @Override
        public final Builder perUnitStorageThroughput(Integer perUnitStorageThroughput) {
            this.perUnitStorageThroughput = perUnitStorageThroughput;
            return this;
        }

        public final String getDeploymentType() {
            return deploymentType;
        }

        public final void setDeploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
        }

        @Override
        public final Builder deploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
            return this;
        }

        @Override
        public final Builder deploymentType(FileCacheLustreDeploymentType deploymentType) {
            this.deploymentType(deploymentType == null ? null : deploymentType.toString());
            return this;
        }

        public final String getWeeklyMaintenanceStartTime() {
            return weeklyMaintenanceStartTime;
        }

        public final void setWeeklyMaintenanceStartTime(String weeklyMaintenanceStartTime) {
            this.weeklyMaintenanceStartTime = weeklyMaintenanceStartTime;
        }

        @Override
        public final Builder weeklyMaintenanceStartTime(String weeklyMaintenanceStartTime) {
            this.weeklyMaintenanceStartTime = weeklyMaintenanceStartTime;
            return this;
        }

        public final FileCacheLustreMetadataConfiguration.Builder getMetadataConfiguration() {
            return metadataConfiguration != null ? metadataConfiguration.toBuilder() : null;
        }

        public final void setMetadataConfiguration(FileCacheLustreMetadataConfiguration.BuilderImpl metadataConfiguration) {
            this.metadataConfiguration = metadataConfiguration != null ? metadataConfiguration.build() : null;
        }

        @Override
        public final Builder metadataConfiguration(FileCacheLustreMetadataConfiguration metadataConfiguration) {
            this.metadataConfiguration = metadataConfiguration;
            return this;
        }

        @Override
        public CreateFileCacheLustreConfiguration build() {
            return new CreateFileCacheLustreConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
