/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSharedVpcConfigurationRequest extends FSxRequest implements
        ToCopyableBuilder<UpdateSharedVpcConfigurationRequest.Builder, UpdateSharedVpcConfigurationRequest> {
    private static final SdkField<String> ENABLE_FSX_ROUTE_TABLE_UPDATES_FROM_PARTICIPANT_ACCOUNTS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("EnableFsxRouteTableUpdatesFromParticipantAccounts")
            .getter(getter(UpdateSharedVpcConfigurationRequest::enableFsxRouteTableUpdatesFromParticipantAccounts))
            .setter(setter(Builder::enableFsxRouteTableUpdatesFromParticipantAccounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("EnableFsxRouteTableUpdatesFromParticipantAccounts").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken")
            .getter(getter(UpdateSharedVpcConfigurationRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ENABLE_FSX_ROUTE_TABLE_UPDATES_FROM_PARTICIPANT_ACCOUNTS_FIELD, CLIENT_REQUEST_TOKEN_FIELD));

    private final String enableFsxRouteTableUpdatesFromParticipantAccounts;

    private final String clientRequestToken;

    private UpdateSharedVpcConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.enableFsxRouteTableUpdatesFromParticipantAccounts = builder.enableFsxRouteTableUpdatesFromParticipantAccounts;
        this.clientRequestToken = builder.clientRequestToken;
    }

    /**
     * <p>
     * Specifies whether participant accounts can create FSx for ONTAP Multi-AZ file systems in shared subnets. Set to
     * <code>true</code> to enable or <code>false</code> to disable.
     * </p>
     * 
     * @return Specifies whether participant accounts can create FSx for ONTAP Multi-AZ file systems in shared subnets.
     *         Set to <code>true</code> to enable or <code>false</code> to disable.
     */
    public final String enableFsxRouteTableUpdatesFromParticipantAccounts() {
        return enableFsxRouteTableUpdatesFromParticipantAccounts;
    }

    /**
     * Returns the value of the ClientRequestToken property for this object.
     * 
     * @return The value of the ClientRequestToken property for this object.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(enableFsxRouteTableUpdatesFromParticipantAccounts());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSharedVpcConfigurationRequest)) {
            return false;
        }
        UpdateSharedVpcConfigurationRequest other = (UpdateSharedVpcConfigurationRequest) obj;
        return Objects.equals(enableFsxRouteTableUpdatesFromParticipantAccounts(),
                other.enableFsxRouteTableUpdatesFromParticipantAccounts())
                && Objects.equals(clientRequestToken(), other.clientRequestToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateSharedVpcConfigurationRequest")
                .add("EnableFsxRouteTableUpdatesFromParticipantAccounts", enableFsxRouteTableUpdatesFromParticipantAccounts())
                .add("ClientRequestToken", clientRequestToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EnableFsxRouteTableUpdatesFromParticipantAccounts":
            return Optional.ofNullable(clazz.cast(enableFsxRouteTableUpdatesFromParticipantAccounts()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSharedVpcConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateSharedVpcConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FSxRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateSharedVpcConfigurationRequest> {
        /**
         * <p>
         * Specifies whether participant accounts can create FSx for ONTAP Multi-AZ file systems in shared subnets. Set
         * to <code>true</code> to enable or <code>false</code> to disable.
         * </p>
         * 
         * @param enableFsxRouteTableUpdatesFromParticipantAccounts
         *        Specifies whether participant accounts can create FSx for ONTAP Multi-AZ file systems in shared
         *        subnets. Set to <code>true</code> to enable or <code>false</code> to disable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableFsxRouteTableUpdatesFromParticipantAccounts(String enableFsxRouteTableUpdatesFromParticipantAccounts);

        /**
         * Sets the value of the ClientRequestToken property for this object.
         *
         * @param clientRequestToken
         *        The new value for the ClientRequestToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FSxRequest.BuilderImpl implements Builder {
        private String enableFsxRouteTableUpdatesFromParticipantAccounts;

        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSharedVpcConfigurationRequest model) {
            super(model);
            enableFsxRouteTableUpdatesFromParticipantAccounts(model.enableFsxRouteTableUpdatesFromParticipantAccounts);
            clientRequestToken(model.clientRequestToken);
        }

        public final String getEnableFsxRouteTableUpdatesFromParticipantAccounts() {
            return enableFsxRouteTableUpdatesFromParticipantAccounts;
        }

        public final void setEnableFsxRouteTableUpdatesFromParticipantAccounts(
                String enableFsxRouteTableUpdatesFromParticipantAccounts) {
            this.enableFsxRouteTableUpdatesFromParticipantAccounts = enableFsxRouteTableUpdatesFromParticipantAccounts;
        }

        @Override
        public final Builder enableFsxRouteTableUpdatesFromParticipantAccounts(
                String enableFsxRouteTableUpdatesFromParticipantAccounts) {
            this.enableFsxRouteTableUpdatesFromParticipantAccounts = enableFsxRouteTableUpdatesFromParticipantAccounts;
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSharedVpcConfigurationRequest build() {
            return new UpdateSharedVpcConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
