/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the task status showing a running total of the total number of files to be processed, the number
 * successfully processed, and the number of files the task failed to process.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataRepositoryTaskStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<DataRepositoryTaskStatus.Builder, DataRepositoryTaskStatus> {
    private static final SdkField<Long> TOTAL_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("TotalCount").getter(getter(DataRepositoryTaskStatus::totalCount)).setter(setter(Builder::totalCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalCount").build()).build();

    private static final SdkField<Long> SUCCEEDED_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("SucceededCount").getter(getter(DataRepositoryTaskStatus::succeededCount))
            .setter(setter(Builder::succeededCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SucceededCount").build()).build();

    private static final SdkField<Long> FAILED_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("FailedCount").getter(getter(DataRepositoryTaskStatus::failedCount)).setter(setter(Builder::failedCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedCount").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTime").getter(getter(DataRepositoryTaskStatus::lastUpdatedTime))
            .setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()).build();

    private static final SdkField<Long> RELEASED_CAPACITY_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ReleasedCapacity").getter(getter(DataRepositoryTaskStatus::releasedCapacity))
            .setter(setter(Builder::releasedCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReleasedCapacity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTAL_COUNT_FIELD,
            SUCCEEDED_COUNT_FIELD, FAILED_COUNT_FIELD, LAST_UPDATED_TIME_FIELD, RELEASED_CAPACITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long totalCount;

    private final Long succeededCount;

    private final Long failedCount;

    private final Instant lastUpdatedTime;

    private final Long releasedCapacity;

    private DataRepositoryTaskStatus(BuilderImpl builder) {
        this.totalCount = builder.totalCount;
        this.succeededCount = builder.succeededCount;
        this.failedCount = builder.failedCount;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.releasedCapacity = builder.releasedCapacity;
    }

    /**
     * <p>
     * The total number of files that the task will process. While a task is executing, the sum of
     * <code>SucceededCount</code> plus <code>FailedCount</code> may not equal <code>TotalCount</code>. When the task is
     * complete, <code>TotalCount</code> equals the sum of <code>SucceededCount</code> plus <code>FailedCount</code>.
     * </p>
     * 
     * @return The total number of files that the task will process. While a task is executing, the sum of
     *         <code>SucceededCount</code> plus <code>FailedCount</code> may not equal <code>TotalCount</code>. When the
     *         task is complete, <code>TotalCount</code> equals the sum of <code>SucceededCount</code> plus
     *         <code>FailedCount</code>.
     */
    public final Long totalCount() {
        return totalCount;
    }

    /**
     * <p>
     * A running total of the number of files that the task has successfully processed.
     * </p>
     * 
     * @return A running total of the number of files that the task has successfully processed.
     */
    public final Long succeededCount() {
        return succeededCount;
    }

    /**
     * <p>
     * A running total of the number of files that the task failed to process.
     * </p>
     * 
     * @return A running total of the number of files that the task failed to process.
     */
    public final Long failedCount() {
        return failedCount;
    }

    /**
     * <p>
     * The time at which the task status was last updated.
     * </p>
     * 
     * @return The time at which the task status was last updated.
     */
    public final Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * <p>
     * The total amount of data, in GiB, released by an Amazon File Cache AUTO_RELEASE_DATA task that automatically
     * releases files from the cache.
     * </p>
     * 
     * @return The total amount of data, in GiB, released by an Amazon File Cache AUTO_RELEASE_DATA task that
     *         automatically releases files from the cache.
     */
    public final Long releasedCapacity() {
        return releasedCapacity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(totalCount());
        hashCode = 31 * hashCode + Objects.hashCode(succeededCount());
        hashCode = 31 * hashCode + Objects.hashCode(failedCount());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(releasedCapacity());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataRepositoryTaskStatus)) {
            return false;
        }
        DataRepositoryTaskStatus other = (DataRepositoryTaskStatus) obj;
        return Objects.equals(totalCount(), other.totalCount()) && Objects.equals(succeededCount(), other.succeededCount())
                && Objects.equals(failedCount(), other.failedCount())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime())
                && Objects.equals(releasedCapacity(), other.releasedCapacity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataRepositoryTaskStatus").add("TotalCount", totalCount())
                .add("SucceededCount", succeededCount()).add("FailedCount", failedCount())
                .add("LastUpdatedTime", lastUpdatedTime()).add("ReleasedCapacity", releasedCapacity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TotalCount":
            return Optional.ofNullable(clazz.cast(totalCount()));
        case "SucceededCount":
            return Optional.ofNullable(clazz.cast(succeededCount()));
        case "FailedCount":
            return Optional.ofNullable(clazz.cast(failedCount()));
        case "LastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        case "ReleasedCapacity":
            return Optional.ofNullable(clazz.cast(releasedCapacity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TotalCount", TOTAL_COUNT_FIELD);
        map.put("SucceededCount", SUCCEEDED_COUNT_FIELD);
        map.put("FailedCount", FAILED_COUNT_FIELD);
        map.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        map.put("ReleasedCapacity", RELEASED_CAPACITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataRepositoryTaskStatus, T> g) {
        return obj -> g.apply((DataRepositoryTaskStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataRepositoryTaskStatus> {
        /**
         * <p>
         * The total number of files that the task will process. While a task is executing, the sum of
         * <code>SucceededCount</code> plus <code>FailedCount</code> may not equal <code>TotalCount</code>. When the
         * task is complete, <code>TotalCount</code> equals the sum of <code>SucceededCount</code> plus
         * <code>FailedCount</code>.
         * </p>
         * 
         * @param totalCount
         *        The total number of files that the task will process. While a task is executing, the sum of
         *        <code>SucceededCount</code> plus <code>FailedCount</code> may not equal <code>TotalCount</code>. When
         *        the task is complete, <code>TotalCount</code> equals the sum of <code>SucceededCount</code> plus
         *        <code>FailedCount</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalCount(Long totalCount);

        /**
         * <p>
         * A running total of the number of files that the task has successfully processed.
         * </p>
         * 
         * @param succeededCount
         *        A running total of the number of files that the task has successfully processed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder succeededCount(Long succeededCount);

        /**
         * <p>
         * A running total of the number of files that the task failed to process.
         * </p>
         * 
         * @param failedCount
         *        A running total of the number of files that the task failed to process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedCount(Long failedCount);

        /**
         * <p>
         * The time at which the task status was last updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The time at which the task status was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);

        /**
         * <p>
         * The total amount of data, in GiB, released by an Amazon File Cache AUTO_RELEASE_DATA task that automatically
         * releases files from the cache.
         * </p>
         * 
         * @param releasedCapacity
         *        The total amount of data, in GiB, released by an Amazon File Cache AUTO_RELEASE_DATA task that
         *        automatically releases files from the cache.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder releasedCapacity(Long releasedCapacity);
    }

    static final class BuilderImpl implements Builder {
        private Long totalCount;

        private Long succeededCount;

        private Long failedCount;

        private Instant lastUpdatedTime;

        private Long releasedCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(DataRepositoryTaskStatus model) {
            totalCount(model.totalCount);
            succeededCount(model.succeededCount);
            failedCount(model.failedCount);
            lastUpdatedTime(model.lastUpdatedTime);
            releasedCapacity(model.releasedCapacity);
        }

        public final Long getTotalCount() {
            return totalCount;
        }

        public final void setTotalCount(Long totalCount) {
            this.totalCount = totalCount;
        }

        @Override
        public final Builder totalCount(Long totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public final Long getSucceededCount() {
            return succeededCount;
        }

        public final void setSucceededCount(Long succeededCount) {
            this.succeededCount = succeededCount;
        }

        @Override
        public final Builder succeededCount(Long succeededCount) {
            this.succeededCount = succeededCount;
            return this;
        }

        public final Long getFailedCount() {
            return failedCount;
        }

        public final void setFailedCount(Long failedCount) {
            this.failedCount = failedCount;
        }

        @Override
        public final Builder failedCount(Long failedCount) {
            this.failedCount = failedCount;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final Long getReleasedCapacity() {
            return releasedCapacity;
        }

        public final void setReleasedCapacity(Long releasedCapacity) {
            this.releasedCapacity = releasedCapacity;
        }

        @Override
        public final Builder releasedCapacity(Long releasedCapacity) {
            this.releasedCapacity = releasedCapacity;
            return this;
        }

        @Override
        public DataRepositoryTaskStatus build() {
            return new DataRepositoryTaskStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
