/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The response object for the Microsoft Windows file system used in the <code>DeleteFileSystem</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteFileSystemWindowsResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<DeleteFileSystemWindowsResponse.Builder, DeleteFileSystemWindowsResponse> {
    private static final SdkField<String> FINAL_BACKUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FinalBackupId").getter(getter(DeleteFileSystemWindowsResponse::finalBackupId))
            .setter(setter(Builder::finalBackupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FinalBackupId").build()).build();

    private static final SdkField<List<Tag>> FINAL_BACKUP_TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("FinalBackupTags")
            .getter(getter(DeleteFileSystemWindowsResponse::finalBackupTags))
            .setter(setter(Builder::finalBackupTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FinalBackupTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FINAL_BACKUP_ID_FIELD,
            FINAL_BACKUP_TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String finalBackupId;

    private final List<Tag> finalBackupTags;

    private DeleteFileSystemWindowsResponse(BuilderImpl builder) {
        this.finalBackupId = builder.finalBackupId;
        this.finalBackupTags = builder.finalBackupTags;
    }

    /**
     * <p>
     * The ID of the final backup for this file system.
     * </p>
     * 
     * @return The ID of the final backup for this file system.
     */
    public final String finalBackupId() {
        return finalBackupId;
    }

    /**
     * For responses, this returns true if the service returned a value for the FinalBackupTags property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFinalBackupTags() {
        return finalBackupTags != null && !(finalBackupTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The set of tags applied to the final backup.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFinalBackupTags} method.
     * </p>
     * 
     * @return The set of tags applied to the final backup.
     */
    public final List<Tag> finalBackupTags() {
        return finalBackupTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(finalBackupId());
        hashCode = 31 * hashCode + Objects.hashCode(hasFinalBackupTags() ? finalBackupTags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteFileSystemWindowsResponse)) {
            return false;
        }
        DeleteFileSystemWindowsResponse other = (DeleteFileSystemWindowsResponse) obj;
        return Objects.equals(finalBackupId(), other.finalBackupId()) && hasFinalBackupTags() == other.hasFinalBackupTags()
                && Objects.equals(finalBackupTags(), other.finalBackupTags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteFileSystemWindowsResponse").add("FinalBackupId", finalBackupId())
                .add("FinalBackupTags", hasFinalBackupTags() ? finalBackupTags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FinalBackupId":
            return Optional.ofNullable(clazz.cast(finalBackupId()));
        case "FinalBackupTags":
            return Optional.ofNullable(clazz.cast(finalBackupTags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FinalBackupId", FINAL_BACKUP_ID_FIELD);
        map.put("FinalBackupTags", FINAL_BACKUP_TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteFileSystemWindowsResponse, T> g) {
        return obj -> g.apply((DeleteFileSystemWindowsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeleteFileSystemWindowsResponse> {
        /**
         * <p>
         * The ID of the final backup for this file system.
         * </p>
         * 
         * @param finalBackupId
         *        The ID of the final backup for this file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder finalBackupId(String finalBackupId);

        /**
         * <p>
         * The set of tags applied to the final backup.
         * </p>
         * 
         * @param finalBackupTags
         *        The set of tags applied to the final backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder finalBackupTags(Collection<Tag> finalBackupTags);

        /**
         * <p>
         * The set of tags applied to the final backup.
         * </p>
         * 
         * @param finalBackupTags
         *        The set of tags applied to the final backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder finalBackupTags(Tag... finalBackupTags);

        /**
         * <p>
         * The set of tags applied to the final backup.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.fsx.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.fsx.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.fsx.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #finalBackupTags(List<Tag>)}.
         * 
         * @param finalBackupTags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.fsx.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #finalBackupTags(java.util.Collection<Tag>)
         */
        Builder finalBackupTags(Consumer<Tag.Builder>... finalBackupTags);
    }

    static final class BuilderImpl implements Builder {
        private String finalBackupId;

        private List<Tag> finalBackupTags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteFileSystemWindowsResponse model) {
            finalBackupId(model.finalBackupId);
            finalBackupTags(model.finalBackupTags);
        }

        public final String getFinalBackupId() {
            return finalBackupId;
        }

        public final void setFinalBackupId(String finalBackupId) {
            this.finalBackupId = finalBackupId;
        }

        @Override
        public final Builder finalBackupId(String finalBackupId) {
            this.finalBackupId = finalBackupId;
            return this;
        }

        public final List<Tag.Builder> getFinalBackupTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.finalBackupTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFinalBackupTags(Collection<Tag.BuilderImpl> finalBackupTags) {
            this.finalBackupTags = TagsCopier.copyFromBuilder(finalBackupTags);
        }

        @Override
        public final Builder finalBackupTags(Collection<Tag> finalBackupTags) {
            this.finalBackupTags = TagsCopier.copy(finalBackupTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder finalBackupTags(Tag... finalBackupTags) {
            finalBackupTags(Arrays.asList(finalBackupTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder finalBackupTags(Consumer<Tag.Builder>... finalBackupTags) {
            finalBackupTags(Stream.of(finalBackupTags).map(c -> Tag.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DeleteFileSystemWindowsResponse build() {
            return new DeleteFileSystemWindowsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
