/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSnapshotsResponse extends FSxResponse implements
        ToCopyableBuilder<DescribeSnapshotsResponse.Builder, DescribeSnapshotsResponse> {
    private static final SdkField<List<Snapshot>> SNAPSHOTS_FIELD = SdkField
            .<List<Snapshot>> builder(MarshallingType.LIST)
            .memberName("Snapshots")
            .getter(getter(DescribeSnapshotsResponse::snapshots))
            .setter(setter(Builder::snapshots))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Snapshots").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Snapshot> builder(MarshallingType.SDK_POJO)
                                            .constructor(Snapshot::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeSnapshotsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOTS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<Snapshot> snapshots;

    private final String nextToken;

    private DescribeSnapshotsResponse(BuilderImpl builder) {
        super(builder);
        this.snapshots = builder.snapshots;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Snapshots property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSnapshots() {
        return snapshots != null && !(snapshots instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of snapshots.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSnapshots} method.
     * </p>
     * 
     * @return An array of snapshots.
     */
    public final List<Snapshot> snapshots() {
        return snapshots;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSnapshots() ? snapshots() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSnapshotsResponse)) {
            return false;
        }
        DescribeSnapshotsResponse other = (DescribeSnapshotsResponse) obj;
        return hasSnapshots() == other.hasSnapshots() && Objects.equals(snapshots(), other.snapshots())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeSnapshotsResponse").add("Snapshots", hasSnapshots() ? snapshots() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Snapshots":
            return Optional.ofNullable(clazz.cast(snapshots()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Snapshots", SNAPSHOTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeSnapshotsResponse, T> g) {
        return obj -> g.apply((DescribeSnapshotsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FSxResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeSnapshotsResponse> {
        /**
         * <p>
         * An array of snapshots.
         * </p>
         * 
         * @param snapshots
         *        An array of snapshots.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshots(Collection<Snapshot> snapshots);

        /**
         * <p>
         * An array of snapshots.
         * </p>
         * 
         * @param snapshots
         *        An array of snapshots.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshots(Snapshot... snapshots);

        /**
         * <p>
         * An array of snapshots.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.fsx.model.Snapshot.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.fsx.model.Snapshot#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.fsx.model.Snapshot.Builder#build()} is called immediately and its
         * result is passed to {@link #snapshots(List<Snapshot>)}.
         * 
         * @param snapshots
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.fsx.model.Snapshot.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #snapshots(java.util.Collection<Snapshot>)
         */
        Builder snapshots(Consumer<Snapshot.Builder>... snapshots);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends FSxResponse.BuilderImpl implements Builder {
        private List<Snapshot> snapshots = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSnapshotsResponse model) {
            super(model);
            snapshots(model.snapshots);
            nextToken(model.nextToken);
        }

        public final List<Snapshot.Builder> getSnapshots() {
            List<Snapshot.Builder> result = SnapshotsCopier.copyToBuilder(this.snapshots);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSnapshots(Collection<Snapshot.BuilderImpl> snapshots) {
            this.snapshots = SnapshotsCopier.copyFromBuilder(snapshots);
        }

        @Override
        public final Builder snapshots(Collection<Snapshot> snapshots) {
            this.snapshots = SnapshotsCopier.copy(snapshots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshots(Snapshot... snapshots) {
            snapshots(Arrays.asList(snapshots));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshots(Consumer<Snapshot.Builder>... snapshots) {
            snapshots(Stream.of(snapshots).map(c -> Snapshot.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeSnapshotsResponse build() {
            return new DescribeSnapshotsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
