/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the SnapLock configuration for an FSx for ONTAP SnapLock volume.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SnaplockConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SnaplockConfiguration.Builder, SnaplockConfiguration> {
    private static final SdkField<Boolean> AUDIT_LOG_VOLUME_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AuditLogVolume").getter(getter(SnaplockConfiguration::auditLogVolume))
            .setter(setter(Builder::auditLogVolume))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuditLogVolume").build()).build();

    private static final SdkField<AutocommitPeriod> AUTOCOMMIT_PERIOD_FIELD = SdkField
            .<AutocommitPeriod> builder(MarshallingType.SDK_POJO).memberName("AutocommitPeriod")
            .getter(getter(SnaplockConfiguration::autocommitPeriod)).setter(setter(Builder::autocommitPeriod))
            .constructor(AutocommitPeriod::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutocommitPeriod").build()).build();

    private static final SdkField<String> PRIVILEGED_DELETE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrivilegedDelete").getter(getter(SnaplockConfiguration::privilegedDeleteAsString))
            .setter(setter(Builder::privilegedDelete))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivilegedDelete").build()).build();

    private static final SdkField<SnaplockRetentionPeriod> RETENTION_PERIOD_FIELD = SdkField
            .<SnaplockRetentionPeriod> builder(MarshallingType.SDK_POJO).memberName("RetentionPeriod")
            .getter(getter(SnaplockConfiguration::retentionPeriod)).setter(setter(Builder::retentionPeriod))
            .constructor(SnaplockRetentionPeriod::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionPeriod").build()).build();

    private static final SdkField<String> SNAPLOCK_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnaplockType").getter(getter(SnaplockConfiguration::snaplockTypeAsString))
            .setter(setter(Builder::snaplockType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnaplockType").build()).build();

    private static final SdkField<Boolean> VOLUME_APPEND_MODE_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("VolumeAppendModeEnabled").getter(getter(SnaplockConfiguration::volumeAppendModeEnabled))
            .setter(setter(Builder::volumeAppendModeEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeAppendModeEnabled").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIT_LOG_VOLUME_FIELD,
            AUTOCOMMIT_PERIOD_FIELD, PRIVILEGED_DELETE_FIELD, RETENTION_PERIOD_FIELD, SNAPLOCK_TYPE_FIELD,
            VOLUME_APPEND_MODE_ENABLED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean auditLogVolume;

    private final AutocommitPeriod autocommitPeriod;

    private final String privilegedDelete;

    private final SnaplockRetentionPeriod retentionPeriod;

    private final String snaplockType;

    private final Boolean volumeAppendModeEnabled;

    private SnaplockConfiguration(BuilderImpl builder) {
        this.auditLogVolume = builder.auditLogVolume;
        this.autocommitPeriod = builder.autocommitPeriod;
        this.privilegedDelete = builder.privilegedDelete;
        this.retentionPeriod = builder.retentionPeriod;
        this.snaplockType = builder.snaplockType;
        this.volumeAppendModeEnabled = builder.volumeAppendModeEnabled;
    }

    /**
     * <p>
     * Enables or disables the audit log volume for an FSx for ONTAP SnapLock volume. The default value is
     * <code>false</code>. If you set <code>AuditLogVolume</code> to <code>true</code>, the SnapLock volume is created
     * as an audit log volume. The minimum retention period for an audit log volume is six months.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/how-snaplock-works.html#snaplock-audit-log-volume">
     * SnapLock audit log volumes</a>.
     * </p>
     * 
     * @return Enables or disables the audit log volume for an FSx for ONTAP SnapLock volume. The default value is
     *         <code>false</code>. If you set <code>AuditLogVolume</code> to <code>true</code>, the SnapLock volume is
     *         created as an audit log volume. The minimum retention period for an audit log volume is six months. </p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/how-snaplock-works.html#snaplock-audit-log-volume">
     *         SnapLock audit log volumes</a>.
     */
    public final Boolean auditLogVolume() {
        return auditLogVolume;
    }

    /**
     * <p>
     * The configuration object for setting the autocommit period of files in an FSx for ONTAP SnapLock volume.
     * </p>
     * 
     * @return The configuration object for setting the autocommit period of files in an FSx for ONTAP SnapLock volume.
     */
    public final AutocommitPeriod autocommitPeriod() {
        return autocommitPeriod;
    }

    /**
     * <p>
     * Enables, disables, or permanently disables privileged delete on an FSx for ONTAP SnapLock Enterprise volume.
     * Enabling privileged delete allows SnapLock administrators to delete write once, read many (WORM) files even if
     * they have active retention periods. <code>PERMANENTLY_DISABLED</code> is a terminal state. If privileged delete
     * is permanently disabled on a SnapLock volume, you can't re-enable it. The default value is <code>DISABLED</code>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snaplock-enterprise.html#privileged-delete">Privileged
     * delete</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #privilegedDelete}
     * will return {@link PrivilegedDelete#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #privilegedDeleteAsString}.
     * </p>
     * 
     * @return Enables, disables, or permanently disables privileged delete on an FSx for ONTAP SnapLock Enterprise
     *         volume. Enabling privileged delete allows SnapLock administrators to delete write once, read many (WORM)
     *         files even if they have active retention periods. <code>PERMANENTLY_DISABLED</code> is a terminal state.
     *         If privileged delete is permanently disabled on a SnapLock volume, you can't re-enable it. The default
     *         value is <code>DISABLED</code>. </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snaplock-enterprise.html#privileged-delete"
     *         >Privileged delete</a>.
     * @see PrivilegedDelete
     */
    public final PrivilegedDelete privilegedDelete() {
        return PrivilegedDelete.fromValue(privilegedDelete);
    }

    /**
     * <p>
     * Enables, disables, or permanently disables privileged delete on an FSx for ONTAP SnapLock Enterprise volume.
     * Enabling privileged delete allows SnapLock administrators to delete write once, read many (WORM) files even if
     * they have active retention periods. <code>PERMANENTLY_DISABLED</code> is a terminal state. If privileged delete
     * is permanently disabled on a SnapLock volume, you can't re-enable it. The default value is <code>DISABLED</code>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snaplock-enterprise.html#privileged-delete">Privileged
     * delete</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #privilegedDelete}
     * will return {@link PrivilegedDelete#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #privilegedDeleteAsString}.
     * </p>
     * 
     * @return Enables, disables, or permanently disables privileged delete on an FSx for ONTAP SnapLock Enterprise
     *         volume. Enabling privileged delete allows SnapLock administrators to delete write once, read many (WORM)
     *         files even if they have active retention periods. <code>PERMANENTLY_DISABLED</code> is a terminal state.
     *         If privileged delete is permanently disabled on a SnapLock volume, you can't re-enable it. The default
     *         value is <code>DISABLED</code>. </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snaplock-enterprise.html#privileged-delete"
     *         >Privileged delete</a>.
     * @see PrivilegedDelete
     */
    public final String privilegedDeleteAsString() {
        return privilegedDelete;
    }

    /**
     * <p>
     * Specifies the retention period of an FSx for ONTAP SnapLock volume.
     * </p>
     * 
     * @return Specifies the retention period of an FSx for ONTAP SnapLock volume.
     */
    public final SnaplockRetentionPeriod retentionPeriod() {
        return retentionPeriod;
    }

    /**
     * <p>
     * Specifies the retention mode of an FSx for ONTAP SnapLock volume. After it is set, it can't be changed. You can
     * choose one of the following retention modes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>COMPLIANCE</code>: Files transitioned to write once, read many (WORM) on a Compliance volume can't be
     * deleted until their retention periods expire. This retention mode is used to address government or
     * industry-specific mandates or to protect against ransomware attacks. For more information, see <a
     * href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snaplock-compliance.html">SnapLock Compliance</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ENTERPRISE</code>: Files transitioned to WORM on an Enterprise volume can be deleted by authorized users
     * before their retention periods expire using privileged delete. This retention mode is used to advance an
     * organization's data integrity and internal compliance or to test retention settings before using SnapLock
     * Compliance. For more information, see <a
     * href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snaplock-enterprise.html">SnapLock Enterprise</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #snaplockType} will
     * return {@link SnaplockType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #snaplockTypeAsString}.
     * </p>
     * 
     * @return Specifies the retention mode of an FSx for ONTAP SnapLock volume. After it is set, it can't be changed.
     *         You can choose one of the following retention modes: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>COMPLIANCE</code>: Files transitioned to write once, read many (WORM) on a Compliance volume can't
     *         be deleted until their retention periods expire. This retention mode is used to address government or
     *         industry-specific mandates or to protect against ransomware attacks. For more information, see <a
     *         href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snaplock-compliance.html">SnapLock
     *         Compliance</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ENTERPRISE</code>: Files transitioned to WORM on an Enterprise volume can be deleted by authorized
     *         users before their retention periods expire using privileged delete. This retention mode is used to
     *         advance an organization's data integrity and internal compliance or to test retention settings before
     *         using SnapLock Compliance. For more information, see <a
     *         href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snaplock-enterprise.html">SnapLock
     *         Enterprise</a>.
     *         </p>
     *         </li>
     * @see SnaplockType
     */
    public final SnaplockType snaplockType() {
        return SnaplockType.fromValue(snaplockType);
    }

    /**
     * <p>
     * Specifies the retention mode of an FSx for ONTAP SnapLock volume. After it is set, it can't be changed. You can
     * choose one of the following retention modes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>COMPLIANCE</code>: Files transitioned to write once, read many (WORM) on a Compliance volume can't be
     * deleted until their retention periods expire. This retention mode is used to address government or
     * industry-specific mandates or to protect against ransomware attacks. For more information, see <a
     * href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snaplock-compliance.html">SnapLock Compliance</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ENTERPRISE</code>: Files transitioned to WORM on an Enterprise volume can be deleted by authorized users
     * before their retention periods expire using privileged delete. This retention mode is used to advance an
     * organization's data integrity and internal compliance or to test retention settings before using SnapLock
     * Compliance. For more information, see <a
     * href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snaplock-enterprise.html">SnapLock Enterprise</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #snaplockType} will
     * return {@link SnaplockType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #snaplockTypeAsString}.
     * </p>
     * 
     * @return Specifies the retention mode of an FSx for ONTAP SnapLock volume. After it is set, it can't be changed.
     *         You can choose one of the following retention modes: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>COMPLIANCE</code>: Files transitioned to write once, read many (WORM) on a Compliance volume can't
     *         be deleted until their retention periods expire. This retention mode is used to address government or
     *         industry-specific mandates or to protect against ransomware attacks. For more information, see <a
     *         href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snaplock-compliance.html">SnapLock
     *         Compliance</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ENTERPRISE</code>: Files transitioned to WORM on an Enterprise volume can be deleted by authorized
     *         users before their retention periods expire using privileged delete. This retention mode is used to
     *         advance an organization's data integrity and internal compliance or to test retention settings before
     *         using SnapLock Compliance. For more information, see <a
     *         href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snaplock-enterprise.html">SnapLock
     *         Enterprise</a>.
     *         </p>
     *         </li>
     * @see SnaplockType
     */
    public final String snaplockTypeAsString() {
        return snaplockType;
    }

    /**
     * <p>
     * Enables or disables volume-append mode on an FSx for ONTAP SnapLock volume. Volume-append mode allows you to
     * create WORM-appendable files and write data to them incrementally. The default value is <code>false</code>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/worm-state.html#worm-state-append">Volume-append
     * mode</a>.
     * </p>
     * 
     * @return Enables or disables volume-append mode on an FSx for ONTAP SnapLock volume. Volume-append mode allows you
     *         to create WORM-appendable files and write data to them incrementally. The default value is
     *         <code>false</code>. </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/worm-state.html#worm-state-append">Volume-append
     *         mode</a>.
     */
    public final Boolean volumeAppendModeEnabled() {
        return volumeAppendModeEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(auditLogVolume());
        hashCode = 31 * hashCode + Objects.hashCode(autocommitPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(privilegedDeleteAsString());
        hashCode = 31 * hashCode + Objects.hashCode(retentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(snaplockTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(volumeAppendModeEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnaplockConfiguration)) {
            return false;
        }
        SnaplockConfiguration other = (SnaplockConfiguration) obj;
        return Objects.equals(auditLogVolume(), other.auditLogVolume())
                && Objects.equals(autocommitPeriod(), other.autocommitPeriod())
                && Objects.equals(privilegedDeleteAsString(), other.privilegedDeleteAsString())
                && Objects.equals(retentionPeriod(), other.retentionPeriod())
                && Objects.equals(snaplockTypeAsString(), other.snaplockTypeAsString())
                && Objects.equals(volumeAppendModeEnabled(), other.volumeAppendModeEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SnaplockConfiguration").add("AuditLogVolume", auditLogVolume())
                .add("AutocommitPeriod", autocommitPeriod()).add("PrivilegedDelete", privilegedDeleteAsString())
                .add("RetentionPeriod", retentionPeriod()).add("SnaplockType", snaplockTypeAsString())
                .add("VolumeAppendModeEnabled", volumeAppendModeEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AuditLogVolume":
            return Optional.ofNullable(clazz.cast(auditLogVolume()));
        case "AutocommitPeriod":
            return Optional.ofNullable(clazz.cast(autocommitPeriod()));
        case "PrivilegedDelete":
            return Optional.ofNullable(clazz.cast(privilegedDeleteAsString()));
        case "RetentionPeriod":
            return Optional.ofNullable(clazz.cast(retentionPeriod()));
        case "SnaplockType":
            return Optional.ofNullable(clazz.cast(snaplockTypeAsString()));
        case "VolumeAppendModeEnabled":
            return Optional.ofNullable(clazz.cast(volumeAppendModeEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AuditLogVolume", AUDIT_LOG_VOLUME_FIELD);
        map.put("AutocommitPeriod", AUTOCOMMIT_PERIOD_FIELD);
        map.put("PrivilegedDelete", PRIVILEGED_DELETE_FIELD);
        map.put("RetentionPeriod", RETENTION_PERIOD_FIELD);
        map.put("SnaplockType", SNAPLOCK_TYPE_FIELD);
        map.put("VolumeAppendModeEnabled", VOLUME_APPEND_MODE_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SnaplockConfiguration, T> g) {
        return obj -> g.apply((SnaplockConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SnaplockConfiguration> {
        /**
         * <p>
         * Enables or disables the audit log volume for an FSx for ONTAP SnapLock volume. The default value is
         * <code>false</code>. If you set <code>AuditLogVolume</code> to <code>true</code>, the SnapLock volume is
         * created as an audit log volume. The minimum retention period for an audit log volume is six months.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/how-snaplock-works.html#snaplock-audit-log-volume">
         * SnapLock audit log volumes</a>.
         * </p>
         * 
         * @param auditLogVolume
         *        Enables or disables the audit log volume for an FSx for ONTAP SnapLock volume. The default value is
         *        <code>false</code>. If you set <code>AuditLogVolume</code> to <code>true</code>, the SnapLock volume
         *        is created as an audit log volume. The minimum retention period for an audit log volume is six months.
         *        </p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/how-snaplock-works.html#snaplock-audit-log-volume">
         *        SnapLock audit log volumes</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder auditLogVolume(Boolean auditLogVolume);

        /**
         * <p>
         * The configuration object for setting the autocommit period of files in an FSx for ONTAP SnapLock volume.
         * </p>
         * 
         * @param autocommitPeriod
         *        The configuration object for setting the autocommit period of files in an FSx for ONTAP SnapLock
         *        volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autocommitPeriod(AutocommitPeriod autocommitPeriod);

        /**
         * <p>
         * The configuration object for setting the autocommit period of files in an FSx for ONTAP SnapLock volume.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutocommitPeriod.Builder} avoiding the
         * need to create one manually via {@link AutocommitPeriod#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutocommitPeriod.Builder#build()} is called immediately and its
         * result is passed to {@link #autocommitPeriod(AutocommitPeriod)}.
         * 
         * @param autocommitPeriod
         *        a consumer that will call methods on {@link AutocommitPeriod.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autocommitPeriod(AutocommitPeriod)
         */
        default Builder autocommitPeriod(Consumer<AutocommitPeriod.Builder> autocommitPeriod) {
            return autocommitPeriod(AutocommitPeriod.builder().applyMutation(autocommitPeriod).build());
        }

        /**
         * <p>
         * Enables, disables, or permanently disables privileged delete on an FSx for ONTAP SnapLock Enterprise volume.
         * Enabling privileged delete allows SnapLock administrators to delete write once, read many (WORM) files even
         * if they have active retention periods. <code>PERMANENTLY_DISABLED</code> is a terminal state. If privileged
         * delete is permanently disabled on a SnapLock volume, you can't re-enable it. The default value is
         * <code>DISABLED</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snaplock-enterprise.html#privileged-delete"
         * >Privileged delete</a>.
         * </p>
         * 
         * @param privilegedDelete
         *        Enables, disables, or permanently disables privileged delete on an FSx for ONTAP SnapLock Enterprise
         *        volume. Enabling privileged delete allows SnapLock administrators to delete write once, read many
         *        (WORM) files even if they have active retention periods. <code>PERMANENTLY_DISABLED</code> is a
         *        terminal state. If privileged delete is permanently disabled on a SnapLock volume, you can't re-enable
         *        it. The default value is <code>DISABLED</code>. </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snaplock-enterprise.html#privileged-delete"
         *        >Privileged delete</a>.
         * @see PrivilegedDelete
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PrivilegedDelete
         */
        Builder privilegedDelete(String privilegedDelete);

        /**
         * <p>
         * Enables, disables, or permanently disables privileged delete on an FSx for ONTAP SnapLock Enterprise volume.
         * Enabling privileged delete allows SnapLock administrators to delete write once, read many (WORM) files even
         * if they have active retention periods. <code>PERMANENTLY_DISABLED</code> is a terminal state. If privileged
         * delete is permanently disabled on a SnapLock volume, you can't re-enable it. The default value is
         * <code>DISABLED</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snaplock-enterprise.html#privileged-delete"
         * >Privileged delete</a>.
         * </p>
         * 
         * @param privilegedDelete
         *        Enables, disables, or permanently disables privileged delete on an FSx for ONTAP SnapLock Enterprise
         *        volume. Enabling privileged delete allows SnapLock administrators to delete write once, read many
         *        (WORM) files even if they have active retention periods. <code>PERMANENTLY_DISABLED</code> is a
         *        terminal state. If privileged delete is permanently disabled on a SnapLock volume, you can't re-enable
         *        it. The default value is <code>DISABLED</code>. </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snaplock-enterprise.html#privileged-delete"
         *        >Privileged delete</a>.
         * @see PrivilegedDelete
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PrivilegedDelete
         */
        Builder privilegedDelete(PrivilegedDelete privilegedDelete);

        /**
         * <p>
         * Specifies the retention period of an FSx for ONTAP SnapLock volume.
         * </p>
         * 
         * @param retentionPeriod
         *        Specifies the retention period of an FSx for ONTAP SnapLock volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionPeriod(SnaplockRetentionPeriod retentionPeriod);

        /**
         * <p>
         * Specifies the retention period of an FSx for ONTAP SnapLock volume.
         * </p>
         * This is a convenience method that creates an instance of the {@link SnaplockRetentionPeriod.Builder} avoiding
         * the need to create one manually via {@link SnaplockRetentionPeriod#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SnaplockRetentionPeriod.Builder#build()} is called immediately
         * and its result is passed to {@link #retentionPeriod(SnaplockRetentionPeriod)}.
         * 
         * @param retentionPeriod
         *        a consumer that will call methods on {@link SnaplockRetentionPeriod.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retentionPeriod(SnaplockRetentionPeriod)
         */
        default Builder retentionPeriod(Consumer<SnaplockRetentionPeriod.Builder> retentionPeriod) {
            return retentionPeriod(SnaplockRetentionPeriod.builder().applyMutation(retentionPeriod).build());
        }

        /**
         * <p>
         * Specifies the retention mode of an FSx for ONTAP SnapLock volume. After it is set, it can't be changed. You
         * can choose one of the following retention modes:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>COMPLIANCE</code>: Files transitioned to write once, read many (WORM) on a Compliance volume can't be
         * deleted until their retention periods expire. This retention mode is used to address government or
         * industry-specific mandates or to protect against ransomware attacks. For more information, see <a
         * href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snaplock-compliance.html">SnapLock Compliance</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ENTERPRISE</code>: Files transitioned to WORM on an Enterprise volume can be deleted by authorized
         * users before their retention periods expire using privileged delete. This retention mode is used to advance
         * an organization's data integrity and internal compliance or to test retention settings before using SnapLock
         * Compliance. For more information, see <a
         * href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snaplock-enterprise.html">SnapLock Enterprise</a>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param snaplockType
         *        Specifies the retention mode of an FSx for ONTAP SnapLock volume. After it is set, it can't be
         *        changed. You can choose one of the following retention modes: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>COMPLIANCE</code>: Files transitioned to write once, read many (WORM) on a Compliance volume
         *        can't be deleted until their retention periods expire. This retention mode is used to address
         *        government or industry-specific mandates or to protect against ransomware attacks. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snaplock-compliance.html">SnapLock
         *        Compliance</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ENTERPRISE</code>: Files transitioned to WORM on an Enterprise volume can be deleted by
         *        authorized users before their retention periods expire using privileged delete. This retention mode is
         *        used to advance an organization's data integrity and internal compliance or to test retention settings
         *        before using SnapLock Compliance. For more information, see <a
         *        href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snaplock-enterprise.html">SnapLock
         *        Enterprise</a>.
         *        </p>
         *        </li>
         * @see SnaplockType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnaplockType
         */
        Builder snaplockType(String snaplockType);

        /**
         * <p>
         * Specifies the retention mode of an FSx for ONTAP SnapLock volume. After it is set, it can't be changed. You
         * can choose one of the following retention modes:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>COMPLIANCE</code>: Files transitioned to write once, read many (WORM) on a Compliance volume can't be
         * deleted until their retention periods expire. This retention mode is used to address government or
         * industry-specific mandates or to protect against ransomware attacks. For more information, see <a
         * href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snaplock-compliance.html">SnapLock Compliance</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ENTERPRISE</code>: Files transitioned to WORM on an Enterprise volume can be deleted by authorized
         * users before their retention periods expire using privileged delete. This retention mode is used to advance
         * an organization's data integrity and internal compliance or to test retention settings before using SnapLock
         * Compliance. For more information, see <a
         * href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snaplock-enterprise.html">SnapLock Enterprise</a>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param snaplockType
         *        Specifies the retention mode of an FSx for ONTAP SnapLock volume. After it is set, it can't be
         *        changed. You can choose one of the following retention modes: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>COMPLIANCE</code>: Files transitioned to write once, read many (WORM) on a Compliance volume
         *        can't be deleted until their retention periods expire. This retention mode is used to address
         *        government or industry-specific mandates or to protect against ransomware attacks. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snaplock-compliance.html">SnapLock
         *        Compliance</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ENTERPRISE</code>: Files transitioned to WORM on an Enterprise volume can be deleted by
         *        authorized users before their retention periods expire using privileged delete. This retention mode is
         *        used to advance an organization's data integrity and internal compliance or to test retention settings
         *        before using SnapLock Compliance. For more information, see <a
         *        href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snaplock-enterprise.html">SnapLock
         *        Enterprise</a>.
         *        </p>
         *        </li>
         * @see SnaplockType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnaplockType
         */
        Builder snaplockType(SnaplockType snaplockType);

        /**
         * <p>
         * Enables or disables volume-append mode on an FSx for ONTAP SnapLock volume. Volume-append mode allows you to
         * create WORM-appendable files and write data to them incrementally. The default value is <code>false</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/worm-state.html#worm-state-append">Volume-append
         * mode</a>.
         * </p>
         * 
         * @param volumeAppendModeEnabled
         *        Enables or disables volume-append mode on an FSx for ONTAP SnapLock volume. Volume-append mode allows
         *        you to create WORM-appendable files and write data to them incrementally. The default value is
         *        <code>false</code>. </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/worm-state.html#worm-state-append"
         *        >Volume-append mode</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeAppendModeEnabled(Boolean volumeAppendModeEnabled);
    }

    static final class BuilderImpl implements Builder {
        private Boolean auditLogVolume;

        private AutocommitPeriod autocommitPeriod;

        private String privilegedDelete;

        private SnaplockRetentionPeriod retentionPeriod;

        private String snaplockType;

        private Boolean volumeAppendModeEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(SnaplockConfiguration model) {
            auditLogVolume(model.auditLogVolume);
            autocommitPeriod(model.autocommitPeriod);
            privilegedDelete(model.privilegedDelete);
            retentionPeriod(model.retentionPeriod);
            snaplockType(model.snaplockType);
            volumeAppendModeEnabled(model.volumeAppendModeEnabled);
        }

        public final Boolean getAuditLogVolume() {
            return auditLogVolume;
        }

        public final void setAuditLogVolume(Boolean auditLogVolume) {
            this.auditLogVolume = auditLogVolume;
        }

        @Override
        public final Builder auditLogVolume(Boolean auditLogVolume) {
            this.auditLogVolume = auditLogVolume;
            return this;
        }

        public final AutocommitPeriod.Builder getAutocommitPeriod() {
            return autocommitPeriod != null ? autocommitPeriod.toBuilder() : null;
        }

        public final void setAutocommitPeriod(AutocommitPeriod.BuilderImpl autocommitPeriod) {
            this.autocommitPeriod = autocommitPeriod != null ? autocommitPeriod.build() : null;
        }

        @Override
        public final Builder autocommitPeriod(AutocommitPeriod autocommitPeriod) {
            this.autocommitPeriod = autocommitPeriod;
            return this;
        }

        public final String getPrivilegedDelete() {
            return privilegedDelete;
        }

        public final void setPrivilegedDelete(String privilegedDelete) {
            this.privilegedDelete = privilegedDelete;
        }

        @Override
        public final Builder privilegedDelete(String privilegedDelete) {
            this.privilegedDelete = privilegedDelete;
            return this;
        }

        @Override
        public final Builder privilegedDelete(PrivilegedDelete privilegedDelete) {
            this.privilegedDelete(privilegedDelete == null ? null : privilegedDelete.toString());
            return this;
        }

        public final SnaplockRetentionPeriod.Builder getRetentionPeriod() {
            return retentionPeriod != null ? retentionPeriod.toBuilder() : null;
        }

        public final void setRetentionPeriod(SnaplockRetentionPeriod.BuilderImpl retentionPeriod) {
            this.retentionPeriod = retentionPeriod != null ? retentionPeriod.build() : null;
        }

        @Override
        public final Builder retentionPeriod(SnaplockRetentionPeriod retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        public final String getSnaplockType() {
            return snaplockType;
        }

        public final void setSnaplockType(String snaplockType) {
            this.snaplockType = snaplockType;
        }

        @Override
        public final Builder snaplockType(String snaplockType) {
            this.snaplockType = snaplockType;
            return this;
        }

        @Override
        public final Builder snaplockType(SnaplockType snaplockType) {
            this.snaplockType(snaplockType == null ? null : snaplockType.toString());
            return this;
        }

        public final Boolean getVolumeAppendModeEnabled() {
            return volumeAppendModeEnabled;
        }

        public final void setVolumeAppendModeEnabled(Boolean volumeAppendModeEnabled) {
            this.volumeAppendModeEnabled = volumeAppendModeEnabled;
        }

        @Override
        public final Builder volumeAppendModeEnabled(Boolean volumeAppendModeEnabled) {
            this.volumeAppendModeEnabled = volumeAppendModeEnabled;
            return this;
        }

        @Override
        public SnaplockConfiguration build() {
            return new SnaplockConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
