/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration object for Amazon FSx for Lustre file systems used in the <code>UpdateFileSystem</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateFileSystemLustreConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateFileSystemLustreConfiguration.Builder, UpdateFileSystemLustreConfiguration> {
    private static final SdkField<String> WEEKLY_MAINTENANCE_START_TIME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("WeeklyMaintenanceStartTime")
            .getter(getter(UpdateFileSystemLustreConfiguration::weeklyMaintenanceStartTime))
            .setter(setter(Builder::weeklyMaintenanceStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WeeklyMaintenanceStartTime").build())
            .build();

    private static final SdkField<String> DAILY_AUTOMATIC_BACKUP_START_TIME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DailyAutomaticBackupStartTime")
            .getter(getter(UpdateFileSystemLustreConfiguration::dailyAutomaticBackupStartTime))
            .setter(setter(Builder::dailyAutomaticBackupStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DailyAutomaticBackupStartTime")
                    .build()).build();

    private static final SdkField<Integer> AUTOMATIC_BACKUP_RETENTION_DAYS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("AutomaticBackupRetentionDays")
            .getter(getter(UpdateFileSystemLustreConfiguration::automaticBackupRetentionDays))
            .setter(setter(Builder::automaticBackupRetentionDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomaticBackupRetentionDays")
                    .build()).build();

    private static final SdkField<String> AUTO_IMPORT_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutoImportPolicy").getter(getter(UpdateFileSystemLustreConfiguration::autoImportPolicyAsString))
            .setter(setter(Builder::autoImportPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoImportPolicy").build()).build();

    private static final SdkField<String> DATA_COMPRESSION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataCompressionType").getter(getter(UpdateFileSystemLustreConfiguration::dataCompressionTypeAsString))
            .setter(setter(Builder::dataCompressionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataCompressionType").build())
            .build();

    private static final SdkField<LustreLogCreateConfiguration> LOG_CONFIGURATION_FIELD = SdkField
            .<LustreLogCreateConfiguration> builder(MarshallingType.SDK_POJO).memberName("LogConfiguration")
            .getter(getter(UpdateFileSystemLustreConfiguration::logConfiguration)).setter(setter(Builder::logConfiguration))
            .constructor(LustreLogCreateConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogConfiguration").build()).build();

    private static final SdkField<LustreRootSquashConfiguration> ROOT_SQUASH_CONFIGURATION_FIELD = SdkField
            .<LustreRootSquashConfiguration> builder(MarshallingType.SDK_POJO).memberName("RootSquashConfiguration")
            .getter(getter(UpdateFileSystemLustreConfiguration::rootSquashConfiguration))
            .setter(setter(Builder::rootSquashConfiguration)).constructor(LustreRootSquashConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootSquashConfiguration").build())
            .build();

    private static final SdkField<Integer> PER_UNIT_STORAGE_THROUGHPUT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("PerUnitStorageThroughput")
            .getter(getter(UpdateFileSystemLustreConfiguration::perUnitStorageThroughput))
            .setter(setter(Builder::perUnitStorageThroughput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerUnitStorageThroughput").build())
            .build();

    private static final SdkField<UpdateFileSystemLustreMetadataConfiguration> METADATA_CONFIGURATION_FIELD = SdkField
            .<UpdateFileSystemLustreMetadataConfiguration> builder(MarshallingType.SDK_POJO).memberName("MetadataConfiguration")
            .getter(getter(UpdateFileSystemLustreConfiguration::metadataConfiguration))
            .setter(setter(Builder::metadataConfiguration)).constructor(UpdateFileSystemLustreMetadataConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            WEEKLY_MAINTENANCE_START_TIME_FIELD, DAILY_AUTOMATIC_BACKUP_START_TIME_FIELD, AUTOMATIC_BACKUP_RETENTION_DAYS_FIELD,
            AUTO_IMPORT_POLICY_FIELD, DATA_COMPRESSION_TYPE_FIELD, LOG_CONFIGURATION_FIELD, ROOT_SQUASH_CONFIGURATION_FIELD,
            PER_UNIT_STORAGE_THROUGHPUT_FIELD, METADATA_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String weeklyMaintenanceStartTime;

    private final String dailyAutomaticBackupStartTime;

    private final Integer automaticBackupRetentionDays;

    private final String autoImportPolicy;

    private final String dataCompressionType;

    private final LustreLogCreateConfiguration logConfiguration;

    private final LustreRootSquashConfiguration rootSquashConfiguration;

    private final Integer perUnitStorageThroughput;

    private final UpdateFileSystemLustreMetadataConfiguration metadataConfiguration;

    private UpdateFileSystemLustreConfiguration(BuilderImpl builder) {
        this.weeklyMaintenanceStartTime = builder.weeklyMaintenanceStartTime;
        this.dailyAutomaticBackupStartTime = builder.dailyAutomaticBackupStartTime;
        this.automaticBackupRetentionDays = builder.automaticBackupRetentionDays;
        this.autoImportPolicy = builder.autoImportPolicy;
        this.dataCompressionType = builder.dataCompressionType;
        this.logConfiguration = builder.logConfiguration;
        this.rootSquashConfiguration = builder.rootSquashConfiguration;
        this.perUnitStorageThroughput = builder.perUnitStorageThroughput;
        this.metadataConfiguration = builder.metadataConfiguration;
    }

    /**
     * <p>
     * (Optional) The preferred start time to perform weekly maintenance, formatted d:HH:MM in the UTC time zone. d is
     * the weekday number, from 1 through 7, beginning with Monday and ending with Sunday.
     * </p>
     * 
     * @return (Optional) The preferred start time to perform weekly maintenance, formatted d:HH:MM in the UTC time
     *         zone. d is the weekday number, from 1 through 7, beginning with Monday and ending with Sunday.
     */
    public final String weeklyMaintenanceStartTime() {
        return weeklyMaintenanceStartTime;
    }

    /**
     * Returns the value of the DailyAutomaticBackupStartTime property for this object.
     * 
     * @return The value of the DailyAutomaticBackupStartTime property for this object.
     */
    public final String dailyAutomaticBackupStartTime() {
        return dailyAutomaticBackupStartTime;
    }

    /**
     * <p>
     * The number of days to retain automatic backups. Setting this property to <code>0</code> disables automatic
     * backups. You can retain automatic backups for a maximum of 90 days. The default is <code>0</code>.
     * </p>
     * 
     * @return The number of days to retain automatic backups. Setting this property to <code>0</code> disables
     *         automatic backups. You can retain automatic backups for a maximum of 90 days. The default is
     *         <code>0</code>.
     */
    public final Integer automaticBackupRetentionDays() {
        return automaticBackupRetentionDays;
    }

    /**
     * <p>
     * (Optional) When you create your file system, your existing S3 objects appear as file and directory listings. Use
     * this property to choose how Amazon FSx keeps your file and directory listing up to date as you add or modify
     * objects in your linked S3 bucket. <code>AutoImportPolicy</code> can have the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NONE</code> - (Default) AutoImport is off. Amazon FSx only updates file and directory listings from the
     * linked S3 bucket when the file system is created. FSx does not update the file and directory listing for any new
     * or changed objects after choosing this option.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NEW</code> - AutoImport is on. Amazon FSx automatically imports directory listings of any new objects added
     * to the linked S3 bucket that do not currently exist in the FSx file system.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NEW_CHANGED</code> - AutoImport is on. Amazon FSx automatically imports file and directory listings of any
     * new objects added to the S3 bucket and any existing objects that are changed in the S3 bucket after you choose
     * this option.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NEW_CHANGED_DELETED</code> - AutoImport is on. Amazon FSx automatically imports file and directory listings
     * of any new objects added to the S3 bucket, any existing objects that are changed in the S3 bucket, and any
     * objects that were deleted in the S3 bucket.
     * </p>
     * </li>
     * </ul>
     * <p>
     * This parameter is not supported for file systems with a data repository association.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #autoImportPolicy}
     * will return {@link AutoImportPolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #autoImportPolicyAsString}.
     * </p>
     * 
     * @return (Optional) When you create your file system, your existing S3 objects appear as file and directory
     *         listings. Use this property to choose how Amazon FSx keeps your file and directory listing up to date as
     *         you add or modify objects in your linked S3 bucket. <code>AutoImportPolicy</code> can have the following
     *         values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NONE</code> - (Default) AutoImport is off. Amazon FSx only updates file and directory listings from
     *         the linked S3 bucket when the file system is created. FSx does not update the file and directory listing
     *         for any new or changed objects after choosing this option.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NEW</code> - AutoImport is on. Amazon FSx automatically imports directory listings of any new
     *         objects added to the linked S3 bucket that do not currently exist in the FSx file system.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NEW_CHANGED</code> - AutoImport is on. Amazon FSx automatically imports file and directory listings
     *         of any new objects added to the S3 bucket and any existing objects that are changed in the S3 bucket
     *         after you choose this option.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NEW_CHANGED_DELETED</code> - AutoImport is on. Amazon FSx automatically imports file and directory
     *         listings of any new objects added to the S3 bucket, any existing objects that are changed in the S3
     *         bucket, and any objects that were deleted in the S3 bucket.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         This parameter is not supported for file systems with a data repository association.
     * @see AutoImportPolicyType
     */
    public final AutoImportPolicyType autoImportPolicy() {
        return AutoImportPolicyType.fromValue(autoImportPolicy);
    }

    /**
     * <p>
     * (Optional) When you create your file system, your existing S3 objects appear as file and directory listings. Use
     * this property to choose how Amazon FSx keeps your file and directory listing up to date as you add or modify
     * objects in your linked S3 bucket. <code>AutoImportPolicy</code> can have the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NONE</code> - (Default) AutoImport is off. Amazon FSx only updates file and directory listings from the
     * linked S3 bucket when the file system is created. FSx does not update the file and directory listing for any new
     * or changed objects after choosing this option.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NEW</code> - AutoImport is on. Amazon FSx automatically imports directory listings of any new objects added
     * to the linked S3 bucket that do not currently exist in the FSx file system.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NEW_CHANGED</code> - AutoImport is on. Amazon FSx automatically imports file and directory listings of any
     * new objects added to the S3 bucket and any existing objects that are changed in the S3 bucket after you choose
     * this option.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NEW_CHANGED_DELETED</code> - AutoImport is on. Amazon FSx automatically imports file and directory listings
     * of any new objects added to the S3 bucket, any existing objects that are changed in the S3 bucket, and any
     * objects that were deleted in the S3 bucket.
     * </p>
     * </li>
     * </ul>
     * <p>
     * This parameter is not supported for file systems with a data repository association.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #autoImportPolicy}
     * will return {@link AutoImportPolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #autoImportPolicyAsString}.
     * </p>
     * 
     * @return (Optional) When you create your file system, your existing S3 objects appear as file and directory
     *         listings. Use this property to choose how Amazon FSx keeps your file and directory listing up to date as
     *         you add or modify objects in your linked S3 bucket. <code>AutoImportPolicy</code> can have the following
     *         values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NONE</code> - (Default) AutoImport is off. Amazon FSx only updates file and directory listings from
     *         the linked S3 bucket when the file system is created. FSx does not update the file and directory listing
     *         for any new or changed objects after choosing this option.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NEW</code> - AutoImport is on. Amazon FSx automatically imports directory listings of any new
     *         objects added to the linked S3 bucket that do not currently exist in the FSx file system.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NEW_CHANGED</code> - AutoImport is on. Amazon FSx automatically imports file and directory listings
     *         of any new objects added to the S3 bucket and any existing objects that are changed in the S3 bucket
     *         after you choose this option.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NEW_CHANGED_DELETED</code> - AutoImport is on. Amazon FSx automatically imports file and directory
     *         listings of any new objects added to the S3 bucket, any existing objects that are changed in the S3
     *         bucket, and any objects that were deleted in the S3 bucket.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         This parameter is not supported for file systems with a data repository association.
     * @see AutoImportPolicyType
     */
    public final String autoImportPolicyAsString() {
        return autoImportPolicy;
    }

    /**
     * <p>
     * Sets the data compression configuration for the file system. <code>DataCompressionType</code> can have the
     * following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NONE</code> - Data compression is turned off for the file system.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LZ4</code> - Data compression is turned on with the LZ4 algorithm.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you don't use <code>DataCompressionType</code>, the file system retains its current data compression
     * configuration.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/data-compression.html">Lustre data compression</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dataCompressionType} will return {@link DataCompressionType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #dataCompressionTypeAsString}.
     * </p>
     * 
     * @return Sets the data compression configuration for the file system. <code>DataCompressionType</code> can have
     *         the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NONE</code> - Data compression is turned off for the file system.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LZ4</code> - Data compression is turned on with the LZ4 algorithm.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you don't use <code>DataCompressionType</code>, the file system retains its current data compression
     *         configuration.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/data-compression.html">Lustre data
     *         compression</a>.
     * @see DataCompressionType
     */
    public final DataCompressionType dataCompressionType() {
        return DataCompressionType.fromValue(dataCompressionType);
    }

    /**
     * <p>
     * Sets the data compression configuration for the file system. <code>DataCompressionType</code> can have the
     * following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NONE</code> - Data compression is turned off for the file system.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LZ4</code> - Data compression is turned on with the LZ4 algorithm.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you don't use <code>DataCompressionType</code>, the file system retains its current data compression
     * configuration.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/data-compression.html">Lustre data compression</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dataCompressionType} will return {@link DataCompressionType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #dataCompressionTypeAsString}.
     * </p>
     * 
     * @return Sets the data compression configuration for the file system. <code>DataCompressionType</code> can have
     *         the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NONE</code> - Data compression is turned off for the file system.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LZ4</code> - Data compression is turned on with the LZ4 algorithm.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you don't use <code>DataCompressionType</code>, the file system retains its current data compression
     *         configuration.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/data-compression.html">Lustre data
     *         compression</a>.
     * @see DataCompressionType
     */
    public final String dataCompressionTypeAsString() {
        return dataCompressionType;
    }

    /**
     * <p>
     * The Lustre logging configuration used when updating an Amazon FSx for Lustre file system. When logging is
     * enabled, Lustre logs error and warning events for data repositories associated with your file system to Amazon
     * CloudWatch Logs.
     * </p>
     * 
     * @return The Lustre logging configuration used when updating an Amazon FSx for Lustre file system. When logging is
     *         enabled, Lustre logs error and warning events for data repositories associated with your file system to
     *         Amazon CloudWatch Logs.
     */
    public final LustreLogCreateConfiguration logConfiguration() {
        return logConfiguration;
    }

    /**
     * <p>
     * The Lustre root squash configuration used when updating an Amazon FSx for Lustre file system. When enabled, root
     * squash restricts root-level access from clients that try to access your file system as a root user.
     * </p>
     * 
     * @return The Lustre root squash configuration used when updating an Amazon FSx for Lustre file system. When
     *         enabled, root squash restricts root-level access from clients that try to access your file system as a
     *         root user.
     */
    public final LustreRootSquashConfiguration rootSquashConfiguration() {
        return rootSquashConfiguration;
    }

    /**
     * <p>
     * The throughput of an Amazon FSx for Lustre Persistent SSD-based file system, measured in megabytes per second per
     * tebibyte (MB/s/TiB). You can increase or decrease your file system's throughput. Valid values depend on the
     * deployment type of the file system, as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For <code>PERSISTENT_1</code> SSD-based deployment types, valid values are 50, 100, and 200 MB/s/TiB.
     * </p>
     * </li>
     * <li>
     * <p>
     * For <code>PERSISTENT_2</code> SSD-based deployment types, valid values are 125, 250, 500, and 1000 MB/s/TiB.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/managing-throughput-capacity.html"> Managing throughput
     * capacity</a>.
     * </p>
     * 
     * @return The throughput of an Amazon FSx for Lustre Persistent SSD-based file system, measured in megabytes per
     *         second per tebibyte (MB/s/TiB). You can increase or decrease your file system's throughput. Valid values
     *         depend on the deployment type of the file system, as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For <code>PERSISTENT_1</code> SSD-based deployment types, valid values are 50, 100, and 200 MB/s/TiB.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For <code>PERSISTENT_2</code> SSD-based deployment types, valid values are 125, 250, 500, and 1000
     *         MB/s/TiB.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/managing-throughput-capacity.html"> Managing
     *         throughput capacity</a>.
     */
    public final Integer perUnitStorageThroughput() {
        return perUnitStorageThroughput;
    }

    /**
     * <p>
     * The Lustre metadata performance configuration for an Amazon FSx for Lustre file system using a
     * <code>PERSISTENT_2</code> deployment type. When this configuration is enabled, the file system supports
     * increasing metadata performance.
     * </p>
     * 
     * @return The Lustre metadata performance configuration for an Amazon FSx for Lustre file system using a
     *         <code>PERSISTENT_2</code> deployment type. When this configuration is enabled, the file system supports
     *         increasing metadata performance.
     */
    public final UpdateFileSystemLustreMetadataConfiguration metadataConfiguration() {
        return metadataConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(weeklyMaintenanceStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(dailyAutomaticBackupStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(automaticBackupRetentionDays());
        hashCode = 31 * hashCode + Objects.hashCode(autoImportPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dataCompressionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(logConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(rootSquashConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(perUnitStorageThroughput());
        hashCode = 31 * hashCode + Objects.hashCode(metadataConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFileSystemLustreConfiguration)) {
            return false;
        }
        UpdateFileSystemLustreConfiguration other = (UpdateFileSystemLustreConfiguration) obj;
        return Objects.equals(weeklyMaintenanceStartTime(), other.weeklyMaintenanceStartTime())
                && Objects.equals(dailyAutomaticBackupStartTime(), other.dailyAutomaticBackupStartTime())
                && Objects.equals(automaticBackupRetentionDays(), other.automaticBackupRetentionDays())
                && Objects.equals(autoImportPolicyAsString(), other.autoImportPolicyAsString())
                && Objects.equals(dataCompressionTypeAsString(), other.dataCompressionTypeAsString())
                && Objects.equals(logConfiguration(), other.logConfiguration())
                && Objects.equals(rootSquashConfiguration(), other.rootSquashConfiguration())
                && Objects.equals(perUnitStorageThroughput(), other.perUnitStorageThroughput())
                && Objects.equals(metadataConfiguration(), other.metadataConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateFileSystemLustreConfiguration")
                .add("WeeklyMaintenanceStartTime", weeklyMaintenanceStartTime())
                .add("DailyAutomaticBackupStartTime", dailyAutomaticBackupStartTime())
                .add("AutomaticBackupRetentionDays", automaticBackupRetentionDays())
                .add("AutoImportPolicy", autoImportPolicyAsString()).add("DataCompressionType", dataCompressionTypeAsString())
                .add("LogConfiguration", logConfiguration()).add("RootSquashConfiguration", rootSquashConfiguration())
                .add("PerUnitStorageThroughput", perUnitStorageThroughput())
                .add("MetadataConfiguration", metadataConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WeeklyMaintenanceStartTime":
            return Optional.ofNullable(clazz.cast(weeklyMaintenanceStartTime()));
        case "DailyAutomaticBackupStartTime":
            return Optional.ofNullable(clazz.cast(dailyAutomaticBackupStartTime()));
        case "AutomaticBackupRetentionDays":
            return Optional.ofNullable(clazz.cast(automaticBackupRetentionDays()));
        case "AutoImportPolicy":
            return Optional.ofNullable(clazz.cast(autoImportPolicyAsString()));
        case "DataCompressionType":
            return Optional.ofNullable(clazz.cast(dataCompressionTypeAsString()));
        case "LogConfiguration":
            return Optional.ofNullable(clazz.cast(logConfiguration()));
        case "RootSquashConfiguration":
            return Optional.ofNullable(clazz.cast(rootSquashConfiguration()));
        case "PerUnitStorageThroughput":
            return Optional.ofNullable(clazz.cast(perUnitStorageThroughput()));
        case "MetadataConfiguration":
            return Optional.ofNullable(clazz.cast(metadataConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("WeeklyMaintenanceStartTime", WEEKLY_MAINTENANCE_START_TIME_FIELD);
        map.put("DailyAutomaticBackupStartTime", DAILY_AUTOMATIC_BACKUP_START_TIME_FIELD);
        map.put("AutomaticBackupRetentionDays", AUTOMATIC_BACKUP_RETENTION_DAYS_FIELD);
        map.put("AutoImportPolicy", AUTO_IMPORT_POLICY_FIELD);
        map.put("DataCompressionType", DATA_COMPRESSION_TYPE_FIELD);
        map.put("LogConfiguration", LOG_CONFIGURATION_FIELD);
        map.put("RootSquashConfiguration", ROOT_SQUASH_CONFIGURATION_FIELD);
        map.put("PerUnitStorageThroughput", PER_UNIT_STORAGE_THROUGHPUT_FIELD);
        map.put("MetadataConfiguration", METADATA_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateFileSystemLustreConfiguration, T> g) {
        return obj -> g.apply((UpdateFileSystemLustreConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateFileSystemLustreConfiguration> {
        /**
         * <p>
         * (Optional) The preferred start time to perform weekly maintenance, formatted d:HH:MM in the UTC time zone. d
         * is the weekday number, from 1 through 7, beginning with Monday and ending with Sunday.
         * </p>
         * 
         * @param weeklyMaintenanceStartTime
         *        (Optional) The preferred start time to perform weekly maintenance, formatted d:HH:MM in the UTC time
         *        zone. d is the weekday number, from 1 through 7, beginning with Monday and ending with Sunday.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder weeklyMaintenanceStartTime(String weeklyMaintenanceStartTime);

        /**
         * Sets the value of the DailyAutomaticBackupStartTime property for this object.
         *
         * @param dailyAutomaticBackupStartTime
         *        The new value for the DailyAutomaticBackupStartTime property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dailyAutomaticBackupStartTime(String dailyAutomaticBackupStartTime);

        /**
         * <p>
         * The number of days to retain automatic backups. Setting this property to <code>0</code> disables automatic
         * backups. You can retain automatic backups for a maximum of 90 days. The default is <code>0</code>.
         * </p>
         * 
         * @param automaticBackupRetentionDays
         *        The number of days to retain automatic backups. Setting this property to <code>0</code> disables
         *        automatic backups. You can retain automatic backups for a maximum of 90 days. The default is
         *        <code>0</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automaticBackupRetentionDays(Integer automaticBackupRetentionDays);

        /**
         * <p>
         * (Optional) When you create your file system, your existing S3 objects appear as file and directory listings.
         * Use this property to choose how Amazon FSx keeps your file and directory listing up to date as you add or
         * modify objects in your linked S3 bucket. <code>AutoImportPolicy</code> can have the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NONE</code> - (Default) AutoImport is off. Amazon FSx only updates file and directory listings from the
         * linked S3 bucket when the file system is created. FSx does not update the file and directory listing for any
         * new or changed objects after choosing this option.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NEW</code> - AutoImport is on. Amazon FSx automatically imports directory listings of any new objects
         * added to the linked S3 bucket that do not currently exist in the FSx file system.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NEW_CHANGED</code> - AutoImport is on. Amazon FSx automatically imports file and directory listings of
         * any new objects added to the S3 bucket and any existing objects that are changed in the S3 bucket after you
         * choose this option.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NEW_CHANGED_DELETED</code> - AutoImport is on. Amazon FSx automatically imports file and directory
         * listings of any new objects added to the S3 bucket, any existing objects that are changed in the S3 bucket,
         * and any objects that were deleted in the S3 bucket.
         * </p>
         * </li>
         * </ul>
         * <p>
         * This parameter is not supported for file systems with a data repository association.
         * </p>
         * 
         * @param autoImportPolicy
         *        (Optional) When you create your file system, your existing S3 objects appear as file and directory
         *        listings. Use this property to choose how Amazon FSx keeps your file and directory listing up to date
         *        as you add or modify objects in your linked S3 bucket. <code>AutoImportPolicy</code> can have the
         *        following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NONE</code> - (Default) AutoImport is off. Amazon FSx only updates file and directory listings
         *        from the linked S3 bucket when the file system is created. FSx does not update the file and directory
         *        listing for any new or changed objects after choosing this option.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NEW</code> - AutoImport is on. Amazon FSx automatically imports directory listings of any new
         *        objects added to the linked S3 bucket that do not currently exist in the FSx file system.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NEW_CHANGED</code> - AutoImport is on. Amazon FSx automatically imports file and directory
         *        listings of any new objects added to the S3 bucket and any existing objects that are changed in the S3
         *        bucket after you choose this option.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NEW_CHANGED_DELETED</code> - AutoImport is on. Amazon FSx automatically imports file and
         *        directory listings of any new objects added to the S3 bucket, any existing objects that are changed in
         *        the S3 bucket, and any objects that were deleted in the S3 bucket.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        This parameter is not supported for file systems with a data repository association.
         * @see AutoImportPolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoImportPolicyType
         */
        Builder autoImportPolicy(String autoImportPolicy);

        /**
         * <p>
         * (Optional) When you create your file system, your existing S3 objects appear as file and directory listings.
         * Use this property to choose how Amazon FSx keeps your file and directory listing up to date as you add or
         * modify objects in your linked S3 bucket. <code>AutoImportPolicy</code> can have the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NONE</code> - (Default) AutoImport is off. Amazon FSx only updates file and directory listings from the
         * linked S3 bucket when the file system is created. FSx does not update the file and directory listing for any
         * new or changed objects after choosing this option.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NEW</code> - AutoImport is on. Amazon FSx automatically imports directory listings of any new objects
         * added to the linked S3 bucket that do not currently exist in the FSx file system.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NEW_CHANGED</code> - AutoImport is on. Amazon FSx automatically imports file and directory listings of
         * any new objects added to the S3 bucket and any existing objects that are changed in the S3 bucket after you
         * choose this option.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NEW_CHANGED_DELETED</code> - AutoImport is on. Amazon FSx automatically imports file and directory
         * listings of any new objects added to the S3 bucket, any existing objects that are changed in the S3 bucket,
         * and any objects that were deleted in the S3 bucket.
         * </p>
         * </li>
         * </ul>
         * <p>
         * This parameter is not supported for file systems with a data repository association.
         * </p>
         * 
         * @param autoImportPolicy
         *        (Optional) When you create your file system, your existing S3 objects appear as file and directory
         *        listings. Use this property to choose how Amazon FSx keeps your file and directory listing up to date
         *        as you add or modify objects in your linked S3 bucket. <code>AutoImportPolicy</code> can have the
         *        following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NONE</code> - (Default) AutoImport is off. Amazon FSx only updates file and directory listings
         *        from the linked S3 bucket when the file system is created. FSx does not update the file and directory
         *        listing for any new or changed objects after choosing this option.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NEW</code> - AutoImport is on. Amazon FSx automatically imports directory listings of any new
         *        objects added to the linked S3 bucket that do not currently exist in the FSx file system.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NEW_CHANGED</code> - AutoImport is on. Amazon FSx automatically imports file and directory
         *        listings of any new objects added to the S3 bucket and any existing objects that are changed in the S3
         *        bucket after you choose this option.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NEW_CHANGED_DELETED</code> - AutoImport is on. Amazon FSx automatically imports file and
         *        directory listings of any new objects added to the S3 bucket, any existing objects that are changed in
         *        the S3 bucket, and any objects that were deleted in the S3 bucket.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        This parameter is not supported for file systems with a data repository association.
         * @see AutoImportPolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoImportPolicyType
         */
        Builder autoImportPolicy(AutoImportPolicyType autoImportPolicy);

        /**
         * <p>
         * Sets the data compression configuration for the file system. <code>DataCompressionType</code> can have the
         * following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NONE</code> - Data compression is turned off for the file system.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LZ4</code> - Data compression is turned on with the LZ4 algorithm.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you don't use <code>DataCompressionType</code>, the file system retains its current data compression
         * configuration.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/data-compression.html">Lustre data compression</a>.
         * </p>
         * 
         * @param dataCompressionType
         *        Sets the data compression configuration for the file system. <code>DataCompressionType</code> can have
         *        the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NONE</code> - Data compression is turned off for the file system.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LZ4</code> - Data compression is turned on with the LZ4 algorithm.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you don't use <code>DataCompressionType</code>, the file system retains its current data
         *        compression configuration.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/data-compression.html">Lustre data
         *        compression</a>.
         * @see DataCompressionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataCompressionType
         */
        Builder dataCompressionType(String dataCompressionType);

        /**
         * <p>
         * Sets the data compression configuration for the file system. <code>DataCompressionType</code> can have the
         * following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NONE</code> - Data compression is turned off for the file system.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LZ4</code> - Data compression is turned on with the LZ4 algorithm.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you don't use <code>DataCompressionType</code>, the file system retains its current data compression
         * configuration.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/data-compression.html">Lustre data compression</a>.
         * </p>
         * 
         * @param dataCompressionType
         *        Sets the data compression configuration for the file system. <code>DataCompressionType</code> can have
         *        the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NONE</code> - Data compression is turned off for the file system.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LZ4</code> - Data compression is turned on with the LZ4 algorithm.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you don't use <code>DataCompressionType</code>, the file system retains its current data
         *        compression configuration.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/data-compression.html">Lustre data
         *        compression</a>.
         * @see DataCompressionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataCompressionType
         */
        Builder dataCompressionType(DataCompressionType dataCompressionType);

        /**
         * <p>
         * The Lustre logging configuration used when updating an Amazon FSx for Lustre file system. When logging is
         * enabled, Lustre logs error and warning events for data repositories associated with your file system to
         * Amazon CloudWatch Logs.
         * </p>
         * 
         * @param logConfiguration
         *        The Lustre logging configuration used when updating an Amazon FSx for Lustre file system. When logging
         *        is enabled, Lustre logs error and warning events for data repositories associated with your file
         *        system to Amazon CloudWatch Logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logConfiguration(LustreLogCreateConfiguration logConfiguration);

        /**
         * <p>
         * The Lustre logging configuration used when updating an Amazon FSx for Lustre file system. When logging is
         * enabled, Lustre logs error and warning events for data repositories associated with your file system to
         * Amazon CloudWatch Logs.
         * </p>
         * This is a convenience method that creates an instance of the {@link LustreLogCreateConfiguration.Builder}
         * avoiding the need to create one manually via {@link LustreLogCreateConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LustreLogCreateConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #logConfiguration(LustreLogCreateConfiguration)}.
         * 
         * @param logConfiguration
         *        a consumer that will call methods on {@link LustreLogCreateConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logConfiguration(LustreLogCreateConfiguration)
         */
        default Builder logConfiguration(Consumer<LustreLogCreateConfiguration.Builder> logConfiguration) {
            return logConfiguration(LustreLogCreateConfiguration.builder().applyMutation(logConfiguration).build());
        }

        /**
         * <p>
         * The Lustre root squash configuration used when updating an Amazon FSx for Lustre file system. When enabled,
         * root squash restricts root-level access from clients that try to access your file system as a root user.
         * </p>
         * 
         * @param rootSquashConfiguration
         *        The Lustre root squash configuration used when updating an Amazon FSx for Lustre file system. When
         *        enabled, root squash restricts root-level access from clients that try to access your file system as a
         *        root user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rootSquashConfiguration(LustreRootSquashConfiguration rootSquashConfiguration);

        /**
         * <p>
         * The Lustre root squash configuration used when updating an Amazon FSx for Lustre file system. When enabled,
         * root squash restricts root-level access from clients that try to access your file system as a root user.
         * </p>
         * This is a convenience method that creates an instance of the {@link LustreRootSquashConfiguration.Builder}
         * avoiding the need to create one manually via {@link LustreRootSquashConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LustreRootSquashConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #rootSquashConfiguration(LustreRootSquashConfiguration)}.
         * 
         * @param rootSquashConfiguration
         *        a consumer that will call methods on {@link LustreRootSquashConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rootSquashConfiguration(LustreRootSquashConfiguration)
         */
        default Builder rootSquashConfiguration(Consumer<LustreRootSquashConfiguration.Builder> rootSquashConfiguration) {
            return rootSquashConfiguration(LustreRootSquashConfiguration.builder().applyMutation(rootSquashConfiguration).build());
        }

        /**
         * <p>
         * The throughput of an Amazon FSx for Lustre Persistent SSD-based file system, measured in megabytes per second
         * per tebibyte (MB/s/TiB). You can increase or decrease your file system's throughput. Valid values depend on
         * the deployment type of the file system, as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * For <code>PERSISTENT_1</code> SSD-based deployment types, valid values are 50, 100, and 200 MB/s/TiB.
         * </p>
         * </li>
         * <li>
         * <p>
         * For <code>PERSISTENT_2</code> SSD-based deployment types, valid values are 125, 250, 500, and 1000 MB/s/TiB.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/managing-throughput-capacity.html"> Managing
         * throughput capacity</a>.
         * </p>
         * 
         * @param perUnitStorageThroughput
         *        The throughput of an Amazon FSx for Lustre Persistent SSD-based file system, measured in megabytes per
         *        second per tebibyte (MB/s/TiB). You can increase or decrease your file system's throughput. Valid
         *        values depend on the deployment type of the file system, as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        For <code>PERSISTENT_1</code> SSD-based deployment types, valid values are 50, 100, and 200 MB/s/TiB.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For <code>PERSISTENT_2</code> SSD-based deployment types, valid values are 125, 250, 500, and 1000
         *        MB/s/TiB.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/managing-throughput-capacity.html"> Managing
         *        throughput capacity</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder perUnitStorageThroughput(Integer perUnitStorageThroughput);

        /**
         * <p>
         * The Lustre metadata performance configuration for an Amazon FSx for Lustre file system using a
         * <code>PERSISTENT_2</code> deployment type. When this configuration is enabled, the file system supports
         * increasing metadata performance.
         * </p>
         * 
         * @param metadataConfiguration
         *        The Lustre metadata performance configuration for an Amazon FSx for Lustre file system using a
         *        <code>PERSISTENT_2</code> deployment type. When this configuration is enabled, the file system
         *        supports increasing metadata performance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataConfiguration(UpdateFileSystemLustreMetadataConfiguration metadataConfiguration);

        /**
         * <p>
         * The Lustre metadata performance configuration for an Amazon FSx for Lustre file system using a
         * <code>PERSISTENT_2</code> deployment type. When this configuration is enabled, the file system supports
         * increasing metadata performance.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link UpdateFileSystemLustreMetadataConfiguration.Builder} avoiding the need to create one manually via
         * {@link UpdateFileSystemLustreMetadataConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateFileSystemLustreMetadataConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #metadataConfiguration(UpdateFileSystemLustreMetadataConfiguration)}.
         * 
         * @param metadataConfiguration
         *        a consumer that will call methods on {@link UpdateFileSystemLustreMetadataConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadataConfiguration(UpdateFileSystemLustreMetadataConfiguration)
         */
        default Builder metadataConfiguration(Consumer<UpdateFileSystemLustreMetadataConfiguration.Builder> metadataConfiguration) {
            return metadataConfiguration(UpdateFileSystemLustreMetadataConfiguration.builder()
                    .applyMutation(metadataConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String weeklyMaintenanceStartTime;

        private String dailyAutomaticBackupStartTime;

        private Integer automaticBackupRetentionDays;

        private String autoImportPolicy;

        private String dataCompressionType;

        private LustreLogCreateConfiguration logConfiguration;

        private LustreRootSquashConfiguration rootSquashConfiguration;

        private Integer perUnitStorageThroughput;

        private UpdateFileSystemLustreMetadataConfiguration metadataConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFileSystemLustreConfiguration model) {
            weeklyMaintenanceStartTime(model.weeklyMaintenanceStartTime);
            dailyAutomaticBackupStartTime(model.dailyAutomaticBackupStartTime);
            automaticBackupRetentionDays(model.automaticBackupRetentionDays);
            autoImportPolicy(model.autoImportPolicy);
            dataCompressionType(model.dataCompressionType);
            logConfiguration(model.logConfiguration);
            rootSquashConfiguration(model.rootSquashConfiguration);
            perUnitStorageThroughput(model.perUnitStorageThroughput);
            metadataConfiguration(model.metadataConfiguration);
        }

        public final String getWeeklyMaintenanceStartTime() {
            return weeklyMaintenanceStartTime;
        }

        public final void setWeeklyMaintenanceStartTime(String weeklyMaintenanceStartTime) {
            this.weeklyMaintenanceStartTime = weeklyMaintenanceStartTime;
        }

        @Override
        public final Builder weeklyMaintenanceStartTime(String weeklyMaintenanceStartTime) {
            this.weeklyMaintenanceStartTime = weeklyMaintenanceStartTime;
            return this;
        }

        public final String getDailyAutomaticBackupStartTime() {
            return dailyAutomaticBackupStartTime;
        }

        public final void setDailyAutomaticBackupStartTime(String dailyAutomaticBackupStartTime) {
            this.dailyAutomaticBackupStartTime = dailyAutomaticBackupStartTime;
        }

        @Override
        public final Builder dailyAutomaticBackupStartTime(String dailyAutomaticBackupStartTime) {
            this.dailyAutomaticBackupStartTime = dailyAutomaticBackupStartTime;
            return this;
        }

        public final Integer getAutomaticBackupRetentionDays() {
            return automaticBackupRetentionDays;
        }

        public final void setAutomaticBackupRetentionDays(Integer automaticBackupRetentionDays) {
            this.automaticBackupRetentionDays = automaticBackupRetentionDays;
        }

        @Override
        public final Builder automaticBackupRetentionDays(Integer automaticBackupRetentionDays) {
            this.automaticBackupRetentionDays = automaticBackupRetentionDays;
            return this;
        }

        public final String getAutoImportPolicy() {
            return autoImportPolicy;
        }

        public final void setAutoImportPolicy(String autoImportPolicy) {
            this.autoImportPolicy = autoImportPolicy;
        }

        @Override
        public final Builder autoImportPolicy(String autoImportPolicy) {
            this.autoImportPolicy = autoImportPolicy;
            return this;
        }

        @Override
        public final Builder autoImportPolicy(AutoImportPolicyType autoImportPolicy) {
            this.autoImportPolicy(autoImportPolicy == null ? null : autoImportPolicy.toString());
            return this;
        }

        public final String getDataCompressionType() {
            return dataCompressionType;
        }

        public final void setDataCompressionType(String dataCompressionType) {
            this.dataCompressionType = dataCompressionType;
        }

        @Override
        public final Builder dataCompressionType(String dataCompressionType) {
            this.dataCompressionType = dataCompressionType;
            return this;
        }

        @Override
        public final Builder dataCompressionType(DataCompressionType dataCompressionType) {
            this.dataCompressionType(dataCompressionType == null ? null : dataCompressionType.toString());
            return this;
        }

        public final LustreLogCreateConfiguration.Builder getLogConfiguration() {
            return logConfiguration != null ? logConfiguration.toBuilder() : null;
        }

        public final void setLogConfiguration(LustreLogCreateConfiguration.BuilderImpl logConfiguration) {
            this.logConfiguration = logConfiguration != null ? logConfiguration.build() : null;
        }

        @Override
        public final Builder logConfiguration(LustreLogCreateConfiguration logConfiguration) {
            this.logConfiguration = logConfiguration;
            return this;
        }

        public final LustreRootSquashConfiguration.Builder getRootSquashConfiguration() {
            return rootSquashConfiguration != null ? rootSquashConfiguration.toBuilder() : null;
        }

        public final void setRootSquashConfiguration(LustreRootSquashConfiguration.BuilderImpl rootSquashConfiguration) {
            this.rootSquashConfiguration = rootSquashConfiguration != null ? rootSquashConfiguration.build() : null;
        }

        @Override
        public final Builder rootSquashConfiguration(LustreRootSquashConfiguration rootSquashConfiguration) {
            this.rootSquashConfiguration = rootSquashConfiguration;
            return this;
        }

        public final Integer getPerUnitStorageThroughput() {
            return perUnitStorageThroughput;
        }

        public final void setPerUnitStorageThroughput(Integer perUnitStorageThroughput) {
            this.perUnitStorageThroughput = perUnitStorageThroughput;
        }

        @Override
        public final Builder perUnitStorageThroughput(Integer perUnitStorageThroughput) {
            this.perUnitStorageThroughput = perUnitStorageThroughput;
            return this;
        }

        public final UpdateFileSystemLustreMetadataConfiguration.Builder getMetadataConfiguration() {
            return metadataConfiguration != null ? metadataConfiguration.toBuilder() : null;
        }

        public final void setMetadataConfiguration(UpdateFileSystemLustreMetadataConfiguration.BuilderImpl metadataConfiguration) {
            this.metadataConfiguration = metadataConfiguration != null ? metadataConfiguration.build() : null;
        }

        @Override
        public final Builder metadataConfiguration(UpdateFileSystemLustreMetadataConfiguration metadataConfiguration) {
            this.metadataConfiguration = metadataConfiguration;
            return this;
        }

        @Override
        public UpdateFileSystemLustreConfiguration build() {
            return new UpdateFileSystemLustreConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
