/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fsx.model.LifecycleTransitionReason;
import software.amazon.awssdk.services.fsx.model.S3AccessPoint;
import software.amazon.awssdk.services.fsx.model.S3AccessPointAttachmentLifecycle;
import software.amazon.awssdk.services.fsx.model.S3AccessPointAttachmentType;
import software.amazon.awssdk.services.fsx.model.S3AccessPointOpenZFSConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3AccessPointAttachment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3AccessPointAttachment> {
    private static final SdkField<String> LIFECYCLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Lifecycle").getter(S3AccessPointAttachment.getter(S3AccessPointAttachment::lifecycleAsString)).setter(S3AccessPointAttachment.setter(Builder::lifecycle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lifecycle").build()}).build();
    private static final SdkField<LifecycleTransitionReason> LIFECYCLE_TRANSITION_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LifecycleTransitionReason").getter(S3AccessPointAttachment.getter(S3AccessPointAttachment::lifecycleTransitionReason)).setter(S3AccessPointAttachment.setter(Builder::lifecycleTransitionReason)).constructor(LifecycleTransitionReason::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifecycleTransitionReason").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(S3AccessPointAttachment.getter(S3AccessPointAttachment::creationTime)).setter(S3AccessPointAttachment.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(S3AccessPointAttachment.getter(S3AccessPointAttachment::name)).setter(S3AccessPointAttachment.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(S3AccessPointAttachment.getter(S3AccessPointAttachment::typeAsString)).setter(S3AccessPointAttachment.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<S3AccessPointOpenZFSConfiguration> OPEN_ZFS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OpenZFSConfiguration").getter(S3AccessPointAttachment.getter(S3AccessPointAttachment::openZFSConfiguration)).setter(S3AccessPointAttachment.setter(Builder::openZFSConfiguration)).constructor(S3AccessPointOpenZFSConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpenZFSConfiguration").build()}).build();
    private static final SdkField<S3AccessPoint> S3_ACCESS_POINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3AccessPoint").getter(S3AccessPointAttachment.getter(S3AccessPointAttachment::s3AccessPoint)).setter(S3AccessPointAttachment.setter(Builder::s3AccessPoint)).constructor(S3AccessPoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3AccessPoint").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIFECYCLE_FIELD, LIFECYCLE_TRANSITION_REASON_FIELD, CREATION_TIME_FIELD, NAME_FIELD, TYPE_FIELD, OPEN_ZFS_CONFIGURATION_FIELD, S3_ACCESS_POINT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = S3AccessPointAttachment.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String lifecycle;
    private final LifecycleTransitionReason lifecycleTransitionReason;
    private final Instant creationTime;
    private final String name;
    private final String type;
    private final S3AccessPointOpenZFSConfiguration openZFSConfiguration;
    private final S3AccessPoint s3AccessPoint;

    private S3AccessPointAttachment(BuilderImpl builder) {
        this.lifecycle = builder.lifecycle;
        this.lifecycleTransitionReason = builder.lifecycleTransitionReason;
        this.creationTime = builder.creationTime;
        this.name = builder.name;
        this.type = builder.type;
        this.openZFSConfiguration = builder.openZFSConfiguration;
        this.s3AccessPoint = builder.s3AccessPoint;
    }

    public final S3AccessPointAttachmentLifecycle lifecycle() {
        return S3AccessPointAttachmentLifecycle.fromValue(this.lifecycle);
    }

    public final String lifecycleAsString() {
        return this.lifecycle;
    }

    public final LifecycleTransitionReason lifecycleTransitionReason() {
        return this.lifecycleTransitionReason;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String name() {
        return this.name;
    }

    public final S3AccessPointAttachmentType type() {
        return S3AccessPointAttachmentType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final S3AccessPointOpenZFSConfiguration openZFSConfiguration() {
        return this.openZFSConfiguration;
    }

    public final S3AccessPoint s3AccessPoint() {
        return this.s3AccessPoint;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleTransitionReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.openZFSConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3AccessPoint());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3AccessPointAttachment)) {
            return false;
        }
        S3AccessPointAttachment other = (S3AccessPointAttachment)obj;
        return Objects.equals(this.lifecycleAsString(), other.lifecycleAsString()) && Objects.equals(this.lifecycleTransitionReason(), other.lifecycleTransitionReason()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.openZFSConfiguration(), other.openZFSConfiguration()) && Objects.equals(this.s3AccessPoint(), other.s3AccessPoint());
    }

    public final String toString() {
        return ToString.builder((String)"S3AccessPointAttachment").add("Lifecycle", (Object)this.lifecycleAsString()).add("LifecycleTransitionReason", (Object)this.lifecycleTransitionReason()).add("CreationTime", (Object)this.creationTime()).add("Name", (Object)this.name()).add("Type", (Object)this.typeAsString()).add("OpenZFSConfiguration", (Object)this.openZFSConfiguration()).add("S3AccessPoint", (Object)this.s3AccessPoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Lifecycle": {
                return Optional.ofNullable(clazz.cast(this.lifecycleAsString()));
            }
            case "LifecycleTransitionReason": {
                return Optional.ofNullable(clazz.cast(this.lifecycleTransitionReason()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "OpenZFSConfiguration": {
                return Optional.ofNullable(clazz.cast(this.openZFSConfiguration()));
            }
            case "S3AccessPoint": {
                return Optional.ofNullable(clazz.cast(this.s3AccessPoint()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Lifecycle", LIFECYCLE_FIELD);
        map.put("LifecycleTransitionReason", LIFECYCLE_TRANSITION_REASON_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("OpenZFSConfiguration", OPEN_ZFS_CONFIGURATION_FIELD);
        map.put("S3AccessPoint", S3_ACCESS_POINT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3AccessPointAttachment, T> g) {
        return obj -> g.apply((S3AccessPointAttachment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String lifecycle;
        private LifecycleTransitionReason lifecycleTransitionReason;
        private Instant creationTime;
        private String name;
        private String type;
        private S3AccessPointOpenZFSConfiguration openZFSConfiguration;
        private S3AccessPoint s3AccessPoint;

        private BuilderImpl() {
        }

        private BuilderImpl(S3AccessPointAttachment model) {
            this.lifecycle(model.lifecycle);
            this.lifecycleTransitionReason(model.lifecycleTransitionReason);
            this.creationTime(model.creationTime);
            this.name(model.name);
            this.type(model.type);
            this.openZFSConfiguration(model.openZFSConfiguration);
            this.s3AccessPoint(model.s3AccessPoint);
        }

        public final String getLifecycle() {
            return this.lifecycle;
        }

        public final void setLifecycle(String lifecycle) {
            this.lifecycle = lifecycle;
        }

        @Override
        public final Builder lifecycle(String lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        @Override
        public final Builder lifecycle(S3AccessPointAttachmentLifecycle lifecycle) {
            this.lifecycle(lifecycle == null ? null : lifecycle.toString());
            return this;
        }

        public final LifecycleTransitionReason.Builder getLifecycleTransitionReason() {
            return this.lifecycleTransitionReason != null ? this.lifecycleTransitionReason.toBuilder() : null;
        }

        public final void setLifecycleTransitionReason(LifecycleTransitionReason.BuilderImpl lifecycleTransitionReason) {
            this.lifecycleTransitionReason = lifecycleTransitionReason != null ? lifecycleTransitionReason.build() : null;
        }

        @Override
        public final Builder lifecycleTransitionReason(LifecycleTransitionReason lifecycleTransitionReason) {
            this.lifecycleTransitionReason = lifecycleTransitionReason;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(S3AccessPointAttachmentType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final S3AccessPointOpenZFSConfiguration.Builder getOpenZFSConfiguration() {
            return this.openZFSConfiguration != null ? this.openZFSConfiguration.toBuilder() : null;
        }

        public final void setOpenZFSConfiguration(S3AccessPointOpenZFSConfiguration.BuilderImpl openZFSConfiguration) {
            this.openZFSConfiguration = openZFSConfiguration != null ? openZFSConfiguration.build() : null;
        }

        @Override
        public final Builder openZFSConfiguration(S3AccessPointOpenZFSConfiguration openZFSConfiguration) {
            this.openZFSConfiguration = openZFSConfiguration;
            return this;
        }

        public final S3AccessPoint.Builder getS3AccessPoint() {
            return this.s3AccessPoint != null ? this.s3AccessPoint.toBuilder() : null;
        }

        public final void setS3AccessPoint(S3AccessPoint.BuilderImpl s3AccessPoint) {
            this.s3AccessPoint = s3AccessPoint != null ? s3AccessPoint.build() : null;
        }

        @Override
        public final Builder s3AccessPoint(S3AccessPoint s3AccessPoint) {
            this.s3AccessPoint = s3AccessPoint;
            return this;
        }

        public S3AccessPointAttachment build() {
            return new S3AccessPointAttachment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3AccessPointAttachment> {
        public Builder lifecycle(String var1);

        public Builder lifecycle(S3AccessPointAttachmentLifecycle var1);

        public Builder lifecycleTransitionReason(LifecycleTransitionReason var1);

        default public Builder lifecycleTransitionReason(Consumer<LifecycleTransitionReason.Builder> lifecycleTransitionReason) {
            return this.lifecycleTransitionReason((LifecycleTransitionReason)((LifecycleTransitionReason.Builder)LifecycleTransitionReason.builder().applyMutation(lifecycleTransitionReason)).build());
        }

        public Builder creationTime(Instant var1);

        public Builder name(String var1);

        public Builder type(String var1);

        public Builder type(S3AccessPointAttachmentType var1);

        public Builder openZFSConfiguration(S3AccessPointOpenZFSConfiguration var1);

        default public Builder openZFSConfiguration(Consumer<S3AccessPointOpenZFSConfiguration.Builder> openZFSConfiguration) {
            return this.openZFSConfiguration((S3AccessPointOpenZFSConfiguration)((S3AccessPointOpenZFSConfiguration.Builder)S3AccessPointOpenZFSConfiguration.builder().applyMutation(openZFSConfiguration)).build());
        }

        public Builder s3AccessPoint(S3AccessPoint var1);

        default public Builder s3AccessPoint(Consumer<S3AccessPoint.Builder> s3AccessPoint) {
            return this.s3AccessPoint((S3AccessPoint)((S3AccessPoint.Builder)S3AccessPoint.builder().applyMutation(s3AccessPoint)).build());
        }
    }
}

