/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.fsx.FSxClient;
import software.amazon.awssdk.services.fsx.FSxServiceClientConfiguration;
import software.amazon.awssdk.services.fsx.internal.FSxServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.fsx.model.AccessPointAlreadyOwnedByYouException;
import software.amazon.awssdk.services.fsx.model.ActiveDirectoryErrorException;
import software.amazon.awssdk.services.fsx.model.AssociateFileSystemAliasesRequest;
import software.amazon.awssdk.services.fsx.model.AssociateFileSystemAliasesResponse;
import software.amazon.awssdk.services.fsx.model.BackupBeingCopiedException;
import software.amazon.awssdk.services.fsx.model.BackupInProgressException;
import software.amazon.awssdk.services.fsx.model.BackupNotFoundException;
import software.amazon.awssdk.services.fsx.model.BackupRestoringException;
import software.amazon.awssdk.services.fsx.model.BadRequestException;
import software.amazon.awssdk.services.fsx.model.CancelDataRepositoryTaskRequest;
import software.amazon.awssdk.services.fsx.model.CancelDataRepositoryTaskResponse;
import software.amazon.awssdk.services.fsx.model.CopyBackupRequest;
import software.amazon.awssdk.services.fsx.model.CopyBackupResponse;
import software.amazon.awssdk.services.fsx.model.CopySnapshotAndUpdateVolumeRequest;
import software.amazon.awssdk.services.fsx.model.CopySnapshotAndUpdateVolumeResponse;
import software.amazon.awssdk.services.fsx.model.CreateAndAttachS3AccessPointRequest;
import software.amazon.awssdk.services.fsx.model.CreateAndAttachS3AccessPointResponse;
import software.amazon.awssdk.services.fsx.model.CreateBackupRequest;
import software.amazon.awssdk.services.fsx.model.CreateBackupResponse;
import software.amazon.awssdk.services.fsx.model.CreateDataRepositoryAssociationRequest;
import software.amazon.awssdk.services.fsx.model.CreateDataRepositoryAssociationResponse;
import software.amazon.awssdk.services.fsx.model.CreateDataRepositoryTaskRequest;
import software.amazon.awssdk.services.fsx.model.CreateDataRepositoryTaskResponse;
import software.amazon.awssdk.services.fsx.model.CreateFileCacheRequest;
import software.amazon.awssdk.services.fsx.model.CreateFileCacheResponse;
import software.amazon.awssdk.services.fsx.model.CreateFileSystemFromBackupRequest;
import software.amazon.awssdk.services.fsx.model.CreateFileSystemFromBackupResponse;
import software.amazon.awssdk.services.fsx.model.CreateFileSystemRequest;
import software.amazon.awssdk.services.fsx.model.CreateFileSystemResponse;
import software.amazon.awssdk.services.fsx.model.CreateSnapshotRequest;
import software.amazon.awssdk.services.fsx.model.CreateSnapshotResponse;
import software.amazon.awssdk.services.fsx.model.CreateStorageVirtualMachineRequest;
import software.amazon.awssdk.services.fsx.model.CreateStorageVirtualMachineResponse;
import software.amazon.awssdk.services.fsx.model.CreateVolumeFromBackupRequest;
import software.amazon.awssdk.services.fsx.model.CreateVolumeFromBackupResponse;
import software.amazon.awssdk.services.fsx.model.CreateVolumeRequest;
import software.amazon.awssdk.services.fsx.model.CreateVolumeResponse;
import software.amazon.awssdk.services.fsx.model.DataRepositoryAssociationNotFoundException;
import software.amazon.awssdk.services.fsx.model.DataRepositoryTaskEndedException;
import software.amazon.awssdk.services.fsx.model.DataRepositoryTaskExecutingException;
import software.amazon.awssdk.services.fsx.model.DataRepositoryTaskNotFoundException;
import software.amazon.awssdk.services.fsx.model.DeleteBackupRequest;
import software.amazon.awssdk.services.fsx.model.DeleteBackupResponse;
import software.amazon.awssdk.services.fsx.model.DeleteDataRepositoryAssociationRequest;
import software.amazon.awssdk.services.fsx.model.DeleteDataRepositoryAssociationResponse;
import software.amazon.awssdk.services.fsx.model.DeleteFileCacheRequest;
import software.amazon.awssdk.services.fsx.model.DeleteFileCacheResponse;
import software.amazon.awssdk.services.fsx.model.DeleteFileSystemRequest;
import software.amazon.awssdk.services.fsx.model.DeleteFileSystemResponse;
import software.amazon.awssdk.services.fsx.model.DeleteSnapshotRequest;
import software.amazon.awssdk.services.fsx.model.DeleteSnapshotResponse;
import software.amazon.awssdk.services.fsx.model.DeleteStorageVirtualMachineRequest;
import software.amazon.awssdk.services.fsx.model.DeleteStorageVirtualMachineResponse;
import software.amazon.awssdk.services.fsx.model.DeleteVolumeRequest;
import software.amazon.awssdk.services.fsx.model.DeleteVolumeResponse;
import software.amazon.awssdk.services.fsx.model.DescribeBackupsRequest;
import software.amazon.awssdk.services.fsx.model.DescribeBackupsResponse;
import software.amazon.awssdk.services.fsx.model.DescribeDataRepositoryAssociationsRequest;
import software.amazon.awssdk.services.fsx.model.DescribeDataRepositoryAssociationsResponse;
import software.amazon.awssdk.services.fsx.model.DescribeDataRepositoryTasksRequest;
import software.amazon.awssdk.services.fsx.model.DescribeDataRepositoryTasksResponse;
import software.amazon.awssdk.services.fsx.model.DescribeFileCachesRequest;
import software.amazon.awssdk.services.fsx.model.DescribeFileCachesResponse;
import software.amazon.awssdk.services.fsx.model.DescribeFileSystemAliasesRequest;
import software.amazon.awssdk.services.fsx.model.DescribeFileSystemAliasesResponse;
import software.amazon.awssdk.services.fsx.model.DescribeFileSystemsRequest;
import software.amazon.awssdk.services.fsx.model.DescribeFileSystemsResponse;
import software.amazon.awssdk.services.fsx.model.DescribeS3AccessPointAttachmentsRequest;
import software.amazon.awssdk.services.fsx.model.DescribeS3AccessPointAttachmentsResponse;
import software.amazon.awssdk.services.fsx.model.DescribeSharedVpcConfigurationRequest;
import software.amazon.awssdk.services.fsx.model.DescribeSharedVpcConfigurationResponse;
import software.amazon.awssdk.services.fsx.model.DescribeSnapshotsRequest;
import software.amazon.awssdk.services.fsx.model.DescribeSnapshotsResponse;
import software.amazon.awssdk.services.fsx.model.DescribeStorageVirtualMachinesRequest;
import software.amazon.awssdk.services.fsx.model.DescribeStorageVirtualMachinesResponse;
import software.amazon.awssdk.services.fsx.model.DescribeVolumesRequest;
import software.amazon.awssdk.services.fsx.model.DescribeVolumesResponse;
import software.amazon.awssdk.services.fsx.model.DetachAndDeleteS3AccessPointRequest;
import software.amazon.awssdk.services.fsx.model.DetachAndDeleteS3AccessPointResponse;
import software.amazon.awssdk.services.fsx.model.DisassociateFileSystemAliasesRequest;
import software.amazon.awssdk.services.fsx.model.DisassociateFileSystemAliasesResponse;
import software.amazon.awssdk.services.fsx.model.FSxException;
import software.amazon.awssdk.services.fsx.model.FileCacheNotFoundException;
import software.amazon.awssdk.services.fsx.model.FileSystemNotFoundException;
import software.amazon.awssdk.services.fsx.model.IncompatibleParameterErrorException;
import software.amazon.awssdk.services.fsx.model.IncompatibleRegionForMultiAzException;
import software.amazon.awssdk.services.fsx.model.InternalServerErrorException;
import software.amazon.awssdk.services.fsx.model.InvalidAccessPointException;
import software.amazon.awssdk.services.fsx.model.InvalidDataRepositoryTypeException;
import software.amazon.awssdk.services.fsx.model.InvalidDestinationKmsKeyException;
import software.amazon.awssdk.services.fsx.model.InvalidExportPathException;
import software.amazon.awssdk.services.fsx.model.InvalidImportPathException;
import software.amazon.awssdk.services.fsx.model.InvalidNetworkSettingsException;
import software.amazon.awssdk.services.fsx.model.InvalidPerUnitStorageThroughputException;
import software.amazon.awssdk.services.fsx.model.InvalidRegionException;
import software.amazon.awssdk.services.fsx.model.InvalidRequestException;
import software.amazon.awssdk.services.fsx.model.InvalidSourceKmsKeyException;
import software.amazon.awssdk.services.fsx.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.fsx.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.fsx.model.MissingFileCacheConfigurationException;
import software.amazon.awssdk.services.fsx.model.MissingFileSystemConfigurationException;
import software.amazon.awssdk.services.fsx.model.MissingVolumeConfigurationException;
import software.amazon.awssdk.services.fsx.model.NotServiceResourceErrorException;
import software.amazon.awssdk.services.fsx.model.ReleaseFileSystemNfsV3LocksRequest;
import software.amazon.awssdk.services.fsx.model.ReleaseFileSystemNfsV3LocksResponse;
import software.amazon.awssdk.services.fsx.model.ResourceDoesNotSupportTaggingException;
import software.amazon.awssdk.services.fsx.model.ResourceNotFoundException;
import software.amazon.awssdk.services.fsx.model.RestoreVolumeFromSnapshotRequest;
import software.amazon.awssdk.services.fsx.model.RestoreVolumeFromSnapshotResponse;
import software.amazon.awssdk.services.fsx.model.S3AccessPointAttachmentNotFoundException;
import software.amazon.awssdk.services.fsx.model.ServiceLimitExceededException;
import software.amazon.awssdk.services.fsx.model.SnapshotNotFoundException;
import software.amazon.awssdk.services.fsx.model.SourceBackupUnavailableException;
import software.amazon.awssdk.services.fsx.model.StartMisconfiguredStateRecoveryRequest;
import software.amazon.awssdk.services.fsx.model.StartMisconfiguredStateRecoveryResponse;
import software.amazon.awssdk.services.fsx.model.StorageVirtualMachineNotFoundException;
import software.amazon.awssdk.services.fsx.model.TagResourceRequest;
import software.amazon.awssdk.services.fsx.model.TagResourceResponse;
import software.amazon.awssdk.services.fsx.model.TooManyAccessPointsException;
import software.amazon.awssdk.services.fsx.model.UnsupportedOperationException;
import software.amazon.awssdk.services.fsx.model.UntagResourceRequest;
import software.amazon.awssdk.services.fsx.model.UntagResourceResponse;
import software.amazon.awssdk.services.fsx.model.UpdateDataRepositoryAssociationRequest;
import software.amazon.awssdk.services.fsx.model.UpdateDataRepositoryAssociationResponse;
import software.amazon.awssdk.services.fsx.model.UpdateFileCacheRequest;
import software.amazon.awssdk.services.fsx.model.UpdateFileCacheResponse;
import software.amazon.awssdk.services.fsx.model.UpdateFileSystemRequest;
import software.amazon.awssdk.services.fsx.model.UpdateFileSystemResponse;
import software.amazon.awssdk.services.fsx.model.UpdateSharedVpcConfigurationRequest;
import software.amazon.awssdk.services.fsx.model.UpdateSharedVpcConfigurationResponse;
import software.amazon.awssdk.services.fsx.model.UpdateSnapshotRequest;
import software.amazon.awssdk.services.fsx.model.UpdateSnapshotResponse;
import software.amazon.awssdk.services.fsx.model.UpdateStorageVirtualMachineRequest;
import software.amazon.awssdk.services.fsx.model.UpdateStorageVirtualMachineResponse;
import software.amazon.awssdk.services.fsx.model.UpdateVolumeRequest;
import software.amazon.awssdk.services.fsx.model.UpdateVolumeResponse;
import software.amazon.awssdk.services.fsx.model.VolumeNotFoundException;
import software.amazon.awssdk.services.fsx.transform.AssociateFileSystemAliasesRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.CancelDataRepositoryTaskRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.CopyBackupRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.CopySnapshotAndUpdateVolumeRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.CreateAndAttachS3AccessPointRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.CreateBackupRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.CreateDataRepositoryAssociationRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.CreateDataRepositoryTaskRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.CreateFileCacheRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.CreateFileSystemFromBackupRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.CreateFileSystemRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.CreateSnapshotRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.CreateStorageVirtualMachineRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.CreateVolumeFromBackupRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.CreateVolumeRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.DeleteBackupRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.DeleteDataRepositoryAssociationRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.DeleteFileCacheRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.DeleteFileSystemRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.DeleteSnapshotRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.DeleteStorageVirtualMachineRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.DeleteVolumeRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.DescribeBackupsRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.DescribeDataRepositoryAssociationsRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.DescribeDataRepositoryTasksRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.DescribeFileCachesRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.DescribeFileSystemAliasesRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.DescribeFileSystemsRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.DescribeS3AccessPointAttachmentsRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.DescribeSharedVpcConfigurationRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.DescribeSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.DescribeStorageVirtualMachinesRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.DescribeVolumesRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.DetachAndDeleteS3AccessPointRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.DisassociateFileSystemAliasesRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.ReleaseFileSystemNfsV3LocksRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.RestoreVolumeFromSnapshotRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.StartMisconfiguredStateRecoveryRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.UpdateDataRepositoryAssociationRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.UpdateFileCacheRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.UpdateFileSystemRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.UpdateSharedVpcConfigurationRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.UpdateSnapshotRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.UpdateStorageVirtualMachineRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.UpdateVolumeRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultFSxClient
implements FSxClient {
    private static final Logger log = Logger.loggerFor(DefaultFSxClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultFSxClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"FSx#2.33.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssociateFileSystemAliasesResponse associateFileSystemAliases(AssociateFileSystemAliasesRequest associateFileSystemAliasesRequest) throws BadRequestException, FileSystemNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateFileSystemAliasesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "S3AccessPointAttachmentNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                }
                case "InvalidImportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                }
                case "InvalidNetworkSettings": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                }
                case "InvalidAccessPoint": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "DataRepositoryAssociationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                }
                case "ResourceDoesNotSupportTagging": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                }
                case "DataRepositoryTaskNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                }
                case "SourceBackupUnavailable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "StorageVirtualMachineNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                }
                case "BackupRestoring": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                }
                case "BackupInProgress": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                }
                case "InvalidExportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                }
                case "InvalidRegion": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                }
                case "MissingVolumeConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                }
                case "InvalidSourceKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                }
                case "DataRepositoryTaskExecuting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                }
                case "IncompatibleRegionForMultiAZ": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                }
                case "MissingFileCacheConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                }
                case "BackupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "FileCacheNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                }
                case "InvalidDestinationKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                }
                case "VolumeNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                }
                case "ServiceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                }
                case "NotServiceResourceError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                }
                case "AccessPointAlreadyOwnedByYou": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                }
                case "MissingFileSystemConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                }
                case "BackupBeingCopied": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                }
                case "IncompatibleParameterError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                }
                case "DataRepositoryTaskEnded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                }
                case "InvalidDataRepositoryType": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                }
                case "SnapshotNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "TooManyAccessPoints": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                }
                case "InvalidPerUnitStorageThroughput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                }
                case "ActiveDirectoryError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)associateFileSystemAliasesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(clientConfiguration, associateFileSystemAliasesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateFileSystemAliases");
            AssociateFileSystemAliasesResponse associateFileSystemAliasesResponse = (AssociateFileSystemAliasesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateFileSystemAliases").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)associateFileSystemAliasesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AssociateFileSystemAliasesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return associateFileSystemAliasesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$associateFileSystemAliases$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CancelDataRepositoryTaskResponse cancelDataRepositoryTask(CancelDataRepositoryTaskRequest cancelDataRepositoryTaskRequest) throws BadRequestException, UnsupportedOperationException, DataRepositoryTaskNotFoundException, DataRepositoryTaskEndedException, InternalServerErrorException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelDataRepositoryTaskResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "S3AccessPointAttachmentNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                }
                case "InvalidImportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                }
                case "InvalidNetworkSettings": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                }
                case "InvalidAccessPoint": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "DataRepositoryAssociationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                }
                case "ResourceDoesNotSupportTagging": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                }
                case "DataRepositoryTaskNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                }
                case "SourceBackupUnavailable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "StorageVirtualMachineNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                }
                case "BackupRestoring": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                }
                case "BackupInProgress": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                }
                case "InvalidExportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                }
                case "InvalidRegion": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                }
                case "MissingVolumeConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                }
                case "InvalidSourceKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                }
                case "DataRepositoryTaskExecuting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                }
                case "IncompatibleRegionForMultiAZ": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                }
                case "MissingFileCacheConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                }
                case "BackupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "FileCacheNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                }
                case "InvalidDestinationKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                }
                case "VolumeNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                }
                case "ServiceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                }
                case "NotServiceResourceError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                }
                case "AccessPointAlreadyOwnedByYou": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                }
                case "MissingFileSystemConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                }
                case "BackupBeingCopied": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                }
                case "IncompatibleParameterError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                }
                case "DataRepositoryTaskEnded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                }
                case "InvalidDataRepositoryType": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                }
                case "SnapshotNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "TooManyAccessPoints": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                }
                case "InvalidPerUnitStorageThroughput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                }
                case "ActiveDirectoryError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)cancelDataRepositoryTaskRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(clientConfiguration, cancelDataRepositoryTaskRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelDataRepositoryTask");
            CancelDataRepositoryTaskResponse cancelDataRepositoryTaskResponse = (CancelDataRepositoryTaskResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelDataRepositoryTask").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)cancelDataRepositoryTaskRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CancelDataRepositoryTaskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return cancelDataRepositoryTaskResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$cancelDataRepositoryTask$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CopyBackupResponse copyBackup(CopyBackupRequest copyBackupRequest) throws BadRequestException, BackupNotFoundException, ServiceLimitExceededException, UnsupportedOperationException, IncompatibleParameterErrorException, InternalServerErrorException, InvalidSourceKmsKeyException, InvalidDestinationKmsKeyException, InvalidRegionException, SourceBackupUnavailableException, IncompatibleRegionForMultiAzException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CopyBackupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "S3AccessPointAttachmentNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                }
                case "InvalidImportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                }
                case "InvalidNetworkSettings": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                }
                case "InvalidAccessPoint": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "DataRepositoryAssociationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                }
                case "ResourceDoesNotSupportTagging": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                }
                case "DataRepositoryTaskNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                }
                case "SourceBackupUnavailable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "StorageVirtualMachineNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                }
                case "BackupRestoring": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                }
                case "BackupInProgress": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                }
                case "InvalidExportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                }
                case "InvalidRegion": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                }
                case "MissingVolumeConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                }
                case "InvalidSourceKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                }
                case "DataRepositoryTaskExecuting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                }
                case "IncompatibleRegionForMultiAZ": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                }
                case "MissingFileCacheConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                }
                case "BackupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "FileCacheNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                }
                case "InvalidDestinationKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                }
                case "VolumeNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                }
                case "ServiceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                }
                case "NotServiceResourceError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                }
                case "AccessPointAlreadyOwnedByYou": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                }
                case "MissingFileSystemConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                }
                case "BackupBeingCopied": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                }
                case "IncompatibleParameterError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                }
                case "DataRepositoryTaskEnded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                }
                case "InvalidDataRepositoryType": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                }
                case "SnapshotNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "TooManyAccessPoints": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                }
                case "InvalidPerUnitStorageThroughput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                }
                case "ActiveDirectoryError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)copyBackupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(clientConfiguration, copyBackupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CopyBackup");
            CopyBackupResponse copyBackupResponse = (CopyBackupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CopyBackup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)copyBackupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CopyBackupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return copyBackupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$copyBackup$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CopySnapshotAndUpdateVolumeResponse copySnapshotAndUpdateVolume(CopySnapshotAndUpdateVolumeRequest copySnapshotAndUpdateVolumeRequest) throws BadRequestException, IncompatibleParameterErrorException, InternalServerErrorException, ServiceLimitExceededException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CopySnapshotAndUpdateVolumeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "S3AccessPointAttachmentNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                }
                case "InvalidImportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                }
                case "InvalidNetworkSettings": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                }
                case "InvalidAccessPoint": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "DataRepositoryAssociationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                }
                case "ResourceDoesNotSupportTagging": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                }
                case "DataRepositoryTaskNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                }
                case "SourceBackupUnavailable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "StorageVirtualMachineNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                }
                case "BackupRestoring": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                }
                case "BackupInProgress": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                }
                case "InvalidExportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                }
                case "InvalidRegion": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                }
                case "MissingVolumeConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                }
                case "InvalidSourceKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                }
                case "DataRepositoryTaskExecuting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                }
                case "IncompatibleRegionForMultiAZ": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                }
                case "MissingFileCacheConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                }
                case "BackupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "FileCacheNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                }
                case "InvalidDestinationKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                }
                case "VolumeNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                }
                case "ServiceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                }
                case "NotServiceResourceError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                }
                case "AccessPointAlreadyOwnedByYou": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                }
                case "MissingFileSystemConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                }
                case "BackupBeingCopied": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                }
                case "IncompatibleParameterError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                }
                case "DataRepositoryTaskEnded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                }
                case "InvalidDataRepositoryType": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                }
                case "SnapshotNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "TooManyAccessPoints": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                }
                case "InvalidPerUnitStorageThroughput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                }
                case "ActiveDirectoryError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)copySnapshotAndUpdateVolumeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(clientConfiguration, copySnapshotAndUpdateVolumeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CopySnapshotAndUpdateVolume");
            CopySnapshotAndUpdateVolumeResponse copySnapshotAndUpdateVolumeResponse = (CopySnapshotAndUpdateVolumeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CopySnapshotAndUpdateVolume").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)copySnapshotAndUpdateVolumeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CopySnapshotAndUpdateVolumeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return copySnapshotAndUpdateVolumeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$copySnapshotAndUpdateVolume$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAndAttachS3AccessPointResponse createAndAttachS3AccessPoint(CreateAndAttachS3AccessPointRequest createAndAttachS3AccessPointRequest) throws BadRequestException, IncompatibleParameterErrorException, InternalServerErrorException, UnsupportedOperationException, VolumeNotFoundException, InvalidAccessPointException, InvalidRequestException, AccessPointAlreadyOwnedByYouException, TooManyAccessPointsException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAndAttachS3AccessPointResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "S3AccessPointAttachmentNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                }
                case "InvalidImportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                }
                case "InvalidNetworkSettings": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                }
                case "InvalidAccessPoint": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "DataRepositoryAssociationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                }
                case "ResourceDoesNotSupportTagging": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                }
                case "DataRepositoryTaskNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                }
                case "SourceBackupUnavailable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "StorageVirtualMachineNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                }
                case "BackupRestoring": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                }
                case "BackupInProgress": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                }
                case "InvalidExportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                }
                case "InvalidRegion": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                }
                case "MissingVolumeConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                }
                case "InvalidSourceKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                }
                case "DataRepositoryTaskExecuting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                }
                case "IncompatibleRegionForMultiAZ": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                }
                case "MissingFileCacheConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                }
                case "BackupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "FileCacheNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                }
                case "InvalidDestinationKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                }
                case "VolumeNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                }
                case "ServiceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                }
                case "NotServiceResourceError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                }
                case "AccessPointAlreadyOwnedByYou": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                }
                case "MissingFileSystemConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                }
                case "BackupBeingCopied": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                }
                case "IncompatibleParameterError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                }
                case "DataRepositoryTaskEnded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                }
                case "InvalidDataRepositoryType": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                }
                case "SnapshotNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "TooManyAccessPoints": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                }
                case "InvalidPerUnitStorageThroughput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                }
                case "ActiveDirectoryError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createAndAttachS3AccessPointRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(clientConfiguration, createAndAttachS3AccessPointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAndAttachS3AccessPoint");
            CreateAndAttachS3AccessPointResponse createAndAttachS3AccessPointResponse = (CreateAndAttachS3AccessPointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAndAttachS3AccessPoint").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createAndAttachS3AccessPointRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateAndAttachS3AccessPointRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createAndAttachS3AccessPointResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$createAndAttachS3AccessPoint$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateBackupResponse createBackup(CreateBackupRequest createBackupRequest) throws BadRequestException, UnsupportedOperationException, FileSystemNotFoundException, VolumeNotFoundException, BackupInProgressException, IncompatibleParameterErrorException, ServiceLimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateBackupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "S3AccessPointAttachmentNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                }
                case "InvalidImportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                }
                case "InvalidNetworkSettings": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                }
                case "InvalidAccessPoint": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "DataRepositoryAssociationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                }
                case "ResourceDoesNotSupportTagging": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                }
                case "DataRepositoryTaskNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                }
                case "SourceBackupUnavailable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "StorageVirtualMachineNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                }
                case "BackupRestoring": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                }
                case "BackupInProgress": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                }
                case "InvalidExportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                }
                case "InvalidRegion": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                }
                case "MissingVolumeConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                }
                case "InvalidSourceKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                }
                case "DataRepositoryTaskExecuting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                }
                case "IncompatibleRegionForMultiAZ": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                }
                case "MissingFileCacheConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                }
                case "BackupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "FileCacheNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                }
                case "InvalidDestinationKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                }
                case "VolumeNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                }
                case "ServiceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                }
                case "NotServiceResourceError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                }
                case "AccessPointAlreadyOwnedByYou": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                }
                case "MissingFileSystemConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                }
                case "BackupBeingCopied": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                }
                case "IncompatibleParameterError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                }
                case "DataRepositoryTaskEnded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                }
                case "InvalidDataRepositoryType": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                }
                case "SnapshotNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "TooManyAccessPoints": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                }
                case "InvalidPerUnitStorageThroughput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                }
                case "ActiveDirectoryError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createBackupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(clientConfiguration, createBackupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateBackup");
            CreateBackupResponse createBackupResponse = (CreateBackupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateBackup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createBackupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateBackupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createBackupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$createBackup$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDataRepositoryAssociationResponse createDataRepositoryAssociation(CreateDataRepositoryAssociationRequest createDataRepositoryAssociationRequest) throws BadRequestException, UnsupportedOperationException, FileSystemNotFoundException, IncompatibleParameterErrorException, ServiceLimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDataRepositoryAssociationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "S3AccessPointAttachmentNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                }
                case "InvalidImportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                }
                case "InvalidNetworkSettings": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                }
                case "InvalidAccessPoint": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "DataRepositoryAssociationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                }
                case "ResourceDoesNotSupportTagging": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                }
                case "DataRepositoryTaskNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                }
                case "SourceBackupUnavailable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "StorageVirtualMachineNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                }
                case "BackupRestoring": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                }
                case "BackupInProgress": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                }
                case "InvalidExportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                }
                case "InvalidRegion": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                }
                case "MissingVolumeConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                }
                case "InvalidSourceKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                }
                case "DataRepositoryTaskExecuting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                }
                case "IncompatibleRegionForMultiAZ": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                }
                case "MissingFileCacheConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                }
                case "BackupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "FileCacheNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                }
                case "InvalidDestinationKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                }
                case "VolumeNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                }
                case "ServiceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                }
                case "NotServiceResourceError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                }
                case "AccessPointAlreadyOwnedByYou": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                }
                case "MissingFileSystemConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                }
                case "BackupBeingCopied": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                }
                case "IncompatibleParameterError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                }
                case "DataRepositoryTaskEnded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                }
                case "InvalidDataRepositoryType": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                }
                case "SnapshotNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "TooManyAccessPoints": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                }
                case "InvalidPerUnitStorageThroughput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                }
                case "ActiveDirectoryError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createDataRepositoryAssociationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(clientConfiguration, createDataRepositoryAssociationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDataRepositoryAssociation");
            CreateDataRepositoryAssociationResponse createDataRepositoryAssociationResponse = (CreateDataRepositoryAssociationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDataRepositoryAssociation").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createDataRepositoryAssociationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateDataRepositoryAssociationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createDataRepositoryAssociationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$createDataRepositoryAssociation$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDataRepositoryTaskResponse createDataRepositoryTask(CreateDataRepositoryTaskRequest createDataRepositoryTaskRequest) throws BadRequestException, UnsupportedOperationException, FileSystemNotFoundException, IncompatibleParameterErrorException, ServiceLimitExceededException, InternalServerErrorException, DataRepositoryTaskExecutingException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDataRepositoryTaskResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "S3AccessPointAttachmentNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                }
                case "InvalidImportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                }
                case "InvalidNetworkSettings": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                }
                case "InvalidAccessPoint": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "DataRepositoryAssociationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                }
                case "ResourceDoesNotSupportTagging": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                }
                case "DataRepositoryTaskNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                }
                case "SourceBackupUnavailable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "StorageVirtualMachineNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                }
                case "BackupRestoring": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                }
                case "BackupInProgress": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                }
                case "InvalidExportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                }
                case "InvalidRegion": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                }
                case "MissingVolumeConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                }
                case "InvalidSourceKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                }
                case "DataRepositoryTaskExecuting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                }
                case "IncompatibleRegionForMultiAZ": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                }
                case "MissingFileCacheConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                }
                case "BackupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "FileCacheNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                }
                case "InvalidDestinationKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                }
                case "VolumeNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                }
                case "ServiceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                }
                case "NotServiceResourceError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                }
                case "AccessPointAlreadyOwnedByYou": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                }
                case "MissingFileSystemConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                }
                case "BackupBeingCopied": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                }
                case "IncompatibleParameterError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                }
                case "DataRepositoryTaskEnded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                }
                case "InvalidDataRepositoryType": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                }
                case "SnapshotNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "TooManyAccessPoints": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                }
                case "InvalidPerUnitStorageThroughput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                }
                case "ActiveDirectoryError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createDataRepositoryTaskRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(clientConfiguration, createDataRepositoryTaskRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDataRepositoryTask");
            CreateDataRepositoryTaskResponse createDataRepositoryTaskResponse = (CreateDataRepositoryTaskResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDataRepositoryTask").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createDataRepositoryTaskRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateDataRepositoryTaskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createDataRepositoryTaskResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$createDataRepositoryTask$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateFileCacheResponse createFileCache(CreateFileCacheRequest createFileCacheRequest) throws BadRequestException, IncompatibleParameterErrorException, InvalidNetworkSettingsException, InvalidPerUnitStorageThroughputException, ServiceLimitExceededException, InternalServerErrorException, MissingFileCacheConfigurationException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateFileCacheResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "S3AccessPointAttachmentNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                }
                case "InvalidImportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                }
                case "InvalidNetworkSettings": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                }
                case "InvalidAccessPoint": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "DataRepositoryAssociationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                }
                case "ResourceDoesNotSupportTagging": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                }
                case "DataRepositoryTaskNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                }
                case "SourceBackupUnavailable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "StorageVirtualMachineNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                }
                case "BackupRestoring": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                }
                case "BackupInProgress": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                }
                case "InvalidExportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                }
                case "InvalidRegion": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                }
                case "MissingVolumeConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                }
                case "InvalidSourceKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                }
                case "DataRepositoryTaskExecuting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                }
                case "IncompatibleRegionForMultiAZ": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                }
                case "MissingFileCacheConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                }
                case "BackupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "FileCacheNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                }
                case "InvalidDestinationKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                }
                case "VolumeNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                }
                case "ServiceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                }
                case "NotServiceResourceError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                }
                case "AccessPointAlreadyOwnedByYou": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                }
                case "MissingFileSystemConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                }
                case "BackupBeingCopied": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                }
                case "IncompatibleParameterError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                }
                case "DataRepositoryTaskEnded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                }
                case "InvalidDataRepositoryType": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                }
                case "SnapshotNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "TooManyAccessPoints": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                }
                case "InvalidPerUnitStorageThroughput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                }
                case "ActiveDirectoryError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createFileCacheRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(clientConfiguration, createFileCacheRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateFileCache");
            CreateFileCacheResponse createFileCacheResponse = (CreateFileCacheResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateFileCache").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createFileCacheRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateFileCacheRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createFileCacheResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$createFileCache$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateFileSystemResponse createFileSystem(CreateFileSystemRequest createFileSystemRequest) throws BadRequestException, ActiveDirectoryErrorException, IncompatibleParameterErrorException, InvalidImportPathException, InvalidExportPathException, InvalidNetworkSettingsException, InvalidPerUnitStorageThroughputException, ServiceLimitExceededException, InternalServerErrorException, MissingFileSystemConfigurationException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateFileSystemResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "S3AccessPointAttachmentNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                }
                case "InvalidImportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                }
                case "InvalidNetworkSettings": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                }
                case "InvalidAccessPoint": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "DataRepositoryAssociationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                }
                case "ResourceDoesNotSupportTagging": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                }
                case "DataRepositoryTaskNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                }
                case "SourceBackupUnavailable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "StorageVirtualMachineNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                }
                case "BackupRestoring": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                }
                case "BackupInProgress": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                }
                case "InvalidExportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                }
                case "InvalidRegion": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                }
                case "MissingVolumeConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                }
                case "InvalidSourceKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                }
                case "DataRepositoryTaskExecuting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                }
                case "IncompatibleRegionForMultiAZ": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                }
                case "MissingFileCacheConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                }
                case "BackupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "FileCacheNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                }
                case "InvalidDestinationKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                }
                case "VolumeNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                }
                case "ServiceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                }
                case "NotServiceResourceError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                }
                case "AccessPointAlreadyOwnedByYou": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                }
                case "MissingFileSystemConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                }
                case "BackupBeingCopied": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                }
                case "IncompatibleParameterError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                }
                case "DataRepositoryTaskEnded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                }
                case "InvalidDataRepositoryType": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                }
                case "SnapshotNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "TooManyAccessPoints": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                }
                case "InvalidPerUnitStorageThroughput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                }
                case "ActiveDirectoryError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createFileSystemRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(clientConfiguration, createFileSystemRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateFileSystem");
            CreateFileSystemResponse createFileSystemResponse = (CreateFileSystemResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateFileSystem").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createFileSystemRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateFileSystemRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createFileSystemResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$createFileSystem$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateFileSystemFromBackupResponse createFileSystemFromBackup(CreateFileSystemFromBackupRequest createFileSystemFromBackupRequest) throws BadRequestException, ActiveDirectoryErrorException, IncompatibleParameterErrorException, InvalidNetworkSettingsException, InvalidPerUnitStorageThroughputException, ServiceLimitExceededException, BackupNotFoundException, InternalServerErrorException, MissingFileSystemConfigurationException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateFileSystemFromBackupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "S3AccessPointAttachmentNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                }
                case "InvalidImportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                }
                case "InvalidNetworkSettings": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                }
                case "InvalidAccessPoint": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "DataRepositoryAssociationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                }
                case "ResourceDoesNotSupportTagging": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                }
                case "DataRepositoryTaskNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                }
                case "SourceBackupUnavailable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "StorageVirtualMachineNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                }
                case "BackupRestoring": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                }
                case "BackupInProgress": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                }
                case "InvalidExportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                }
                case "InvalidRegion": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                }
                case "MissingVolumeConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                }
                case "InvalidSourceKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                }
                case "DataRepositoryTaskExecuting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                }
                case "IncompatibleRegionForMultiAZ": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                }
                case "MissingFileCacheConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                }
                case "BackupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "FileCacheNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                }
                case "InvalidDestinationKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                }
                case "VolumeNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                }
                case "ServiceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                }
                case "NotServiceResourceError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                }
                case "AccessPointAlreadyOwnedByYou": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                }
                case "MissingFileSystemConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                }
                case "BackupBeingCopied": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                }
                case "IncompatibleParameterError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                }
                case "DataRepositoryTaskEnded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                }
                case "InvalidDataRepositoryType": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                }
                case "SnapshotNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "TooManyAccessPoints": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                }
                case "InvalidPerUnitStorageThroughput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                }
                case "ActiveDirectoryError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createFileSystemFromBackupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(clientConfiguration, createFileSystemFromBackupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateFileSystemFromBackup");
            CreateFileSystemFromBackupResponse createFileSystemFromBackupResponse = (CreateFileSystemFromBackupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateFileSystemFromBackup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createFileSystemFromBackupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateFileSystemFromBackupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createFileSystemFromBackupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$createFileSystemFromBackup$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateSnapshotResponse createSnapshot(CreateSnapshotRequest createSnapshotRequest) throws BadRequestException, VolumeNotFoundException, ServiceLimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSnapshotResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "S3AccessPointAttachmentNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                }
                case "InvalidImportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                }
                case "InvalidNetworkSettings": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                }
                case "InvalidAccessPoint": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "DataRepositoryAssociationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                }
                case "ResourceDoesNotSupportTagging": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                }
                case "DataRepositoryTaskNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                }
                case "SourceBackupUnavailable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "StorageVirtualMachineNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                }
                case "BackupRestoring": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                }
                case "BackupInProgress": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                }
                case "InvalidExportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                }
                case "InvalidRegion": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                }
                case "MissingVolumeConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                }
                case "InvalidSourceKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                }
                case "DataRepositoryTaskExecuting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                }
                case "IncompatibleRegionForMultiAZ": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                }
                case "MissingFileCacheConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                }
                case "BackupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "FileCacheNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                }
                case "InvalidDestinationKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                }
                case "VolumeNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                }
                case "ServiceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                }
                case "NotServiceResourceError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                }
                case "AccessPointAlreadyOwnedByYou": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                }
                case "MissingFileSystemConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                }
                case "BackupBeingCopied": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                }
                case "IncompatibleParameterError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                }
                case "DataRepositoryTaskEnded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                }
                case "InvalidDataRepositoryType": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                }
                case "SnapshotNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "TooManyAccessPoints": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                }
                case "InvalidPerUnitStorageThroughput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                }
                case "ActiveDirectoryError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(clientConfiguration, createSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateSnapshot");
            CreateSnapshotResponse createSnapshotResponse = (CreateSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSnapshot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createSnapshotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createSnapshotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$createSnapshot$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateStorageVirtualMachineResponse createStorageVirtualMachine(CreateStorageVirtualMachineRequest createStorageVirtualMachineRequest) throws ActiveDirectoryErrorException, BadRequestException, FileSystemNotFoundException, IncompatibleParameterErrorException, InternalServerErrorException, ServiceLimitExceededException, UnsupportedOperationException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateStorageVirtualMachineResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "S3AccessPointAttachmentNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                }
                case "InvalidImportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                }
                case "InvalidNetworkSettings": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                }
                case "InvalidAccessPoint": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "DataRepositoryAssociationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                }
                case "ResourceDoesNotSupportTagging": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                }
                case "DataRepositoryTaskNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                }
                case "SourceBackupUnavailable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "StorageVirtualMachineNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                }
                case "BackupRestoring": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                }
                case "BackupInProgress": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                }
                case "InvalidExportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                }
                case "InvalidRegion": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                }
                case "MissingVolumeConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                }
                case "InvalidSourceKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                }
                case "DataRepositoryTaskExecuting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                }
                case "IncompatibleRegionForMultiAZ": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                }
                case "MissingFileCacheConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                }
                case "BackupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "FileCacheNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                }
                case "InvalidDestinationKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                }
                case "VolumeNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                }
                case "ServiceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                }
                case "NotServiceResourceError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                }
                case "AccessPointAlreadyOwnedByYou": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                }
                case "MissingFileSystemConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                }
                case "BackupBeingCopied": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                }
                case "IncompatibleParameterError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                }
                case "DataRepositoryTaskEnded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                }
                case "InvalidDataRepositoryType": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                }
                case "SnapshotNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "TooManyAccessPoints": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                }
                case "InvalidPerUnitStorageThroughput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                }
                case "ActiveDirectoryError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createStorageVirtualMachineRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(clientConfiguration, createStorageVirtualMachineRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateStorageVirtualMachine");
            CreateStorageVirtualMachineResponse createStorageVirtualMachineResponse = (CreateStorageVirtualMachineResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateStorageVirtualMachine").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createStorageVirtualMachineRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateStorageVirtualMachineRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createStorageVirtualMachineResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$createStorageVirtualMachine$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateVolumeResponse createVolume(CreateVolumeRequest createVolumeRequest) throws BadRequestException, FileSystemNotFoundException, IncompatibleParameterErrorException, InternalServerErrorException, MissingVolumeConfigurationException, ServiceLimitExceededException, StorageVirtualMachineNotFoundException, UnsupportedOperationException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateVolumeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "S3AccessPointAttachmentNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                }
                case "InvalidImportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                }
                case "InvalidNetworkSettings": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                }
                case "InvalidAccessPoint": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "DataRepositoryAssociationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                }
                case "ResourceDoesNotSupportTagging": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                }
                case "DataRepositoryTaskNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                }
                case "SourceBackupUnavailable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "StorageVirtualMachineNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                }
                case "BackupRestoring": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                }
                case "BackupInProgress": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                }
                case "InvalidExportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                }
                case "InvalidRegion": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                }
                case "MissingVolumeConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                }
                case "InvalidSourceKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                }
                case "DataRepositoryTaskExecuting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                }
                case "IncompatibleRegionForMultiAZ": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                }
                case "MissingFileCacheConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                }
                case "BackupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "FileCacheNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                }
                case "InvalidDestinationKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                }
                case "VolumeNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                }
                case "ServiceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                }
                case "NotServiceResourceError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                }
                case "AccessPointAlreadyOwnedByYou": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                }
                case "MissingFileSystemConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                }
                case "BackupBeingCopied": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                }
                case "IncompatibleParameterError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                }
                case "DataRepositoryTaskEnded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                }
                case "InvalidDataRepositoryType": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                }
                case "SnapshotNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "TooManyAccessPoints": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                }
                case "InvalidPerUnitStorageThroughput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                }
                case "ActiveDirectoryError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createVolumeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(clientConfiguration, createVolumeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateVolume");
            CreateVolumeResponse createVolumeResponse = (CreateVolumeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateVolume").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createVolumeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateVolumeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createVolumeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$createVolume$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateVolumeFromBackupResponse createVolumeFromBackup(CreateVolumeFromBackupRequest createVolumeFromBackupRequest) throws BackupNotFoundException, BadRequestException, FileSystemNotFoundException, IncompatibleParameterErrorException, InternalServerErrorException, MissingVolumeConfigurationException, ServiceLimitExceededException, StorageVirtualMachineNotFoundException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateVolumeFromBackupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "S3AccessPointAttachmentNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                }
                case "InvalidImportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                }
                case "InvalidNetworkSettings": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                }
                case "InvalidAccessPoint": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "DataRepositoryAssociationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                }
                case "ResourceDoesNotSupportTagging": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                }
                case "DataRepositoryTaskNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                }
                case "SourceBackupUnavailable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "StorageVirtualMachineNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                }
                case "BackupRestoring": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                }
                case "BackupInProgress": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                }
                case "InvalidExportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                }
                case "InvalidRegion": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                }
                case "MissingVolumeConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                }
                case "InvalidSourceKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                }
                case "DataRepositoryTaskExecuting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                }
                case "IncompatibleRegionForMultiAZ": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                }
                case "MissingFileCacheConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                }
                case "BackupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "FileCacheNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                }
                case "InvalidDestinationKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                }
                case "VolumeNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                }
                case "ServiceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                }
                case "NotServiceResourceError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                }
                case "AccessPointAlreadyOwnedByYou": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                }
                case "MissingFileSystemConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                }
                case "BackupBeingCopied": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                }
                case "IncompatibleParameterError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                }
                case "DataRepositoryTaskEnded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                }
                case "InvalidDataRepositoryType": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                }
                case "SnapshotNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "TooManyAccessPoints": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                }
                case "InvalidPerUnitStorageThroughput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                }
                case "ActiveDirectoryError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createVolumeFromBackupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(clientConfiguration, createVolumeFromBackupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateVolumeFromBackup");
            CreateVolumeFromBackupResponse createVolumeFromBackupResponse = (CreateVolumeFromBackupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateVolumeFromBackup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createVolumeFromBackupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateVolumeFromBackupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createVolumeFromBackupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$createVolumeFromBackup$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteBackupResponse deleteBackup(DeleteBackupRequest deleteBackupRequest) throws BadRequestException, BackupInProgressException, BackupNotFoundException, BackupRestoringException, IncompatibleParameterErrorException, InternalServerErrorException, BackupBeingCopiedException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteBackupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "S3AccessPointAttachmentNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                }
                case "InvalidImportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                }
                case "InvalidNetworkSettings": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                }
                case "InvalidAccessPoint": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "DataRepositoryAssociationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                }
                case "ResourceDoesNotSupportTagging": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                }
                case "DataRepositoryTaskNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                }
                case "SourceBackupUnavailable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "StorageVirtualMachineNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                }
                case "BackupRestoring": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                }
                case "BackupInProgress": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                }
                case "InvalidExportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                }
                case "InvalidRegion": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                }
                case "MissingVolumeConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                }
                case "InvalidSourceKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                }
                case "DataRepositoryTaskExecuting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                }
                case "IncompatibleRegionForMultiAZ": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                }
                case "MissingFileCacheConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                }
                case "BackupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "FileCacheNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                }
                case "InvalidDestinationKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                }
                case "VolumeNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                }
                case "ServiceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                }
                case "NotServiceResourceError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                }
                case "AccessPointAlreadyOwnedByYou": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                }
                case "MissingFileSystemConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                }
                case "BackupBeingCopied": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                }
                case "IncompatibleParameterError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                }
                case "DataRepositoryTaskEnded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                }
                case "InvalidDataRepositoryType": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                }
                case "SnapshotNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "TooManyAccessPoints": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                }
                case "InvalidPerUnitStorageThroughput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                }
                case "ActiveDirectoryError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteBackupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(clientConfiguration, deleteBackupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteBackup");
            DeleteBackupResponse deleteBackupResponse = (DeleteBackupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBackup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteBackupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteBackupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteBackupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$deleteBackup$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDataRepositoryAssociationResponse deleteDataRepositoryAssociation(DeleteDataRepositoryAssociationRequest deleteDataRepositoryAssociationRequest) throws BadRequestException, IncompatibleParameterErrorException, DataRepositoryAssociationNotFoundException, ServiceLimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDataRepositoryAssociationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "S3AccessPointAttachmentNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                }
                case "InvalidImportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                }
                case "InvalidNetworkSettings": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                }
                case "InvalidAccessPoint": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "DataRepositoryAssociationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                }
                case "ResourceDoesNotSupportTagging": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                }
                case "DataRepositoryTaskNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                }
                case "SourceBackupUnavailable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "StorageVirtualMachineNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                }
                case "BackupRestoring": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                }
                case "BackupInProgress": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                }
                case "InvalidExportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                }
                case "InvalidRegion": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                }
                case "MissingVolumeConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                }
                case "InvalidSourceKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                }
                case "DataRepositoryTaskExecuting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                }
                case "IncompatibleRegionForMultiAZ": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                }
                case "MissingFileCacheConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                }
                case "BackupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "FileCacheNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                }
                case "InvalidDestinationKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                }
                case "VolumeNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                }
                case "ServiceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                }
                case "NotServiceResourceError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                }
                case "AccessPointAlreadyOwnedByYou": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                }
                case "MissingFileSystemConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                }
                case "BackupBeingCopied": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                }
                case "IncompatibleParameterError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                }
                case "DataRepositoryTaskEnded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                }
                case "InvalidDataRepositoryType": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                }
                case "SnapshotNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "TooManyAccessPoints": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                }
                case "InvalidPerUnitStorageThroughput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                }
                case "ActiveDirectoryError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteDataRepositoryAssociationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(clientConfiguration, deleteDataRepositoryAssociationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDataRepositoryAssociation");
            DeleteDataRepositoryAssociationResponse deleteDataRepositoryAssociationResponse = (DeleteDataRepositoryAssociationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDataRepositoryAssociation").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteDataRepositoryAssociationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteDataRepositoryAssociationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteDataRepositoryAssociationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$deleteDataRepositoryAssociation$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteFileCacheResponse deleteFileCache(DeleteFileCacheRequest deleteFileCacheRequest) throws BadRequestException, IncompatibleParameterErrorException, FileCacheNotFoundException, ServiceLimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteFileCacheResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "S3AccessPointAttachmentNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                }
                case "InvalidImportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                }
                case "InvalidNetworkSettings": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                }
                case "InvalidAccessPoint": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "DataRepositoryAssociationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                }
                case "ResourceDoesNotSupportTagging": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                }
                case "DataRepositoryTaskNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                }
                case "SourceBackupUnavailable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "StorageVirtualMachineNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                }
                case "BackupRestoring": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                }
                case "BackupInProgress": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                }
                case "InvalidExportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                }
                case "InvalidRegion": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                }
                case "MissingVolumeConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                }
                case "InvalidSourceKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                }
                case "DataRepositoryTaskExecuting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                }
                case "IncompatibleRegionForMultiAZ": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                }
                case "MissingFileCacheConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                }
                case "BackupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "FileCacheNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                }
                case "InvalidDestinationKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                }
                case "VolumeNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                }
                case "ServiceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                }
                case "NotServiceResourceError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                }
                case "AccessPointAlreadyOwnedByYou": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                }
                case "MissingFileSystemConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                }
                case "BackupBeingCopied": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                }
                case "IncompatibleParameterError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                }
                case "DataRepositoryTaskEnded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                }
                case "InvalidDataRepositoryType": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                }
                case "SnapshotNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "TooManyAccessPoints": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                }
                case "InvalidPerUnitStorageThroughput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                }
                case "ActiveDirectoryError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteFileCacheRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(clientConfiguration, deleteFileCacheRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteFileCache");
            DeleteFileCacheResponse deleteFileCacheResponse = (DeleteFileCacheResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteFileCache").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteFileCacheRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteFileCacheRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteFileCacheResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$deleteFileCache$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteFileSystemResponse deleteFileSystem(DeleteFileSystemRequest deleteFileSystemRequest) throws BadRequestException, IncompatibleParameterErrorException, FileSystemNotFoundException, ServiceLimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteFileSystemResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "S3AccessPointAttachmentNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                }
                case "InvalidImportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                }
                case "InvalidNetworkSettings": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                }
                case "InvalidAccessPoint": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "DataRepositoryAssociationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                }
                case "ResourceDoesNotSupportTagging": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                }
                case "DataRepositoryTaskNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                }
                case "SourceBackupUnavailable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "StorageVirtualMachineNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                }
                case "BackupRestoring": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                }
                case "BackupInProgress": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                }
                case "InvalidExportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                }
                case "InvalidRegion": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                }
                case "MissingVolumeConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                }
                case "InvalidSourceKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                }
                case "DataRepositoryTaskExecuting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                }
                case "IncompatibleRegionForMultiAZ": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                }
                case "MissingFileCacheConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                }
                case "BackupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "FileCacheNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                }
                case "InvalidDestinationKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                }
                case "VolumeNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                }
                case "ServiceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                }
                case "NotServiceResourceError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                }
                case "AccessPointAlreadyOwnedByYou": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                }
                case "MissingFileSystemConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                }
                case "BackupBeingCopied": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                }
                case "IncompatibleParameterError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                }
                case "DataRepositoryTaskEnded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                }
                case "InvalidDataRepositoryType": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                }
                case "SnapshotNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "TooManyAccessPoints": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                }
                case "InvalidPerUnitStorageThroughput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                }
                case "ActiveDirectoryError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteFileSystemRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(clientConfiguration, deleteFileSystemRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteFileSystem");
            DeleteFileSystemResponse deleteFileSystemResponse = (DeleteFileSystemResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteFileSystem").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteFileSystemRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteFileSystemRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteFileSystemResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$deleteFileSystem$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteSnapshotResponse deleteSnapshot(DeleteSnapshotRequest deleteSnapshotRequest) throws BadRequestException, InternalServerErrorException, SnapshotNotFoundException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSnapshotResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "S3AccessPointAttachmentNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                }
                case "InvalidImportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                }
                case "InvalidNetworkSettings": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                }
                case "InvalidAccessPoint": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "DataRepositoryAssociationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                }
                case "ResourceDoesNotSupportTagging": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                }
                case "DataRepositoryTaskNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                }
                case "SourceBackupUnavailable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "StorageVirtualMachineNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                }
                case "BackupRestoring": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                }
                case "BackupInProgress": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                }
                case "InvalidExportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                }
                case "InvalidRegion": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                }
                case "MissingVolumeConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                }
                case "InvalidSourceKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                }
                case "DataRepositoryTaskExecuting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                }
                case "IncompatibleRegionForMultiAZ": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                }
                case "MissingFileCacheConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                }
                case "BackupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "FileCacheNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                }
                case "InvalidDestinationKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                }
                case "VolumeNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                }
                case "ServiceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                }
                case "NotServiceResourceError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                }
                case "AccessPointAlreadyOwnedByYou": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                }
                case "MissingFileSystemConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                }
                case "BackupBeingCopied": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                }
                case "IncompatibleParameterError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                }
                case "DataRepositoryTaskEnded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                }
                case "InvalidDataRepositoryType": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                }
                case "SnapshotNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "TooManyAccessPoints": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                }
                case "InvalidPerUnitStorageThroughput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                }
                case "ActiveDirectoryError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(clientConfiguration, deleteSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSnapshot");
            DeleteSnapshotResponse deleteSnapshotResponse = (DeleteSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSnapshot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteSnapshotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteSnapshotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$deleteSnapshot$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteStorageVirtualMachineResponse deleteStorageVirtualMachine(DeleteStorageVirtualMachineRequest deleteStorageVirtualMachineRequest) throws BadRequestException, IncompatibleParameterErrorException, InternalServerErrorException, StorageVirtualMachineNotFoundException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteStorageVirtualMachineResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "S3AccessPointAttachmentNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                }
                case "InvalidImportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                }
                case "InvalidNetworkSettings": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                }
                case "InvalidAccessPoint": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "DataRepositoryAssociationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                }
                case "ResourceDoesNotSupportTagging": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                }
                case "DataRepositoryTaskNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                }
                case "SourceBackupUnavailable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "StorageVirtualMachineNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                }
                case "BackupRestoring": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                }
                case "BackupInProgress": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                }
                case "InvalidExportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                }
                case "InvalidRegion": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                }
                case "MissingVolumeConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                }
                case "InvalidSourceKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                }
                case "DataRepositoryTaskExecuting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                }
                case "IncompatibleRegionForMultiAZ": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                }
                case "MissingFileCacheConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                }
                case "BackupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "FileCacheNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                }
                case "InvalidDestinationKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                }
                case "VolumeNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                }
                case "ServiceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                }
                case "NotServiceResourceError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                }
                case "AccessPointAlreadyOwnedByYou": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                }
                case "MissingFileSystemConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                }
                case "BackupBeingCopied": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                }
                case "IncompatibleParameterError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                }
                case "DataRepositoryTaskEnded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                }
                case "InvalidDataRepositoryType": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                }
                case "SnapshotNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "TooManyAccessPoints": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                }
                case "InvalidPerUnitStorageThroughput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                }
                case "ActiveDirectoryError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteStorageVirtualMachineRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(clientConfiguration, deleteStorageVirtualMachineRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteStorageVirtualMachine");
            DeleteStorageVirtualMachineResponse deleteStorageVirtualMachineResponse = (DeleteStorageVirtualMachineResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteStorageVirtualMachine").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteStorageVirtualMachineRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteStorageVirtualMachineRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteStorageVirtualMachineResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$deleteStorageVirtualMachine$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteVolumeResponse deleteVolume(DeleteVolumeRequest deleteVolumeRequest) throws BadRequestException, IncompatibleParameterErrorException, InternalServerErrorException, VolumeNotFoundException, ServiceLimitExceededException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteVolumeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "S3AccessPointAttachmentNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                }
                case "InvalidImportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                }
                case "InvalidNetworkSettings": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                }
                case "InvalidAccessPoint": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "DataRepositoryAssociationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                }
                case "ResourceDoesNotSupportTagging": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                }
                case "DataRepositoryTaskNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                }
                case "SourceBackupUnavailable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "StorageVirtualMachineNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                }
                case "BackupRestoring": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                }
                case "BackupInProgress": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                }
                case "InvalidExportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                }
                case "InvalidRegion": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                }
                case "MissingVolumeConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                }
                case "InvalidSourceKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                }
                case "DataRepositoryTaskExecuting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                }
                case "IncompatibleRegionForMultiAZ": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                }
                case "MissingFileCacheConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                }
                case "BackupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "FileCacheNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                }
                case "InvalidDestinationKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                }
                case "VolumeNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                }
                case "ServiceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                }
                case "NotServiceResourceError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                }
                case "AccessPointAlreadyOwnedByYou": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                }
                case "MissingFileSystemConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                }
                case "BackupBeingCopied": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                }
                case "IncompatibleParameterError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                }
                case "DataRepositoryTaskEnded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                }
                case "InvalidDataRepositoryType": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                }
                case "SnapshotNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "TooManyAccessPoints": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                }
                case "InvalidPerUnitStorageThroughput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                }
                case "ActiveDirectoryError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteVolumeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(clientConfiguration, deleteVolumeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteVolume");
            DeleteVolumeResponse deleteVolumeResponse = (DeleteVolumeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteVolume").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteVolumeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteVolumeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteVolumeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$deleteVolume$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeBackupsResponse describeBackups(DescribeBackupsRequest describeBackupsRequest) throws BadRequestException, FileSystemNotFoundException, VolumeNotFoundException, BackupNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeBackupsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "S3AccessPointAttachmentNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                }
                case "InvalidImportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                }
                case "InvalidNetworkSettings": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                }
                case "InvalidAccessPoint": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "DataRepositoryAssociationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                }
                case "ResourceDoesNotSupportTagging": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                }
                case "DataRepositoryTaskNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                }
                case "SourceBackupUnavailable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "StorageVirtualMachineNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                }
                case "BackupRestoring": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                }
                case "BackupInProgress": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                }
                case "InvalidExportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                }
                case "InvalidRegion": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                }
                case "MissingVolumeConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                }
                case "InvalidSourceKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                }
                case "DataRepositoryTaskExecuting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                }
                case "IncompatibleRegionForMultiAZ": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                }
                case "MissingFileCacheConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                }
                case "BackupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "FileCacheNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                }
                case "InvalidDestinationKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                }
                case "VolumeNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                }
                case "ServiceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                }
                case "NotServiceResourceError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                }
                case "AccessPointAlreadyOwnedByYou": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                }
                case "MissingFileSystemConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                }
                case "BackupBeingCopied": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                }
                case "IncompatibleParameterError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                }
                case "DataRepositoryTaskEnded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                }
                case "InvalidDataRepositoryType": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                }
                case "SnapshotNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "TooManyAccessPoints": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                }
                case "InvalidPerUnitStorageThroughput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                }
                case "ActiveDirectoryError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeBackupsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(clientConfiguration, describeBackupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeBackups");
            DescribeBackupsResponse describeBackupsResponse = (DescribeBackupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeBackups").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeBackupsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeBackupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeBackupsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$describeBackups$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDataRepositoryAssociationsResponse describeDataRepositoryAssociations(DescribeDataRepositoryAssociationsRequest describeDataRepositoryAssociationsRequest) throws BadRequestException, FileSystemNotFoundException, DataRepositoryAssociationNotFoundException, InvalidDataRepositoryTypeException, InternalServerErrorException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDataRepositoryAssociationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "S3AccessPointAttachmentNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                }
                case "InvalidImportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                }
                case "InvalidNetworkSettings": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                }
                case "InvalidAccessPoint": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "DataRepositoryAssociationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                }
                case "ResourceDoesNotSupportTagging": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                }
                case "DataRepositoryTaskNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                }
                case "SourceBackupUnavailable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "StorageVirtualMachineNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                }
                case "BackupRestoring": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                }
                case "BackupInProgress": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                }
                case "InvalidExportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                }
                case "InvalidRegion": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                }
                case "MissingVolumeConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                }
                case "InvalidSourceKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                }
                case "DataRepositoryTaskExecuting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                }
                case "IncompatibleRegionForMultiAZ": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                }
                case "MissingFileCacheConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                }
                case "BackupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "FileCacheNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                }
                case "InvalidDestinationKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                }
                case "VolumeNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                }
                case "ServiceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                }
                case "NotServiceResourceError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                }
                case "AccessPointAlreadyOwnedByYou": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                }
                case "MissingFileSystemConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                }
                case "BackupBeingCopied": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                }
                case "IncompatibleParameterError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                }
                case "DataRepositoryTaskEnded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                }
                case "InvalidDataRepositoryType": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                }
                case "SnapshotNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "TooManyAccessPoints": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                }
                case "InvalidPerUnitStorageThroughput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                }
                case "ActiveDirectoryError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeDataRepositoryAssociationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(clientConfiguration, describeDataRepositoryAssociationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDataRepositoryAssociations");
            DescribeDataRepositoryAssociationsResponse describeDataRepositoryAssociationsResponse = (DescribeDataRepositoryAssociationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDataRepositoryAssociations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeDataRepositoryAssociationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDataRepositoryAssociationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeDataRepositoryAssociationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$describeDataRepositoryAssociations$47((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDataRepositoryTasksResponse describeDataRepositoryTasks(DescribeDataRepositoryTasksRequest describeDataRepositoryTasksRequest) throws BadRequestException, FileSystemNotFoundException, DataRepositoryTaskNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDataRepositoryTasksResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "S3AccessPointAttachmentNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                }
                case "InvalidImportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                }
                case "InvalidNetworkSettings": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                }
                case "InvalidAccessPoint": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "DataRepositoryAssociationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                }
                case "ResourceDoesNotSupportTagging": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                }
                case "DataRepositoryTaskNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                }
                case "SourceBackupUnavailable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "StorageVirtualMachineNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                }
                case "BackupRestoring": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                }
                case "BackupInProgress": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                }
                case "InvalidExportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                }
                case "InvalidRegion": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                }
                case "MissingVolumeConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                }
                case "InvalidSourceKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                }
                case "DataRepositoryTaskExecuting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                }
                case "IncompatibleRegionForMultiAZ": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                }
                case "MissingFileCacheConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                }
                case "BackupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "FileCacheNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                }
                case "InvalidDestinationKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                }
                case "VolumeNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                }
                case "ServiceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                }
                case "NotServiceResourceError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                }
                case "AccessPointAlreadyOwnedByYou": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                }
                case "MissingFileSystemConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                }
                case "BackupBeingCopied": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                }
                case "IncompatibleParameterError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                }
                case "DataRepositoryTaskEnded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                }
                case "InvalidDataRepositoryType": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                }
                case "SnapshotNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "TooManyAccessPoints": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                }
                case "InvalidPerUnitStorageThroughput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                }
                case "ActiveDirectoryError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeDataRepositoryTasksRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(clientConfiguration, describeDataRepositoryTasksRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDataRepositoryTasks");
            DescribeDataRepositoryTasksResponse describeDataRepositoryTasksResponse = (DescribeDataRepositoryTasksResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDataRepositoryTasks").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeDataRepositoryTasksRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDataRepositoryTasksRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeDataRepositoryTasksResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$describeDataRepositoryTasks$49((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeFileCachesResponse describeFileCaches(DescribeFileCachesRequest describeFileCachesRequest) throws BadRequestException, FileCacheNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeFileCachesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "S3AccessPointAttachmentNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                }
                case "InvalidImportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                }
                case "InvalidNetworkSettings": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                }
                case "InvalidAccessPoint": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "DataRepositoryAssociationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                }
                case "ResourceDoesNotSupportTagging": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                }
                case "DataRepositoryTaskNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                }
                case "SourceBackupUnavailable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "StorageVirtualMachineNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                }
                case "BackupRestoring": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                }
                case "BackupInProgress": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                }
                case "InvalidExportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                }
                case "InvalidRegion": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                }
                case "MissingVolumeConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                }
                case "InvalidSourceKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                }
                case "DataRepositoryTaskExecuting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                }
                case "IncompatibleRegionForMultiAZ": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                }
                case "MissingFileCacheConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                }
                case "BackupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "FileCacheNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                }
                case "InvalidDestinationKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                }
                case "VolumeNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                }
                case "ServiceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                }
                case "NotServiceResourceError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                }
                case "AccessPointAlreadyOwnedByYou": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                }
                case "MissingFileSystemConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                }
                case "BackupBeingCopied": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                }
                case "IncompatibleParameterError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                }
                case "DataRepositoryTaskEnded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                }
                case "InvalidDataRepositoryType": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                }
                case "SnapshotNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "TooManyAccessPoints": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                }
                case "InvalidPerUnitStorageThroughput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                }
                case "ActiveDirectoryError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeFileCachesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(clientConfiguration, describeFileCachesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeFileCaches");
            DescribeFileCachesResponse describeFileCachesResponse = (DescribeFileCachesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeFileCaches").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeFileCachesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeFileCachesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeFileCachesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$describeFileCaches$51((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeFileSystemAliasesResponse describeFileSystemAliases(DescribeFileSystemAliasesRequest describeFileSystemAliasesRequest) throws BadRequestException, FileSystemNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeFileSystemAliasesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "S3AccessPointAttachmentNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                }
                case "InvalidImportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                }
                case "InvalidNetworkSettings": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                }
                case "InvalidAccessPoint": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "DataRepositoryAssociationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                }
                case "ResourceDoesNotSupportTagging": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                }
                case "DataRepositoryTaskNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                }
                case "SourceBackupUnavailable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "StorageVirtualMachineNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                }
                case "BackupRestoring": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                }
                case "BackupInProgress": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                }
                case "InvalidExportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                }
                case "InvalidRegion": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                }
                case "MissingVolumeConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                }
                case "InvalidSourceKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                }
                case "DataRepositoryTaskExecuting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                }
                case "IncompatibleRegionForMultiAZ": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                }
                case "MissingFileCacheConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                }
                case "BackupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "FileCacheNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                }
                case "InvalidDestinationKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                }
                case "VolumeNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                }
                case "ServiceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                }
                case "NotServiceResourceError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                }
                case "AccessPointAlreadyOwnedByYou": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                }
                case "MissingFileSystemConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                }
                case "BackupBeingCopied": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                }
                case "IncompatibleParameterError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                }
                case "DataRepositoryTaskEnded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                }
                case "InvalidDataRepositoryType": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                }
                case "SnapshotNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "TooManyAccessPoints": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                }
                case "InvalidPerUnitStorageThroughput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                }
                case "ActiveDirectoryError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeFileSystemAliasesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(clientConfiguration, describeFileSystemAliasesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeFileSystemAliases");
            DescribeFileSystemAliasesResponse describeFileSystemAliasesResponse = (DescribeFileSystemAliasesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeFileSystemAliases").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeFileSystemAliasesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeFileSystemAliasesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeFileSystemAliasesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$describeFileSystemAliases$53((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeFileSystemsResponse describeFileSystems(DescribeFileSystemsRequest describeFileSystemsRequest) throws BadRequestException, FileSystemNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeFileSystemsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "S3AccessPointAttachmentNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                }
                case "InvalidImportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                }
                case "InvalidNetworkSettings": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                }
                case "InvalidAccessPoint": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "DataRepositoryAssociationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                }
                case "ResourceDoesNotSupportTagging": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                }
                case "DataRepositoryTaskNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                }
                case "SourceBackupUnavailable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "StorageVirtualMachineNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                }
                case "BackupRestoring": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                }
                case "BackupInProgress": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                }
                case "InvalidExportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                }
                case "InvalidRegion": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                }
                case "MissingVolumeConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                }
                case "InvalidSourceKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                }
                case "DataRepositoryTaskExecuting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                }
                case "IncompatibleRegionForMultiAZ": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                }
                case "MissingFileCacheConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                }
                case "BackupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "FileCacheNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                }
                case "InvalidDestinationKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                }
                case "VolumeNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                }
                case "ServiceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                }
                case "NotServiceResourceError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                }
                case "AccessPointAlreadyOwnedByYou": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                }
                case "MissingFileSystemConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                }
                case "BackupBeingCopied": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                }
                case "IncompatibleParameterError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                }
                case "DataRepositoryTaskEnded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                }
                case "InvalidDataRepositoryType": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                }
                case "SnapshotNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "TooManyAccessPoints": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                }
                case "InvalidPerUnitStorageThroughput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                }
                case "ActiveDirectoryError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeFileSystemsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(clientConfiguration, describeFileSystemsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeFileSystems");
            DescribeFileSystemsResponse describeFileSystemsResponse = (DescribeFileSystemsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeFileSystems").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeFileSystemsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeFileSystemsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeFileSystemsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$describeFileSystems$55((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeS3AccessPointAttachmentsResponse describeS3AccessPointAttachments(DescribeS3AccessPointAttachmentsRequest describeS3AccessPointAttachmentsRequest) throws S3AccessPointAttachmentNotFoundException, BadRequestException, InternalServerErrorException, UnsupportedOperationException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeS3AccessPointAttachmentsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "S3AccessPointAttachmentNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                }
                case "InvalidImportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                }
                case "InvalidNetworkSettings": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                }
                case "InvalidAccessPoint": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "DataRepositoryAssociationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                }
                case "ResourceDoesNotSupportTagging": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                }
                case "DataRepositoryTaskNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                }
                case "SourceBackupUnavailable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "StorageVirtualMachineNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                }
                case "BackupRestoring": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                }
                case "BackupInProgress": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                }
                case "InvalidExportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                }
                case "InvalidRegion": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                }
                case "MissingVolumeConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                }
                case "InvalidSourceKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                }
                case "DataRepositoryTaskExecuting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                }
                case "IncompatibleRegionForMultiAZ": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                }
                case "MissingFileCacheConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                }
                case "BackupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "FileCacheNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                }
                case "InvalidDestinationKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                }
                case "VolumeNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                }
                case "ServiceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                }
                case "NotServiceResourceError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                }
                case "AccessPointAlreadyOwnedByYou": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                }
                case "MissingFileSystemConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                }
                case "BackupBeingCopied": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                }
                case "IncompatibleParameterError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                }
                case "DataRepositoryTaskEnded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                }
                case "InvalidDataRepositoryType": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                }
                case "SnapshotNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "TooManyAccessPoints": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                }
                case "InvalidPerUnitStorageThroughput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                }
                case "ActiveDirectoryError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeS3AccessPointAttachmentsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(clientConfiguration, describeS3AccessPointAttachmentsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeS3AccessPointAttachments");
            DescribeS3AccessPointAttachmentsResponse describeS3AccessPointAttachmentsResponse = (DescribeS3AccessPointAttachmentsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeS3AccessPointAttachments").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeS3AccessPointAttachmentsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeS3AccessPointAttachmentsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeS3AccessPointAttachmentsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$describeS3AccessPointAttachments$57((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeSharedVpcConfigurationResponse describeSharedVpcConfiguration(DescribeSharedVpcConfigurationRequest describeSharedVpcConfigurationRequest) throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeSharedVpcConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "S3AccessPointAttachmentNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                }
                case "InvalidImportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                }
                case "InvalidNetworkSettings": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                }
                case "InvalidAccessPoint": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "DataRepositoryAssociationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                }
                case "ResourceDoesNotSupportTagging": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                }
                case "DataRepositoryTaskNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                }
                case "SourceBackupUnavailable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "StorageVirtualMachineNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                }
                case "BackupRestoring": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                }
                case "BackupInProgress": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                }
                case "InvalidExportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                }
                case "InvalidRegion": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                }
                case "MissingVolumeConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                }
                case "InvalidSourceKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                }
                case "DataRepositoryTaskExecuting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                }
                case "IncompatibleRegionForMultiAZ": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                }
                case "MissingFileCacheConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                }
                case "BackupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "FileCacheNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                }
                case "InvalidDestinationKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                }
                case "VolumeNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                }
                case "ServiceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                }
                case "NotServiceResourceError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                }
                case "AccessPointAlreadyOwnedByYou": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                }
                case "MissingFileSystemConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                }
                case "BackupBeingCopied": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                }
                case "IncompatibleParameterError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                }
                case "DataRepositoryTaskEnded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                }
                case "InvalidDataRepositoryType": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                }
                case "SnapshotNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "TooManyAccessPoints": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                }
                case "InvalidPerUnitStorageThroughput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                }
                case "ActiveDirectoryError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeSharedVpcConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(clientConfiguration, describeSharedVpcConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeSharedVpcConfiguration");
            DescribeSharedVpcConfigurationResponse describeSharedVpcConfigurationResponse = (DescribeSharedVpcConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSharedVpcConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeSharedVpcConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeSharedVpcConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeSharedVpcConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$describeSharedVpcConfiguration$59((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeSnapshotsResponse describeSnapshots(DescribeSnapshotsRequest describeSnapshotsRequest) throws BadRequestException, InternalServerErrorException, SnapshotNotFoundException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeSnapshotsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "S3AccessPointAttachmentNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                }
                case "InvalidImportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                }
                case "InvalidNetworkSettings": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                }
                case "InvalidAccessPoint": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "DataRepositoryAssociationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                }
                case "ResourceDoesNotSupportTagging": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                }
                case "DataRepositoryTaskNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                }
                case "SourceBackupUnavailable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "StorageVirtualMachineNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                }
                case "BackupRestoring": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                }
                case "BackupInProgress": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                }
                case "InvalidExportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                }
                case "InvalidRegion": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                }
                case "MissingVolumeConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                }
                case "InvalidSourceKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                }
                case "DataRepositoryTaskExecuting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                }
                case "IncompatibleRegionForMultiAZ": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                }
                case "MissingFileCacheConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                }
                case "BackupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "FileCacheNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                }
                case "InvalidDestinationKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                }
                case "VolumeNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                }
                case "ServiceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                }
                case "NotServiceResourceError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                }
                case "AccessPointAlreadyOwnedByYou": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                }
                case "MissingFileSystemConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                }
                case "BackupBeingCopied": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                }
                case "IncompatibleParameterError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                }
                case "DataRepositoryTaskEnded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                }
                case "InvalidDataRepositoryType": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                }
                case "SnapshotNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "TooManyAccessPoints": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                }
                case "InvalidPerUnitStorageThroughput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                }
                case "ActiveDirectoryError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeSnapshotsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(clientConfiguration, describeSnapshotsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeSnapshots");
            DescribeSnapshotsResponse describeSnapshotsResponse = (DescribeSnapshotsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSnapshots").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeSnapshotsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeSnapshotsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeSnapshotsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$describeSnapshots$61((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeStorageVirtualMachinesResponse describeStorageVirtualMachines(DescribeStorageVirtualMachinesRequest describeStorageVirtualMachinesRequest) throws BadRequestException, InternalServerErrorException, StorageVirtualMachineNotFoundException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeStorageVirtualMachinesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "S3AccessPointAttachmentNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                }
                case "InvalidImportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                }
                case "InvalidNetworkSettings": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                }
                case "InvalidAccessPoint": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "DataRepositoryAssociationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                }
                case "ResourceDoesNotSupportTagging": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                }
                case "DataRepositoryTaskNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                }
                case "SourceBackupUnavailable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "StorageVirtualMachineNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                }
                case "BackupRestoring": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                }
                case "BackupInProgress": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                }
                case "InvalidExportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                }
                case "InvalidRegion": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                }
                case "MissingVolumeConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                }
                case "InvalidSourceKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                }
                case "DataRepositoryTaskExecuting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                }
                case "IncompatibleRegionForMultiAZ": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                }
                case "MissingFileCacheConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                }
                case "BackupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "FileCacheNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                }
                case "InvalidDestinationKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                }
                case "VolumeNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                }
                case "ServiceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                }
                case "NotServiceResourceError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                }
                case "AccessPointAlreadyOwnedByYou": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                }
                case "MissingFileSystemConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                }
                case "BackupBeingCopied": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                }
                case "IncompatibleParameterError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                }
                case "DataRepositoryTaskEnded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                }
                case "InvalidDataRepositoryType": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                }
                case "SnapshotNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "TooManyAccessPoints": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                }
                case "InvalidPerUnitStorageThroughput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                }
                case "ActiveDirectoryError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeStorageVirtualMachinesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(clientConfiguration, describeStorageVirtualMachinesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeStorageVirtualMachines");
            DescribeStorageVirtualMachinesResponse describeStorageVirtualMachinesResponse = (DescribeStorageVirtualMachinesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeStorageVirtualMachines").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeStorageVirtualMachinesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeStorageVirtualMachinesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeStorageVirtualMachinesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$describeStorageVirtualMachines$63((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeVolumesResponse describeVolumes(DescribeVolumesRequest describeVolumesRequest) throws BadRequestException, InternalServerErrorException, VolumeNotFoundException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeVolumesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "S3AccessPointAttachmentNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                }
                case "InvalidImportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                }
                case "InvalidNetworkSettings": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                }
                case "InvalidAccessPoint": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "DataRepositoryAssociationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                }
                case "ResourceDoesNotSupportTagging": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                }
                case "DataRepositoryTaskNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                }
                case "SourceBackupUnavailable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "StorageVirtualMachineNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                }
                case "BackupRestoring": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                }
                case "BackupInProgress": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                }
                case "InvalidExportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                }
                case "InvalidRegion": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                }
                case "MissingVolumeConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                }
                case "InvalidSourceKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                }
                case "DataRepositoryTaskExecuting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                }
                case "IncompatibleRegionForMultiAZ": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                }
                case "MissingFileCacheConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                }
                case "BackupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "FileCacheNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                }
                case "InvalidDestinationKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                }
                case "VolumeNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                }
                case "ServiceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                }
                case "NotServiceResourceError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                }
                case "AccessPointAlreadyOwnedByYou": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                }
                case "MissingFileSystemConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                }
                case "BackupBeingCopied": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                }
                case "IncompatibleParameterError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                }
                case "DataRepositoryTaskEnded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                }
                case "InvalidDataRepositoryType": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                }
                case "SnapshotNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "TooManyAccessPoints": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                }
                case "InvalidPerUnitStorageThroughput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                }
                case "ActiveDirectoryError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeVolumesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(clientConfiguration, describeVolumesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeVolumes");
            DescribeVolumesResponse describeVolumesResponse = (DescribeVolumesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeVolumes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeVolumesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeVolumesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeVolumesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$describeVolumes$65((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DetachAndDeleteS3AccessPointResponse detachAndDeleteS3AccessPoint(DetachAndDeleteS3AccessPointRequest detachAndDeleteS3AccessPointRequest) throws BadRequestException, IncompatibleParameterErrorException, InternalServerErrorException, UnsupportedOperationException, S3AccessPointAttachmentNotFoundException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DetachAndDeleteS3AccessPointResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "S3AccessPointAttachmentNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                }
                case "InvalidImportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                }
                case "InvalidNetworkSettings": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                }
                case "InvalidAccessPoint": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "DataRepositoryAssociationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                }
                case "ResourceDoesNotSupportTagging": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                }
                case "DataRepositoryTaskNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                }
                case "SourceBackupUnavailable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "StorageVirtualMachineNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                }
                case "BackupRestoring": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                }
                case "BackupInProgress": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                }
                case "InvalidExportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                }
                case "InvalidRegion": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                }
                case "MissingVolumeConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                }
                case "InvalidSourceKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                }
                case "DataRepositoryTaskExecuting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                }
                case "IncompatibleRegionForMultiAZ": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                }
                case "MissingFileCacheConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                }
                case "BackupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "FileCacheNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                }
                case "InvalidDestinationKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                }
                case "VolumeNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                }
                case "ServiceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                }
                case "NotServiceResourceError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                }
                case "AccessPointAlreadyOwnedByYou": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                }
                case "MissingFileSystemConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                }
                case "BackupBeingCopied": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                }
                case "IncompatibleParameterError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                }
                case "DataRepositoryTaskEnded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                }
                case "InvalidDataRepositoryType": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                }
                case "SnapshotNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "TooManyAccessPoints": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                }
                case "InvalidPerUnitStorageThroughput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                }
                case "ActiveDirectoryError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)detachAndDeleteS3AccessPointRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(clientConfiguration, detachAndDeleteS3AccessPointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DetachAndDeleteS3AccessPoint");
            DetachAndDeleteS3AccessPointResponse detachAndDeleteS3AccessPointResponse = (DetachAndDeleteS3AccessPointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetachAndDeleteS3AccessPoint").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)detachAndDeleteS3AccessPointRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DetachAndDeleteS3AccessPointRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return detachAndDeleteS3AccessPointResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$detachAndDeleteS3AccessPoint$67((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisassociateFileSystemAliasesResponse disassociateFileSystemAliases(DisassociateFileSystemAliasesRequest disassociateFileSystemAliasesRequest) throws BadRequestException, FileSystemNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateFileSystemAliasesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "S3AccessPointAttachmentNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                }
                case "InvalidImportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                }
                case "InvalidNetworkSettings": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                }
                case "InvalidAccessPoint": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "DataRepositoryAssociationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                }
                case "ResourceDoesNotSupportTagging": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                }
                case "DataRepositoryTaskNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                }
                case "SourceBackupUnavailable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "StorageVirtualMachineNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                }
                case "BackupRestoring": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                }
                case "BackupInProgress": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                }
                case "InvalidExportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                }
                case "InvalidRegion": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                }
                case "MissingVolumeConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                }
                case "InvalidSourceKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                }
                case "DataRepositoryTaskExecuting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                }
                case "IncompatibleRegionForMultiAZ": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                }
                case "MissingFileCacheConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                }
                case "BackupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "FileCacheNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                }
                case "InvalidDestinationKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                }
                case "VolumeNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                }
                case "ServiceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                }
                case "NotServiceResourceError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                }
                case "AccessPointAlreadyOwnedByYou": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                }
                case "MissingFileSystemConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                }
                case "BackupBeingCopied": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                }
                case "IncompatibleParameterError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                }
                case "DataRepositoryTaskEnded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                }
                case "InvalidDataRepositoryType": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                }
                case "SnapshotNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "TooManyAccessPoints": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                }
                case "InvalidPerUnitStorageThroughput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                }
                case "ActiveDirectoryError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disassociateFileSystemAliasesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(clientConfiguration, disassociateFileSystemAliasesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateFileSystemAliases");
            DisassociateFileSystemAliasesResponse disassociateFileSystemAliasesResponse = (DisassociateFileSystemAliasesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateFileSystemAliases").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)disassociateFileSystemAliasesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisassociateFileSystemAliasesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disassociateFileSystemAliasesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$disassociateFileSystemAliases$69((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws BadRequestException, InternalServerErrorException, ResourceNotFoundException, NotServiceResourceErrorException, ResourceDoesNotSupportTaggingException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "S3AccessPointAttachmentNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                }
                case "InvalidImportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                }
                case "InvalidNetworkSettings": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                }
                case "InvalidAccessPoint": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "DataRepositoryAssociationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                }
                case "ResourceDoesNotSupportTagging": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                }
                case "DataRepositoryTaskNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                }
                case "SourceBackupUnavailable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "StorageVirtualMachineNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                }
                case "BackupRestoring": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                }
                case "BackupInProgress": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                }
                case "InvalidExportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                }
                case "InvalidRegion": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                }
                case "MissingVolumeConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                }
                case "InvalidSourceKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                }
                case "DataRepositoryTaskExecuting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                }
                case "IncompatibleRegionForMultiAZ": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                }
                case "MissingFileCacheConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                }
                case "BackupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "FileCacheNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                }
                case "InvalidDestinationKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                }
                case "VolumeNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                }
                case "ServiceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                }
                case "NotServiceResourceError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                }
                case "AccessPointAlreadyOwnedByYou": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                }
                case "MissingFileSystemConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                }
                case "BackupBeingCopied": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                }
                case "IncompatibleParameterError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                }
                case "DataRepositoryTaskEnded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                }
                case "InvalidDataRepositoryType": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                }
                case "SnapshotNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "TooManyAccessPoints": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                }
                case "InvalidPerUnitStorageThroughput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                }
                case "ActiveDirectoryError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$listTagsForResource$71((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReleaseFileSystemNfsV3LocksResponse releaseFileSystemNfsV3Locks(ReleaseFileSystemNfsV3LocksRequest releaseFileSystemNfsV3LocksRequest) throws BadRequestException, IncompatibleParameterErrorException, FileSystemNotFoundException, ServiceLimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ReleaseFileSystemNfsV3LocksResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "S3AccessPointAttachmentNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                }
                case "InvalidImportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                }
                case "InvalidNetworkSettings": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                }
                case "InvalidAccessPoint": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "DataRepositoryAssociationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                }
                case "ResourceDoesNotSupportTagging": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                }
                case "DataRepositoryTaskNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                }
                case "SourceBackupUnavailable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "StorageVirtualMachineNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                }
                case "BackupRestoring": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                }
                case "BackupInProgress": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                }
                case "InvalidExportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                }
                case "InvalidRegion": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                }
                case "MissingVolumeConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                }
                case "InvalidSourceKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                }
                case "DataRepositoryTaskExecuting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                }
                case "IncompatibleRegionForMultiAZ": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                }
                case "MissingFileCacheConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                }
                case "BackupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "FileCacheNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                }
                case "InvalidDestinationKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                }
                case "VolumeNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                }
                case "ServiceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                }
                case "NotServiceResourceError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                }
                case "AccessPointAlreadyOwnedByYou": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                }
                case "MissingFileSystemConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                }
                case "BackupBeingCopied": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                }
                case "IncompatibleParameterError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                }
                case "DataRepositoryTaskEnded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                }
                case "InvalidDataRepositoryType": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                }
                case "SnapshotNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "TooManyAccessPoints": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                }
                case "InvalidPerUnitStorageThroughput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                }
                case "ActiveDirectoryError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)releaseFileSystemNfsV3LocksRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(clientConfiguration, releaseFileSystemNfsV3LocksRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ReleaseFileSystemNfsV3Locks");
            ReleaseFileSystemNfsV3LocksResponse releaseFileSystemNfsV3LocksResponse = (ReleaseFileSystemNfsV3LocksResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ReleaseFileSystemNfsV3Locks").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)releaseFileSystemNfsV3LocksRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ReleaseFileSystemNfsV3LocksRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return releaseFileSystemNfsV3LocksResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$releaseFileSystemNfsV3Locks$73((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RestoreVolumeFromSnapshotResponse restoreVolumeFromSnapshot(RestoreVolumeFromSnapshotRequest restoreVolumeFromSnapshotRequest) throws BadRequestException, InternalServerErrorException, VolumeNotFoundException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RestoreVolumeFromSnapshotResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "S3AccessPointAttachmentNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                }
                case "InvalidImportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                }
                case "InvalidNetworkSettings": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                }
                case "InvalidAccessPoint": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "DataRepositoryAssociationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                }
                case "ResourceDoesNotSupportTagging": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                }
                case "DataRepositoryTaskNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                }
                case "SourceBackupUnavailable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "StorageVirtualMachineNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                }
                case "BackupRestoring": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                }
                case "BackupInProgress": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                }
                case "InvalidExportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                }
                case "InvalidRegion": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                }
                case "MissingVolumeConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                }
                case "InvalidSourceKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                }
                case "DataRepositoryTaskExecuting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                }
                case "IncompatibleRegionForMultiAZ": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                }
                case "MissingFileCacheConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                }
                case "BackupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "FileCacheNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                }
                case "InvalidDestinationKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                }
                case "VolumeNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                }
                case "ServiceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                }
                case "NotServiceResourceError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                }
                case "AccessPointAlreadyOwnedByYou": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                }
                case "MissingFileSystemConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                }
                case "BackupBeingCopied": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                }
                case "IncompatibleParameterError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                }
                case "DataRepositoryTaskEnded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                }
                case "InvalidDataRepositoryType": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                }
                case "SnapshotNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "TooManyAccessPoints": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                }
                case "InvalidPerUnitStorageThroughput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                }
                case "ActiveDirectoryError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)restoreVolumeFromSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(clientConfiguration, restoreVolumeFromSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RestoreVolumeFromSnapshot");
            RestoreVolumeFromSnapshotResponse restoreVolumeFromSnapshotResponse = (RestoreVolumeFromSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RestoreVolumeFromSnapshot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)restoreVolumeFromSnapshotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RestoreVolumeFromSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return restoreVolumeFromSnapshotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$restoreVolumeFromSnapshot$75((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartMisconfiguredStateRecoveryResponse startMisconfiguredStateRecovery(StartMisconfiguredStateRecoveryRequest startMisconfiguredStateRecoveryRequest) throws BadRequestException, FileSystemNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartMisconfiguredStateRecoveryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "S3AccessPointAttachmentNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                }
                case "InvalidImportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                }
                case "InvalidNetworkSettings": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                }
                case "InvalidAccessPoint": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "DataRepositoryAssociationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                }
                case "ResourceDoesNotSupportTagging": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                }
                case "DataRepositoryTaskNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                }
                case "SourceBackupUnavailable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "StorageVirtualMachineNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                }
                case "BackupRestoring": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                }
                case "BackupInProgress": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                }
                case "InvalidExportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                }
                case "InvalidRegion": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                }
                case "MissingVolumeConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                }
                case "InvalidSourceKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                }
                case "DataRepositoryTaskExecuting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                }
                case "IncompatibleRegionForMultiAZ": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                }
                case "MissingFileCacheConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                }
                case "BackupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "FileCacheNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                }
                case "InvalidDestinationKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                }
                case "VolumeNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                }
                case "ServiceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                }
                case "NotServiceResourceError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                }
                case "AccessPointAlreadyOwnedByYou": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                }
                case "MissingFileSystemConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                }
                case "BackupBeingCopied": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                }
                case "IncompatibleParameterError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                }
                case "DataRepositoryTaskEnded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                }
                case "InvalidDataRepositoryType": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                }
                case "SnapshotNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "TooManyAccessPoints": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                }
                case "InvalidPerUnitStorageThroughput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                }
                case "ActiveDirectoryError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startMisconfiguredStateRecoveryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(clientConfiguration, startMisconfiguredStateRecoveryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartMisconfiguredStateRecovery");
            StartMisconfiguredStateRecoveryResponse startMisconfiguredStateRecoveryResponse = (StartMisconfiguredStateRecoveryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartMisconfiguredStateRecovery").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startMisconfiguredStateRecoveryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartMisconfiguredStateRecoveryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startMisconfiguredStateRecoveryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$startMisconfiguredStateRecovery$77((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws BadRequestException, InternalServerErrorException, ResourceNotFoundException, NotServiceResourceErrorException, ResourceDoesNotSupportTaggingException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "S3AccessPointAttachmentNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                }
                case "InvalidImportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                }
                case "InvalidNetworkSettings": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                }
                case "InvalidAccessPoint": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "DataRepositoryAssociationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                }
                case "ResourceDoesNotSupportTagging": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                }
                case "DataRepositoryTaskNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                }
                case "SourceBackupUnavailable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "StorageVirtualMachineNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                }
                case "BackupRestoring": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                }
                case "BackupInProgress": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                }
                case "InvalidExportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                }
                case "InvalidRegion": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                }
                case "MissingVolumeConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                }
                case "InvalidSourceKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                }
                case "DataRepositoryTaskExecuting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                }
                case "IncompatibleRegionForMultiAZ": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                }
                case "MissingFileCacheConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                }
                case "BackupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "FileCacheNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                }
                case "InvalidDestinationKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                }
                case "VolumeNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                }
                case "ServiceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                }
                case "NotServiceResourceError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                }
                case "AccessPointAlreadyOwnedByYou": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                }
                case "MissingFileSystemConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                }
                case "BackupBeingCopied": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                }
                case "IncompatibleParameterError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                }
                case "DataRepositoryTaskEnded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                }
                case "InvalidDataRepositoryType": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                }
                case "SnapshotNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "TooManyAccessPoints": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                }
                case "InvalidPerUnitStorageThroughput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                }
                case "ActiveDirectoryError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$tagResource$79((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws BadRequestException, InternalServerErrorException, ResourceNotFoundException, NotServiceResourceErrorException, ResourceDoesNotSupportTaggingException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "S3AccessPointAttachmentNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                }
                case "InvalidImportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                }
                case "InvalidNetworkSettings": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                }
                case "InvalidAccessPoint": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "DataRepositoryAssociationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                }
                case "ResourceDoesNotSupportTagging": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                }
                case "DataRepositoryTaskNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                }
                case "SourceBackupUnavailable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "StorageVirtualMachineNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                }
                case "BackupRestoring": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                }
                case "BackupInProgress": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                }
                case "InvalidExportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                }
                case "InvalidRegion": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                }
                case "MissingVolumeConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                }
                case "InvalidSourceKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                }
                case "DataRepositoryTaskExecuting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                }
                case "IncompatibleRegionForMultiAZ": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                }
                case "MissingFileCacheConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                }
                case "BackupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "FileCacheNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                }
                case "InvalidDestinationKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                }
                case "VolumeNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                }
                case "ServiceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                }
                case "NotServiceResourceError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                }
                case "AccessPointAlreadyOwnedByYou": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                }
                case "MissingFileSystemConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                }
                case "BackupBeingCopied": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                }
                case "IncompatibleParameterError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                }
                case "DataRepositoryTaskEnded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                }
                case "InvalidDataRepositoryType": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                }
                case "SnapshotNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "TooManyAccessPoints": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                }
                case "InvalidPerUnitStorageThroughput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                }
                case "ActiveDirectoryError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$untagResource$81((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateDataRepositoryAssociationResponse updateDataRepositoryAssociation(UpdateDataRepositoryAssociationRequest updateDataRepositoryAssociationRequest) throws BadRequestException, IncompatibleParameterErrorException, DataRepositoryAssociationNotFoundException, ServiceLimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDataRepositoryAssociationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "S3AccessPointAttachmentNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                }
                case "InvalidImportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                }
                case "InvalidNetworkSettings": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                }
                case "InvalidAccessPoint": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "DataRepositoryAssociationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                }
                case "ResourceDoesNotSupportTagging": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                }
                case "DataRepositoryTaskNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                }
                case "SourceBackupUnavailable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "StorageVirtualMachineNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                }
                case "BackupRestoring": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                }
                case "BackupInProgress": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                }
                case "InvalidExportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                }
                case "InvalidRegion": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                }
                case "MissingVolumeConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                }
                case "InvalidSourceKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                }
                case "DataRepositoryTaskExecuting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                }
                case "IncompatibleRegionForMultiAZ": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                }
                case "MissingFileCacheConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                }
                case "BackupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "FileCacheNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                }
                case "InvalidDestinationKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                }
                case "VolumeNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                }
                case "ServiceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                }
                case "NotServiceResourceError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                }
                case "AccessPointAlreadyOwnedByYou": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                }
                case "MissingFileSystemConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                }
                case "BackupBeingCopied": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                }
                case "IncompatibleParameterError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                }
                case "DataRepositoryTaskEnded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                }
                case "InvalidDataRepositoryType": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                }
                case "SnapshotNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "TooManyAccessPoints": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                }
                case "InvalidPerUnitStorageThroughput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                }
                case "ActiveDirectoryError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateDataRepositoryAssociationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(clientConfiguration, updateDataRepositoryAssociationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateDataRepositoryAssociation");
            UpdateDataRepositoryAssociationResponse updateDataRepositoryAssociationResponse = (UpdateDataRepositoryAssociationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDataRepositoryAssociation").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateDataRepositoryAssociationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateDataRepositoryAssociationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateDataRepositoryAssociationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$updateDataRepositoryAssociation$83((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateFileCacheResponse updateFileCache(UpdateFileCacheRequest updateFileCacheRequest) throws BadRequestException, UnsupportedOperationException, IncompatibleParameterErrorException, InternalServerErrorException, FileCacheNotFoundException, MissingFileCacheConfigurationException, ServiceLimitExceededException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateFileCacheResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "S3AccessPointAttachmentNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                }
                case "InvalidImportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                }
                case "InvalidNetworkSettings": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                }
                case "InvalidAccessPoint": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "DataRepositoryAssociationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                }
                case "ResourceDoesNotSupportTagging": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                }
                case "DataRepositoryTaskNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                }
                case "SourceBackupUnavailable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "StorageVirtualMachineNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                }
                case "BackupRestoring": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                }
                case "BackupInProgress": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                }
                case "InvalidExportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                }
                case "InvalidRegion": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                }
                case "MissingVolumeConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                }
                case "InvalidSourceKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                }
                case "DataRepositoryTaskExecuting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                }
                case "IncompatibleRegionForMultiAZ": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                }
                case "MissingFileCacheConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                }
                case "BackupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "FileCacheNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                }
                case "InvalidDestinationKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                }
                case "VolumeNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                }
                case "ServiceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                }
                case "NotServiceResourceError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                }
                case "AccessPointAlreadyOwnedByYou": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                }
                case "MissingFileSystemConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                }
                case "BackupBeingCopied": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                }
                case "IncompatibleParameterError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                }
                case "DataRepositoryTaskEnded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                }
                case "InvalidDataRepositoryType": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                }
                case "SnapshotNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "TooManyAccessPoints": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                }
                case "InvalidPerUnitStorageThroughput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                }
                case "ActiveDirectoryError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateFileCacheRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(clientConfiguration, updateFileCacheRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateFileCache");
            UpdateFileCacheResponse updateFileCacheResponse = (UpdateFileCacheResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateFileCache").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateFileCacheRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateFileCacheRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateFileCacheResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$updateFileCache$85((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateFileSystemResponse updateFileSystem(UpdateFileSystemRequest updateFileSystemRequest) throws BadRequestException, UnsupportedOperationException, IncompatibleParameterErrorException, InvalidNetworkSettingsException, InternalServerErrorException, FileSystemNotFoundException, MissingFileSystemConfigurationException, ServiceLimitExceededException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateFileSystemResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "S3AccessPointAttachmentNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                }
                case "InvalidImportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                }
                case "InvalidNetworkSettings": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                }
                case "InvalidAccessPoint": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "DataRepositoryAssociationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                }
                case "ResourceDoesNotSupportTagging": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                }
                case "DataRepositoryTaskNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                }
                case "SourceBackupUnavailable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "StorageVirtualMachineNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                }
                case "BackupRestoring": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                }
                case "BackupInProgress": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                }
                case "InvalidExportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                }
                case "InvalidRegion": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                }
                case "MissingVolumeConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                }
                case "InvalidSourceKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                }
                case "DataRepositoryTaskExecuting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                }
                case "IncompatibleRegionForMultiAZ": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                }
                case "MissingFileCacheConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                }
                case "BackupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "FileCacheNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                }
                case "InvalidDestinationKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                }
                case "VolumeNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                }
                case "ServiceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                }
                case "NotServiceResourceError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                }
                case "AccessPointAlreadyOwnedByYou": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                }
                case "MissingFileSystemConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                }
                case "BackupBeingCopied": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                }
                case "IncompatibleParameterError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                }
                case "DataRepositoryTaskEnded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                }
                case "InvalidDataRepositoryType": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                }
                case "SnapshotNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "TooManyAccessPoints": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                }
                case "InvalidPerUnitStorageThroughput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                }
                case "ActiveDirectoryError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateFileSystemRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(clientConfiguration, updateFileSystemRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateFileSystem");
            UpdateFileSystemResponse updateFileSystemResponse = (UpdateFileSystemResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateFileSystem").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateFileSystemRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateFileSystemRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateFileSystemResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$updateFileSystem$87((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateSharedVpcConfigurationResponse updateSharedVpcConfiguration(UpdateSharedVpcConfigurationRequest updateSharedVpcConfigurationRequest) throws BadRequestException, IncompatibleParameterErrorException, InternalServerErrorException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateSharedVpcConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "S3AccessPointAttachmentNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                }
                case "InvalidImportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                }
                case "InvalidNetworkSettings": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                }
                case "InvalidAccessPoint": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "DataRepositoryAssociationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                }
                case "ResourceDoesNotSupportTagging": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                }
                case "DataRepositoryTaskNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                }
                case "SourceBackupUnavailable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "StorageVirtualMachineNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                }
                case "BackupRestoring": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                }
                case "BackupInProgress": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                }
                case "InvalidExportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                }
                case "InvalidRegion": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                }
                case "MissingVolumeConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                }
                case "InvalidSourceKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                }
                case "DataRepositoryTaskExecuting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                }
                case "IncompatibleRegionForMultiAZ": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                }
                case "MissingFileCacheConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                }
                case "BackupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "FileCacheNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                }
                case "InvalidDestinationKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                }
                case "VolumeNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                }
                case "ServiceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                }
                case "NotServiceResourceError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                }
                case "AccessPointAlreadyOwnedByYou": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                }
                case "MissingFileSystemConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                }
                case "BackupBeingCopied": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                }
                case "IncompatibleParameterError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                }
                case "DataRepositoryTaskEnded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                }
                case "InvalidDataRepositoryType": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                }
                case "SnapshotNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "TooManyAccessPoints": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                }
                case "InvalidPerUnitStorageThroughput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                }
                case "ActiveDirectoryError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateSharedVpcConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(clientConfiguration, updateSharedVpcConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateSharedVpcConfiguration");
            UpdateSharedVpcConfigurationResponse updateSharedVpcConfigurationResponse = (UpdateSharedVpcConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateSharedVpcConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateSharedVpcConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateSharedVpcConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateSharedVpcConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$updateSharedVpcConfiguration$89((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateSnapshotResponse updateSnapshot(UpdateSnapshotRequest updateSnapshotRequest) throws BadRequestException, SnapshotNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateSnapshotResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "S3AccessPointAttachmentNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                }
                case "InvalidImportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                }
                case "InvalidNetworkSettings": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                }
                case "InvalidAccessPoint": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "DataRepositoryAssociationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                }
                case "ResourceDoesNotSupportTagging": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                }
                case "DataRepositoryTaskNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                }
                case "SourceBackupUnavailable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "StorageVirtualMachineNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                }
                case "BackupRestoring": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                }
                case "BackupInProgress": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                }
                case "InvalidExportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                }
                case "InvalidRegion": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                }
                case "MissingVolumeConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                }
                case "InvalidSourceKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                }
                case "DataRepositoryTaskExecuting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                }
                case "IncompatibleRegionForMultiAZ": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                }
                case "MissingFileCacheConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                }
                case "BackupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "FileCacheNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                }
                case "InvalidDestinationKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                }
                case "VolumeNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                }
                case "ServiceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                }
                case "NotServiceResourceError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                }
                case "AccessPointAlreadyOwnedByYou": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                }
                case "MissingFileSystemConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                }
                case "BackupBeingCopied": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                }
                case "IncompatibleParameterError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                }
                case "DataRepositoryTaskEnded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                }
                case "InvalidDataRepositoryType": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                }
                case "SnapshotNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "TooManyAccessPoints": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                }
                case "InvalidPerUnitStorageThroughput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                }
                case "ActiveDirectoryError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(clientConfiguration, updateSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateSnapshot");
            UpdateSnapshotResponse updateSnapshotResponse = (UpdateSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateSnapshot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateSnapshotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateSnapshotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$updateSnapshot$91((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateStorageVirtualMachineResponse updateStorageVirtualMachine(UpdateStorageVirtualMachineRequest updateStorageVirtualMachineRequest) throws BadRequestException, IncompatibleParameterErrorException, InternalServerErrorException, StorageVirtualMachineNotFoundException, UnsupportedOperationException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateStorageVirtualMachineResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "S3AccessPointAttachmentNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                }
                case "InvalidImportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                }
                case "InvalidNetworkSettings": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                }
                case "InvalidAccessPoint": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "DataRepositoryAssociationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                }
                case "ResourceDoesNotSupportTagging": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                }
                case "DataRepositoryTaskNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                }
                case "SourceBackupUnavailable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "StorageVirtualMachineNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                }
                case "BackupRestoring": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                }
                case "BackupInProgress": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                }
                case "InvalidExportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                }
                case "InvalidRegion": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                }
                case "MissingVolumeConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                }
                case "InvalidSourceKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                }
                case "DataRepositoryTaskExecuting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                }
                case "IncompatibleRegionForMultiAZ": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                }
                case "MissingFileCacheConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                }
                case "BackupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "FileCacheNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                }
                case "InvalidDestinationKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                }
                case "VolumeNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                }
                case "ServiceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                }
                case "NotServiceResourceError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                }
                case "AccessPointAlreadyOwnedByYou": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                }
                case "MissingFileSystemConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                }
                case "BackupBeingCopied": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                }
                case "IncompatibleParameterError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                }
                case "DataRepositoryTaskEnded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                }
                case "InvalidDataRepositoryType": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                }
                case "SnapshotNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "TooManyAccessPoints": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                }
                case "InvalidPerUnitStorageThroughput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                }
                case "ActiveDirectoryError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateStorageVirtualMachineRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(clientConfiguration, updateStorageVirtualMachineRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateStorageVirtualMachine");
            UpdateStorageVirtualMachineResponse updateStorageVirtualMachineResponse = (UpdateStorageVirtualMachineResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateStorageVirtualMachine").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateStorageVirtualMachineRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateStorageVirtualMachineRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateStorageVirtualMachineResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$updateStorageVirtualMachine$93((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateVolumeResponse updateVolume(UpdateVolumeRequest updateVolumeRequest) throws BadRequestException, IncompatibleParameterErrorException, InternalServerErrorException, MissingVolumeConfigurationException, VolumeNotFoundException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateVolumeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "S3AccessPointAttachmentNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                }
                case "InvalidImportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                }
                case "InvalidNetworkSettings": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                }
                case "InvalidAccessPoint": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "DataRepositoryAssociationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                }
                case "ResourceDoesNotSupportTagging": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                }
                case "DataRepositoryTaskNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                }
                case "SourceBackupUnavailable": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                }
                case "ResourceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "StorageVirtualMachineNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                }
                case "BackupRestoring": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                }
                case "BackupInProgress": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                }
                case "InvalidExportPath": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                }
                case "InvalidRegion": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                }
                case "MissingVolumeConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                }
                case "InvalidSourceKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                }
                case "DataRepositoryTaskExecuting": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                }
                case "IncompatibleRegionForMultiAZ": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                }
                case "MissingFileCacheConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                }
                case "BackupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "FileCacheNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                }
                case "InvalidDestinationKmsKey": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                }
                case "VolumeNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                }
                case "ServiceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                }
                case "NotServiceResourceError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                }
                case "AccessPointAlreadyOwnedByYou": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                }
                case "MissingFileSystemConfiguration": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                }
                case "BackupBeingCopied": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                }
                case "IncompatibleParameterError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                }
                case "DataRepositoryTaskEnded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                }
                case "InvalidDataRepositoryType": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                }
                case "SnapshotNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "TooManyAccessPoints": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                }
                case "InvalidPerUnitStorageThroughput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                }
                case "ActiveDirectoryError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateVolumeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(clientConfiguration, updateVolumeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateVolume");
            UpdateVolumeResponse updateVolumeResponse = (UpdateVolumeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateVolume").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateVolumeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateVolumeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateVolumeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$updateVolume$95((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "fsx";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        FSxServiceClientConfigurationBuilder serviceConfigBuilder = new FSxServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(FSxException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1");
    }

    @Override
    public final FSxServiceClientConfiguration serviceClientConfiguration() {
        return new FSxServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateVolume$95(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateStorageVirtualMachine$93(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateSnapshot$91(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateSharedVpcConfiguration$89(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateFileSystem$87(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateFileCache$85(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateDataRepositoryAssociation$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$81(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$79(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startMisconfiguredStateRecovery$77(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$restoreVolumeFromSnapshot$75(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$releaseFileSystemNfsV3Locks$73(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disassociateFileSystemAliases$69(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$detachAndDeleteS3AccessPoint$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeVolumes$65(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeStorageVirtualMachines$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeSnapshots$61(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeSharedVpcConfiguration$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeS3AccessPointAttachments$57(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeFileSystems$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeFileSystemAliases$53(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeFileCaches$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDataRepositoryTasks$49(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDataRepositoryAssociations$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeBackups$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteVolume$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteStorageVirtualMachine$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteSnapshot$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteFileSystem$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteFileCache$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDataRepositoryAssociation$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteBackup$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createVolumeFromBackup$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createVolume$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createStorageVirtualMachine$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createSnapshot$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createFileSystemFromBackup$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createFileSystem$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createFileCache$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDataRepositoryTask$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDataRepositoryAssociation$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createBackup$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createAndAttachS3AccessPoint$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$copySnapshotAndUpdateVolume$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$copyBackup$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$cancelDataRepositoryTask$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associateFileSystemAliases$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

