/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fsx.model.OpenZFSClientConfiguration;
import software.amazon.awssdk.services.fsx.model.OpenZFSClientConfigurationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OpenZFSNfsExport
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OpenZFSNfsExport> {
    private static final SdkField<List<OpenZFSClientConfiguration>> CLIENT_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ClientConfigurations").getter(OpenZFSNfsExport.getter(OpenZFSNfsExport::clientConfigurations)).setter(OpenZFSNfsExport.setter(Builder::clientConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OpenZFSClientConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_CONFIGURATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OpenZFSNfsExport.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<OpenZFSClientConfiguration> clientConfigurations;

    private OpenZFSNfsExport(BuilderImpl builder) {
        this.clientConfigurations = builder.clientConfigurations;
    }

    public final boolean hasClientConfigurations() {
        return this.clientConfigurations != null && !(this.clientConfigurations instanceof SdkAutoConstructList);
    }

    public final List<OpenZFSClientConfiguration> clientConfigurations() {
        return this.clientConfigurations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClientConfigurations() ? this.clientConfigurations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpenZFSNfsExport)) {
            return false;
        }
        OpenZFSNfsExport other = (OpenZFSNfsExport)obj;
        return this.hasClientConfigurations() == other.hasClientConfigurations() && Objects.equals(this.clientConfigurations(), other.clientConfigurations());
    }

    public final String toString() {
        return ToString.builder((String)"OpenZFSNfsExport").add("ClientConfigurations", this.hasClientConfigurations() ? this.clientConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientConfigurations": {
                return Optional.ofNullable(clazz.cast(this.clientConfigurations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<OpenZFSClientConfiguration>>> map = new HashMap<String, SdkField<List<OpenZFSClientConfiguration>>>();
        map.put("ClientConfigurations", CLIENT_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OpenZFSNfsExport, T> g) {
        return obj -> g.apply((OpenZFSNfsExport)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<OpenZFSClientConfiguration> clientConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OpenZFSNfsExport model) {
            this.clientConfigurations(model.clientConfigurations);
        }

        public final List<OpenZFSClientConfiguration.Builder> getClientConfigurations() {
            List<OpenZFSClientConfiguration.Builder> result = OpenZFSClientConfigurationsCopier.copyToBuilder(this.clientConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClientConfigurations(Collection<OpenZFSClientConfiguration.BuilderImpl> clientConfigurations) {
            this.clientConfigurations = OpenZFSClientConfigurationsCopier.copyFromBuilder(clientConfigurations);
        }

        @Override
        public final Builder clientConfigurations(Collection<OpenZFSClientConfiguration> clientConfigurations) {
            this.clientConfigurations = OpenZFSClientConfigurationsCopier.copy(clientConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clientConfigurations(OpenZFSClientConfiguration ... clientConfigurations) {
            this.clientConfigurations(Arrays.asList(clientConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clientConfigurations(Consumer<OpenZFSClientConfiguration.Builder> ... clientConfigurations) {
            this.clientConfigurations(Stream.of(clientConfigurations).map(c -> (OpenZFSClientConfiguration)((OpenZFSClientConfiguration.Builder)OpenZFSClientConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public OpenZFSNfsExport build() {
            return new OpenZFSNfsExport(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OpenZFSNfsExport> {
        public Builder clientConfigurations(Collection<OpenZFSClientConfiguration> var1);

        public Builder clientConfigurations(OpenZFSClientConfiguration ... var1);

        public Builder clientConfigurations(Consumer<OpenZFSClientConfiguration.Builder> ... var1);
    }
}

