/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fsx.model.DiskIopsConfiguration;
import software.amazon.awssdk.services.fsx.model.OpenZFSReadCacheConfiguration;
import software.amazon.awssdk.services.fsx.model.RouteTableIdsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateFileSystemOpenZFSConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UpdateFileSystemOpenZFSConfiguration> {
    private static final SdkField<Integer> AUTOMATIC_BACKUP_RETENTION_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AutomaticBackupRetentionDays").getter(UpdateFileSystemOpenZFSConfiguration.getter(UpdateFileSystemOpenZFSConfiguration::automaticBackupRetentionDays)).setter(UpdateFileSystemOpenZFSConfiguration.setter(Builder::automaticBackupRetentionDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomaticBackupRetentionDays").build()}).build();
    private static final SdkField<Boolean> COPY_TAGS_TO_BACKUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CopyTagsToBackups").getter(UpdateFileSystemOpenZFSConfiguration.getter(UpdateFileSystemOpenZFSConfiguration::copyTagsToBackups)).setter(UpdateFileSystemOpenZFSConfiguration.setter(Builder::copyTagsToBackups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTagsToBackups").build()}).build();
    private static final SdkField<Boolean> COPY_TAGS_TO_VOLUMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CopyTagsToVolumes").getter(UpdateFileSystemOpenZFSConfiguration.getter(UpdateFileSystemOpenZFSConfiguration::copyTagsToVolumes)).setter(UpdateFileSystemOpenZFSConfiguration.setter(Builder::copyTagsToVolumes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTagsToVolumes").build()}).build();
    private static final SdkField<String> DAILY_AUTOMATIC_BACKUP_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DailyAutomaticBackupStartTime").getter(UpdateFileSystemOpenZFSConfiguration.getter(UpdateFileSystemOpenZFSConfiguration::dailyAutomaticBackupStartTime)).setter(UpdateFileSystemOpenZFSConfiguration.setter(Builder::dailyAutomaticBackupStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DailyAutomaticBackupStartTime").build()}).build();
    private static final SdkField<Integer> THROUGHPUT_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ThroughputCapacity").getter(UpdateFileSystemOpenZFSConfiguration.getter(UpdateFileSystemOpenZFSConfiguration::throughputCapacity)).setter(UpdateFileSystemOpenZFSConfiguration.setter(Builder::throughputCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThroughputCapacity").build()}).build();
    private static final SdkField<String> WEEKLY_MAINTENANCE_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WeeklyMaintenanceStartTime").getter(UpdateFileSystemOpenZFSConfiguration.getter(UpdateFileSystemOpenZFSConfiguration::weeklyMaintenanceStartTime)).setter(UpdateFileSystemOpenZFSConfiguration.setter(Builder::weeklyMaintenanceStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WeeklyMaintenanceStartTime").build()}).build();
    private static final SdkField<DiskIopsConfiguration> DISK_IOPS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DiskIopsConfiguration").getter(UpdateFileSystemOpenZFSConfiguration.getter(UpdateFileSystemOpenZFSConfiguration::diskIopsConfiguration)).setter(UpdateFileSystemOpenZFSConfiguration.setter(Builder::diskIopsConfiguration)).constructor(DiskIopsConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiskIopsConfiguration").build()}).build();
    private static final SdkField<List<String>> ADD_ROUTE_TABLE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AddRouteTableIds").getter(UpdateFileSystemOpenZFSConfiguration.getter(UpdateFileSystemOpenZFSConfiguration::addRouteTableIds)).setter(UpdateFileSystemOpenZFSConfiguration.setter(Builder::addRouteTableIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddRouteTableIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> REMOVE_ROUTE_TABLE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RemoveRouteTableIds").getter(UpdateFileSystemOpenZFSConfiguration.getter(UpdateFileSystemOpenZFSConfiguration::removeRouteTableIds)).setter(UpdateFileSystemOpenZFSConfiguration.setter(Builder::removeRouteTableIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveRouteTableIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<OpenZFSReadCacheConfiguration> READ_CACHE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ReadCacheConfiguration").getter(UpdateFileSystemOpenZFSConfiguration.getter(UpdateFileSystemOpenZFSConfiguration::readCacheConfiguration)).setter(UpdateFileSystemOpenZFSConfiguration.setter(Builder::readCacheConfiguration)).constructor(OpenZFSReadCacheConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadCacheConfiguration").build()}).build();
    private static final SdkField<String> ENDPOINT_IPV6_ADDRESS_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointIpv6AddressRange").getter(UpdateFileSystemOpenZFSConfiguration.getter(UpdateFileSystemOpenZFSConfiguration::endpointIpv6AddressRange)).setter(UpdateFileSystemOpenZFSConfiguration.setter(Builder::endpointIpv6AddressRange)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointIpv6AddressRange").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTOMATIC_BACKUP_RETENTION_DAYS_FIELD, COPY_TAGS_TO_BACKUPS_FIELD, COPY_TAGS_TO_VOLUMES_FIELD, DAILY_AUTOMATIC_BACKUP_START_TIME_FIELD, THROUGHPUT_CAPACITY_FIELD, WEEKLY_MAINTENANCE_START_TIME_FIELD, DISK_IOPS_CONFIGURATION_FIELD, ADD_ROUTE_TABLE_IDS_FIELD, REMOVE_ROUTE_TABLE_IDS_FIELD, READ_CACHE_CONFIGURATION_FIELD, ENDPOINT_IPV6_ADDRESS_RANGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateFileSystemOpenZFSConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer automaticBackupRetentionDays;
    private final Boolean copyTagsToBackups;
    private final Boolean copyTagsToVolumes;
    private final String dailyAutomaticBackupStartTime;
    private final Integer throughputCapacity;
    private final String weeklyMaintenanceStartTime;
    private final DiskIopsConfiguration diskIopsConfiguration;
    private final List<String> addRouteTableIds;
    private final List<String> removeRouteTableIds;
    private final OpenZFSReadCacheConfiguration readCacheConfiguration;
    private final String endpointIpv6AddressRange;

    private UpdateFileSystemOpenZFSConfiguration(BuilderImpl builder) {
        this.automaticBackupRetentionDays = builder.automaticBackupRetentionDays;
        this.copyTagsToBackups = builder.copyTagsToBackups;
        this.copyTagsToVolumes = builder.copyTagsToVolumes;
        this.dailyAutomaticBackupStartTime = builder.dailyAutomaticBackupStartTime;
        this.throughputCapacity = builder.throughputCapacity;
        this.weeklyMaintenanceStartTime = builder.weeklyMaintenanceStartTime;
        this.diskIopsConfiguration = builder.diskIopsConfiguration;
        this.addRouteTableIds = builder.addRouteTableIds;
        this.removeRouteTableIds = builder.removeRouteTableIds;
        this.readCacheConfiguration = builder.readCacheConfiguration;
        this.endpointIpv6AddressRange = builder.endpointIpv6AddressRange;
    }

    public final Integer automaticBackupRetentionDays() {
        return this.automaticBackupRetentionDays;
    }

    public final Boolean copyTagsToBackups() {
        return this.copyTagsToBackups;
    }

    public final Boolean copyTagsToVolumes() {
        return this.copyTagsToVolumes;
    }

    public final String dailyAutomaticBackupStartTime() {
        return this.dailyAutomaticBackupStartTime;
    }

    public final Integer throughputCapacity() {
        return this.throughputCapacity;
    }

    public final String weeklyMaintenanceStartTime() {
        return this.weeklyMaintenanceStartTime;
    }

    public final DiskIopsConfiguration diskIopsConfiguration() {
        return this.diskIopsConfiguration;
    }

    public final boolean hasAddRouteTableIds() {
        return this.addRouteTableIds != null && !(this.addRouteTableIds instanceof SdkAutoConstructList);
    }

    public final List<String> addRouteTableIds() {
        return this.addRouteTableIds;
    }

    public final boolean hasRemoveRouteTableIds() {
        return this.removeRouteTableIds != null && !(this.removeRouteTableIds instanceof SdkAutoConstructList);
    }

    public final List<String> removeRouteTableIds() {
        return this.removeRouteTableIds;
    }

    public final OpenZFSReadCacheConfiguration readCacheConfiguration() {
        return this.readCacheConfiguration;
    }

    public final String endpointIpv6AddressRange() {
        return this.endpointIpv6AddressRange;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.automaticBackupRetentionDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.copyTagsToBackups());
        hashCode = 31 * hashCode + Objects.hashCode(this.copyTagsToVolumes());
        hashCode = 31 * hashCode + Objects.hashCode(this.dailyAutomaticBackupStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.throughputCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.weeklyMaintenanceStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.diskIopsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAddRouteTableIds() ? this.addRouteTableIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRemoveRouteTableIds() ? this.removeRouteTableIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.readCacheConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointIpv6AddressRange());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFileSystemOpenZFSConfiguration)) {
            return false;
        }
        UpdateFileSystemOpenZFSConfiguration other = (UpdateFileSystemOpenZFSConfiguration)obj;
        return Objects.equals(this.automaticBackupRetentionDays(), other.automaticBackupRetentionDays()) && Objects.equals(this.copyTagsToBackups(), other.copyTagsToBackups()) && Objects.equals(this.copyTagsToVolumes(), other.copyTagsToVolumes()) && Objects.equals(this.dailyAutomaticBackupStartTime(), other.dailyAutomaticBackupStartTime()) && Objects.equals(this.throughputCapacity(), other.throughputCapacity()) && Objects.equals(this.weeklyMaintenanceStartTime(), other.weeklyMaintenanceStartTime()) && Objects.equals(this.diskIopsConfiguration(), other.diskIopsConfiguration()) && this.hasAddRouteTableIds() == other.hasAddRouteTableIds() && Objects.equals(this.addRouteTableIds(), other.addRouteTableIds()) && this.hasRemoveRouteTableIds() == other.hasRemoveRouteTableIds() && Objects.equals(this.removeRouteTableIds(), other.removeRouteTableIds()) && Objects.equals(this.readCacheConfiguration(), other.readCacheConfiguration()) && Objects.equals(this.endpointIpv6AddressRange(), other.endpointIpv6AddressRange());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateFileSystemOpenZFSConfiguration").add("AutomaticBackupRetentionDays", (Object)this.automaticBackupRetentionDays()).add("CopyTagsToBackups", (Object)this.copyTagsToBackups()).add("CopyTagsToVolumes", (Object)this.copyTagsToVolumes()).add("DailyAutomaticBackupStartTime", (Object)this.dailyAutomaticBackupStartTime()).add("ThroughputCapacity", (Object)this.throughputCapacity()).add("WeeklyMaintenanceStartTime", (Object)this.weeklyMaintenanceStartTime()).add("DiskIopsConfiguration", (Object)this.diskIopsConfiguration()).add("AddRouteTableIds", this.hasAddRouteTableIds() ? this.addRouteTableIds() : null).add("RemoveRouteTableIds", this.hasRemoveRouteTableIds() ? this.removeRouteTableIds() : null).add("ReadCacheConfiguration", (Object)this.readCacheConfiguration()).add("EndpointIpv6AddressRange", (Object)this.endpointIpv6AddressRange()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutomaticBackupRetentionDays": {
                return Optional.ofNullable(clazz.cast(this.automaticBackupRetentionDays()));
            }
            case "CopyTagsToBackups": {
                return Optional.ofNullable(clazz.cast(this.copyTagsToBackups()));
            }
            case "CopyTagsToVolumes": {
                return Optional.ofNullable(clazz.cast(this.copyTagsToVolumes()));
            }
            case "DailyAutomaticBackupStartTime": {
                return Optional.ofNullable(clazz.cast(this.dailyAutomaticBackupStartTime()));
            }
            case "ThroughputCapacity": {
                return Optional.ofNullable(clazz.cast(this.throughputCapacity()));
            }
            case "WeeklyMaintenanceStartTime": {
                return Optional.ofNullable(clazz.cast(this.weeklyMaintenanceStartTime()));
            }
            case "DiskIopsConfiguration": {
                return Optional.ofNullable(clazz.cast(this.diskIopsConfiguration()));
            }
            case "AddRouteTableIds": {
                return Optional.ofNullable(clazz.cast(this.addRouteTableIds()));
            }
            case "RemoveRouteTableIds": {
                return Optional.ofNullable(clazz.cast(this.removeRouteTableIds()));
            }
            case "ReadCacheConfiguration": {
                return Optional.ofNullable(clazz.cast(this.readCacheConfiguration()));
            }
            case "EndpointIpv6AddressRange": {
                return Optional.ofNullable(clazz.cast(this.endpointIpv6AddressRange()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AutomaticBackupRetentionDays", AUTOMATIC_BACKUP_RETENTION_DAYS_FIELD);
        map.put("CopyTagsToBackups", COPY_TAGS_TO_BACKUPS_FIELD);
        map.put("CopyTagsToVolumes", COPY_TAGS_TO_VOLUMES_FIELD);
        map.put("DailyAutomaticBackupStartTime", DAILY_AUTOMATIC_BACKUP_START_TIME_FIELD);
        map.put("ThroughputCapacity", THROUGHPUT_CAPACITY_FIELD);
        map.put("WeeklyMaintenanceStartTime", WEEKLY_MAINTENANCE_START_TIME_FIELD);
        map.put("DiskIopsConfiguration", DISK_IOPS_CONFIGURATION_FIELD);
        map.put("AddRouteTableIds", ADD_ROUTE_TABLE_IDS_FIELD);
        map.put("RemoveRouteTableIds", REMOVE_ROUTE_TABLE_IDS_FIELD);
        map.put("ReadCacheConfiguration", READ_CACHE_CONFIGURATION_FIELD);
        map.put("EndpointIpv6AddressRange", ENDPOINT_IPV6_ADDRESS_RANGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateFileSystemOpenZFSConfiguration, T> g) {
        return obj -> g.apply((UpdateFileSystemOpenZFSConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer automaticBackupRetentionDays;
        private Boolean copyTagsToBackups;
        private Boolean copyTagsToVolumes;
        private String dailyAutomaticBackupStartTime;
        private Integer throughputCapacity;
        private String weeklyMaintenanceStartTime;
        private DiskIopsConfiguration diskIopsConfiguration;
        private List<String> addRouteTableIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> removeRouteTableIds = DefaultSdkAutoConstructList.getInstance();
        private OpenZFSReadCacheConfiguration readCacheConfiguration;
        private String endpointIpv6AddressRange;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFileSystemOpenZFSConfiguration model) {
            this.automaticBackupRetentionDays(model.automaticBackupRetentionDays);
            this.copyTagsToBackups(model.copyTagsToBackups);
            this.copyTagsToVolumes(model.copyTagsToVolumes);
            this.dailyAutomaticBackupStartTime(model.dailyAutomaticBackupStartTime);
            this.throughputCapacity(model.throughputCapacity);
            this.weeklyMaintenanceStartTime(model.weeklyMaintenanceStartTime);
            this.diskIopsConfiguration(model.diskIopsConfiguration);
            this.addRouteTableIds(model.addRouteTableIds);
            this.removeRouteTableIds(model.removeRouteTableIds);
            this.readCacheConfiguration(model.readCacheConfiguration);
            this.endpointIpv6AddressRange(model.endpointIpv6AddressRange);
        }

        public final Integer getAutomaticBackupRetentionDays() {
            return this.automaticBackupRetentionDays;
        }

        public final void setAutomaticBackupRetentionDays(Integer automaticBackupRetentionDays) {
            this.automaticBackupRetentionDays = automaticBackupRetentionDays;
        }

        @Override
        public final Builder automaticBackupRetentionDays(Integer automaticBackupRetentionDays) {
            this.automaticBackupRetentionDays = automaticBackupRetentionDays;
            return this;
        }

        public final Boolean getCopyTagsToBackups() {
            return this.copyTagsToBackups;
        }

        public final void setCopyTagsToBackups(Boolean copyTagsToBackups) {
            this.copyTagsToBackups = copyTagsToBackups;
        }

        @Override
        public final Builder copyTagsToBackups(Boolean copyTagsToBackups) {
            this.copyTagsToBackups = copyTagsToBackups;
            return this;
        }

        public final Boolean getCopyTagsToVolumes() {
            return this.copyTagsToVolumes;
        }

        public final void setCopyTagsToVolumes(Boolean copyTagsToVolumes) {
            this.copyTagsToVolumes = copyTagsToVolumes;
        }

        @Override
        public final Builder copyTagsToVolumes(Boolean copyTagsToVolumes) {
            this.copyTagsToVolumes = copyTagsToVolumes;
            return this;
        }

        public final String getDailyAutomaticBackupStartTime() {
            return this.dailyAutomaticBackupStartTime;
        }

        public final void setDailyAutomaticBackupStartTime(String dailyAutomaticBackupStartTime) {
            this.dailyAutomaticBackupStartTime = dailyAutomaticBackupStartTime;
        }

        @Override
        public final Builder dailyAutomaticBackupStartTime(String dailyAutomaticBackupStartTime) {
            this.dailyAutomaticBackupStartTime = dailyAutomaticBackupStartTime;
            return this;
        }

        public final Integer getThroughputCapacity() {
            return this.throughputCapacity;
        }

        public final void setThroughputCapacity(Integer throughputCapacity) {
            this.throughputCapacity = throughputCapacity;
        }

        @Override
        public final Builder throughputCapacity(Integer throughputCapacity) {
            this.throughputCapacity = throughputCapacity;
            return this;
        }

        public final String getWeeklyMaintenanceStartTime() {
            return this.weeklyMaintenanceStartTime;
        }

        public final void setWeeklyMaintenanceStartTime(String weeklyMaintenanceStartTime) {
            this.weeklyMaintenanceStartTime = weeklyMaintenanceStartTime;
        }

        @Override
        public final Builder weeklyMaintenanceStartTime(String weeklyMaintenanceStartTime) {
            this.weeklyMaintenanceStartTime = weeklyMaintenanceStartTime;
            return this;
        }

        public final DiskIopsConfiguration.Builder getDiskIopsConfiguration() {
            return this.diskIopsConfiguration != null ? this.diskIopsConfiguration.toBuilder() : null;
        }

        public final void setDiskIopsConfiguration(DiskIopsConfiguration.BuilderImpl diskIopsConfiguration) {
            this.diskIopsConfiguration = diskIopsConfiguration != null ? diskIopsConfiguration.build() : null;
        }

        @Override
        public final Builder diskIopsConfiguration(DiskIopsConfiguration diskIopsConfiguration) {
            this.diskIopsConfiguration = diskIopsConfiguration;
            return this;
        }

        public final Collection<String> getAddRouteTableIds() {
            if (this.addRouteTableIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.addRouteTableIds;
        }

        public final void setAddRouteTableIds(Collection<String> addRouteTableIds) {
            this.addRouteTableIds = RouteTableIdsCopier.copy(addRouteTableIds);
        }

        @Override
        public final Builder addRouteTableIds(Collection<String> addRouteTableIds) {
            this.addRouteTableIds = RouteTableIdsCopier.copy(addRouteTableIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addRouteTableIds(String ... addRouteTableIds) {
            this.addRouteTableIds(Arrays.asList(addRouteTableIds));
            return this;
        }

        public final Collection<String> getRemoveRouteTableIds() {
            if (this.removeRouteTableIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.removeRouteTableIds;
        }

        public final void setRemoveRouteTableIds(Collection<String> removeRouteTableIds) {
            this.removeRouteTableIds = RouteTableIdsCopier.copy(removeRouteTableIds);
        }

        @Override
        public final Builder removeRouteTableIds(Collection<String> removeRouteTableIds) {
            this.removeRouteTableIds = RouteTableIdsCopier.copy(removeRouteTableIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeRouteTableIds(String ... removeRouteTableIds) {
            this.removeRouteTableIds(Arrays.asList(removeRouteTableIds));
            return this;
        }

        public final OpenZFSReadCacheConfiguration.Builder getReadCacheConfiguration() {
            return this.readCacheConfiguration != null ? this.readCacheConfiguration.toBuilder() : null;
        }

        public final void setReadCacheConfiguration(OpenZFSReadCacheConfiguration.BuilderImpl readCacheConfiguration) {
            this.readCacheConfiguration = readCacheConfiguration != null ? readCacheConfiguration.build() : null;
        }

        @Override
        public final Builder readCacheConfiguration(OpenZFSReadCacheConfiguration readCacheConfiguration) {
            this.readCacheConfiguration = readCacheConfiguration;
            return this;
        }

        public final String getEndpointIpv6AddressRange() {
            return this.endpointIpv6AddressRange;
        }

        public final void setEndpointIpv6AddressRange(String endpointIpv6AddressRange) {
            this.endpointIpv6AddressRange = endpointIpv6AddressRange;
        }

        @Override
        public final Builder endpointIpv6AddressRange(String endpointIpv6AddressRange) {
            this.endpointIpv6AddressRange = endpointIpv6AddressRange;
            return this;
        }

        public UpdateFileSystemOpenZFSConfiguration build() {
            return new UpdateFileSystemOpenZFSConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UpdateFileSystemOpenZFSConfiguration> {
        public Builder automaticBackupRetentionDays(Integer var1);

        public Builder copyTagsToBackups(Boolean var1);

        public Builder copyTagsToVolumes(Boolean var1);

        public Builder dailyAutomaticBackupStartTime(String var1);

        public Builder throughputCapacity(Integer var1);

        public Builder weeklyMaintenanceStartTime(String var1);

        public Builder diskIopsConfiguration(DiskIopsConfiguration var1);

        default public Builder diskIopsConfiguration(Consumer<DiskIopsConfiguration.Builder> diskIopsConfiguration) {
            return this.diskIopsConfiguration((DiskIopsConfiguration)((DiskIopsConfiguration.Builder)DiskIopsConfiguration.builder().applyMutation(diskIopsConfiguration)).build());
        }

        public Builder addRouteTableIds(Collection<String> var1);

        public Builder addRouteTableIds(String ... var1);

        public Builder removeRouteTableIds(Collection<String> var1);

        public Builder removeRouteTableIds(String ... var1);

        public Builder readCacheConfiguration(OpenZFSReadCacheConfiguration var1);

        default public Builder readCacheConfiguration(Consumer<OpenZFSReadCacheConfiguration.Builder> readCacheConfiguration) {
            return this.readCacheConfiguration((OpenZFSReadCacheConfiguration)((OpenZFSReadCacheConfiguration.Builder)OpenZFSReadCacheConfiguration.builder().applyMutation(readCacheConfiguration)).build());
        }

        public Builder endpointIpv6AddressRange(String var1);
    }
}

