/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for the Amazon File Cache resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FileCacheLustreConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<FileCacheLustreConfiguration.Builder, FileCacheLustreConfiguration> {
    private static final SdkField<Integer> PER_UNIT_STORAGE_THROUGHPUT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("PerUnitStorageThroughput")
            .getter(getter(FileCacheLustreConfiguration::perUnitStorageThroughput))
            .setter(setter(Builder::perUnitStorageThroughput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerUnitStorageThroughput").build())
            .build();

    private static final SdkField<String> DEPLOYMENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeploymentType").getter(getter(FileCacheLustreConfiguration::deploymentTypeAsString))
            .setter(setter(Builder::deploymentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentType").build()).build();

    private static final SdkField<String> MOUNT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MountName").getter(getter(FileCacheLustreConfiguration::mountName)).setter(setter(Builder::mountName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MountName").build()).build();

    private static final SdkField<String> WEEKLY_MAINTENANCE_START_TIME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("WeeklyMaintenanceStartTime")
            .getter(getter(FileCacheLustreConfiguration::weeklyMaintenanceStartTime))
            .setter(setter(Builder::weeklyMaintenanceStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WeeklyMaintenanceStartTime").build())
            .build();

    private static final SdkField<FileCacheLustreMetadataConfiguration> METADATA_CONFIGURATION_FIELD = SdkField
            .<FileCacheLustreMetadataConfiguration> builder(MarshallingType.SDK_POJO).memberName("MetadataConfiguration")
            .getter(getter(FileCacheLustreConfiguration::metadataConfiguration)).setter(setter(Builder::metadataConfiguration))
            .constructor(FileCacheLustreMetadataConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataConfiguration").build())
            .build();

    private static final SdkField<LustreLogConfiguration> LOG_CONFIGURATION_FIELD = SdkField
            .<LustreLogConfiguration> builder(MarshallingType.SDK_POJO).memberName("LogConfiguration")
            .getter(getter(FileCacheLustreConfiguration::logConfiguration)).setter(setter(Builder::logConfiguration))
            .constructor(LustreLogConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PER_UNIT_STORAGE_THROUGHPUT_FIELD, DEPLOYMENT_TYPE_FIELD, MOUNT_NAME_FIELD, WEEKLY_MAINTENANCE_START_TIME_FIELD,
            METADATA_CONFIGURATION_FIELD, LOG_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer perUnitStorageThroughput;

    private final String deploymentType;

    private final String mountName;

    private final String weeklyMaintenanceStartTime;

    private final FileCacheLustreMetadataConfiguration metadataConfiguration;

    private final LustreLogConfiguration logConfiguration;

    private FileCacheLustreConfiguration(BuilderImpl builder) {
        this.perUnitStorageThroughput = builder.perUnitStorageThroughput;
        this.deploymentType = builder.deploymentType;
        this.mountName = builder.mountName;
        this.weeklyMaintenanceStartTime = builder.weeklyMaintenanceStartTime;
        this.metadataConfiguration = builder.metadataConfiguration;
        this.logConfiguration = builder.logConfiguration;
    }

    /**
     * <p>
     * Per unit storage throughput represents the megabytes per second of read or write throughput per 1 tebibyte of
     * storage provisioned. Cache throughput capacity is equal to Storage capacity (TiB) * PerUnitStorageThroughput
     * (MB/s/TiB). The only supported value is <code>1000</code>.
     * </p>
     * 
     * @return Per unit storage throughput represents the megabytes per second of read or write throughput per 1
     *         tebibyte of storage provisioned. Cache throughput capacity is equal to Storage capacity (TiB) *
     *         PerUnitStorageThroughput (MB/s/TiB). The only supported value is <code>1000</code>.
     */
    public final Integer perUnitStorageThroughput() {
        return perUnitStorageThroughput;
    }

    /**
     * <p>
     * The deployment type of the Amazon File Cache resource, which must be <code>CACHE_1</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentType}
     * will return {@link FileCacheLustreDeploymentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #deploymentTypeAsString}.
     * </p>
     * 
     * @return The deployment type of the Amazon File Cache resource, which must be <code>CACHE_1</code>.
     * @see FileCacheLustreDeploymentType
     */
    public final FileCacheLustreDeploymentType deploymentType() {
        return FileCacheLustreDeploymentType.fromValue(deploymentType);
    }

    /**
     * <p>
     * The deployment type of the Amazon File Cache resource, which must be <code>CACHE_1</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentType}
     * will return {@link FileCacheLustreDeploymentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #deploymentTypeAsString}.
     * </p>
     * 
     * @return The deployment type of the Amazon File Cache resource, which must be <code>CACHE_1</code>.
     * @see FileCacheLustreDeploymentType
     */
    public final String deploymentTypeAsString() {
        return deploymentType;
    }

    /**
     * <p>
     * You use the <code>MountName</code> value when mounting the cache. If you pass a cache ID to the
     * <code>DescribeFileCaches</code> operation, it returns the the <code>MountName</code> value as part of the cache's
     * description.
     * </p>
     * 
     * @return You use the <code>MountName</code> value when mounting the cache. If you pass a cache ID to the
     *         <code>DescribeFileCaches</code> operation, it returns the the <code>MountName</code> value as part of the
     *         cache's description.
     */
    public final String mountName() {
        return mountName;
    }

    /**
     * Returns the value of the WeeklyMaintenanceStartTime property for this object.
     * 
     * @return The value of the WeeklyMaintenanceStartTime property for this object.
     */
    public final String weeklyMaintenanceStartTime() {
        return weeklyMaintenanceStartTime;
    }

    /**
     * <p>
     * The configuration for a Lustre MDT (Metadata Target) storage volume.
     * </p>
     * 
     * @return The configuration for a Lustre MDT (Metadata Target) storage volume.
     */
    public final FileCacheLustreMetadataConfiguration metadataConfiguration() {
        return metadataConfiguration;
    }

    /**
     * <p>
     * The configuration for Lustre logging used to write the enabled logging events for your Amazon File Cache resource
     * to Amazon CloudWatch Logs.
     * </p>
     * 
     * @return The configuration for Lustre logging used to write the enabled logging events for your Amazon File Cache
     *         resource to Amazon CloudWatch Logs.
     */
    public final LustreLogConfiguration logConfiguration() {
        return logConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(perUnitStorageThroughput());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(mountName());
        hashCode = 31 * hashCode + Objects.hashCode(weeklyMaintenanceStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(metadataConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(logConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileCacheLustreConfiguration)) {
            return false;
        }
        FileCacheLustreConfiguration other = (FileCacheLustreConfiguration) obj;
        return Objects.equals(perUnitStorageThroughput(), other.perUnitStorageThroughput())
                && Objects.equals(deploymentTypeAsString(), other.deploymentTypeAsString())
                && Objects.equals(mountName(), other.mountName())
                && Objects.equals(weeklyMaintenanceStartTime(), other.weeklyMaintenanceStartTime())
                && Objects.equals(metadataConfiguration(), other.metadataConfiguration())
                && Objects.equals(logConfiguration(), other.logConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FileCacheLustreConfiguration").add("PerUnitStorageThroughput", perUnitStorageThroughput())
                .add("DeploymentType", deploymentTypeAsString()).add("MountName", mountName())
                .add("WeeklyMaintenanceStartTime", weeklyMaintenanceStartTime())
                .add("MetadataConfiguration", metadataConfiguration()).add("LogConfiguration", logConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PerUnitStorageThroughput":
            return Optional.ofNullable(clazz.cast(perUnitStorageThroughput()));
        case "DeploymentType":
            return Optional.ofNullable(clazz.cast(deploymentTypeAsString()));
        case "MountName":
            return Optional.ofNullable(clazz.cast(mountName()));
        case "WeeklyMaintenanceStartTime":
            return Optional.ofNullable(clazz.cast(weeklyMaintenanceStartTime()));
        case "MetadataConfiguration":
            return Optional.ofNullable(clazz.cast(metadataConfiguration()));
        case "LogConfiguration":
            return Optional.ofNullable(clazz.cast(logConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PerUnitStorageThroughput", PER_UNIT_STORAGE_THROUGHPUT_FIELD);
        map.put("DeploymentType", DEPLOYMENT_TYPE_FIELD);
        map.put("MountName", MOUNT_NAME_FIELD);
        map.put("WeeklyMaintenanceStartTime", WEEKLY_MAINTENANCE_START_TIME_FIELD);
        map.put("MetadataConfiguration", METADATA_CONFIGURATION_FIELD);
        map.put("LogConfiguration", LOG_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FileCacheLustreConfiguration, T> g) {
        return obj -> g.apply((FileCacheLustreConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FileCacheLustreConfiguration> {
        /**
         * <p>
         * Per unit storage throughput represents the megabytes per second of read or write throughput per 1 tebibyte of
         * storage provisioned. Cache throughput capacity is equal to Storage capacity (TiB) * PerUnitStorageThroughput
         * (MB/s/TiB). The only supported value is <code>1000</code>.
         * </p>
         * 
         * @param perUnitStorageThroughput
         *        Per unit storage throughput represents the megabytes per second of read or write throughput per 1
         *        tebibyte of storage provisioned. Cache throughput capacity is equal to Storage capacity (TiB) *
         *        PerUnitStorageThroughput (MB/s/TiB). The only supported value is <code>1000</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder perUnitStorageThroughput(Integer perUnitStorageThroughput);

        /**
         * <p>
         * The deployment type of the Amazon File Cache resource, which must be <code>CACHE_1</code>.
         * </p>
         * 
         * @param deploymentType
         *        The deployment type of the Amazon File Cache resource, which must be <code>CACHE_1</code>.
         * @see FileCacheLustreDeploymentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileCacheLustreDeploymentType
         */
        Builder deploymentType(String deploymentType);

        /**
         * <p>
         * The deployment type of the Amazon File Cache resource, which must be <code>CACHE_1</code>.
         * </p>
         * 
         * @param deploymentType
         *        The deployment type of the Amazon File Cache resource, which must be <code>CACHE_1</code>.
         * @see FileCacheLustreDeploymentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileCacheLustreDeploymentType
         */
        Builder deploymentType(FileCacheLustreDeploymentType deploymentType);

        /**
         * <p>
         * You use the <code>MountName</code> value when mounting the cache. If you pass a cache ID to the
         * <code>DescribeFileCaches</code> operation, it returns the the <code>MountName</code> value as part of the
         * cache's description.
         * </p>
         * 
         * @param mountName
         *        You use the <code>MountName</code> value when mounting the cache. If you pass a cache ID to the
         *        <code>DescribeFileCaches</code> operation, it returns the the <code>MountName</code> value as part of
         *        the cache's description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mountName(String mountName);

        /**
         * Sets the value of the WeeklyMaintenanceStartTime property for this object.
         *
         * @param weeklyMaintenanceStartTime
         *        The new value for the WeeklyMaintenanceStartTime property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder weeklyMaintenanceStartTime(String weeklyMaintenanceStartTime);

        /**
         * <p>
         * The configuration for a Lustre MDT (Metadata Target) storage volume.
         * </p>
         * 
         * @param metadataConfiguration
         *        The configuration for a Lustre MDT (Metadata Target) storage volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataConfiguration(FileCacheLustreMetadataConfiguration metadataConfiguration);

        /**
         * <p>
         * The configuration for a Lustre MDT (Metadata Target) storage volume.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link FileCacheLustreMetadataConfiguration.Builder} avoiding the need to create one manually via
         * {@link FileCacheLustreMetadataConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FileCacheLustreMetadataConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #metadataConfiguration(FileCacheLustreMetadataConfiguration)}.
         * 
         * @param metadataConfiguration
         *        a consumer that will call methods on {@link FileCacheLustreMetadataConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadataConfiguration(FileCacheLustreMetadataConfiguration)
         */
        default Builder metadataConfiguration(Consumer<FileCacheLustreMetadataConfiguration.Builder> metadataConfiguration) {
            return metadataConfiguration(FileCacheLustreMetadataConfiguration.builder().applyMutation(metadataConfiguration)
                    .build());
        }

        /**
         * <p>
         * The configuration for Lustre logging used to write the enabled logging events for your Amazon File Cache
         * resource to Amazon CloudWatch Logs.
         * </p>
         * 
         * @param logConfiguration
         *        The configuration for Lustre logging used to write the enabled logging events for your Amazon File
         *        Cache resource to Amazon CloudWatch Logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logConfiguration(LustreLogConfiguration logConfiguration);

        /**
         * <p>
         * The configuration for Lustre logging used to write the enabled logging events for your Amazon File Cache
         * resource to Amazon CloudWatch Logs.
         * </p>
         * This is a convenience method that creates an instance of the {@link LustreLogConfiguration.Builder} avoiding
         * the need to create one manually via {@link LustreLogConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LustreLogConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #logConfiguration(LustreLogConfiguration)}.
         * 
         * @param logConfiguration
         *        a consumer that will call methods on {@link LustreLogConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logConfiguration(LustreLogConfiguration)
         */
        default Builder logConfiguration(Consumer<LustreLogConfiguration.Builder> logConfiguration) {
            return logConfiguration(LustreLogConfiguration.builder().applyMutation(logConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Integer perUnitStorageThroughput;

        private String deploymentType;

        private String mountName;

        private String weeklyMaintenanceStartTime;

        private FileCacheLustreMetadataConfiguration metadataConfiguration;

        private LustreLogConfiguration logConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(FileCacheLustreConfiguration model) {
            perUnitStorageThroughput(model.perUnitStorageThroughput);
            deploymentType(model.deploymentType);
            mountName(model.mountName);
            weeklyMaintenanceStartTime(model.weeklyMaintenanceStartTime);
            metadataConfiguration(model.metadataConfiguration);
            logConfiguration(model.logConfiguration);
        }

        public final Integer getPerUnitStorageThroughput() {
            return perUnitStorageThroughput;
        }

        public final void setPerUnitStorageThroughput(Integer perUnitStorageThroughput) {
            this.perUnitStorageThroughput = perUnitStorageThroughput;
        }

        @Override
        public final Builder perUnitStorageThroughput(Integer perUnitStorageThroughput) {
            this.perUnitStorageThroughput = perUnitStorageThroughput;
            return this;
        }

        public final String getDeploymentType() {
            return deploymentType;
        }

        public final void setDeploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
        }

        @Override
        public final Builder deploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
            return this;
        }

        @Override
        public final Builder deploymentType(FileCacheLustreDeploymentType deploymentType) {
            this.deploymentType(deploymentType == null ? null : deploymentType.toString());
            return this;
        }

        public final String getMountName() {
            return mountName;
        }

        public final void setMountName(String mountName) {
            this.mountName = mountName;
        }

        @Override
        public final Builder mountName(String mountName) {
            this.mountName = mountName;
            return this;
        }

        public final String getWeeklyMaintenanceStartTime() {
            return weeklyMaintenanceStartTime;
        }

        public final void setWeeklyMaintenanceStartTime(String weeklyMaintenanceStartTime) {
            this.weeklyMaintenanceStartTime = weeklyMaintenanceStartTime;
        }

        @Override
        public final Builder weeklyMaintenanceStartTime(String weeklyMaintenanceStartTime) {
            this.weeklyMaintenanceStartTime = weeklyMaintenanceStartTime;
            return this;
        }

        public final FileCacheLustreMetadataConfiguration.Builder getMetadataConfiguration() {
            return metadataConfiguration != null ? metadataConfiguration.toBuilder() : null;
        }

        public final void setMetadataConfiguration(FileCacheLustreMetadataConfiguration.BuilderImpl metadataConfiguration) {
            this.metadataConfiguration = metadataConfiguration != null ? metadataConfiguration.build() : null;
        }

        @Override
        public final Builder metadataConfiguration(FileCacheLustreMetadataConfiguration metadataConfiguration) {
            this.metadataConfiguration = metadataConfiguration;
            return this;
        }

        public final LustreLogConfiguration.Builder getLogConfiguration() {
            return logConfiguration != null ? logConfiguration.toBuilder() : null;
        }

        public final void setLogConfiguration(LustreLogConfiguration.BuilderImpl logConfiguration) {
            this.logConfiguration = logConfiguration != null ? logConfiguration.build() : null;
        }

        @Override
        public final Builder logConfiguration(LustreLogConfiguration logConfiguration) {
            this.logConfiguration = logConfiguration;
            return this;
        }

        @Override
        public FileCacheLustreConfiguration build() {
            return new FileCacheLustreConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
