/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An S3 access point attached to an Amazon FSx volume.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3AccessPointAttachment implements SdkPojo, Serializable,
        ToCopyableBuilder<S3AccessPointAttachment.Builder, S3AccessPointAttachment> {
    private static final SdkField<String> LIFECYCLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Lifecycle").getter(getter(S3AccessPointAttachment::lifecycleAsString))
            .setter(setter(Builder::lifecycle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lifecycle").build()).build();

    private static final SdkField<LifecycleTransitionReason> LIFECYCLE_TRANSITION_REASON_FIELD = SdkField
            .<LifecycleTransitionReason> builder(MarshallingType.SDK_POJO).memberName("LifecycleTransitionReason")
            .getter(getter(S3AccessPointAttachment::lifecycleTransitionReason))
            .setter(setter(Builder::lifecycleTransitionReason)).constructor(LifecycleTransitionReason::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifecycleTransitionReason").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(S3AccessPointAttachment::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(S3AccessPointAttachment::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(S3AccessPointAttachment::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<S3AccessPointOpenZFSConfiguration> OPEN_ZFS_CONFIGURATION_FIELD = SdkField
            .<S3AccessPointOpenZFSConfiguration> builder(MarshallingType.SDK_POJO).memberName("OpenZFSConfiguration")
            .getter(getter(S3AccessPointAttachment::openZFSConfiguration)).setter(setter(Builder::openZFSConfiguration))
            .constructor(S3AccessPointOpenZFSConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpenZFSConfiguration").build())
            .build();

    private static final SdkField<S3AccessPoint> S3_ACCESS_POINT_FIELD = SdkField
            .<S3AccessPoint> builder(MarshallingType.SDK_POJO).memberName("S3AccessPoint")
            .getter(getter(S3AccessPointAttachment::s3AccessPoint)).setter(setter(Builder::s3AccessPoint))
            .constructor(S3AccessPoint::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3AccessPoint").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIFECYCLE_FIELD,
            LIFECYCLE_TRANSITION_REASON_FIELD, CREATION_TIME_FIELD, NAME_FIELD, TYPE_FIELD, OPEN_ZFS_CONFIGURATION_FIELD,
            S3_ACCESS_POINT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String lifecycle;

    private final LifecycleTransitionReason lifecycleTransitionReason;

    private final Instant creationTime;

    private final String name;

    private final String type;

    private final S3AccessPointOpenZFSConfiguration openZFSConfiguration;

    private final S3AccessPoint s3AccessPoint;

    private S3AccessPointAttachment(BuilderImpl builder) {
        this.lifecycle = builder.lifecycle;
        this.lifecycleTransitionReason = builder.lifecycleTransitionReason;
        this.creationTime = builder.creationTime;
        this.name = builder.name;
        this.type = builder.type;
        this.openZFSConfiguration = builder.openZFSConfiguration;
        this.s3AccessPoint = builder.s3AccessPoint;
    }

    /**
     * <p>
     * The lifecycle status of the S3 access point attachment. The lifecycle can have the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * AVAILABLE - the S3 access point attachment is available for use
     * </p>
     * </li>
     * <li>
     * <p>
     * CREATING - Amazon FSx is creating the S3 access point and attachment
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETING - Amazon FSx is deleting the S3 access point and attachment
     * </p>
     * </li>
     * <li>
     * <p>
     * FAILED - The S3 access point attachment is in a failed state. Delete and detach the S3 access point attachment,
     * and create a new one.
     * </p>
     * </li>
     * <li>
     * <p>
     * UPDATING - Amazon FSx is updating the S3 access point attachment
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lifecycle} will
     * return {@link S3AccessPointAttachmentLifecycle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #lifecycleAsString}.
     * </p>
     * 
     * @return The lifecycle status of the S3 access point attachment. The lifecycle can have the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         AVAILABLE - the S3 access point attachment is available for use
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CREATING - Amazon FSx is creating the S3 access point and attachment
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELETING - Amazon FSx is deleting the S3 access point and attachment
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FAILED - The S3 access point attachment is in a failed state. Delete and detach the S3 access point
     *         attachment, and create a new one.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UPDATING - Amazon FSx is updating the S3 access point attachment
     *         </p>
     *         </li>
     * @see S3AccessPointAttachmentLifecycle
     */
    public final S3AccessPointAttachmentLifecycle lifecycle() {
        return S3AccessPointAttachmentLifecycle.fromValue(lifecycle);
    }

    /**
     * <p>
     * The lifecycle status of the S3 access point attachment. The lifecycle can have the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * AVAILABLE - the S3 access point attachment is available for use
     * </p>
     * </li>
     * <li>
     * <p>
     * CREATING - Amazon FSx is creating the S3 access point and attachment
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETING - Amazon FSx is deleting the S3 access point and attachment
     * </p>
     * </li>
     * <li>
     * <p>
     * FAILED - The S3 access point attachment is in a failed state. Delete and detach the S3 access point attachment,
     * and create a new one.
     * </p>
     * </li>
     * <li>
     * <p>
     * UPDATING - Amazon FSx is updating the S3 access point attachment
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lifecycle} will
     * return {@link S3AccessPointAttachmentLifecycle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #lifecycleAsString}.
     * </p>
     * 
     * @return The lifecycle status of the S3 access point attachment. The lifecycle can have the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         AVAILABLE - the S3 access point attachment is available for use
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CREATING - Amazon FSx is creating the S3 access point and attachment
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELETING - Amazon FSx is deleting the S3 access point and attachment
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FAILED - The S3 access point attachment is in a failed state. Delete and detach the S3 access point
     *         attachment, and create a new one.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UPDATING - Amazon FSx is updating the S3 access point attachment
     *         </p>
     *         </li>
     * @see S3AccessPointAttachmentLifecycle
     */
    public final String lifecycleAsString() {
        return lifecycle;
    }

    /**
     * Returns the value of the LifecycleTransitionReason property for this object.
     * 
     * @return The value of the LifecycleTransitionReason property for this object.
     */
    public final LifecycleTransitionReason lifecycleTransitionReason() {
        return lifecycleTransitionReason;
    }

    /**
     * Returns the value of the CreationTime property for this object.
     * 
     * @return The value of the CreationTime property for this object.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The name of the S3 access point attachment; also used for the name of the S3 access point.
     * </p>
     * 
     * @return The name of the S3 access point attachment; also used for the name of the S3 access point.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The type of Amazon FSx volume that the S3 access point is attached to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link S3AccessPointAttachmentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return The type of Amazon FSx volume that the S3 access point is attached to.
     * @see S3AccessPointAttachmentType
     */
    public final S3AccessPointAttachmentType type() {
        return S3AccessPointAttachmentType.fromValue(type);
    }

    /**
     * <p>
     * The type of Amazon FSx volume that the S3 access point is attached to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link S3AccessPointAttachmentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return The type of Amazon FSx volume that the S3 access point is attached to.
     * @see S3AccessPointAttachmentType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The OpenZFSConfiguration of the S3 access point attachment.
     * </p>
     * 
     * @return The OpenZFSConfiguration of the S3 access point attachment.
     */
    public final S3AccessPointOpenZFSConfiguration openZFSConfiguration() {
        return openZFSConfiguration;
    }

    /**
     * <p>
     * The S3 access point configuration of the S3 access point attachment.
     * </p>
     * 
     * @return The S3 access point configuration of the S3 access point attachment.
     */
    public final S3AccessPoint s3AccessPoint() {
        return s3AccessPoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleTransitionReason());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(openZFSConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(s3AccessPoint());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3AccessPointAttachment)) {
            return false;
        }
        S3AccessPointAttachment other = (S3AccessPointAttachment) obj;
        return Objects.equals(lifecycleAsString(), other.lifecycleAsString())
                && Objects.equals(lifecycleTransitionReason(), other.lifecycleTransitionReason())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(name(), other.name())
                && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(openZFSConfiguration(), other.openZFSConfiguration())
                && Objects.equals(s3AccessPoint(), other.s3AccessPoint());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3AccessPointAttachment").add("Lifecycle", lifecycleAsString())
                .add("LifecycleTransitionReason", lifecycleTransitionReason()).add("CreationTime", creationTime())
                .add("Name", name()).add("Type", typeAsString()).add("OpenZFSConfiguration", openZFSConfiguration())
                .add("S3AccessPoint", s3AccessPoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Lifecycle":
            return Optional.ofNullable(clazz.cast(lifecycleAsString()));
        case "LifecycleTransitionReason":
            return Optional.ofNullable(clazz.cast(lifecycleTransitionReason()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "OpenZFSConfiguration":
            return Optional.ofNullable(clazz.cast(openZFSConfiguration()));
        case "S3AccessPoint":
            return Optional.ofNullable(clazz.cast(s3AccessPoint()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Lifecycle", LIFECYCLE_FIELD);
        map.put("LifecycleTransitionReason", LIFECYCLE_TRANSITION_REASON_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("OpenZFSConfiguration", OPEN_ZFS_CONFIGURATION_FIELD);
        map.put("S3AccessPoint", S3_ACCESS_POINT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3AccessPointAttachment, T> g) {
        return obj -> g.apply((S3AccessPointAttachment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3AccessPointAttachment> {
        /**
         * <p>
         * The lifecycle status of the S3 access point attachment. The lifecycle can have the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * AVAILABLE - the S3 access point attachment is available for use
         * </p>
         * </li>
         * <li>
         * <p>
         * CREATING - Amazon FSx is creating the S3 access point and attachment
         * </p>
         * </li>
         * <li>
         * <p>
         * DELETING - Amazon FSx is deleting the S3 access point and attachment
         * </p>
         * </li>
         * <li>
         * <p>
         * FAILED - The S3 access point attachment is in a failed state. Delete and detach the S3 access point
         * attachment, and create a new one.
         * </p>
         * </li>
         * <li>
         * <p>
         * UPDATING - Amazon FSx is updating the S3 access point attachment
         * </p>
         * </li>
         * </ul>
         * 
         * @param lifecycle
         *        The lifecycle status of the S3 access point attachment. The lifecycle can have the following
         *        values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        AVAILABLE - the S3 access point attachment is available for use
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CREATING - Amazon FSx is creating the S3 access point and attachment
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELETING - Amazon FSx is deleting the S3 access point and attachment
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FAILED - The S3 access point attachment is in a failed state. Delete and detach the S3 access point
         *        attachment, and create a new one.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UPDATING - Amazon FSx is updating the S3 access point attachment
         *        </p>
         *        </li>
         * @see S3AccessPointAttachmentLifecycle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see S3AccessPointAttachmentLifecycle
         */
        Builder lifecycle(String lifecycle);

        /**
         * <p>
         * The lifecycle status of the S3 access point attachment. The lifecycle can have the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * AVAILABLE - the S3 access point attachment is available for use
         * </p>
         * </li>
         * <li>
         * <p>
         * CREATING - Amazon FSx is creating the S3 access point and attachment
         * </p>
         * </li>
         * <li>
         * <p>
         * DELETING - Amazon FSx is deleting the S3 access point and attachment
         * </p>
         * </li>
         * <li>
         * <p>
         * FAILED - The S3 access point attachment is in a failed state. Delete and detach the S3 access point
         * attachment, and create a new one.
         * </p>
         * </li>
         * <li>
         * <p>
         * UPDATING - Amazon FSx is updating the S3 access point attachment
         * </p>
         * </li>
         * </ul>
         * 
         * @param lifecycle
         *        The lifecycle status of the S3 access point attachment. The lifecycle can have the following
         *        values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        AVAILABLE - the S3 access point attachment is available for use
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CREATING - Amazon FSx is creating the S3 access point and attachment
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELETING - Amazon FSx is deleting the S3 access point and attachment
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FAILED - The S3 access point attachment is in a failed state. Delete and detach the S3 access point
         *        attachment, and create a new one.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UPDATING - Amazon FSx is updating the S3 access point attachment
         *        </p>
         *        </li>
         * @see S3AccessPointAttachmentLifecycle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see S3AccessPointAttachmentLifecycle
         */
        Builder lifecycle(S3AccessPointAttachmentLifecycle lifecycle);

        /**
         * Sets the value of the LifecycleTransitionReason property for this object.
         *
         * @param lifecycleTransitionReason
         *        The new value for the LifecycleTransitionReason property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleTransitionReason(LifecycleTransitionReason lifecycleTransitionReason);

        /**
         * Sets the value of the LifecycleTransitionReason property for this object.
         *
         * This is a convenience method that creates an instance of the {@link LifecycleTransitionReason.Builder}
         * avoiding the need to create one manually via {@link LifecycleTransitionReason#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LifecycleTransitionReason.Builder#build()} is called immediately
         * and its result is passed to {@link #lifecycleTransitionReason(LifecycleTransitionReason)}.
         * 
         * @param lifecycleTransitionReason
         *        a consumer that will call methods on {@link LifecycleTransitionReason.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lifecycleTransitionReason(LifecycleTransitionReason)
         */
        default Builder lifecycleTransitionReason(Consumer<LifecycleTransitionReason.Builder> lifecycleTransitionReason) {
            return lifecycleTransitionReason(LifecycleTransitionReason.builder().applyMutation(lifecycleTransitionReason).build());
        }

        /**
         * Sets the value of the CreationTime property for this object.
         *
         * @param creationTime
         *        The new value for the CreationTime property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The name of the S3 access point attachment; also used for the name of the S3 access point.
         * </p>
         * 
         * @param name
         *        The name of the S3 access point attachment; also used for the name of the S3 access point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of Amazon FSx volume that the S3 access point is attached to.
         * </p>
         * 
         * @param type
         *        The type of Amazon FSx volume that the S3 access point is attached to.
         * @see S3AccessPointAttachmentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see S3AccessPointAttachmentType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of Amazon FSx volume that the S3 access point is attached to.
         * </p>
         * 
         * @param type
         *        The type of Amazon FSx volume that the S3 access point is attached to.
         * @see S3AccessPointAttachmentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see S3AccessPointAttachmentType
         */
        Builder type(S3AccessPointAttachmentType type);

        /**
         * <p>
         * The OpenZFSConfiguration of the S3 access point attachment.
         * </p>
         * 
         * @param openZFSConfiguration
         *        The OpenZFSConfiguration of the S3 access point attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openZFSConfiguration(S3AccessPointOpenZFSConfiguration openZFSConfiguration);

        /**
         * <p>
         * The OpenZFSConfiguration of the S3 access point attachment.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link S3AccessPointOpenZFSConfiguration.Builder} avoiding the need to create one manually via
         * {@link S3AccessPointOpenZFSConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3AccessPointOpenZFSConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #openZFSConfiguration(S3AccessPointOpenZFSConfiguration)}.
         * 
         * @param openZFSConfiguration
         *        a consumer that will call methods on {@link S3AccessPointOpenZFSConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #openZFSConfiguration(S3AccessPointOpenZFSConfiguration)
         */
        default Builder openZFSConfiguration(Consumer<S3AccessPointOpenZFSConfiguration.Builder> openZFSConfiguration) {
            return openZFSConfiguration(S3AccessPointOpenZFSConfiguration.builder().applyMutation(openZFSConfiguration).build());
        }

        /**
         * <p>
         * The S3 access point configuration of the S3 access point attachment.
         * </p>
         * 
         * @param s3AccessPoint
         *        The S3 access point configuration of the S3 access point attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3AccessPoint(S3AccessPoint s3AccessPoint);

        /**
         * <p>
         * The S3 access point configuration of the S3 access point attachment.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3AccessPoint.Builder} avoiding the need
         * to create one manually via {@link S3AccessPoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3AccessPoint.Builder#build()} is called immediately and its
         * result is passed to {@link #s3AccessPoint(S3AccessPoint)}.
         * 
         * @param s3AccessPoint
         *        a consumer that will call methods on {@link S3AccessPoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3AccessPoint(S3AccessPoint)
         */
        default Builder s3AccessPoint(Consumer<S3AccessPoint.Builder> s3AccessPoint) {
            return s3AccessPoint(S3AccessPoint.builder().applyMutation(s3AccessPoint).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String lifecycle;

        private LifecycleTransitionReason lifecycleTransitionReason;

        private Instant creationTime;

        private String name;

        private String type;

        private S3AccessPointOpenZFSConfiguration openZFSConfiguration;

        private S3AccessPoint s3AccessPoint;

        private BuilderImpl() {
        }

        private BuilderImpl(S3AccessPointAttachment model) {
            lifecycle(model.lifecycle);
            lifecycleTransitionReason(model.lifecycleTransitionReason);
            creationTime(model.creationTime);
            name(model.name);
            type(model.type);
            openZFSConfiguration(model.openZFSConfiguration);
            s3AccessPoint(model.s3AccessPoint);
        }

        public final String getLifecycle() {
            return lifecycle;
        }

        public final void setLifecycle(String lifecycle) {
            this.lifecycle = lifecycle;
        }

        @Override
        public final Builder lifecycle(String lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        @Override
        public final Builder lifecycle(S3AccessPointAttachmentLifecycle lifecycle) {
            this.lifecycle(lifecycle == null ? null : lifecycle.toString());
            return this;
        }

        public final LifecycleTransitionReason.Builder getLifecycleTransitionReason() {
            return lifecycleTransitionReason != null ? lifecycleTransitionReason.toBuilder() : null;
        }

        public final void setLifecycleTransitionReason(LifecycleTransitionReason.BuilderImpl lifecycleTransitionReason) {
            this.lifecycleTransitionReason = lifecycleTransitionReason != null ? lifecycleTransitionReason.build() : null;
        }

        @Override
        public final Builder lifecycleTransitionReason(LifecycleTransitionReason lifecycleTransitionReason) {
            this.lifecycleTransitionReason = lifecycleTransitionReason;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(S3AccessPointAttachmentType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final S3AccessPointOpenZFSConfiguration.Builder getOpenZFSConfiguration() {
            return openZFSConfiguration != null ? openZFSConfiguration.toBuilder() : null;
        }

        public final void setOpenZFSConfiguration(S3AccessPointOpenZFSConfiguration.BuilderImpl openZFSConfiguration) {
            this.openZFSConfiguration = openZFSConfiguration != null ? openZFSConfiguration.build() : null;
        }

        @Override
        public final Builder openZFSConfiguration(S3AccessPointOpenZFSConfiguration openZFSConfiguration) {
            this.openZFSConfiguration = openZFSConfiguration;
            return this;
        }

        public final S3AccessPoint.Builder getS3AccessPoint() {
            return s3AccessPoint != null ? s3AccessPoint.toBuilder() : null;
        }

        public final void setS3AccessPoint(S3AccessPoint.BuilderImpl s3AccessPoint) {
            this.s3AccessPoint = s3AccessPoint != null ? s3AccessPoint.build() : null;
        }

        @Override
        public final Builder s3AccessPoint(S3AccessPoint s3AccessPoint) {
            this.s3AccessPoint = s3AccessPoint;
            return this;
        }

        @Override
        public S3AccessPointAttachment build() {
            return new S3AccessPointAttachment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
