/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateFileCacheRequest extends FSxRequest implements
        ToCopyableBuilder<UpdateFileCacheRequest.Builder, UpdateFileCacheRequest> {
    private static final SdkField<String> FILE_CACHE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileCacheId").getter(getter(UpdateFileCacheRequest::fileCacheId)).setter(setter(Builder::fileCacheId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileCacheId").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken")
            .getter(getter(UpdateFileCacheRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<UpdateFileCacheLustreConfiguration> LUSTRE_CONFIGURATION_FIELD = SdkField
            .<UpdateFileCacheLustreConfiguration> builder(MarshallingType.SDK_POJO).memberName("LustreConfiguration")
            .getter(getter(UpdateFileCacheRequest::lustreConfiguration)).setter(setter(Builder::lustreConfiguration))
            .constructor(UpdateFileCacheLustreConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LustreConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_CACHE_ID_FIELD,
            CLIENT_REQUEST_TOKEN_FIELD, LUSTRE_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String fileCacheId;

    private final String clientRequestToken;

    private final UpdateFileCacheLustreConfiguration lustreConfiguration;

    private UpdateFileCacheRequest(BuilderImpl builder) {
        super(builder);
        this.fileCacheId = builder.fileCacheId;
        this.clientRequestToken = builder.clientRequestToken;
        this.lustreConfiguration = builder.lustreConfiguration;
    }

    /**
     * <p>
     * The ID of the cache that you are updating.
     * </p>
     * 
     * @return The ID of the cache that you are updating.
     */
    public final String fileCacheId() {
        return fileCacheId;
    }

    /**
     * Returns the value of the ClientRequestToken property for this object.
     * 
     * @return The value of the ClientRequestToken property for this object.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * The configuration updates for an Amazon File Cache resource.
     * </p>
     * 
     * @return The configuration updates for an Amazon File Cache resource.
     */
    public final UpdateFileCacheLustreConfiguration lustreConfiguration() {
        return lustreConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fileCacheId());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(lustreConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFileCacheRequest)) {
            return false;
        }
        UpdateFileCacheRequest other = (UpdateFileCacheRequest) obj;
        return Objects.equals(fileCacheId(), other.fileCacheId())
                && Objects.equals(clientRequestToken(), other.clientRequestToken())
                && Objects.equals(lustreConfiguration(), other.lustreConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateFileCacheRequest").add("FileCacheId", fileCacheId())
                .add("ClientRequestToken", clientRequestToken()).add("LustreConfiguration", lustreConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FileCacheId":
            return Optional.ofNullable(clazz.cast(fileCacheId()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "LustreConfiguration":
            return Optional.ofNullable(clazz.cast(lustreConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FileCacheId", FILE_CACHE_ID_FIELD);
        map.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("LustreConfiguration", LUSTRE_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateFileCacheRequest, T> g) {
        return obj -> g.apply((UpdateFileCacheRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends FSxRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateFileCacheRequest> {
        /**
         * <p>
         * The ID of the cache that you are updating.
         * </p>
         * 
         * @param fileCacheId
         *        The ID of the cache that you are updating.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileCacheId(String fileCacheId);

        /**
         * Sets the value of the ClientRequestToken property for this object.
         *
         * @param clientRequestToken
         *        The new value for the ClientRequestToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * The configuration updates for an Amazon File Cache resource.
         * </p>
         * 
         * @param lustreConfiguration
         *        The configuration updates for an Amazon File Cache resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lustreConfiguration(UpdateFileCacheLustreConfiguration lustreConfiguration);

        /**
         * <p>
         * The configuration updates for an Amazon File Cache resource.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link UpdateFileCacheLustreConfiguration.Builder} avoiding the need to create one manually via
         * {@link UpdateFileCacheLustreConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateFileCacheLustreConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #lustreConfiguration(UpdateFileCacheLustreConfiguration)}.
         * 
         * @param lustreConfiguration
         *        a consumer that will call methods on {@link UpdateFileCacheLustreConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lustreConfiguration(UpdateFileCacheLustreConfiguration)
         */
        default Builder lustreConfiguration(Consumer<UpdateFileCacheLustreConfiguration.Builder> lustreConfiguration) {
            return lustreConfiguration(UpdateFileCacheLustreConfiguration.builder().applyMutation(lustreConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FSxRequest.BuilderImpl implements Builder {
        private String fileCacheId;

        private String clientRequestToken;

        private UpdateFileCacheLustreConfiguration lustreConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFileCacheRequest model) {
            super(model);
            fileCacheId(model.fileCacheId);
            clientRequestToken(model.clientRequestToken);
            lustreConfiguration(model.lustreConfiguration);
        }

        public final String getFileCacheId() {
            return fileCacheId;
        }

        public final void setFileCacheId(String fileCacheId) {
            this.fileCacheId = fileCacheId;
        }

        @Override
        public final Builder fileCacheId(String fileCacheId) {
            this.fileCacheId = fileCacheId;
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final UpdateFileCacheLustreConfiguration.Builder getLustreConfiguration() {
            return lustreConfiguration != null ? lustreConfiguration.toBuilder() : null;
        }

        public final void setLustreConfiguration(UpdateFileCacheLustreConfiguration.BuilderImpl lustreConfiguration) {
            this.lustreConfiguration = lustreConfiguration != null ? lustreConfiguration.build() : null;
        }

        @Override
        public final Builder lustreConfiguration(UpdateFileCacheLustreConfiguration lustreConfiguration) {
            this.lustreConfiguration = lustreConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFileCacheRequest build() {
            return new UpdateFileCacheRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
