/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the returned data in response to a request action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAliasResponse extends GameLiftResponse implements
        ToCopyableBuilder<DescribeAliasResponse.Builder, DescribeAliasResponse> {
    private static final SdkField<Alias> ALIAS_FIELD = SdkField.<Alias> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeAliasResponse::alias)).setter(setter(Builder::alias)).constructor(Alias::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Alias").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALIAS_FIELD));

    private final Alias alias;

    private DescribeAliasResponse(BuilderImpl builder) {
        super(builder);
        this.alias = builder.alias;
    }

    /**
     * <p>
     * The requested alias resource.
     * </p>
     * 
     * @return The requested alias resource.
     */
    public Alias alias() {
        return alias;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(alias());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAliasResponse)) {
            return false;
        }
        DescribeAliasResponse other = (DescribeAliasResponse) obj;
        return Objects.equals(alias(), other.alias());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeAliasResponse").add("Alias", alias()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Alias":
            return Optional.ofNullable(clazz.cast(alias()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAliasResponse, T> g) {
        return obj -> g.apply((DescribeAliasResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeAliasResponse> {
        /**
         * <p>
         * The requested alias resource.
         * </p>
         * 
         * @param alias
         *        The requested alias resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alias(Alias alias);

        /**
         * <p>
         * The requested alias resource.
         * </p>
         * This is a convenience that creates an instance of the {@link Alias.Builder} avoiding the need to create one
         * manually via {@link Alias#builder()}.
         *
         * When the {@link Consumer} completes, {@link Alias.Builder#build()} is called immediately and its result is
         * passed to {@link #alias(Alias)}.
         * 
         * @param alias
         *        a consumer that will call methods on {@link Alias.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #alias(Alias)
         */
        default Builder alias(Consumer<Alias.Builder> alias) {
            return alias(Alias.builder().applyMutation(alias).build());
        }
    }

    static final class BuilderImpl extends GameLiftResponse.BuilderImpl implements Builder {
        private Alias alias;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAliasResponse model) {
            super(model);
            alias(model.alias);
        }

        public final Alias.Builder getAlias() {
            return alias != null ? alias.toBuilder() : null;
        }

        @Override
        public final Builder alias(Alias alias) {
            this.alias = alias;
            return this;
        }

        public final void setAlias(Alias.BuilderImpl alias) {
            this.alias = alias != null ? alias.build() : null;
        }

        @Override
        public DescribeAliasResponse build() {
            return new DescribeAliasResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
