/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the returned data in response to a request action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RequestUploadCredentialsResponse extends GameLiftResponse implements
        ToCopyableBuilder<RequestUploadCredentialsResponse.Builder, RequestUploadCredentialsResponse> {
    private static final SdkField<Credentials> UPLOAD_CREDENTIALS_FIELD = SdkField
            .<Credentials> builder(MarshallingType.SDK_POJO).getter(getter(RequestUploadCredentialsResponse::uploadCredentials))
            .setter(setter(Builder::uploadCredentials)).constructor(Credentials::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UploadCredentials").build()).build();

    private static final SdkField<S3Location> STORAGE_LOCATION_FIELD = SdkField.<S3Location> builder(MarshallingType.SDK_POJO)
            .getter(getter(RequestUploadCredentialsResponse::storageLocation)).setter(setter(Builder::storageLocation))
            .constructor(S3Location::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageLocation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UPLOAD_CREDENTIALS_FIELD,
            STORAGE_LOCATION_FIELD));

    private final Credentials uploadCredentials;

    private final S3Location storageLocation;

    private RequestUploadCredentialsResponse(BuilderImpl builder) {
        super(builder);
        this.uploadCredentials = builder.uploadCredentials;
        this.storageLocation = builder.storageLocation;
    }

    /**
     * <p>
     * AWS credentials required when uploading a game build to the storage location. These credentials have a limited
     * lifespan and are valid only for the build they were issued for.
     * </p>
     * 
     * @return AWS credentials required when uploading a game build to the storage location. These credentials have a
     *         limited lifespan and are valid only for the build they were issued for.
     */
    public Credentials uploadCredentials() {
        return uploadCredentials;
    }

    /**
     * <p>
     * Amazon S3 path and key, identifying where the game build files are stored.
     * </p>
     * 
     * @return Amazon S3 path and key, identifying where the game build files are stored.
     */
    public S3Location storageLocation() {
        return storageLocation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(uploadCredentials());
        hashCode = 31 * hashCode + Objects.hashCode(storageLocation());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequestUploadCredentialsResponse)) {
            return false;
        }
        RequestUploadCredentialsResponse other = (RequestUploadCredentialsResponse) obj;
        return Objects.equals(uploadCredentials(), other.uploadCredentials())
                && Objects.equals(storageLocation(), other.storageLocation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RequestUploadCredentialsResponse")
                .add("UploadCredentials", uploadCredentials() == null ? null : "*** Sensitive Data Redacted ***")
                .add("StorageLocation", storageLocation()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UploadCredentials":
            return Optional.ofNullable(clazz.cast(uploadCredentials()));
        case "StorageLocation":
            return Optional.ofNullable(clazz.cast(storageLocation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RequestUploadCredentialsResponse, T> g) {
        return obj -> g.apply((RequestUploadCredentialsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, RequestUploadCredentialsResponse> {
        /**
         * <p>
         * AWS credentials required when uploading a game build to the storage location. These credentials have a
         * limited lifespan and are valid only for the build they were issued for.
         * </p>
         * 
         * @param uploadCredentials
         *        AWS credentials required when uploading a game build to the storage location. These credentials have a
         *        limited lifespan and are valid only for the build they were issued for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uploadCredentials(Credentials uploadCredentials);

        /**
         * <p>
         * AWS credentials required when uploading a game build to the storage location. These credentials have a
         * limited lifespan and are valid only for the build they were issued for.
         * </p>
         * This is a convenience that creates an instance of the {@link Credentials.Builder} avoiding the need to create
         * one manually via {@link Credentials#builder()}.
         *
         * When the {@link Consumer} completes, {@link Credentials.Builder#build()} is called immediately and its result
         * is passed to {@link #uploadCredentials(Credentials)}.
         * 
         * @param uploadCredentials
         *        a consumer that will call methods on {@link Credentials.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #uploadCredentials(Credentials)
         */
        default Builder uploadCredentials(Consumer<Credentials.Builder> uploadCredentials) {
            return uploadCredentials(Credentials.builder().applyMutation(uploadCredentials).build());
        }

        /**
         * <p>
         * Amazon S3 path and key, identifying where the game build files are stored.
         * </p>
         * 
         * @param storageLocation
         *        Amazon S3 path and key, identifying where the game build files are stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageLocation(S3Location storageLocation);

        /**
         * <p>
         * Amazon S3 path and key, identifying where the game build files are stored.
         * </p>
         * This is a convenience that creates an instance of the {@link S3Location.Builder} avoiding the need to create
         * one manually via {@link S3Location#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3Location.Builder#build()} is called immediately and its result
         * is passed to {@link #storageLocation(S3Location)}.
         * 
         * @param storageLocation
         *        a consumer that will call methods on {@link S3Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storageLocation(S3Location)
         */
        default Builder storageLocation(Consumer<S3Location.Builder> storageLocation) {
            return storageLocation(S3Location.builder().applyMutation(storageLocation).build());
        }
    }

    static final class BuilderImpl extends GameLiftResponse.BuilderImpl implements Builder {
        private Credentials uploadCredentials;

        private S3Location storageLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(RequestUploadCredentialsResponse model) {
            super(model);
            uploadCredentials(model.uploadCredentials);
            storageLocation(model.storageLocation);
        }

        public final Credentials.Builder getUploadCredentials() {
            return uploadCredentials != null ? uploadCredentials.toBuilder() : null;
        }

        @Override
        public final Builder uploadCredentials(Credentials uploadCredentials) {
            this.uploadCredentials = uploadCredentials;
            return this;
        }

        public final void setUploadCredentials(Credentials.BuilderImpl uploadCredentials) {
            this.uploadCredentials = uploadCredentials != null ? uploadCredentials.build() : null;
        }

        public final S3Location.Builder getStorageLocation() {
            return storageLocation != null ? storageLocation.toBuilder() : null;
        }

        @Override
        public final Builder storageLocation(S3Location storageLocation) {
            this.storageLocation = storageLocation;
            return this;
        }

        public final void setStorageLocation(S3Location.BuilderImpl storageLocation) {
            this.storageLocation = storageLocation != null ? storageLocation.build() : null;
        }

        @Override
        public RequestUploadCredentialsResponse build() {
            return new RequestUploadCredentialsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
