/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A policy that limits the number of game sessions a player can create on the same fleet. This optional policy gives
 * game owners control over how players can consume available game server resources. A resource creation policy makes
 * the following statement:
 * "An individual player can create a maximum number of new game sessions within a specified time period".
 * </p>
 * <p>
 * The policy is evaluated when a player tries to create a new game session. For example: Assume you have a policy of 10
 * new game sessions and a time period of 60 minutes. On receiving a <code>CreateGameSession</code> request, Amazon
 * GameLift checks that the player (identified by <code>CreatorId</code>) has created fewer than 10 game sessions in the
 * past 60 minutes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceCreationLimitPolicy implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceCreationLimitPolicy.Builder, ResourceCreationLimitPolicy> {
    private static final SdkField<Integer> NEW_GAME_SESSIONS_PER_CREATOR_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).getter(getter(ResourceCreationLimitPolicy::newGameSessionsPerCreator))
            .setter(setter(Builder::newGameSessionsPerCreator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewGameSessionsPerCreator").build())
            .build();

    private static final SdkField<Integer> POLICY_PERIOD_IN_MINUTES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ResourceCreationLimitPolicy::policyPeriodInMinutes)).setter(setter(Builder::policyPeriodInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyPeriodInMinutes").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            NEW_GAME_SESSIONS_PER_CREATOR_FIELD, POLICY_PERIOD_IN_MINUTES_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer newGameSessionsPerCreator;

    private final Integer policyPeriodInMinutes;

    private ResourceCreationLimitPolicy(BuilderImpl builder) {
        this.newGameSessionsPerCreator = builder.newGameSessionsPerCreator;
        this.policyPeriodInMinutes = builder.policyPeriodInMinutes;
    }

    /**
     * <p>
     * The maximum number of game sessions that an individual can create during the policy period.
     * </p>
     * 
     * @return The maximum number of game sessions that an individual can create during the policy period.
     */
    public Integer newGameSessionsPerCreator() {
        return newGameSessionsPerCreator;
    }

    /**
     * <p>
     * The time span used in evaluating the resource creation limit policy.
     * </p>
     * 
     * @return The time span used in evaluating the resource creation limit policy.
     */
    public Integer policyPeriodInMinutes() {
        return policyPeriodInMinutes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(newGameSessionsPerCreator());
        hashCode = 31 * hashCode + Objects.hashCode(policyPeriodInMinutes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceCreationLimitPolicy)) {
            return false;
        }
        ResourceCreationLimitPolicy other = (ResourceCreationLimitPolicy) obj;
        return Objects.equals(newGameSessionsPerCreator(), other.newGameSessionsPerCreator())
                && Objects.equals(policyPeriodInMinutes(), other.policyPeriodInMinutes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ResourceCreationLimitPolicy").add("NewGameSessionsPerCreator", newGameSessionsPerCreator())
                .add("PolicyPeriodInMinutes", policyPeriodInMinutes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NewGameSessionsPerCreator":
            return Optional.ofNullable(clazz.cast(newGameSessionsPerCreator()));
        case "PolicyPeriodInMinutes":
            return Optional.ofNullable(clazz.cast(policyPeriodInMinutes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceCreationLimitPolicy, T> g) {
        return obj -> g.apply((ResourceCreationLimitPolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceCreationLimitPolicy> {
        /**
         * <p>
         * The maximum number of game sessions that an individual can create during the policy period.
         * </p>
         * 
         * @param newGameSessionsPerCreator
         *        The maximum number of game sessions that an individual can create during the policy period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newGameSessionsPerCreator(Integer newGameSessionsPerCreator);

        /**
         * <p>
         * The time span used in evaluating the resource creation limit policy.
         * </p>
         * 
         * @param policyPeriodInMinutes
         *        The time span used in evaluating the resource creation limit policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyPeriodInMinutes(Integer policyPeriodInMinutes);
    }

    static final class BuilderImpl implements Builder {
        private Integer newGameSessionsPerCreator;

        private Integer policyPeriodInMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceCreationLimitPolicy model) {
            newGameSessionsPerCreator(model.newGameSessionsPerCreator);
            policyPeriodInMinutes(model.policyPeriodInMinutes);
        }

        public final Integer getNewGameSessionsPerCreator() {
            return newGameSessionsPerCreator;
        }

        @Override
        public final Builder newGameSessionsPerCreator(Integer newGameSessionsPerCreator) {
            this.newGameSessionsPerCreator = newGameSessionsPerCreator;
            return this;
        }

        public final void setNewGameSessionsPerCreator(Integer newGameSessionsPerCreator) {
            this.newGameSessionsPerCreator = newGameSessionsPerCreator;
        }

        public final Integer getPolicyPeriodInMinutes() {
            return policyPeriodInMinutes;
        }

        @Override
        public final Builder policyPeriodInMinutes(Integer policyPeriodInMinutes) {
            this.policyPeriodInMinutes = policyPeriodInMinutes;
            return this;
        }

        public final void setPolicyPeriodInMinutes(Integer policyPeriodInMinutes) {
            this.policyPeriodInMinutes = policyPeriodInMinutes;
        }

        @Override
        public ResourceCreationLimitPolicy build() {
            return new ResourceCreationLimitPolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
