/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the returned data in response to a request action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateGameSessionQueueResponse extends GameLiftResponse implements
        ToCopyableBuilder<UpdateGameSessionQueueResponse.Builder, UpdateGameSessionQueueResponse> {
    private static final SdkField<GameSessionQueue> GAME_SESSION_QUEUE_FIELD = SdkField
            .<GameSessionQueue> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateGameSessionQueueResponse::gameSessionQueue)).setter(setter(Builder::gameSessionQueue))
            .constructor(GameSessionQueue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameSessionQueue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GAME_SESSION_QUEUE_FIELD));

    private final GameSessionQueue gameSessionQueue;

    private UpdateGameSessionQueueResponse(BuilderImpl builder) {
        super(builder);
        this.gameSessionQueue = builder.gameSessionQueue;
    }

    /**
     * <p>
     * An object that describes the newly updated game session queue.
     * </p>
     * 
     * @return An object that describes the newly updated game session queue.
     */
    public GameSessionQueue gameSessionQueue() {
        return gameSessionQueue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gameSessionQueue());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGameSessionQueueResponse)) {
            return false;
        }
        UpdateGameSessionQueueResponse other = (UpdateGameSessionQueueResponse) obj;
        return Objects.equals(gameSessionQueue(), other.gameSessionQueue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateGameSessionQueueResponse").add("GameSessionQueue", gameSessionQueue()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GameSessionQueue":
            return Optional.ofNullable(clazz.cast(gameSessionQueue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateGameSessionQueueResponse, T> g) {
        return obj -> g.apply((UpdateGameSessionQueueResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateGameSessionQueueResponse> {
        /**
         * <p>
         * An object that describes the newly updated game session queue.
         * </p>
         * 
         * @param gameSessionQueue
         *        An object that describes the newly updated game session queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameSessionQueue(GameSessionQueue gameSessionQueue);

        /**
         * <p>
         * An object that describes the newly updated game session queue.
         * </p>
         * This is a convenience that creates an instance of the {@link GameSessionQueue.Builder} avoiding the need to
         * create one manually via {@link GameSessionQueue#builder()}.
         *
         * When the {@link Consumer} completes, {@link GameSessionQueue.Builder#build()} is called immediately and its
         * result is passed to {@link #gameSessionQueue(GameSessionQueue)}.
         * 
         * @param gameSessionQueue
         *        a consumer that will call methods on {@link GameSessionQueue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gameSessionQueue(GameSessionQueue)
         */
        default Builder gameSessionQueue(Consumer<GameSessionQueue.Builder> gameSessionQueue) {
            return gameSessionQueue(GameSessionQueue.builder().applyMutation(gameSessionQueue).build());
        }
    }

    static final class BuilderImpl extends GameLiftResponse.BuilderImpl implements Builder {
        private GameSessionQueue gameSessionQueue;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGameSessionQueueResponse model) {
            super(model);
            gameSessionQueue(model.gameSessionQueue);
        }

        public final GameSessionQueue.Builder getGameSessionQueue() {
            return gameSessionQueue != null ? gameSessionQueue.toBuilder() : null;
        }

        @Override
        public final Builder gameSessionQueue(GameSessionQueue gameSessionQueue) {
            this.gameSessionQueue = gameSessionQueue;
            return this;
        }

        public final void setGameSessionQueue(GameSessionQueue.BuilderImpl gameSessionQueue) {
            this.gameSessionQueue = gameSessionQueue != null ? gameSessionQueue.build() : null;
        }

        @Override
        public UpdateGameSessionQueueResponse build() {
            return new UpdateGameSessionQueueResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
