/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input for a request operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateFleetRequest extends GameLiftRequest implements
        ToCopyableBuilder<CreateFleetRequest.Builder, CreateFleetRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateFleetRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateFleetRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> BUILD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BuildId").getter(getter(CreateFleetRequest::buildId)).setter(setter(Builder::buildId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BuildId").build()).build();

    private static final SdkField<String> SCRIPT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScriptId").getter(getter(CreateFleetRequest::scriptId)).setter(setter(Builder::scriptId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScriptId").build()).build();

    private static final SdkField<String> SERVER_LAUNCH_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServerLaunchPath").getter(getter(CreateFleetRequest::serverLaunchPath))
            .setter(setter(Builder::serverLaunchPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerLaunchPath").build()).build();

    private static final SdkField<String> SERVER_LAUNCH_PARAMETERS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServerLaunchParameters").getter(getter(CreateFleetRequest::serverLaunchParameters))
            .setter(setter(Builder::serverLaunchParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerLaunchParameters").build())
            .build();

    private static final SdkField<List<String>> LOG_PATHS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("LogPaths")
            .getter(getter(CreateFleetRequest::logPaths))
            .setter(setter(Builder::logPaths))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogPaths").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> EC2_INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EC2InstanceType").getter(getter(CreateFleetRequest::ec2InstanceTypeAsString))
            .setter(setter(Builder::ec2InstanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EC2InstanceType").build()).build();

    private static final SdkField<List<IpPermission>> EC2_INBOUND_PERMISSIONS_FIELD = SdkField
            .<List<IpPermission>> builder(MarshallingType.LIST)
            .memberName("EC2InboundPermissions")
            .getter(getter(CreateFleetRequest::ec2InboundPermissions))
            .setter(setter(Builder::ec2InboundPermissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EC2InboundPermissions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IpPermission> builder(MarshallingType.SDK_POJO)
                                            .constructor(IpPermission::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEW_GAME_SESSION_PROTECTION_POLICY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NewGameSessionProtectionPolicy")
            .getter(getter(CreateFleetRequest::newGameSessionProtectionPolicyAsString))
            .setter(setter(Builder::newGameSessionProtectionPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewGameSessionProtectionPolicy")
                    .build()).build();

    private static final SdkField<RuntimeConfiguration> RUNTIME_CONFIGURATION_FIELD = SdkField
            .<RuntimeConfiguration> builder(MarshallingType.SDK_POJO).memberName("RuntimeConfiguration")
            .getter(getter(CreateFleetRequest::runtimeConfiguration)).setter(setter(Builder::runtimeConfiguration))
            .constructor(RuntimeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuntimeConfiguration").build())
            .build();

    private static final SdkField<ResourceCreationLimitPolicy> RESOURCE_CREATION_LIMIT_POLICY_FIELD = SdkField
            .<ResourceCreationLimitPolicy> builder(MarshallingType.SDK_POJO)
            .memberName("ResourceCreationLimitPolicy")
            .getter(getter(CreateFleetRequest::resourceCreationLimitPolicy))
            .setter(setter(Builder::resourceCreationLimitPolicy))
            .constructor(ResourceCreationLimitPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceCreationLimitPolicy")
                    .build()).build();

    private static final SdkField<List<String>> METRIC_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("MetricGroups")
            .getter(getter(CreateFleetRequest::metricGroups))
            .setter(setter(Builder::metricGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PEER_VPC_AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PeerVpcAwsAccountId").getter(getter(CreateFleetRequest::peerVpcAwsAccountId))
            .setter(setter(Builder::peerVpcAwsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerVpcAwsAccountId").build())
            .build();

    private static final SdkField<String> PEER_VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PeerVpcId").getter(getter(CreateFleetRequest::peerVpcId)).setter(setter(Builder::peerVpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerVpcId").build()).build();

    private static final SdkField<String> FLEET_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FleetType").getter(getter(CreateFleetRequest::fleetTypeAsString)).setter(setter(Builder::fleetType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetType").build()).build();

    private static final SdkField<String> INSTANCE_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceRoleArn").getter(getter(CreateFleetRequest::instanceRoleArn))
            .setter(setter(Builder::instanceRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceRoleArn").build()).build();

    private static final SdkField<CertificateConfiguration> CERTIFICATE_CONFIGURATION_FIELD = SdkField
            .<CertificateConfiguration> builder(MarshallingType.SDK_POJO).memberName("CertificateConfiguration")
            .getter(getter(CreateFleetRequest::certificateConfiguration)).setter(setter(Builder::certificateConfiguration))
            .constructor(CertificateConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateConfiguration").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateFleetRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            BUILD_ID_FIELD, SCRIPT_ID_FIELD, SERVER_LAUNCH_PATH_FIELD, SERVER_LAUNCH_PARAMETERS_FIELD, LOG_PATHS_FIELD,
            EC2_INSTANCE_TYPE_FIELD, EC2_INBOUND_PERMISSIONS_FIELD, NEW_GAME_SESSION_PROTECTION_POLICY_FIELD,
            RUNTIME_CONFIGURATION_FIELD, RESOURCE_CREATION_LIMIT_POLICY_FIELD, METRIC_GROUPS_FIELD,
            PEER_VPC_AWS_ACCOUNT_ID_FIELD, PEER_VPC_ID_FIELD, FLEET_TYPE_FIELD, INSTANCE_ROLE_ARN_FIELD,
            CERTIFICATE_CONFIGURATION_FIELD, TAGS_FIELD));

    private final String name;

    private final String description;

    private final String buildId;

    private final String scriptId;

    private final String serverLaunchPath;

    private final String serverLaunchParameters;

    private final List<String> logPaths;

    private final String ec2InstanceType;

    private final List<IpPermission> ec2InboundPermissions;

    private final String newGameSessionProtectionPolicy;

    private final RuntimeConfiguration runtimeConfiguration;

    private final ResourceCreationLimitPolicy resourceCreationLimitPolicy;

    private final List<String> metricGroups;

    private final String peerVpcAwsAccountId;

    private final String peerVpcId;

    private final String fleetType;

    private final String instanceRoleArn;

    private final CertificateConfiguration certificateConfiguration;

    private final List<Tag> tags;

    private CreateFleetRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.buildId = builder.buildId;
        this.scriptId = builder.scriptId;
        this.serverLaunchPath = builder.serverLaunchPath;
        this.serverLaunchParameters = builder.serverLaunchParameters;
        this.logPaths = builder.logPaths;
        this.ec2InstanceType = builder.ec2InstanceType;
        this.ec2InboundPermissions = builder.ec2InboundPermissions;
        this.newGameSessionProtectionPolicy = builder.newGameSessionProtectionPolicy;
        this.runtimeConfiguration = builder.runtimeConfiguration;
        this.resourceCreationLimitPolicy = builder.resourceCreationLimitPolicy;
        this.metricGroups = builder.metricGroups;
        this.peerVpcAwsAccountId = builder.peerVpcAwsAccountId;
        this.peerVpcId = builder.peerVpcId;
        this.fleetType = builder.fleetType;
        this.instanceRoleArn = builder.instanceRoleArn;
        this.certificateConfiguration = builder.certificateConfiguration;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A descriptive label that is associated with a fleet. Fleet names do not need to be unique.
     * </p>
     * 
     * @return A descriptive label that is associated with a fleet. Fleet names do not need to be unique.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * A human-readable description of a fleet.
     * </p>
     * 
     * @return A human-readable description of a fleet.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * A unique identifier for a build to be deployed on the new fleet. You can use either the build ID or ARN value.
     * The custom game server build must have been successfully uploaded to Amazon GameLift and be in a
     * <code>READY</code> status. This fleet setting cannot be changed once the fleet is created.
     * </p>
     * 
     * @return A unique identifier for a build to be deployed on the new fleet. You can use either the build ID or ARN
     *         value. The custom game server build must have been successfully uploaded to Amazon GameLift and be in a
     *         <code>READY</code> status. This fleet setting cannot be changed once the fleet is created.
     */
    public String buildId() {
        return buildId;
    }

    /**
     * <p>
     * A unique identifier for a Realtime script to be deployed on the new fleet. You can use either the script ID or
     * ARN value. The Realtime script must have been successfully uploaded to Amazon GameLift. This fleet setting cannot
     * be changed once the fleet is created.
     * </p>
     * 
     * @return A unique identifier for a Realtime script to be deployed on the new fleet. You can use either the script
     *         ID or ARN value. The Realtime script must have been successfully uploaded to Amazon GameLift. This fleet
     *         setting cannot be changed once the fleet is created.
     */
    public String scriptId() {
        return scriptId;
    }

    /**
     * <p>
     * This parameter is no longer used. Instead, specify a server launch path using the
     * <code>RuntimeConfiguration</code> parameter. Requests that specify a server launch path and launch parameters
     * instead of a runtime configuration will continue to work.
     * </p>
     * 
     * @return This parameter is no longer used. Instead, specify a server launch path using the
     *         <code>RuntimeConfiguration</code> parameter. Requests that specify a server launch path and launch
     *         parameters instead of a runtime configuration will continue to work.
     */
    public String serverLaunchPath() {
        return serverLaunchPath;
    }

    /**
     * <p>
     * This parameter is no longer used. Instead, specify server launch parameters in the
     * <code>RuntimeConfiguration</code> parameter. (Requests that specify a server launch path and launch parameters
     * instead of a runtime configuration will continue to work.)
     * </p>
     * 
     * @return This parameter is no longer used. Instead, specify server launch parameters in the
     *         <code>RuntimeConfiguration</code> parameter. (Requests that specify a server launch path and launch
     *         parameters instead of a runtime configuration will continue to work.)
     */
    public String serverLaunchParameters() {
        return serverLaunchParameters;
    }

    /**
     * Returns true if the LogPaths property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasLogPaths() {
        return logPaths != null && !(logPaths instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * This parameter is no longer used. Instead, to specify where Amazon GameLift should store log files once a server
     * process shuts down, use the Amazon GameLift server API <code>ProcessReady()</code> and specify one or more
     * directory paths in <code>logParameters</code>. See more information in the <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api-ref.html#gamelift-sdk-server-api-ref-dataypes-process"
     * >Server API Reference</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLogPaths()} to see if a value was sent in this field.
     * </p>
     * 
     * @return This parameter is no longer used. Instead, to specify where Amazon GameLift should store log files once a
     *         server process shuts down, use the Amazon GameLift server API <code>ProcessReady()</code> and specify one
     *         or more directory paths in <code>logParameters</code>. See more information in the <a href=
     *         "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api-ref.html#gamelift-sdk-server-api-ref-dataypes-process"
     *         >Server API Reference</a>.
     */
    public List<String> logPaths() {
        return logPaths;
    }

    /**
     * <p>
     * The name of an EC2 instance type that is supported in Amazon GameLift. A fleet instance type determines the
     * computing resources of each instance in the fleet, including CPU, memory, storage, and networking capacity.
     * Amazon GameLift supports the following EC2 instance types. See <a
     * href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2 Instance Types</a> for detailed descriptions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ec2InstanceType}
     * will return {@link EC2InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #ec2InstanceTypeAsString}.
     * </p>
     * 
     * @return The name of an EC2 instance type that is supported in Amazon GameLift. A fleet instance type determines
     *         the computing resources of each instance in the fleet, including CPU, memory, storage, and networking
     *         capacity. Amazon GameLift supports the following EC2 instance types. See <a
     *         href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2 Instance Types</a> for detailed descriptions.
     * @see EC2InstanceType
     */
    public EC2InstanceType ec2InstanceType() {
        return EC2InstanceType.fromValue(ec2InstanceType);
    }

    /**
     * <p>
     * The name of an EC2 instance type that is supported in Amazon GameLift. A fleet instance type determines the
     * computing resources of each instance in the fleet, including CPU, memory, storage, and networking capacity.
     * Amazon GameLift supports the following EC2 instance types. See <a
     * href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2 Instance Types</a> for detailed descriptions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ec2InstanceType}
     * will return {@link EC2InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #ec2InstanceTypeAsString}.
     * </p>
     * 
     * @return The name of an EC2 instance type that is supported in Amazon GameLift. A fleet instance type determines
     *         the computing resources of each instance in the fleet, including CPU, memory, storage, and networking
     *         capacity. Amazon GameLift supports the following EC2 instance types. See <a
     *         href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2 Instance Types</a> for detailed descriptions.
     * @see EC2InstanceType
     */
    public String ec2InstanceTypeAsString() {
        return ec2InstanceType;
    }

    /**
     * Returns true if the EC2InboundPermissions property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasEc2InboundPermissions() {
        return ec2InboundPermissions != null && !(ec2InboundPermissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Range of IP addresses and port settings that permit inbound traffic to access game sessions that are running on
     * the fleet. For fleets using a custom game build, this parameter is required before game sessions running on the
     * fleet can accept connections. For Realtime Servers fleets, Amazon GameLift automatically sets TCP and UDP ranges
     * for use by the Realtime servers. You can specify multiple permission settings or add more by updating the fleet.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEc2InboundPermissions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Range of IP addresses and port settings that permit inbound traffic to access game sessions that are
     *         running on the fleet. For fleets using a custom game build, this parameter is required before game
     *         sessions running on the fleet can accept connections. For Realtime Servers fleets, Amazon GameLift
     *         automatically sets TCP and UDP ranges for use by the Realtime servers. You can specify multiple
     *         permission settings or add more by updating the fleet.
     */
    public List<IpPermission> ec2InboundPermissions() {
        return ec2InboundPermissions;
    }

    /**
     * <p>
     * A game session protection policy to apply to all instances in this fleet. If this parameter is not set, instances
     * in this fleet default to no protection. You can change a fleet's protection policy using
     * <a>UpdateFleetAttributes</a>, but this change will only affect sessions created after the policy change. You can
     * also set protection for individual instances using <a>UpdateGameSession</a>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>NoProtection</b> - The game session can be terminated during a scale-down event.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>FullProtection</b> - If the game session is in an <code>ACTIVE</code> status, it cannot be terminated during a
     * scale-down event.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #newGameSessionProtectionPolicy} will return {@link ProtectionPolicy#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #newGameSessionProtectionPolicyAsString}.
     * </p>
     * 
     * @return A game session protection policy to apply to all instances in this fleet. If this parameter is not set,
     *         instances in this fleet default to no protection. You can change a fleet's protection policy using
     *         <a>UpdateFleetAttributes</a>, but this change will only affect sessions created after the policy change.
     *         You can also set protection for individual instances using <a>UpdateGameSession</a>.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>NoProtection</b> - The game session can be terminated during a scale-down event.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>FullProtection</b> - If the game session is in an <code>ACTIVE</code> status, it cannot be terminated
     *         during a scale-down event.
     *         </p>
     *         </li>
     * @see ProtectionPolicy
     */
    public ProtectionPolicy newGameSessionProtectionPolicy() {
        return ProtectionPolicy.fromValue(newGameSessionProtectionPolicy);
    }

    /**
     * <p>
     * A game session protection policy to apply to all instances in this fleet. If this parameter is not set, instances
     * in this fleet default to no protection. You can change a fleet's protection policy using
     * <a>UpdateFleetAttributes</a>, but this change will only affect sessions created after the policy change. You can
     * also set protection for individual instances using <a>UpdateGameSession</a>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>NoProtection</b> - The game session can be terminated during a scale-down event.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>FullProtection</b> - If the game session is in an <code>ACTIVE</code> status, it cannot be terminated during a
     * scale-down event.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #newGameSessionProtectionPolicy} will return {@link ProtectionPolicy#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #newGameSessionProtectionPolicyAsString}.
     * </p>
     * 
     * @return A game session protection policy to apply to all instances in this fleet. If this parameter is not set,
     *         instances in this fleet default to no protection. You can change a fleet's protection policy using
     *         <a>UpdateFleetAttributes</a>, but this change will only affect sessions created after the policy change.
     *         You can also set protection for individual instances using <a>UpdateGameSession</a>.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>NoProtection</b> - The game session can be terminated during a scale-down event.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>FullProtection</b> - If the game session is in an <code>ACTIVE</code> status, it cannot be terminated
     *         during a scale-down event.
     *         </p>
     *         </li>
     * @see ProtectionPolicy
     */
    public String newGameSessionProtectionPolicyAsString() {
        return newGameSessionProtectionPolicy;
    }

    /**
     * <p>
     * Instructions for launching server processes on each instance in the fleet. Server processes run either a custom
     * game build executable or a Realtime script. The runtime configuration defines the server executables or launch
     * script file, launch parameters, and the number of processes to run concurrently on each instance. When creating a
     * fleet, the runtime configuration must have at least one server process configuration; otherwise the request fails
     * with an invalid request exception. (This parameter replaces the parameters <code>ServerLaunchPath</code> and
     * <code>ServerLaunchParameters</code>, although requests that contain values for these parameters instead of a
     * runtime configuration will continue to work.) This parameter is required unless the parameters
     * <code>ServerLaunchPath</code> and <code>ServerLaunchParameters</code> are defined. Runtime configuration replaced
     * these parameters, but fleets that use them will continue to work.
     * </p>
     * 
     * @return Instructions for launching server processes on each instance in the fleet. Server processes run either a
     *         custom game build executable or a Realtime script. The runtime configuration defines the server
     *         executables or launch script file, launch parameters, and the number of processes to run concurrently on
     *         each instance. When creating a fleet, the runtime configuration must have at least one server process
     *         configuration; otherwise the request fails with an invalid request exception. (This parameter replaces
     *         the parameters <code>ServerLaunchPath</code> and <code>ServerLaunchParameters</code>, although requests
     *         that contain values for these parameters instead of a runtime configuration will continue to work.) This
     *         parameter is required unless the parameters <code>ServerLaunchPath</code> and
     *         <code>ServerLaunchParameters</code> are defined. Runtime configuration replaced these parameters, but
     *         fleets that use them will continue to work.
     */
    public RuntimeConfiguration runtimeConfiguration() {
        return runtimeConfiguration;
    }

    /**
     * <p>
     * A policy that limits the number of game sessions an individual player can create over a span of time for this
     * fleet.
     * </p>
     * 
     * @return A policy that limits the number of game sessions an individual player can create over a span of time for
     *         this fleet.
     */
    public ResourceCreationLimitPolicy resourceCreationLimitPolicy() {
        return resourceCreationLimitPolicy;
    }

    /**
     * Returns true if the MetricGroups property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasMetricGroups() {
        return metricGroups != null && !(metricGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The name of an Amazon CloudWatch metric group to add this fleet to. A metric group aggregates the metrics for all
     * fleets in the group. Specify an existing metric group name, or provide a new name to create a new metric group. A
     * fleet can only be included in one metric group at a time.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMetricGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The name of an Amazon CloudWatch metric group to add this fleet to. A metric group aggregates the metrics
     *         for all fleets in the group. Specify an existing metric group name, or provide a new name to create a new
     *         metric group. A fleet can only be included in one metric group at a time.
     */
    public List<String> metricGroups() {
        return metricGroups;
    }

    /**
     * <p>
     * A unique identifier for the AWS account with the VPC that you want to peer your Amazon GameLift fleet with. You
     * can find your account ID in the AWS Management Console under account settings.
     * </p>
     * 
     * @return A unique identifier for the AWS account with the VPC that you want to peer your Amazon GameLift fleet
     *         with. You can find your account ID in the AWS Management Console under account settings.
     */
    public String peerVpcAwsAccountId() {
        return peerVpcAwsAccountId;
    }

    /**
     * <p>
     * A unique identifier for a VPC with resources to be accessed by your Amazon GameLift fleet. The VPC must be in the
     * same Region as your fleet. To look up a VPC ID, use the <a href="https://console.aws.amazon.com/vpc/">VPC
     * Dashboard</a> in the AWS Management Console. Learn more about VPC peering in <a
     * href="https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html">VPC Peering with Amazon
     * GameLift Fleets</a>.
     * </p>
     * 
     * @return A unique identifier for a VPC with resources to be accessed by your Amazon GameLift fleet. The VPC must
     *         be in the same Region as your fleet. To look up a VPC ID, use the <a
     *         href="https://console.aws.amazon.com/vpc/">VPC Dashboard</a> in the AWS Management Console. Learn more
     *         about VPC peering in <a
     *         href="https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html">VPC Peering with
     *         Amazon GameLift Fleets</a>.
     */
    public String peerVpcId() {
        return peerVpcId;
    }

    /**
     * <p>
     * Indicates whether to use On-Demand instances or Spot instances for this fleet. If empty, the default is
     * <code>ON_DEMAND</code>. Both categories of instances use identical hardware and configurations based on the
     * instance type selected for this fleet. Learn more about <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-ec2-instances.html#gamelift-ec2-instances-spot"
     * > On-Demand versus Spot Instances</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fleetType} will
     * return {@link FleetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fleetTypeAsString}.
     * </p>
     * 
     * @return Indicates whether to use On-Demand instances or Spot instances for this fleet. If empty, the default is
     *         <code>ON_DEMAND</code>. Both categories of instances use identical hardware and configurations based on
     *         the instance type selected for this fleet. Learn more about <a href=
     *         "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-ec2-instances.html#gamelift-ec2-instances-spot"
     *         > On-Demand versus Spot Instances</a>.
     * @see FleetType
     */
    public FleetType fleetType() {
        return FleetType.fromValue(fleetType);
    }

    /**
     * <p>
     * Indicates whether to use On-Demand instances or Spot instances for this fleet. If empty, the default is
     * <code>ON_DEMAND</code>. Both categories of instances use identical hardware and configurations based on the
     * instance type selected for this fleet. Learn more about <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-ec2-instances.html#gamelift-ec2-instances-spot"
     * > On-Demand versus Spot Instances</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fleetType} will
     * return {@link FleetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fleetTypeAsString}.
     * </p>
     * 
     * @return Indicates whether to use On-Demand instances or Spot instances for this fleet. If empty, the default is
     *         <code>ON_DEMAND</code>. Both categories of instances use identical hardware and configurations based on
     *         the instance type selected for this fleet. Learn more about <a href=
     *         "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-ec2-instances.html#gamelift-ec2-instances-spot"
     *         > On-Demand versus Spot Instances</a>.
     * @see FleetType
     */
    public String fleetTypeAsString() {
        return fleetType;
    }

    /**
     * <p>
     * A unique identifier for an AWS IAM role that manages access to your AWS services. With an instance role ARN set,
     * any application that runs on an instance in this fleet can assume the role, including install scripts, server
     * processes, and daemons (background processes). Create a role or look up a role's ARN from the <a
     * href="https://console.aws.amazon.com/iam/">IAM dashboard</a> in the AWS Management Console. Learn more about
     * using on-box credentials for your game servers at <a
     * href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-resources.html"> Access
     * external resources from a game server</a>.
     * </p>
     * 
     * @return A unique identifier for an AWS IAM role that manages access to your AWS services. With an instance role
     *         ARN set, any application that runs on an instance in this fleet can assume the role, including install
     *         scripts, server processes, and daemons (background processes). Create a role or look up a role's ARN from
     *         the <a href="https://console.aws.amazon.com/iam/">IAM dashboard</a> in the AWS Management Console. Learn
     *         more about using on-box credentials for your game servers at <a
     *         href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-resources.html">
     *         Access external resources from a game server</a>.
     */
    public String instanceRoleArn() {
        return instanceRoleArn;
    }

    /**
     * <p>
     * Indicates whether to generate a TLS/SSL certificate for the new fleet. TLS certificates are used for encrypting
     * traffic between game clients and game servers running on GameLift. If this parameter is not specified, the
     * default value, DISABLED, is used. This fleet setting cannot be changed once the fleet is created. Learn more at
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-howitworks.html#gamelift-howitworks-security"
     * >Securing Client/Server Communication</a>.
     * </p>
     * <p>
     * Note: This feature requires the AWS Certificate Manager (ACM) service, which is available in the AWS global
     * partition but not in all other partitions. When working in a partition that does not support this feature, a
     * request for a new fleet with certificate generation results fails with a 4xx unsupported Region error.
     * </p>
     * <p>
     * Valid values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>GENERATED</b> - Generate a TLS/SSL certificate for this fleet.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>DISABLED</b> - (default) Do not generate a TLS/SSL certificate for this fleet.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Indicates whether to generate a TLS/SSL certificate for the new fleet. TLS certificates are used for
     *         encrypting traffic between game clients and game servers running on GameLift. If this parameter is not
     *         specified, the default value, DISABLED, is used. This fleet setting cannot be changed once the fleet is
     *         created. Learn more at <a href=
     *         "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-howitworks.html#gamelift-howitworks-security"
     *         >Securing Client/Server Communication</a>. </p>
     *         <p>
     *         Note: This feature requires the AWS Certificate Manager (ACM) service, which is available in the AWS
     *         global partition but not in all other partitions. When working in a partition that does not support this
     *         feature, a request for a new fleet with certificate generation results fails with a 4xx unsupported
     *         Region error.
     *         </p>
     *         <p>
     *         Valid values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>GENERATED</b> - Generate a TLS/SSL certificate for this fleet.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>DISABLED</b> - (default) Do not generate a TLS/SSL certificate for this fleet.
     *         </p>
     *         </li>
     */
    public CertificateConfiguration certificateConfiguration() {
        return certificateConfiguration;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of labels to assign to the new fleet resource. Tags are developer-defined key-value pairs. Tagging AWS
     * resources are useful for resource management, access management and cost allocation. For more information, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging AWS Resources</a> in the <i>AWS
     * General Reference</i>. Once the resource is created, you can use <a>TagResource</a>, <a>UntagResource</a>, and
     * <a>ListTagsForResource</a> to add, remove, and view tags. The maximum tag limit may be lower than stated. See the
     * AWS General Reference for actual tagging limits.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of labels to assign to the new fleet resource. Tags are developer-defined key-value pairs. Tagging
     *         AWS resources are useful for resource management, access management and cost allocation. For more
     *         information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging AWS
     *         Resources</a> in the <i>AWS General Reference</i>. Once the resource is created, you can use
     *         <a>TagResource</a>, <a>UntagResource</a>, and <a>ListTagsForResource</a> to add, remove, and view tags.
     *         The maximum tag limit may be lower than stated. See the AWS General Reference for actual tagging limits.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(buildId());
        hashCode = 31 * hashCode + Objects.hashCode(scriptId());
        hashCode = 31 * hashCode + Objects.hashCode(serverLaunchPath());
        hashCode = 31 * hashCode + Objects.hashCode(serverLaunchParameters());
        hashCode = 31 * hashCode + Objects.hashCode(logPaths());
        hashCode = 31 * hashCode + Objects.hashCode(ec2InstanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ec2InboundPermissions());
        hashCode = 31 * hashCode + Objects.hashCode(newGameSessionProtectionPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(runtimeConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(resourceCreationLimitPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(metricGroups());
        hashCode = 31 * hashCode + Objects.hashCode(peerVpcAwsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(peerVpcId());
        hashCode = 31 * hashCode + Objects.hashCode(fleetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(instanceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(certificateConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFleetRequest)) {
            return false;
        }
        CreateFleetRequest other = (CreateFleetRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(buildId(), other.buildId()) && Objects.equals(scriptId(), other.scriptId())
                && Objects.equals(serverLaunchPath(), other.serverLaunchPath())
                && Objects.equals(serverLaunchParameters(), other.serverLaunchParameters())
                && Objects.equals(logPaths(), other.logPaths())
                && Objects.equals(ec2InstanceTypeAsString(), other.ec2InstanceTypeAsString())
                && Objects.equals(ec2InboundPermissions(), other.ec2InboundPermissions())
                && Objects.equals(newGameSessionProtectionPolicyAsString(), other.newGameSessionProtectionPolicyAsString())
                && Objects.equals(runtimeConfiguration(), other.runtimeConfiguration())
                && Objects.equals(resourceCreationLimitPolicy(), other.resourceCreationLimitPolicy())
                && Objects.equals(metricGroups(), other.metricGroups())
                && Objects.equals(peerVpcAwsAccountId(), other.peerVpcAwsAccountId())
                && Objects.equals(peerVpcId(), other.peerVpcId())
                && Objects.equals(fleetTypeAsString(), other.fleetTypeAsString())
                && Objects.equals(instanceRoleArn(), other.instanceRoleArn())
                && Objects.equals(certificateConfiguration(), other.certificateConfiguration())
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateFleetRequest").add("Name", name()).add("Description", description())
                .add("BuildId", buildId()).add("ScriptId", scriptId()).add("ServerLaunchPath", serverLaunchPath())
                .add("ServerLaunchParameters", serverLaunchParameters()).add("LogPaths", logPaths())
                .add("EC2InstanceType", ec2InstanceTypeAsString()).add("EC2InboundPermissions", ec2InboundPermissions())
                .add("NewGameSessionProtectionPolicy", newGameSessionProtectionPolicyAsString())
                .add("RuntimeConfiguration", runtimeConfiguration())
                .add("ResourceCreationLimitPolicy", resourceCreationLimitPolicy()).add("MetricGroups", metricGroups())
                .add("PeerVpcAwsAccountId", peerVpcAwsAccountId()).add("PeerVpcId", peerVpcId())
                .add("FleetType", fleetTypeAsString()).add("InstanceRoleArn", instanceRoleArn())
                .add("CertificateConfiguration", certificateConfiguration()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "BuildId":
            return Optional.ofNullable(clazz.cast(buildId()));
        case "ScriptId":
            return Optional.ofNullable(clazz.cast(scriptId()));
        case "ServerLaunchPath":
            return Optional.ofNullable(clazz.cast(serverLaunchPath()));
        case "ServerLaunchParameters":
            return Optional.ofNullable(clazz.cast(serverLaunchParameters()));
        case "LogPaths":
            return Optional.ofNullable(clazz.cast(logPaths()));
        case "EC2InstanceType":
            return Optional.ofNullable(clazz.cast(ec2InstanceTypeAsString()));
        case "EC2InboundPermissions":
            return Optional.ofNullable(clazz.cast(ec2InboundPermissions()));
        case "NewGameSessionProtectionPolicy":
            return Optional.ofNullable(clazz.cast(newGameSessionProtectionPolicyAsString()));
        case "RuntimeConfiguration":
            return Optional.ofNullable(clazz.cast(runtimeConfiguration()));
        case "ResourceCreationLimitPolicy":
            return Optional.ofNullable(clazz.cast(resourceCreationLimitPolicy()));
        case "MetricGroups":
            return Optional.ofNullable(clazz.cast(metricGroups()));
        case "PeerVpcAwsAccountId":
            return Optional.ofNullable(clazz.cast(peerVpcAwsAccountId()));
        case "PeerVpcId":
            return Optional.ofNullable(clazz.cast(peerVpcId()));
        case "FleetType":
            return Optional.ofNullable(clazz.cast(fleetTypeAsString()));
        case "InstanceRoleArn":
            return Optional.ofNullable(clazz.cast(instanceRoleArn()));
        case "CertificateConfiguration":
            return Optional.ofNullable(clazz.cast(certificateConfiguration()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateFleetRequest, T> g) {
        return obj -> g.apply((CreateFleetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateFleetRequest> {
        /**
         * <p>
         * A descriptive label that is associated with a fleet. Fleet names do not need to be unique.
         * </p>
         * 
         * @param name
         *        A descriptive label that is associated with a fleet. Fleet names do not need to be unique.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A human-readable description of a fleet.
         * </p>
         * 
         * @param description
         *        A human-readable description of a fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A unique identifier for a build to be deployed on the new fleet. You can use either the build ID or ARN
         * value. The custom game server build must have been successfully uploaded to Amazon GameLift and be in a
         * <code>READY</code> status. This fleet setting cannot be changed once the fleet is created.
         * </p>
         * 
         * @param buildId
         *        A unique identifier for a build to be deployed on the new fleet. You can use either the build ID or
         *        ARN value. The custom game server build must have been successfully uploaded to Amazon GameLift and be
         *        in a <code>READY</code> status. This fleet setting cannot be changed once the fleet is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder buildId(String buildId);

        /**
         * <p>
         * A unique identifier for a Realtime script to be deployed on the new fleet. You can use either the script ID
         * or ARN value. The Realtime script must have been successfully uploaded to Amazon GameLift. This fleet setting
         * cannot be changed once the fleet is created.
         * </p>
         * 
         * @param scriptId
         *        A unique identifier for a Realtime script to be deployed on the new fleet. You can use either the
         *        script ID or ARN value. The Realtime script must have been successfully uploaded to Amazon GameLift.
         *        This fleet setting cannot be changed once the fleet is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scriptId(String scriptId);

        /**
         * <p>
         * This parameter is no longer used. Instead, specify a server launch path using the
         * <code>RuntimeConfiguration</code> parameter. Requests that specify a server launch path and launch parameters
         * instead of a runtime configuration will continue to work.
         * </p>
         * 
         * @param serverLaunchPath
         *        This parameter is no longer used. Instead, specify a server launch path using the
         *        <code>RuntimeConfiguration</code> parameter. Requests that specify a server launch path and launch
         *        parameters instead of a runtime configuration will continue to work.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverLaunchPath(String serverLaunchPath);

        /**
         * <p>
         * This parameter is no longer used. Instead, specify server launch parameters in the
         * <code>RuntimeConfiguration</code> parameter. (Requests that specify a server launch path and launch
         * parameters instead of a runtime configuration will continue to work.)
         * </p>
         * 
         * @param serverLaunchParameters
         *        This parameter is no longer used. Instead, specify server launch parameters in the
         *        <code>RuntimeConfiguration</code> parameter. (Requests that specify a server launch path and launch
         *        parameters instead of a runtime configuration will continue to work.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverLaunchParameters(String serverLaunchParameters);

        /**
         * <p>
         * This parameter is no longer used. Instead, to specify where Amazon GameLift should store log files once a
         * server process shuts down, use the Amazon GameLift server API <code>ProcessReady()</code> and specify one or
         * more directory paths in <code>logParameters</code>. See more information in the <a href=
         * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api-ref.html#gamelift-sdk-server-api-ref-dataypes-process"
         * >Server API Reference</a>.
         * </p>
         * 
         * @param logPaths
         *        This parameter is no longer used. Instead, to specify where Amazon GameLift should store log files
         *        once a server process shuts down, use the Amazon GameLift server API <code>ProcessReady()</code> and
         *        specify one or more directory paths in <code>logParameters</code>. See more information in the <a
         *        href=
         *        "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api-ref.html#gamelift-sdk-server-api-ref-dataypes-process"
         *        >Server API Reference</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logPaths(Collection<String> logPaths);

        /**
         * <p>
         * This parameter is no longer used. Instead, to specify where Amazon GameLift should store log files once a
         * server process shuts down, use the Amazon GameLift server API <code>ProcessReady()</code> and specify one or
         * more directory paths in <code>logParameters</code>. See more information in the <a href=
         * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api-ref.html#gamelift-sdk-server-api-ref-dataypes-process"
         * >Server API Reference</a>.
         * </p>
         * 
         * @param logPaths
         *        This parameter is no longer used. Instead, to specify where Amazon GameLift should store log files
         *        once a server process shuts down, use the Amazon GameLift server API <code>ProcessReady()</code> and
         *        specify one or more directory paths in <code>logParameters</code>. See more information in the <a
         *        href=
         *        "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api-ref.html#gamelift-sdk-server-api-ref-dataypes-process"
         *        >Server API Reference</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logPaths(String... logPaths);

        /**
         * <p>
         * The name of an EC2 instance type that is supported in Amazon GameLift. A fleet instance type determines the
         * computing resources of each instance in the fleet, including CPU, memory, storage, and networking capacity.
         * Amazon GameLift supports the following EC2 instance types. See <a
         * href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2 Instance Types</a> for detailed descriptions.
         * </p>
         * 
         * @param ec2InstanceType
         *        The name of an EC2 instance type that is supported in Amazon GameLift. A fleet instance type
         *        determines the computing resources of each instance in the fleet, including CPU, memory, storage, and
         *        networking capacity. Amazon GameLift supports the following EC2 instance types. See <a
         *        href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2 Instance Types</a> for detailed
         *        descriptions.
         * @see EC2InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EC2InstanceType
         */
        Builder ec2InstanceType(String ec2InstanceType);

        /**
         * <p>
         * The name of an EC2 instance type that is supported in Amazon GameLift. A fleet instance type determines the
         * computing resources of each instance in the fleet, including CPU, memory, storage, and networking capacity.
         * Amazon GameLift supports the following EC2 instance types. See <a
         * href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2 Instance Types</a> for detailed descriptions.
         * </p>
         * 
         * @param ec2InstanceType
         *        The name of an EC2 instance type that is supported in Amazon GameLift. A fleet instance type
         *        determines the computing resources of each instance in the fleet, including CPU, memory, storage, and
         *        networking capacity. Amazon GameLift supports the following EC2 instance types. See <a
         *        href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2 Instance Types</a> for detailed
         *        descriptions.
         * @see EC2InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EC2InstanceType
         */
        Builder ec2InstanceType(EC2InstanceType ec2InstanceType);

        /**
         * <p>
         * Range of IP addresses and port settings that permit inbound traffic to access game sessions that are running
         * on the fleet. For fleets using a custom game build, this parameter is required before game sessions running
         * on the fleet can accept connections. For Realtime Servers fleets, Amazon GameLift automatically sets TCP and
         * UDP ranges for use by the Realtime servers. You can specify multiple permission settings or add more by
         * updating the fleet.
         * </p>
         * 
         * @param ec2InboundPermissions
         *        Range of IP addresses and port settings that permit inbound traffic to access game sessions that are
         *        running on the fleet. For fleets using a custom game build, this parameter is required before game
         *        sessions running on the fleet can accept connections. For Realtime Servers fleets, Amazon GameLift
         *        automatically sets TCP and UDP ranges for use by the Realtime servers. You can specify multiple
         *        permission settings or add more by updating the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2InboundPermissions(Collection<IpPermission> ec2InboundPermissions);

        /**
         * <p>
         * Range of IP addresses and port settings that permit inbound traffic to access game sessions that are running
         * on the fleet. For fleets using a custom game build, this parameter is required before game sessions running
         * on the fleet can accept connections. For Realtime Servers fleets, Amazon GameLift automatically sets TCP and
         * UDP ranges for use by the Realtime servers. You can specify multiple permission settings or add more by
         * updating the fleet.
         * </p>
         * 
         * @param ec2InboundPermissions
         *        Range of IP addresses and port settings that permit inbound traffic to access game sessions that are
         *        running on the fleet. For fleets using a custom game build, this parameter is required before game
         *        sessions running on the fleet can accept connections. For Realtime Servers fleets, Amazon GameLift
         *        automatically sets TCP and UDP ranges for use by the Realtime servers. You can specify multiple
         *        permission settings or add more by updating the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2InboundPermissions(IpPermission... ec2InboundPermissions);

        /**
         * <p>
         * Range of IP addresses and port settings that permit inbound traffic to access game sessions that are running
         * on the fleet. For fleets using a custom game build, this parameter is required before game sessions running
         * on the fleet can accept connections. For Realtime Servers fleets, Amazon GameLift automatically sets TCP and
         * UDP ranges for use by the Realtime servers. You can specify multiple permission settings or add more by
         * updating the fleet.
         * </p>
         * This is a convenience that creates an instance of the {@link List<IpPermission>.Builder} avoiding the need to
         * create one manually via {@link List<IpPermission>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<IpPermission>.Builder#build()} is called immediately and its
         * result is passed to {@link #ec2InboundPermissions(List<IpPermission>)}.
         * 
         * @param ec2InboundPermissions
         *        a consumer that will call methods on {@link List<IpPermission>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ec2InboundPermissions(List<IpPermission>)
         */
        Builder ec2InboundPermissions(Consumer<IpPermission.Builder>... ec2InboundPermissions);

        /**
         * <p>
         * A game session protection policy to apply to all instances in this fleet. If this parameter is not set,
         * instances in this fleet default to no protection. You can change a fleet's protection policy using
         * <a>UpdateFleetAttributes</a>, but this change will only affect sessions created after the policy change. You
         * can also set protection for individual instances using <a>UpdateGameSession</a>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>NoProtection</b> - The game session can be terminated during a scale-down event.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>FullProtection</b> - If the game session is in an <code>ACTIVE</code> status, it cannot be terminated
         * during a scale-down event.
         * </p>
         * </li>
         * </ul>
         * 
         * @param newGameSessionProtectionPolicy
         *        A game session protection policy to apply to all instances in this fleet. If this parameter is not
         *        set, instances in this fleet default to no protection. You can change a fleet's protection policy
         *        using <a>UpdateFleetAttributes</a>, but this change will only affect sessions created after the policy
         *        change. You can also set protection for individual instances using <a>UpdateGameSession</a>.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>NoProtection</b> - The game session can be terminated during a scale-down event.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>FullProtection</b> - If the game session is in an <code>ACTIVE</code> status, it cannot be
         *        terminated during a scale-down event.
         *        </p>
         *        </li>
         * @see ProtectionPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProtectionPolicy
         */
        Builder newGameSessionProtectionPolicy(String newGameSessionProtectionPolicy);

        /**
         * <p>
         * A game session protection policy to apply to all instances in this fleet. If this parameter is not set,
         * instances in this fleet default to no protection. You can change a fleet's protection policy using
         * <a>UpdateFleetAttributes</a>, but this change will only affect sessions created after the policy change. You
         * can also set protection for individual instances using <a>UpdateGameSession</a>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>NoProtection</b> - The game session can be terminated during a scale-down event.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>FullProtection</b> - If the game session is in an <code>ACTIVE</code> status, it cannot be terminated
         * during a scale-down event.
         * </p>
         * </li>
         * </ul>
         * 
         * @param newGameSessionProtectionPolicy
         *        A game session protection policy to apply to all instances in this fleet. If this parameter is not
         *        set, instances in this fleet default to no protection. You can change a fleet's protection policy
         *        using <a>UpdateFleetAttributes</a>, but this change will only affect sessions created after the policy
         *        change. You can also set protection for individual instances using <a>UpdateGameSession</a>.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>NoProtection</b> - The game session can be terminated during a scale-down event.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>FullProtection</b> - If the game session is in an <code>ACTIVE</code> status, it cannot be
         *        terminated during a scale-down event.
         *        </p>
         *        </li>
         * @see ProtectionPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProtectionPolicy
         */
        Builder newGameSessionProtectionPolicy(ProtectionPolicy newGameSessionProtectionPolicy);

        /**
         * <p>
         * Instructions for launching server processes on each instance in the fleet. Server processes run either a
         * custom game build executable or a Realtime script. The runtime configuration defines the server executables
         * or launch script file, launch parameters, and the number of processes to run concurrently on each instance.
         * When creating a fleet, the runtime configuration must have at least one server process configuration;
         * otherwise the request fails with an invalid request exception. (This parameter replaces the parameters
         * <code>ServerLaunchPath</code> and <code>ServerLaunchParameters</code>, although requests that contain values
         * for these parameters instead of a runtime configuration will continue to work.) This parameter is required
         * unless the parameters <code>ServerLaunchPath</code> and <code>ServerLaunchParameters</code> are defined.
         * Runtime configuration replaced these parameters, but fleets that use them will continue to work.
         * </p>
         * 
         * @param runtimeConfiguration
         *        Instructions for launching server processes on each instance in the fleet. Server processes run either
         *        a custom game build executable or a Realtime script. The runtime configuration defines the server
         *        executables or launch script file, launch parameters, and the number of processes to run concurrently
         *        on each instance. When creating a fleet, the runtime configuration must have at least one server
         *        process configuration; otherwise the request fails with an invalid request exception. (This parameter
         *        replaces the parameters <code>ServerLaunchPath</code> and <code>ServerLaunchParameters</code>,
         *        although requests that contain values for these parameters instead of a runtime configuration will
         *        continue to work.) This parameter is required unless the parameters <code>ServerLaunchPath</code> and
         *        <code>ServerLaunchParameters</code> are defined. Runtime configuration replaced these parameters, but
         *        fleets that use them will continue to work.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runtimeConfiguration(RuntimeConfiguration runtimeConfiguration);

        /**
         * <p>
         * Instructions for launching server processes on each instance in the fleet. Server processes run either a
         * custom game build executable or a Realtime script. The runtime configuration defines the server executables
         * or launch script file, launch parameters, and the number of processes to run concurrently on each instance.
         * When creating a fleet, the runtime configuration must have at least one server process configuration;
         * otherwise the request fails with an invalid request exception. (This parameter replaces the parameters
         * <code>ServerLaunchPath</code> and <code>ServerLaunchParameters</code>, although requests that contain values
         * for these parameters instead of a runtime configuration will continue to work.) This parameter is required
         * unless the parameters <code>ServerLaunchPath</code> and <code>ServerLaunchParameters</code> are defined.
         * Runtime configuration replaced these parameters, but fleets that use them will continue to work.
         * </p>
         * This is a convenience that creates an instance of the {@link RuntimeConfiguration.Builder} avoiding the need
         * to create one manually via {@link RuntimeConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link RuntimeConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #runtimeConfiguration(RuntimeConfiguration)}.
         * 
         * @param runtimeConfiguration
         *        a consumer that will call methods on {@link RuntimeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #runtimeConfiguration(RuntimeConfiguration)
         */
        default Builder runtimeConfiguration(Consumer<RuntimeConfiguration.Builder> runtimeConfiguration) {
            return runtimeConfiguration(RuntimeConfiguration.builder().applyMutation(runtimeConfiguration).build());
        }

        /**
         * <p>
         * A policy that limits the number of game sessions an individual player can create over a span of time for this
         * fleet.
         * </p>
         * 
         * @param resourceCreationLimitPolicy
         *        A policy that limits the number of game sessions an individual player can create over a span of time
         *        for this fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceCreationLimitPolicy(ResourceCreationLimitPolicy resourceCreationLimitPolicy);

        /**
         * <p>
         * A policy that limits the number of game sessions an individual player can create over a span of time for this
         * fleet.
         * </p>
         * This is a convenience that creates an instance of the {@link ResourceCreationLimitPolicy.Builder} avoiding
         * the need to create one manually via {@link ResourceCreationLimitPolicy#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceCreationLimitPolicy.Builder#build()} is called
         * immediately and its result is passed to {@link #resourceCreationLimitPolicy(ResourceCreationLimitPolicy)}.
         * 
         * @param resourceCreationLimitPolicy
         *        a consumer that will call methods on {@link ResourceCreationLimitPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceCreationLimitPolicy(ResourceCreationLimitPolicy)
         */
        default Builder resourceCreationLimitPolicy(Consumer<ResourceCreationLimitPolicy.Builder> resourceCreationLimitPolicy) {
            return resourceCreationLimitPolicy(ResourceCreationLimitPolicy.builder().applyMutation(resourceCreationLimitPolicy)
                    .build());
        }

        /**
         * <p>
         * The name of an Amazon CloudWatch metric group to add this fleet to. A metric group aggregates the metrics for
         * all fleets in the group. Specify an existing metric group name, or provide a new name to create a new metric
         * group. A fleet can only be included in one metric group at a time.
         * </p>
         * 
         * @param metricGroups
         *        The name of an Amazon CloudWatch metric group to add this fleet to. A metric group aggregates the
         *        metrics for all fleets in the group. Specify an existing metric group name, or provide a new name to
         *        create a new metric group. A fleet can only be included in one metric group at a time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricGroups(Collection<String> metricGroups);

        /**
         * <p>
         * The name of an Amazon CloudWatch metric group to add this fleet to. A metric group aggregates the metrics for
         * all fleets in the group. Specify an existing metric group name, or provide a new name to create a new metric
         * group. A fleet can only be included in one metric group at a time.
         * </p>
         * 
         * @param metricGroups
         *        The name of an Amazon CloudWatch metric group to add this fleet to. A metric group aggregates the
         *        metrics for all fleets in the group. Specify an existing metric group name, or provide a new name to
         *        create a new metric group. A fleet can only be included in one metric group at a time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricGroups(String... metricGroups);

        /**
         * <p>
         * A unique identifier for the AWS account with the VPC that you want to peer your Amazon GameLift fleet with.
         * You can find your account ID in the AWS Management Console under account settings.
         * </p>
         * 
         * @param peerVpcAwsAccountId
         *        A unique identifier for the AWS account with the VPC that you want to peer your Amazon GameLift fleet
         *        with. You can find your account ID in the AWS Management Console under account settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peerVpcAwsAccountId(String peerVpcAwsAccountId);

        /**
         * <p>
         * A unique identifier for a VPC with resources to be accessed by your Amazon GameLift fleet. The VPC must be in
         * the same Region as your fleet. To look up a VPC ID, use the <a href="https://console.aws.amazon.com/vpc/">VPC
         * Dashboard</a> in the AWS Management Console. Learn more about VPC peering in <a
         * href="https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html">VPC Peering with Amazon
         * GameLift Fleets</a>.
         * </p>
         * 
         * @param peerVpcId
         *        A unique identifier for a VPC with resources to be accessed by your Amazon GameLift fleet. The VPC
         *        must be in the same Region as your fleet. To look up a VPC ID, use the <a
         *        href="https://console.aws.amazon.com/vpc/">VPC Dashboard</a> in the AWS Management Console. Learn more
         *        about VPC peering in <a
         *        href="https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html">VPC Peering with
         *        Amazon GameLift Fleets</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peerVpcId(String peerVpcId);

        /**
         * <p>
         * Indicates whether to use On-Demand instances or Spot instances for this fleet. If empty, the default is
         * <code>ON_DEMAND</code>. Both categories of instances use identical hardware and configurations based on the
         * instance type selected for this fleet. Learn more about <a href=
         * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-ec2-instances.html#gamelift-ec2-instances-spot"
         * > On-Demand versus Spot Instances</a>.
         * </p>
         * 
         * @param fleetType
         *        Indicates whether to use On-Demand instances or Spot instances for this fleet. If empty, the default
         *        is <code>ON_DEMAND</code>. Both categories of instances use identical hardware and configurations
         *        based on the instance type selected for this fleet. Learn more about <a href=
         *        "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-ec2-instances.html#gamelift-ec2-instances-spot"
         *        > On-Demand versus Spot Instances</a>.
         * @see FleetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetType
         */
        Builder fleetType(String fleetType);

        /**
         * <p>
         * Indicates whether to use On-Demand instances or Spot instances for this fleet. If empty, the default is
         * <code>ON_DEMAND</code>. Both categories of instances use identical hardware and configurations based on the
         * instance type selected for this fleet. Learn more about <a href=
         * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-ec2-instances.html#gamelift-ec2-instances-spot"
         * > On-Demand versus Spot Instances</a>.
         * </p>
         * 
         * @param fleetType
         *        Indicates whether to use On-Demand instances or Spot instances for this fleet. If empty, the default
         *        is <code>ON_DEMAND</code>. Both categories of instances use identical hardware and configurations
         *        based on the instance type selected for this fleet. Learn more about <a href=
         *        "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-ec2-instances.html#gamelift-ec2-instances-spot"
         *        > On-Demand versus Spot Instances</a>.
         * @see FleetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetType
         */
        Builder fleetType(FleetType fleetType);

        /**
         * <p>
         * A unique identifier for an AWS IAM role that manages access to your AWS services. With an instance role ARN
         * set, any application that runs on an instance in this fleet can assume the role, including install scripts,
         * server processes, and daemons (background processes). Create a role or look up a role's ARN from the <a
         * href="https://console.aws.amazon.com/iam/">IAM dashboard</a> in the AWS Management Console. Learn more about
         * using on-box credentials for your game servers at <a
         * href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-resources.html"> Access
         * external resources from a game server</a>.
         * </p>
         * 
         * @param instanceRoleArn
         *        A unique identifier for an AWS IAM role that manages access to your AWS services. With an instance
         *        role ARN set, any application that runs on an instance in this fleet can assume the role, including
         *        install scripts, server processes, and daemons (background processes). Create a role or look up a
         *        role's ARN from the <a href="https://console.aws.amazon.com/iam/">IAM dashboard</a> in the AWS
         *        Management Console. Learn more about using on-box credentials for your game servers at <a
         *        href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-resources.html">
         *        Access external resources from a game server</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceRoleArn(String instanceRoleArn);

        /**
         * <p>
         * Indicates whether to generate a TLS/SSL certificate for the new fleet. TLS certificates are used for
         * encrypting traffic between game clients and game servers running on GameLift. If this parameter is not
         * specified, the default value, DISABLED, is used. This fleet setting cannot be changed once the fleet is
         * created. Learn more at <a href=
         * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-howitworks.html#gamelift-howitworks-security"
         * >Securing Client/Server Communication</a>.
         * </p>
         * <p>
         * Note: This feature requires the AWS Certificate Manager (ACM) service, which is available in the AWS global
         * partition but not in all other partitions. When working in a partition that does not support this feature, a
         * request for a new fleet with certificate generation results fails with a 4xx unsupported Region error.
         * </p>
         * <p>
         * Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>GENERATED</b> - Generate a TLS/SSL certificate for this fleet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>DISABLED</b> - (default) Do not generate a TLS/SSL certificate for this fleet.
         * </p>
         * </li>
         * </ul>
         * 
         * @param certificateConfiguration
         *        Indicates whether to generate a TLS/SSL certificate for the new fleet. TLS certificates are used for
         *        encrypting traffic between game clients and game servers running on GameLift. If this parameter is not
         *        specified, the default value, DISABLED, is used. This fleet setting cannot be changed once the fleet
         *        is created. Learn more at <a href=
         *        "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-howitworks.html#gamelift-howitworks-security"
         *        >Securing Client/Server Communication</a>. </p>
         *        <p>
         *        Note: This feature requires the AWS Certificate Manager (ACM) service, which is available in the AWS
         *        global partition but not in all other partitions. When working in a partition that does not support
         *        this feature, a request for a new fleet with certificate generation results fails with a 4xx
         *        unsupported Region error.
         *        </p>
         *        <p>
         *        Valid values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>GENERATED</b> - Generate a TLS/SSL certificate for this fleet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>DISABLED</b> - (default) Do not generate a TLS/SSL certificate for this fleet.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateConfiguration(CertificateConfiguration certificateConfiguration);

        /**
         * <p>
         * Indicates whether to generate a TLS/SSL certificate for the new fleet. TLS certificates are used for
         * encrypting traffic between game clients and game servers running on GameLift. If this parameter is not
         * specified, the default value, DISABLED, is used. This fleet setting cannot be changed once the fleet is
         * created. Learn more at <a href=
         * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-howitworks.html#gamelift-howitworks-security"
         * >Securing Client/Server Communication</a>.
         * </p>
         * <p>
         * Note: This feature requires the AWS Certificate Manager (ACM) service, which is available in the AWS global
         * partition but not in all other partitions. When working in a partition that does not support this feature, a
         * request for a new fleet with certificate generation results fails with a 4xx unsupported Region error.
         * </p>
         * <p>
         * Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>GENERATED</b> - Generate a TLS/SSL certificate for this fleet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>DISABLED</b> - (default) Do not generate a TLS/SSL certificate for this fleet.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link CertificateConfiguration.Builder} avoiding the
         * need to create one manually via {@link CertificateConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link CertificateConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #certificateConfiguration(CertificateConfiguration)}.
         * 
         * @param certificateConfiguration
         *        a consumer that will call methods on {@link CertificateConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #certificateConfiguration(CertificateConfiguration)
         */
        default Builder certificateConfiguration(Consumer<CertificateConfiguration.Builder> certificateConfiguration) {
            return certificateConfiguration(CertificateConfiguration.builder().applyMutation(certificateConfiguration).build());
        }

        /**
         * <p>
         * A list of labels to assign to the new fleet resource. Tags are developer-defined key-value pairs. Tagging AWS
         * resources are useful for resource management, access management and cost allocation. For more information,
         * see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging AWS Resources</a> in
         * the <i>AWS General Reference</i>. Once the resource is created, you can use <a>TagResource</a>,
         * <a>UntagResource</a>, and <a>ListTagsForResource</a> to add, remove, and view tags. The maximum tag limit may
         * be lower than stated. See the AWS General Reference for actual tagging limits.
         * </p>
         * 
         * @param tags
         *        A list of labels to assign to the new fleet resource. Tags are developer-defined key-value pairs.
         *        Tagging AWS resources are useful for resource management, access management and cost allocation. For
         *        more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">
         *        Tagging AWS Resources</a> in the <i>AWS General Reference</i>. Once the resource is created, you can
         *        use <a>TagResource</a>, <a>UntagResource</a>, and <a>ListTagsForResource</a> to add, remove, and view
         *        tags. The maximum tag limit may be lower than stated. See the AWS General Reference for actual tagging
         *        limits.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of labels to assign to the new fleet resource. Tags are developer-defined key-value pairs. Tagging AWS
         * resources are useful for resource management, access management and cost allocation. For more information,
         * see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging AWS Resources</a> in
         * the <i>AWS General Reference</i>. Once the resource is created, you can use <a>TagResource</a>,
         * <a>UntagResource</a>, and <a>ListTagsForResource</a> to add, remove, and view tags. The maximum tag limit may
         * be lower than stated. See the AWS General Reference for actual tagging limits.
         * </p>
         * 
         * @param tags
         *        A list of labels to assign to the new fleet resource. Tags are developer-defined key-value pairs.
         *        Tagging AWS resources are useful for resource management, access management and cost allocation. For
         *        more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">
         *        Tagging AWS Resources</a> in the <i>AWS General Reference</i>. Once the resource is created, you can
         *        use <a>TagResource</a>, <a>UntagResource</a>, and <a>ListTagsForResource</a> to add, remove, and view
         *        tags. The maximum tag limit may be lower than stated. See the AWS General Reference for actual tagging
         *        limits.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of labels to assign to the new fleet resource. Tags are developer-defined key-value pairs. Tagging AWS
         * resources are useful for resource management, access management and cost allocation. For more information,
         * see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging AWS Resources</a> in
         * the <i>AWS General Reference</i>. Once the resource is created, you can use <a>TagResource</a>,
         * <a>UntagResource</a>, and <a>ListTagsForResource</a> to add, remove, and view tags. The maximum tag limit may
         * be lower than stated. See the AWS General Reference for actual tagging limits.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GameLiftRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private String buildId;

        private String scriptId;

        private String serverLaunchPath;

        private String serverLaunchParameters;

        private List<String> logPaths = DefaultSdkAutoConstructList.getInstance();

        private String ec2InstanceType;

        private List<IpPermission> ec2InboundPermissions = DefaultSdkAutoConstructList.getInstance();

        private String newGameSessionProtectionPolicy;

        private RuntimeConfiguration runtimeConfiguration;

        private ResourceCreationLimitPolicy resourceCreationLimitPolicy;

        private List<String> metricGroups = DefaultSdkAutoConstructList.getInstance();

        private String peerVpcAwsAccountId;

        private String peerVpcId;

        private String fleetType;

        private String instanceRoleArn;

        private CertificateConfiguration certificateConfiguration;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFleetRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            buildId(model.buildId);
            scriptId(model.scriptId);
            serverLaunchPath(model.serverLaunchPath);
            serverLaunchParameters(model.serverLaunchParameters);
            logPaths(model.logPaths);
            ec2InstanceType(model.ec2InstanceType);
            ec2InboundPermissions(model.ec2InboundPermissions);
            newGameSessionProtectionPolicy(model.newGameSessionProtectionPolicy);
            runtimeConfiguration(model.runtimeConfiguration);
            resourceCreationLimitPolicy(model.resourceCreationLimitPolicy);
            metricGroups(model.metricGroups);
            peerVpcAwsAccountId(model.peerVpcAwsAccountId);
            peerVpcId(model.peerVpcId);
            fleetType(model.fleetType);
            instanceRoleArn(model.instanceRoleArn);
            certificateConfiguration(model.certificateConfiguration);
            tags(model.tags);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getBuildId() {
            return buildId;
        }

        @Override
        public final Builder buildId(String buildId) {
            this.buildId = buildId;
            return this;
        }

        public final void setBuildId(String buildId) {
            this.buildId = buildId;
        }

        public final String getScriptId() {
            return scriptId;
        }

        @Override
        public final Builder scriptId(String scriptId) {
            this.scriptId = scriptId;
            return this;
        }

        public final void setScriptId(String scriptId) {
            this.scriptId = scriptId;
        }

        public final String getServerLaunchPath() {
            return serverLaunchPath;
        }

        @Override
        public final Builder serverLaunchPath(String serverLaunchPath) {
            this.serverLaunchPath = serverLaunchPath;
            return this;
        }

        public final void setServerLaunchPath(String serverLaunchPath) {
            this.serverLaunchPath = serverLaunchPath;
        }

        public final String getServerLaunchParameters() {
            return serverLaunchParameters;
        }

        @Override
        public final Builder serverLaunchParameters(String serverLaunchParameters) {
            this.serverLaunchParameters = serverLaunchParameters;
            return this;
        }

        public final void setServerLaunchParameters(String serverLaunchParameters) {
            this.serverLaunchParameters = serverLaunchParameters;
        }

        public final Collection<String> getLogPaths() {
            return logPaths;
        }

        @Override
        public final Builder logPaths(Collection<String> logPaths) {
            this.logPaths = StringListCopier.copy(logPaths);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logPaths(String... logPaths) {
            logPaths(Arrays.asList(logPaths));
            return this;
        }

        public final void setLogPaths(Collection<String> logPaths) {
            this.logPaths = StringListCopier.copy(logPaths);
        }

        public final String getEc2InstanceType() {
            return ec2InstanceType;
        }

        @Override
        public final Builder ec2InstanceType(String ec2InstanceType) {
            this.ec2InstanceType = ec2InstanceType;
            return this;
        }

        @Override
        public final Builder ec2InstanceType(EC2InstanceType ec2InstanceType) {
            this.ec2InstanceType(ec2InstanceType == null ? null : ec2InstanceType.toString());
            return this;
        }

        public final void setEc2InstanceType(String ec2InstanceType) {
            this.ec2InstanceType = ec2InstanceType;
        }

        public final Collection<IpPermission.Builder> getEc2InboundPermissions() {
            return ec2InboundPermissions != null ? ec2InboundPermissions.stream().map(IpPermission::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ec2InboundPermissions(Collection<IpPermission> ec2InboundPermissions) {
            this.ec2InboundPermissions = IpPermissionsListCopier.copy(ec2InboundPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2InboundPermissions(IpPermission... ec2InboundPermissions) {
            ec2InboundPermissions(Arrays.asList(ec2InboundPermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2InboundPermissions(Consumer<IpPermission.Builder>... ec2InboundPermissions) {
            ec2InboundPermissions(Stream.of(ec2InboundPermissions).map(c -> IpPermission.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setEc2InboundPermissions(Collection<IpPermission.BuilderImpl> ec2InboundPermissions) {
            this.ec2InboundPermissions = IpPermissionsListCopier.copyFromBuilder(ec2InboundPermissions);
        }

        public final String getNewGameSessionProtectionPolicy() {
            return newGameSessionProtectionPolicy;
        }

        @Override
        public final Builder newGameSessionProtectionPolicy(String newGameSessionProtectionPolicy) {
            this.newGameSessionProtectionPolicy = newGameSessionProtectionPolicy;
            return this;
        }

        @Override
        public final Builder newGameSessionProtectionPolicy(ProtectionPolicy newGameSessionProtectionPolicy) {
            this.newGameSessionProtectionPolicy(newGameSessionProtectionPolicy == null ? null : newGameSessionProtectionPolicy
                    .toString());
            return this;
        }

        public final void setNewGameSessionProtectionPolicy(String newGameSessionProtectionPolicy) {
            this.newGameSessionProtectionPolicy = newGameSessionProtectionPolicy;
        }

        public final RuntimeConfiguration.Builder getRuntimeConfiguration() {
            return runtimeConfiguration != null ? runtimeConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder runtimeConfiguration(RuntimeConfiguration runtimeConfiguration) {
            this.runtimeConfiguration = runtimeConfiguration;
            return this;
        }

        public final void setRuntimeConfiguration(RuntimeConfiguration.BuilderImpl runtimeConfiguration) {
            this.runtimeConfiguration = runtimeConfiguration != null ? runtimeConfiguration.build() : null;
        }

        public final ResourceCreationLimitPolicy.Builder getResourceCreationLimitPolicy() {
            return resourceCreationLimitPolicy != null ? resourceCreationLimitPolicy.toBuilder() : null;
        }

        @Override
        public final Builder resourceCreationLimitPolicy(ResourceCreationLimitPolicy resourceCreationLimitPolicy) {
            this.resourceCreationLimitPolicy = resourceCreationLimitPolicy;
            return this;
        }

        public final void setResourceCreationLimitPolicy(ResourceCreationLimitPolicy.BuilderImpl resourceCreationLimitPolicy) {
            this.resourceCreationLimitPolicy = resourceCreationLimitPolicy != null ? resourceCreationLimitPolicy.build() : null;
        }

        public final Collection<String> getMetricGroups() {
            return metricGroups;
        }

        @Override
        public final Builder metricGroups(Collection<String> metricGroups) {
            this.metricGroups = MetricGroupListCopier.copy(metricGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricGroups(String... metricGroups) {
            metricGroups(Arrays.asList(metricGroups));
            return this;
        }

        public final void setMetricGroups(Collection<String> metricGroups) {
            this.metricGroups = MetricGroupListCopier.copy(metricGroups);
        }

        public final String getPeerVpcAwsAccountId() {
            return peerVpcAwsAccountId;
        }

        @Override
        public final Builder peerVpcAwsAccountId(String peerVpcAwsAccountId) {
            this.peerVpcAwsAccountId = peerVpcAwsAccountId;
            return this;
        }

        public final void setPeerVpcAwsAccountId(String peerVpcAwsAccountId) {
            this.peerVpcAwsAccountId = peerVpcAwsAccountId;
        }

        public final String getPeerVpcId() {
            return peerVpcId;
        }

        @Override
        public final Builder peerVpcId(String peerVpcId) {
            this.peerVpcId = peerVpcId;
            return this;
        }

        public final void setPeerVpcId(String peerVpcId) {
            this.peerVpcId = peerVpcId;
        }

        public final String getFleetType() {
            return fleetType;
        }

        @Override
        public final Builder fleetType(String fleetType) {
            this.fleetType = fleetType;
            return this;
        }

        @Override
        public final Builder fleetType(FleetType fleetType) {
            this.fleetType(fleetType == null ? null : fleetType.toString());
            return this;
        }

        public final void setFleetType(String fleetType) {
            this.fleetType = fleetType;
        }

        public final String getInstanceRoleArn() {
            return instanceRoleArn;
        }

        @Override
        public final Builder instanceRoleArn(String instanceRoleArn) {
            this.instanceRoleArn = instanceRoleArn;
            return this;
        }

        public final void setInstanceRoleArn(String instanceRoleArn) {
            this.instanceRoleArn = instanceRoleArn;
        }

        public final CertificateConfiguration.Builder getCertificateConfiguration() {
            return certificateConfiguration != null ? certificateConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder certificateConfiguration(CertificateConfiguration certificateConfiguration) {
            this.certificateConfiguration = certificateConfiguration;
            return this;
        }

        public final void setCertificateConfiguration(CertificateConfiguration.BuilderImpl certificateConfiguration) {
            this.certificateConfiguration = certificateConfiguration != null ? certificateConfiguration.build() : null;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFleetRequest build() {
            return new CreateFleetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
