/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateGameServerGroupRequest extends GameLiftRequest implements
        ToCopyableBuilder<CreateGameServerGroupRequest.Builder, CreateGameServerGroupRequest> {
    private static final SdkField<String> GAME_SERVER_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GameServerGroupName").getter(getter(CreateGameServerGroupRequest::gameServerGroupName))
            .setter(setter(Builder::gameServerGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameServerGroupName").build())
            .build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(CreateGameServerGroupRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<Integer> MIN_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinSize").getter(getter(CreateGameServerGroupRequest::minSize)).setter(setter(Builder::minSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinSize").build()).build();

    private static final SdkField<Integer> MAX_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxSize").getter(getter(CreateGameServerGroupRequest::maxSize)).setter(setter(Builder::maxSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxSize").build()).build();

    private static final SdkField<LaunchTemplateSpecification> LAUNCH_TEMPLATE_FIELD = SdkField
            .<LaunchTemplateSpecification> builder(MarshallingType.SDK_POJO).memberName("LaunchTemplate")
            .getter(getter(CreateGameServerGroupRequest::launchTemplate)).setter(setter(Builder::launchTemplate))
            .constructor(LaunchTemplateSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplate").build()).build();

    private static final SdkField<List<InstanceDefinition>> INSTANCE_DEFINITIONS_FIELD = SdkField
            .<List<InstanceDefinition>> builder(MarshallingType.LIST)
            .memberName("InstanceDefinitions")
            .getter(getter(CreateGameServerGroupRequest::instanceDefinitions))
            .setter(setter(Builder::instanceDefinitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceDefinitions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InstanceDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<GameServerGroupAutoScalingPolicy> AUTO_SCALING_POLICY_FIELD = SdkField
            .<GameServerGroupAutoScalingPolicy> builder(MarshallingType.SDK_POJO).memberName("AutoScalingPolicy")
            .getter(getter(CreateGameServerGroupRequest::autoScalingPolicy)).setter(setter(Builder::autoScalingPolicy))
            .constructor(GameServerGroupAutoScalingPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingPolicy").build()).build();

    private static final SdkField<String> BALANCING_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BalancingStrategy").getter(getter(CreateGameServerGroupRequest::balancingStrategyAsString))
            .setter(setter(Builder::balancingStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BalancingStrategy").build()).build();

    private static final SdkField<String> GAME_SERVER_PROTECTION_POLICY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("GameServerProtectionPolicy")
            .getter(getter(CreateGameServerGroupRequest::gameServerProtectionPolicyAsString))
            .setter(setter(Builder::gameServerProtectionPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameServerProtectionPolicy").build())
            .build();

    private static final SdkField<List<String>> VPC_SUBNETS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("VpcSubnets")
            .getter(getter(CreateGameServerGroupRequest::vpcSubnets))
            .setter(setter(Builder::vpcSubnets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSubnets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateGameServerGroupRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GAME_SERVER_GROUP_NAME_FIELD,
            ROLE_ARN_FIELD, MIN_SIZE_FIELD, MAX_SIZE_FIELD, LAUNCH_TEMPLATE_FIELD, INSTANCE_DEFINITIONS_FIELD,
            AUTO_SCALING_POLICY_FIELD, BALANCING_STRATEGY_FIELD, GAME_SERVER_PROTECTION_POLICY_FIELD, VPC_SUBNETS_FIELD,
            TAGS_FIELD));

    private final String gameServerGroupName;

    private final String roleArn;

    private final Integer minSize;

    private final Integer maxSize;

    private final LaunchTemplateSpecification launchTemplate;

    private final List<InstanceDefinition> instanceDefinitions;

    private final GameServerGroupAutoScalingPolicy autoScalingPolicy;

    private final String balancingStrategy;

    private final String gameServerProtectionPolicy;

    private final List<String> vpcSubnets;

    private final List<Tag> tags;

    private CreateGameServerGroupRequest(BuilderImpl builder) {
        super(builder);
        this.gameServerGroupName = builder.gameServerGroupName;
        this.roleArn = builder.roleArn;
        this.minSize = builder.minSize;
        this.maxSize = builder.maxSize;
        this.launchTemplate = builder.launchTemplate;
        this.instanceDefinitions = builder.instanceDefinitions;
        this.autoScalingPolicy = builder.autoScalingPolicy;
        this.balancingStrategy = builder.balancingStrategy;
        this.gameServerProtectionPolicy = builder.gameServerProtectionPolicy;
        this.vpcSubnets = builder.vpcSubnets;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * An identifier for the new game server group. This value is used to generate unique ARN identifiers for the EC2
     * Auto Scaling group and the GameLift FleetIQ game server group. The name must be unique per Region per AWS
     * account.
     * </p>
     * 
     * @return An identifier for the new game server group. This value is used to generate unique ARN identifiers for
     *         the EC2 Auto Scaling group and the GameLift FleetIQ game server group. The name must be unique per Region
     *         per AWS account.
     */
    public String gameServerGroupName() {
        return gameServerGroupName;
    }

    /**
     * <p>
     * The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>)
     * for an IAM role that allows Amazon GameLift to access your EC2 Auto Scaling groups.
     * </p>
     * 
     * @return The Amazon Resource Name (<a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) for an IAM role that
     *         allows Amazon GameLift to access your EC2 Auto Scaling groups.
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The minimum number of instances allowed in the EC2 Auto Scaling group. During automatic scaling events, GameLift
     * FleetIQ and EC2 do not scale down the group below this minimum. In production, this value should be set to at
     * least 1. After the Auto Scaling group is created, update this value directly in the Auto Scaling group using the
     * AWS console or APIs.
     * </p>
     * 
     * @return The minimum number of instances allowed in the EC2 Auto Scaling group. During automatic scaling events,
     *         GameLift FleetIQ and EC2 do not scale down the group below this minimum. In production, this value should
     *         be set to at least 1. After the Auto Scaling group is created, update this value directly in the Auto
     *         Scaling group using the AWS console or APIs.
     */
    public Integer minSize() {
        return minSize;
    }

    /**
     * <p>
     * The maximum number of instances allowed in the EC2 Auto Scaling group. During automatic scaling events, GameLift
     * FleetIQ and EC2 do not scale up the group above this maximum. After the Auto Scaling group is created, update
     * this value directly in the Auto Scaling group using the AWS console or APIs.
     * </p>
     * 
     * @return The maximum number of instances allowed in the EC2 Auto Scaling group. During automatic scaling events,
     *         GameLift FleetIQ and EC2 do not scale up the group above this maximum. After the Auto Scaling group is
     *         created, update this value directly in the Auto Scaling group using the AWS console or APIs.
     */
    public Integer maxSize() {
        return maxSize;
    }

    /**
     * <p>
     * The EC2 launch template that contains configuration settings and game server code to be deployed to all instances
     * in the game server group. You can specify the template using either the template name or ID. For help with
     * creating a launch template, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-template.html">Creating a Launch
     * Template for an Auto Scaling Group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>. After the Auto Scaling
     * group is created, update this value directly in the Auto Scaling group using the AWS console or APIs.
     * </p>
     * 
     * @return The EC2 launch template that contains configuration settings and game server code to be deployed to all
     *         instances in the game server group. You can specify the template using either the template name or ID.
     *         For help with creating a launch template, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-template.html">Creating a
     *         Launch Template for an Auto Scaling Group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>. After the
     *         Auto Scaling group is created, update this value directly in the Auto Scaling group using the AWS console
     *         or APIs.
     */
    public LaunchTemplateSpecification launchTemplate() {
        return launchTemplate;
    }

    /**
     * Returns true if the InstanceDefinitions property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasInstanceDefinitions() {
        return instanceDefinitions != null && !(instanceDefinitions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The EC2 instance types and sizes to use in the Auto Scaling group. The instance definitions must specify at least
     * two different instance types that are supported by GameLift FleetIQ. For more information on instance types, see
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">EC2 Instance Types</a> in the
     * <i>Amazon EC2 User Guide</i>. You can optionally specify capacity weighting for each instance type. If no weight
     * value is specified for an instance type, it is set to the default value "1". For more information about capacity
     * weighting, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-weighting.html">
     * Instance Weighting for Amazon EC2 Auto Scaling</a> in the Amazon EC2 Auto Scaling User Guide.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInstanceDefinitions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The EC2 instance types and sizes to use in the Auto Scaling group. The instance definitions must specify
     *         at least two different instance types that are supported by GameLift FleetIQ. For more information on
     *         instance types, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">EC2
     *         Instance Types</a> in the <i>Amazon EC2 User Guide</i>. You can optionally specify capacity weighting for
     *         each instance type. If no weight value is specified for an instance type, it is set to the default value
     *         "1". For more information about capacity weighting, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-weighting.html"> Instance
     *         Weighting for Amazon EC2 Auto Scaling</a> in the Amazon EC2 Auto Scaling User Guide.
     */
    public List<InstanceDefinition> instanceDefinitions() {
        return instanceDefinitions;
    }

    /**
     * <p>
     * Configuration settings to define a scaling policy for the Auto Scaling group that is optimized for game hosting.
     * The scaling policy uses the metric <code>"PercentUtilizedGameServers"</code> to maintain a buffer of idle game
     * servers that can immediately accommodate new games and players. After the Auto Scaling group is created, update
     * this value directly in the Auto Scaling group using the AWS console or APIs.
     * </p>
     * 
     * @return Configuration settings to define a scaling policy for the Auto Scaling group that is optimized for game
     *         hosting. The scaling policy uses the metric <code>"PercentUtilizedGameServers"</code> to maintain a
     *         buffer of idle game servers that can immediately accommodate new games and players. After the Auto
     *         Scaling group is created, update this value directly in the Auto Scaling group using the AWS console or
     *         APIs.
     */
    public GameServerGroupAutoScalingPolicy autoScalingPolicy() {
        return autoScalingPolicy;
    }

    /**
     * <p>
     * Indicates how GameLift FleetIQ balances the use of Spot Instances and On-Demand Instances in the game server
     * group. Method options include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SPOT_ONLY</code> - Only Spot Instances are used in the game server group. If Spot Instances are unavailable
     * or not viable for game hosting, the game server group provides no hosting capacity until Spot Instances can again
     * be used. Until then, no new instances are started, and the existing nonviable Spot Instances are terminated
     * (after current gameplay ends) and are not replaced.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SPOT_PREFERRED</code> - (default value) Spot Instances are used whenever available in the game server
     * group. If Spot Instances are unavailable, the game server group continues to provide hosting capacity by falling
     * back to On-Demand Instances. Existing nonviable Spot Instances are terminated (after current gameplay ends) and
     * are replaced with new On-Demand Instances.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ON_DEMAND_ONLY</code> - Only On-Demand Instances are used in the game server group. No Spot Instances are
     * used, even when available, while this balancing strategy is in force.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #balancingStrategy}
     * will return {@link BalancingStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #balancingStrategyAsString}.
     * </p>
     * 
     * @return Indicates how GameLift FleetIQ balances the use of Spot Instances and On-Demand Instances in the game
     *         server group. Method options include the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SPOT_ONLY</code> - Only Spot Instances are used in the game server group. If Spot Instances are
     *         unavailable or not viable for game hosting, the game server group provides no hosting capacity until Spot
     *         Instances can again be used. Until then, no new instances are started, and the existing nonviable Spot
     *         Instances are terminated (after current gameplay ends) and are not replaced.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SPOT_PREFERRED</code> - (default value) Spot Instances are used whenever available in the game
     *         server group. If Spot Instances are unavailable, the game server group continues to provide hosting
     *         capacity by falling back to On-Demand Instances. Existing nonviable Spot Instances are terminated (after
     *         current gameplay ends) and are replaced with new On-Demand Instances.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ON_DEMAND_ONLY</code> - Only On-Demand Instances are used in the game server group. No Spot
     *         Instances are used, even when available, while this balancing strategy is in force.
     *         </p>
     *         </li>
     * @see BalancingStrategy
     */
    public BalancingStrategy balancingStrategy() {
        return BalancingStrategy.fromValue(balancingStrategy);
    }

    /**
     * <p>
     * Indicates how GameLift FleetIQ balances the use of Spot Instances and On-Demand Instances in the game server
     * group. Method options include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SPOT_ONLY</code> - Only Spot Instances are used in the game server group. If Spot Instances are unavailable
     * or not viable for game hosting, the game server group provides no hosting capacity until Spot Instances can again
     * be used. Until then, no new instances are started, and the existing nonviable Spot Instances are terminated
     * (after current gameplay ends) and are not replaced.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SPOT_PREFERRED</code> - (default value) Spot Instances are used whenever available in the game server
     * group. If Spot Instances are unavailable, the game server group continues to provide hosting capacity by falling
     * back to On-Demand Instances. Existing nonviable Spot Instances are terminated (after current gameplay ends) and
     * are replaced with new On-Demand Instances.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ON_DEMAND_ONLY</code> - Only On-Demand Instances are used in the game server group. No Spot Instances are
     * used, even when available, while this balancing strategy is in force.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #balancingStrategy}
     * will return {@link BalancingStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #balancingStrategyAsString}.
     * </p>
     * 
     * @return Indicates how GameLift FleetIQ balances the use of Spot Instances and On-Demand Instances in the game
     *         server group. Method options include the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SPOT_ONLY</code> - Only Spot Instances are used in the game server group. If Spot Instances are
     *         unavailable or not viable for game hosting, the game server group provides no hosting capacity until Spot
     *         Instances can again be used. Until then, no new instances are started, and the existing nonviable Spot
     *         Instances are terminated (after current gameplay ends) and are not replaced.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SPOT_PREFERRED</code> - (default value) Spot Instances are used whenever available in the game
     *         server group. If Spot Instances are unavailable, the game server group continues to provide hosting
     *         capacity by falling back to On-Demand Instances. Existing nonviable Spot Instances are terminated (after
     *         current gameplay ends) and are replaced with new On-Demand Instances.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ON_DEMAND_ONLY</code> - Only On-Demand Instances are used in the game server group. No Spot
     *         Instances are used, even when available, while this balancing strategy is in force.
     *         </p>
     *         </li>
     * @see BalancingStrategy
     */
    public String balancingStrategyAsString() {
        return balancingStrategy;
    }

    /**
     * <p>
     * A flag that indicates whether instances in the game server group are protected from early termination.
     * Unprotected instances that have active game servers running might be terminated during a scale-down event,
     * causing players to be dropped from the game. Protected instances cannot be terminated while there are active game
     * servers running except in the event of a forced game server group deletion (see ). An exception to this is with
     * Spot Instances, which can be terminated by AWS regardless of protection status. This property is set to
     * <code>NO_PROTECTION</code> by default.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #gameServerProtectionPolicy} will return {@link GameServerProtectionPolicy#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #gameServerProtectionPolicyAsString}.
     * </p>
     * 
     * @return A flag that indicates whether instances in the game server group are protected from early termination.
     *         Unprotected instances that have active game servers running might be terminated during a scale-down
     *         event, causing players to be dropped from the game. Protected instances cannot be terminated while there
     *         are active game servers running except in the event of a forced game server group deletion (see ). An
     *         exception to this is with Spot Instances, which can be terminated by AWS regardless of protection status.
     *         This property is set to <code>NO_PROTECTION</code> by default.
     * @see GameServerProtectionPolicy
     */
    public GameServerProtectionPolicy gameServerProtectionPolicy() {
        return GameServerProtectionPolicy.fromValue(gameServerProtectionPolicy);
    }

    /**
     * <p>
     * A flag that indicates whether instances in the game server group are protected from early termination.
     * Unprotected instances that have active game servers running might be terminated during a scale-down event,
     * causing players to be dropped from the game. Protected instances cannot be terminated while there are active game
     * servers running except in the event of a forced game server group deletion (see ). An exception to this is with
     * Spot Instances, which can be terminated by AWS regardless of protection status. This property is set to
     * <code>NO_PROTECTION</code> by default.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #gameServerProtectionPolicy} will return {@link GameServerProtectionPolicy#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #gameServerProtectionPolicyAsString}.
     * </p>
     * 
     * @return A flag that indicates whether instances in the game server group are protected from early termination.
     *         Unprotected instances that have active game servers running might be terminated during a scale-down
     *         event, causing players to be dropped from the game. Protected instances cannot be terminated while there
     *         are active game servers running except in the event of a forced game server group deletion (see ). An
     *         exception to this is with Spot Instances, which can be terminated by AWS regardless of protection status.
     *         This property is set to <code>NO_PROTECTION</code> by default.
     * @see GameServerProtectionPolicy
     */
    public String gameServerProtectionPolicyAsString() {
        return gameServerProtectionPolicy;
    }

    /**
     * Returns true if the VpcSubnets property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasVpcSubnets() {
        return vpcSubnets != null && !(vpcSubnets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of virtual private cloud (VPC) subnets to use with instances in the game server group. By default, all
     * GameLift FleetIQ-supported Availability Zones are used. You can use this parameter to specify VPCs that you've
     * set up. This property cannot be updated after the game server group is created, and the corresponding Auto
     * Scaling group will always use the property value that is set with this request, even if the Auto Scaling group is
     * updated directly
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasVpcSubnets()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of virtual private cloud (VPC) subnets to use with instances in the game server group. By default,
     *         all GameLift FleetIQ-supported Availability Zones are used. You can use this parameter to specify VPCs
     *         that you've set up. This property cannot be updated after the game server group is created, and the
     *         corresponding Auto Scaling group will always use the property value that is set with this request, even
     *         if the Auto Scaling group is updated directly
     */
    public List<String> vpcSubnets() {
        return vpcSubnets;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of labels to assign to the new game server group resource. Tags are developer-defined key-value pairs.
     * Tagging AWS resources is useful for resource management, access management, and cost allocation. For more
     * information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging AWS
     * Resources</a> in the <i>AWS General Reference</i>. Once the resource is created, you can use <a>TagResource</a>,
     * <a>UntagResource</a>, and <a>ListTagsForResource</a> to add, remove, and view tags, respectively. The maximum tag
     * limit may be lower than stated. See the AWS General Reference for actual tagging limits.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of labels to assign to the new game server group resource. Tags are developer-defined key-value
     *         pairs. Tagging AWS resources is useful for resource management, access management, and cost allocation.
     *         For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">
     *         Tagging AWS Resources</a> in the <i>AWS General Reference</i>. Once the resource is created, you can use
     *         <a>TagResource</a>, <a>UntagResource</a>, and <a>ListTagsForResource</a> to add, remove, and view tags,
     *         respectively. The maximum tag limit may be lower than stated. See the AWS General Reference for actual
     *         tagging limits.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gameServerGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(minSize());
        hashCode = 31 * hashCode + Objects.hashCode(maxSize());
        hashCode = 31 * hashCode + Objects.hashCode(launchTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(instanceDefinitions());
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(balancingStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(gameServerProtectionPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(vpcSubnets());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGameServerGroupRequest)) {
            return false;
        }
        CreateGameServerGroupRequest other = (CreateGameServerGroupRequest) obj;
        return Objects.equals(gameServerGroupName(), other.gameServerGroupName()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(minSize(), other.minSize()) && Objects.equals(maxSize(), other.maxSize())
                && Objects.equals(launchTemplate(), other.launchTemplate())
                && Objects.equals(instanceDefinitions(), other.instanceDefinitions())
                && Objects.equals(autoScalingPolicy(), other.autoScalingPolicy())
                && Objects.equals(balancingStrategyAsString(), other.balancingStrategyAsString())
                && Objects.equals(gameServerProtectionPolicyAsString(), other.gameServerProtectionPolicyAsString())
                && Objects.equals(vpcSubnets(), other.vpcSubnets()) && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateGameServerGroupRequest").add("GameServerGroupName", gameServerGroupName())
                .add("RoleArn", roleArn()).add("MinSize", minSize()).add("MaxSize", maxSize())
                .add("LaunchTemplate", launchTemplate()).add("InstanceDefinitions", instanceDefinitions())
                .add("AutoScalingPolicy", autoScalingPolicy()).add("BalancingStrategy", balancingStrategyAsString())
                .add("GameServerProtectionPolicy", gameServerProtectionPolicyAsString()).add("VpcSubnets", vpcSubnets())
                .add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GameServerGroupName":
            return Optional.ofNullable(clazz.cast(gameServerGroupName()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "MinSize":
            return Optional.ofNullable(clazz.cast(minSize()));
        case "MaxSize":
            return Optional.ofNullable(clazz.cast(maxSize()));
        case "LaunchTemplate":
            return Optional.ofNullable(clazz.cast(launchTemplate()));
        case "InstanceDefinitions":
            return Optional.ofNullable(clazz.cast(instanceDefinitions()));
        case "AutoScalingPolicy":
            return Optional.ofNullable(clazz.cast(autoScalingPolicy()));
        case "BalancingStrategy":
            return Optional.ofNullable(clazz.cast(balancingStrategyAsString()));
        case "GameServerProtectionPolicy":
            return Optional.ofNullable(clazz.cast(gameServerProtectionPolicyAsString()));
        case "VpcSubnets":
            return Optional.ofNullable(clazz.cast(vpcSubnets()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateGameServerGroupRequest, T> g) {
        return obj -> g.apply((CreateGameServerGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateGameServerGroupRequest> {
        /**
         * <p>
         * An identifier for the new game server group. This value is used to generate unique ARN identifiers for the
         * EC2 Auto Scaling group and the GameLift FleetIQ game server group. The name must be unique per Region per AWS
         * account.
         * </p>
         * 
         * @param gameServerGroupName
         *        An identifier for the new game server group. This value is used to generate unique ARN identifiers for
         *        the EC2 Auto Scaling group and the GameLift FleetIQ game server group. The name must be unique per
         *        Region per AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameServerGroupName(String gameServerGroupName);

        /**
         * <p>
         * The Amazon Resource Name (<a
         * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) for an IAM role that
         * allows Amazon GameLift to access your EC2 Auto Scaling groups.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (<a
         *        href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) for an IAM role
         *        that allows Amazon GameLift to access your EC2 Auto Scaling groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The minimum number of instances allowed in the EC2 Auto Scaling group. During automatic scaling events,
         * GameLift FleetIQ and EC2 do not scale down the group below this minimum. In production, this value should be
         * set to at least 1. After the Auto Scaling group is created, update this value directly in the Auto Scaling
         * group using the AWS console or APIs.
         * </p>
         * 
         * @param minSize
         *        The minimum number of instances allowed in the EC2 Auto Scaling group. During automatic scaling
         *        events, GameLift FleetIQ and EC2 do not scale down the group below this minimum. In production, this
         *        value should be set to at least 1. After the Auto Scaling group is created, update this value directly
         *        in the Auto Scaling group using the AWS console or APIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minSize(Integer minSize);

        /**
         * <p>
         * The maximum number of instances allowed in the EC2 Auto Scaling group. During automatic scaling events,
         * GameLift FleetIQ and EC2 do not scale up the group above this maximum. After the Auto Scaling group is
         * created, update this value directly in the Auto Scaling group using the AWS console or APIs.
         * </p>
         * 
         * @param maxSize
         *        The maximum number of instances allowed in the EC2 Auto Scaling group. During automatic scaling
         *        events, GameLift FleetIQ and EC2 do not scale up the group above this maximum. After the Auto Scaling
         *        group is created, update this value directly in the Auto Scaling group using the AWS console or APIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxSize(Integer maxSize);

        /**
         * <p>
         * The EC2 launch template that contains configuration settings and game server code to be deployed to all
         * instances in the game server group. You can specify the template using either the template name or ID. For
         * help with creating a launch template, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-template.html">Creating a Launch
         * Template for an Auto Scaling Group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>. After the Auto
         * Scaling group is created, update this value directly in the Auto Scaling group using the AWS console or APIs.
         * </p>
         * 
         * @param launchTemplate
         *        The EC2 launch template that contains configuration settings and game server code to be deployed to
         *        all instances in the game server group. You can specify the template using either the template name or
         *        ID. For help with creating a launch template, see <a
         *        href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-template.html">Creating a
         *        Launch Template for an Auto Scaling Group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>. After
         *        the Auto Scaling group is created, update this value directly in the Auto Scaling group using the AWS
         *        console or APIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplate(LaunchTemplateSpecification launchTemplate);

        /**
         * <p>
         * The EC2 launch template that contains configuration settings and game server code to be deployed to all
         * instances in the game server group. You can specify the template using either the template name or ID. For
         * help with creating a launch template, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-template.html">Creating a Launch
         * Template for an Auto Scaling Group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>. After the Auto
         * Scaling group is created, update this value directly in the Auto Scaling group using the AWS console or APIs.
         * </p>
         * This is a convenience that creates an instance of the {@link LaunchTemplateSpecification.Builder} avoiding
         * the need to create one manually via {@link LaunchTemplateSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link LaunchTemplateSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #launchTemplate(LaunchTemplateSpecification)}.
         * 
         * @param launchTemplate
         *        a consumer that will call methods on {@link LaunchTemplateSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchTemplate(LaunchTemplateSpecification)
         */
        default Builder launchTemplate(Consumer<LaunchTemplateSpecification.Builder> launchTemplate) {
            return launchTemplate(LaunchTemplateSpecification.builder().applyMutation(launchTemplate).build());
        }

        /**
         * <p>
         * The EC2 instance types and sizes to use in the Auto Scaling group. The instance definitions must specify at
         * least two different instance types that are supported by GameLift FleetIQ. For more information on instance
         * types, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">EC2 Instance
         * Types</a> in the <i>Amazon EC2 User Guide</i>. You can optionally specify capacity weighting for each
         * instance type. If no weight value is specified for an instance type, it is set to the default value "1". For
         * more information about capacity weighting, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-weighting.html"> Instance Weighting
         * for Amazon EC2 Auto Scaling</a> in the Amazon EC2 Auto Scaling User Guide.
         * </p>
         * 
         * @param instanceDefinitions
         *        The EC2 instance types and sizes to use in the Auto Scaling group. The instance definitions must
         *        specify at least two different instance types that are supported by GameLift FleetIQ. For more
         *        information on instance types, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">EC2 Instance Types</a>
         *        in the <i>Amazon EC2 User Guide</i>. You can optionally specify capacity weighting for each instance
         *        type. If no weight value is specified for an instance type, it is set to the default value "1". For
         *        more information about capacity weighting, see <a
         *        href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-weighting.html"> Instance
         *        Weighting for Amazon EC2 Auto Scaling</a> in the Amazon EC2 Auto Scaling User Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceDefinitions(Collection<InstanceDefinition> instanceDefinitions);

        /**
         * <p>
         * The EC2 instance types and sizes to use in the Auto Scaling group. The instance definitions must specify at
         * least two different instance types that are supported by GameLift FleetIQ. For more information on instance
         * types, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">EC2 Instance
         * Types</a> in the <i>Amazon EC2 User Guide</i>. You can optionally specify capacity weighting for each
         * instance type. If no weight value is specified for an instance type, it is set to the default value "1". For
         * more information about capacity weighting, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-weighting.html"> Instance Weighting
         * for Amazon EC2 Auto Scaling</a> in the Amazon EC2 Auto Scaling User Guide.
         * </p>
         * 
         * @param instanceDefinitions
         *        The EC2 instance types and sizes to use in the Auto Scaling group. The instance definitions must
         *        specify at least two different instance types that are supported by GameLift FleetIQ. For more
         *        information on instance types, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">EC2 Instance Types</a>
         *        in the <i>Amazon EC2 User Guide</i>. You can optionally specify capacity weighting for each instance
         *        type. If no weight value is specified for an instance type, it is set to the default value "1". For
         *        more information about capacity weighting, see <a
         *        href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-weighting.html"> Instance
         *        Weighting for Amazon EC2 Auto Scaling</a> in the Amazon EC2 Auto Scaling User Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceDefinitions(InstanceDefinition... instanceDefinitions);

        /**
         * <p>
         * The EC2 instance types and sizes to use in the Auto Scaling group. The instance definitions must specify at
         * least two different instance types that are supported by GameLift FleetIQ. For more information on instance
         * types, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">EC2 Instance
         * Types</a> in the <i>Amazon EC2 User Guide</i>. You can optionally specify capacity weighting for each
         * instance type. If no weight value is specified for an instance type, it is set to the default value "1". For
         * more information about capacity weighting, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-weighting.html"> Instance Weighting
         * for Amazon EC2 Auto Scaling</a> in the Amazon EC2 Auto Scaling User Guide.
         * </p>
         * This is a convenience that creates an instance of the {@link List<InstanceDefinition>.Builder} avoiding the
         * need to create one manually via {@link List<InstanceDefinition>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InstanceDefinition>.Builder#build()} is called immediately
         * and its result is passed to {@link #instanceDefinitions(List<InstanceDefinition>)}.
         * 
         * @param instanceDefinitions
         *        a consumer that will call methods on {@link List<InstanceDefinition>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceDefinitions(List<InstanceDefinition>)
         */
        Builder instanceDefinitions(Consumer<InstanceDefinition.Builder>... instanceDefinitions);

        /**
         * <p>
         * Configuration settings to define a scaling policy for the Auto Scaling group that is optimized for game
         * hosting. The scaling policy uses the metric <code>"PercentUtilizedGameServers"</code> to maintain a buffer of
         * idle game servers that can immediately accommodate new games and players. After the Auto Scaling group is
         * created, update this value directly in the Auto Scaling group using the AWS console or APIs.
         * </p>
         * 
         * @param autoScalingPolicy
         *        Configuration settings to define a scaling policy for the Auto Scaling group that is optimized for
         *        game hosting. The scaling policy uses the metric <code>"PercentUtilizedGameServers"</code> to maintain
         *        a buffer of idle game servers that can immediately accommodate new games and players. After the Auto
         *        Scaling group is created, update this value directly in the Auto Scaling group using the AWS console
         *        or APIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingPolicy(GameServerGroupAutoScalingPolicy autoScalingPolicy);

        /**
         * <p>
         * Configuration settings to define a scaling policy for the Auto Scaling group that is optimized for game
         * hosting. The scaling policy uses the metric <code>"PercentUtilizedGameServers"</code> to maintain a buffer of
         * idle game servers that can immediately accommodate new games and players. After the Auto Scaling group is
         * created, update this value directly in the Auto Scaling group using the AWS console or APIs.
         * </p>
         * This is a convenience that creates an instance of the {@link GameServerGroupAutoScalingPolicy.Builder}
         * avoiding the need to create one manually via {@link GameServerGroupAutoScalingPolicy#builder()}.
         *
         * When the {@link Consumer} completes, {@link GameServerGroupAutoScalingPolicy.Builder#build()} is called
         * immediately and its result is passed to {@link #autoScalingPolicy(GameServerGroupAutoScalingPolicy)}.
         * 
         * @param autoScalingPolicy
         *        a consumer that will call methods on {@link GameServerGroupAutoScalingPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoScalingPolicy(GameServerGroupAutoScalingPolicy)
         */
        default Builder autoScalingPolicy(Consumer<GameServerGroupAutoScalingPolicy.Builder> autoScalingPolicy) {
            return autoScalingPolicy(GameServerGroupAutoScalingPolicy.builder().applyMutation(autoScalingPolicy).build());
        }

        /**
         * <p>
         * Indicates how GameLift FleetIQ balances the use of Spot Instances and On-Demand Instances in the game server
         * group. Method options include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SPOT_ONLY</code> - Only Spot Instances are used in the game server group. If Spot Instances are
         * unavailable or not viable for game hosting, the game server group provides no hosting capacity until Spot
         * Instances can again be used. Until then, no new instances are started, and the existing nonviable Spot
         * Instances are terminated (after current gameplay ends) and are not replaced.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SPOT_PREFERRED</code> - (default value) Spot Instances are used whenever available in the game server
         * group. If Spot Instances are unavailable, the game server group continues to provide hosting capacity by
         * falling back to On-Demand Instances. Existing nonviable Spot Instances are terminated (after current gameplay
         * ends) and are replaced with new On-Demand Instances.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ON_DEMAND_ONLY</code> - Only On-Demand Instances are used in the game server group. No Spot Instances
         * are used, even when available, while this balancing strategy is in force.
         * </p>
         * </li>
         * </ul>
         * 
         * @param balancingStrategy
         *        Indicates how GameLift FleetIQ balances the use of Spot Instances and On-Demand Instances in the game
         *        server group. Method options include the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SPOT_ONLY</code> - Only Spot Instances are used in the game server group. If Spot Instances are
         *        unavailable or not viable for game hosting, the game server group provides no hosting capacity until
         *        Spot Instances can again be used. Until then, no new instances are started, and the existing nonviable
         *        Spot Instances are terminated (after current gameplay ends) and are not replaced.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SPOT_PREFERRED</code> - (default value) Spot Instances are used whenever available in the game
         *        server group. If Spot Instances are unavailable, the game server group continues to provide hosting
         *        capacity by falling back to On-Demand Instances. Existing nonviable Spot Instances are terminated
         *        (after current gameplay ends) and are replaced with new On-Demand Instances.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ON_DEMAND_ONLY</code> - Only On-Demand Instances are used in the game server group. No Spot
         *        Instances are used, even when available, while this balancing strategy is in force.
         *        </p>
         *        </li>
         * @see BalancingStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BalancingStrategy
         */
        Builder balancingStrategy(String balancingStrategy);

        /**
         * <p>
         * Indicates how GameLift FleetIQ balances the use of Spot Instances and On-Demand Instances in the game server
         * group. Method options include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SPOT_ONLY</code> - Only Spot Instances are used in the game server group. If Spot Instances are
         * unavailable or not viable for game hosting, the game server group provides no hosting capacity until Spot
         * Instances can again be used. Until then, no new instances are started, and the existing nonviable Spot
         * Instances are terminated (after current gameplay ends) and are not replaced.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SPOT_PREFERRED</code> - (default value) Spot Instances are used whenever available in the game server
         * group. If Spot Instances are unavailable, the game server group continues to provide hosting capacity by
         * falling back to On-Demand Instances. Existing nonviable Spot Instances are terminated (after current gameplay
         * ends) and are replaced with new On-Demand Instances.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ON_DEMAND_ONLY</code> - Only On-Demand Instances are used in the game server group. No Spot Instances
         * are used, even when available, while this balancing strategy is in force.
         * </p>
         * </li>
         * </ul>
         * 
         * @param balancingStrategy
         *        Indicates how GameLift FleetIQ balances the use of Spot Instances and On-Demand Instances in the game
         *        server group. Method options include the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SPOT_ONLY</code> - Only Spot Instances are used in the game server group. If Spot Instances are
         *        unavailable or not viable for game hosting, the game server group provides no hosting capacity until
         *        Spot Instances can again be used. Until then, no new instances are started, and the existing nonviable
         *        Spot Instances are terminated (after current gameplay ends) and are not replaced.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SPOT_PREFERRED</code> - (default value) Spot Instances are used whenever available in the game
         *        server group. If Spot Instances are unavailable, the game server group continues to provide hosting
         *        capacity by falling back to On-Demand Instances. Existing nonviable Spot Instances are terminated
         *        (after current gameplay ends) and are replaced with new On-Demand Instances.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ON_DEMAND_ONLY</code> - Only On-Demand Instances are used in the game server group. No Spot
         *        Instances are used, even when available, while this balancing strategy is in force.
         *        </p>
         *        </li>
         * @see BalancingStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BalancingStrategy
         */
        Builder balancingStrategy(BalancingStrategy balancingStrategy);

        /**
         * <p>
         * A flag that indicates whether instances in the game server group are protected from early termination.
         * Unprotected instances that have active game servers running might be terminated during a scale-down event,
         * causing players to be dropped from the game. Protected instances cannot be terminated while there are active
         * game servers running except in the event of a forced game server group deletion (see ). An exception to this
         * is with Spot Instances, which can be terminated by AWS regardless of protection status. This property is set
         * to <code>NO_PROTECTION</code> by default.
         * </p>
         * 
         * @param gameServerProtectionPolicy
         *        A flag that indicates whether instances in the game server group are protected from early termination.
         *        Unprotected instances that have active game servers running might be terminated during a scale-down
         *        event, causing players to be dropped from the game. Protected instances cannot be terminated while
         *        there are active game servers running except in the event of a forced game server group deletion (see
         *        ). An exception to this is with Spot Instances, which can be terminated by AWS regardless of
         *        protection status. This property is set to <code>NO_PROTECTION</code> by default.
         * @see GameServerProtectionPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GameServerProtectionPolicy
         */
        Builder gameServerProtectionPolicy(String gameServerProtectionPolicy);

        /**
         * <p>
         * A flag that indicates whether instances in the game server group are protected from early termination.
         * Unprotected instances that have active game servers running might be terminated during a scale-down event,
         * causing players to be dropped from the game. Protected instances cannot be terminated while there are active
         * game servers running except in the event of a forced game server group deletion (see ). An exception to this
         * is with Spot Instances, which can be terminated by AWS regardless of protection status. This property is set
         * to <code>NO_PROTECTION</code> by default.
         * </p>
         * 
         * @param gameServerProtectionPolicy
         *        A flag that indicates whether instances in the game server group are protected from early termination.
         *        Unprotected instances that have active game servers running might be terminated during a scale-down
         *        event, causing players to be dropped from the game. Protected instances cannot be terminated while
         *        there are active game servers running except in the event of a forced game server group deletion (see
         *        ). An exception to this is with Spot Instances, which can be terminated by AWS regardless of
         *        protection status. This property is set to <code>NO_PROTECTION</code> by default.
         * @see GameServerProtectionPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GameServerProtectionPolicy
         */
        Builder gameServerProtectionPolicy(GameServerProtectionPolicy gameServerProtectionPolicy);

        /**
         * <p>
         * A list of virtual private cloud (VPC) subnets to use with instances in the game server group. By default, all
         * GameLift FleetIQ-supported Availability Zones are used. You can use this parameter to specify VPCs that
         * you've set up. This property cannot be updated after the game server group is created, and the corresponding
         * Auto Scaling group will always use the property value that is set with this request, even if the Auto Scaling
         * group is updated directly
         * </p>
         * 
         * @param vpcSubnets
         *        A list of virtual private cloud (VPC) subnets to use with instances in the game server group. By
         *        default, all GameLift FleetIQ-supported Availability Zones are used. You can use this parameter to
         *        specify VPCs that you've set up. This property cannot be updated after the game server group is
         *        created, and the corresponding Auto Scaling group will always use the property value that is set with
         *        this request, even if the Auto Scaling group is updated directly
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSubnets(Collection<String> vpcSubnets);

        /**
         * <p>
         * A list of virtual private cloud (VPC) subnets to use with instances in the game server group. By default, all
         * GameLift FleetIQ-supported Availability Zones are used. You can use this parameter to specify VPCs that
         * you've set up. This property cannot be updated after the game server group is created, and the corresponding
         * Auto Scaling group will always use the property value that is set with this request, even if the Auto Scaling
         * group is updated directly
         * </p>
         * 
         * @param vpcSubnets
         *        A list of virtual private cloud (VPC) subnets to use with instances in the game server group. By
         *        default, all GameLift FleetIQ-supported Availability Zones are used. You can use this parameter to
         *        specify VPCs that you've set up. This property cannot be updated after the game server group is
         *        created, and the corresponding Auto Scaling group will always use the property value that is set with
         *        this request, even if the Auto Scaling group is updated directly
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSubnets(String... vpcSubnets);

        /**
         * <p>
         * A list of labels to assign to the new game server group resource. Tags are developer-defined key-value pairs.
         * Tagging AWS resources is useful for resource management, access management, and cost allocation. For more
         * information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging AWS
         * Resources</a> in the <i>AWS General Reference</i>. Once the resource is created, you can use
         * <a>TagResource</a>, <a>UntagResource</a>, and <a>ListTagsForResource</a> to add, remove, and view tags,
         * respectively. The maximum tag limit may be lower than stated. See the AWS General Reference for actual
         * tagging limits.
         * </p>
         * 
         * @param tags
         *        A list of labels to assign to the new game server group resource. Tags are developer-defined key-value
         *        pairs. Tagging AWS resources is useful for resource management, access management, and cost
         *        allocation. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging AWS Resources</a> in
         *        the <i>AWS General Reference</i>. Once the resource is created, you can use <a>TagResource</a>,
         *        <a>UntagResource</a>, and <a>ListTagsForResource</a> to add, remove, and view tags, respectively. The
         *        maximum tag limit may be lower than stated. See the AWS General Reference for actual tagging limits.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of labels to assign to the new game server group resource. Tags are developer-defined key-value pairs.
         * Tagging AWS resources is useful for resource management, access management, and cost allocation. For more
         * information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging AWS
         * Resources</a> in the <i>AWS General Reference</i>. Once the resource is created, you can use
         * <a>TagResource</a>, <a>UntagResource</a>, and <a>ListTagsForResource</a> to add, remove, and view tags,
         * respectively. The maximum tag limit may be lower than stated. See the AWS General Reference for actual
         * tagging limits.
         * </p>
         * 
         * @param tags
         *        A list of labels to assign to the new game server group resource. Tags are developer-defined key-value
         *        pairs. Tagging AWS resources is useful for resource management, access management, and cost
         *        allocation. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging AWS Resources</a> in
         *        the <i>AWS General Reference</i>. Once the resource is created, you can use <a>TagResource</a>,
         *        <a>UntagResource</a>, and <a>ListTagsForResource</a> to add, remove, and view tags, respectively. The
         *        maximum tag limit may be lower than stated. See the AWS General Reference for actual tagging limits.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of labels to assign to the new game server group resource. Tags are developer-defined key-value pairs.
         * Tagging AWS resources is useful for resource management, access management, and cost allocation. For more
         * information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging AWS
         * Resources</a> in the <i>AWS General Reference</i>. Once the resource is created, you can use
         * <a>TagResource</a>, <a>UntagResource</a>, and <a>ListTagsForResource</a> to add, remove, and view tags,
         * respectively. The maximum tag limit may be lower than stated. See the AWS General Reference for actual
         * tagging limits.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GameLiftRequest.BuilderImpl implements Builder {
        private String gameServerGroupName;

        private String roleArn;

        private Integer minSize;

        private Integer maxSize;

        private LaunchTemplateSpecification launchTemplate;

        private List<InstanceDefinition> instanceDefinitions = DefaultSdkAutoConstructList.getInstance();

        private GameServerGroupAutoScalingPolicy autoScalingPolicy;

        private String balancingStrategy;

        private String gameServerProtectionPolicy;

        private List<String> vpcSubnets = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGameServerGroupRequest model) {
            super(model);
            gameServerGroupName(model.gameServerGroupName);
            roleArn(model.roleArn);
            minSize(model.minSize);
            maxSize(model.maxSize);
            launchTemplate(model.launchTemplate);
            instanceDefinitions(model.instanceDefinitions);
            autoScalingPolicy(model.autoScalingPolicy);
            balancingStrategy(model.balancingStrategy);
            gameServerProtectionPolicy(model.gameServerProtectionPolicy);
            vpcSubnets(model.vpcSubnets);
            tags(model.tags);
        }

        public final String getGameServerGroupName() {
            return gameServerGroupName;
        }

        @Override
        public final Builder gameServerGroupName(String gameServerGroupName) {
            this.gameServerGroupName = gameServerGroupName;
            return this;
        }

        public final void setGameServerGroupName(String gameServerGroupName) {
            this.gameServerGroupName = gameServerGroupName;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final Integer getMinSize() {
            return minSize;
        }

        @Override
        public final Builder minSize(Integer minSize) {
            this.minSize = minSize;
            return this;
        }

        public final void setMinSize(Integer minSize) {
            this.minSize = minSize;
        }

        public final Integer getMaxSize() {
            return maxSize;
        }

        @Override
        public final Builder maxSize(Integer maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public final void setMaxSize(Integer maxSize) {
            this.maxSize = maxSize;
        }

        public final LaunchTemplateSpecification.Builder getLaunchTemplate() {
            return launchTemplate != null ? launchTemplate.toBuilder() : null;
        }

        @Override
        public final Builder launchTemplate(LaunchTemplateSpecification launchTemplate) {
            this.launchTemplate = launchTemplate;
            return this;
        }

        public final void setLaunchTemplate(LaunchTemplateSpecification.BuilderImpl launchTemplate) {
            this.launchTemplate = launchTemplate != null ? launchTemplate.build() : null;
        }

        public final Collection<InstanceDefinition.Builder> getInstanceDefinitions() {
            return instanceDefinitions != null ? instanceDefinitions.stream().map(InstanceDefinition::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instanceDefinitions(Collection<InstanceDefinition> instanceDefinitions) {
            this.instanceDefinitions = InstanceDefinitionsCopier.copy(instanceDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceDefinitions(InstanceDefinition... instanceDefinitions) {
            instanceDefinitions(Arrays.asList(instanceDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceDefinitions(Consumer<InstanceDefinition.Builder>... instanceDefinitions) {
            instanceDefinitions(Stream.of(instanceDefinitions).map(c -> InstanceDefinition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setInstanceDefinitions(Collection<InstanceDefinition.BuilderImpl> instanceDefinitions) {
            this.instanceDefinitions = InstanceDefinitionsCopier.copyFromBuilder(instanceDefinitions);
        }

        public final GameServerGroupAutoScalingPolicy.Builder getAutoScalingPolicy() {
            return autoScalingPolicy != null ? autoScalingPolicy.toBuilder() : null;
        }

        @Override
        public final Builder autoScalingPolicy(GameServerGroupAutoScalingPolicy autoScalingPolicy) {
            this.autoScalingPolicy = autoScalingPolicy;
            return this;
        }

        public final void setAutoScalingPolicy(GameServerGroupAutoScalingPolicy.BuilderImpl autoScalingPolicy) {
            this.autoScalingPolicy = autoScalingPolicy != null ? autoScalingPolicy.build() : null;
        }

        public final String getBalancingStrategy() {
            return balancingStrategy;
        }

        @Override
        public final Builder balancingStrategy(String balancingStrategy) {
            this.balancingStrategy = balancingStrategy;
            return this;
        }

        @Override
        public final Builder balancingStrategy(BalancingStrategy balancingStrategy) {
            this.balancingStrategy(balancingStrategy == null ? null : balancingStrategy.toString());
            return this;
        }

        public final void setBalancingStrategy(String balancingStrategy) {
            this.balancingStrategy = balancingStrategy;
        }

        public final String getGameServerProtectionPolicy() {
            return gameServerProtectionPolicy;
        }

        @Override
        public final Builder gameServerProtectionPolicy(String gameServerProtectionPolicy) {
            this.gameServerProtectionPolicy = gameServerProtectionPolicy;
            return this;
        }

        @Override
        public final Builder gameServerProtectionPolicy(GameServerProtectionPolicy gameServerProtectionPolicy) {
            this.gameServerProtectionPolicy(gameServerProtectionPolicy == null ? null : gameServerProtectionPolicy.toString());
            return this;
        }

        public final void setGameServerProtectionPolicy(String gameServerProtectionPolicy) {
            this.gameServerProtectionPolicy = gameServerProtectionPolicy;
        }

        public final Collection<String> getVpcSubnets() {
            return vpcSubnets;
        }

        @Override
        public final Builder vpcSubnets(Collection<String> vpcSubnets) {
            this.vpcSubnets = VpcSubnetsCopier.copy(vpcSubnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSubnets(String... vpcSubnets) {
            vpcSubnets(Arrays.asList(vpcSubnets));
            return this;
        }

        public final void setVpcSubnets(Collection<String> vpcSubnets) {
            this.vpcSubnets = VpcSubnetsCopier.copy(vpcSubnets);
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateGameServerGroupRequest build() {
            return new CreateGameServerGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
