/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input for a request operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateGameSessionQueueRequest extends GameLiftRequest implements
        ToCopyableBuilder<CreateGameSessionQueueRequest.Builder, CreateGameSessionQueueRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateGameSessionQueueRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Integer> TIMEOUT_IN_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TimeoutInSeconds").getter(getter(CreateGameSessionQueueRequest::timeoutInSeconds))
            .setter(setter(Builder::timeoutInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeoutInSeconds").build()).build();

    private static final SdkField<List<PlayerLatencyPolicy>> PLAYER_LATENCY_POLICIES_FIELD = SdkField
            .<List<PlayerLatencyPolicy>> builder(MarshallingType.LIST)
            .memberName("PlayerLatencyPolicies")
            .getter(getter(CreateGameSessionQueueRequest::playerLatencyPolicies))
            .setter(setter(Builder::playerLatencyPolicies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlayerLatencyPolicies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PlayerLatencyPolicy> builder(MarshallingType.SDK_POJO)
                                            .constructor(PlayerLatencyPolicy::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<GameSessionQueueDestination>> DESTINATIONS_FIELD = SdkField
            .<List<GameSessionQueueDestination>> builder(MarshallingType.LIST)
            .memberName("Destinations")
            .getter(getter(CreateGameSessionQueueRequest::destinations))
            .setter(setter(Builder::destinations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destinations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GameSessionQueueDestination> builder(MarshallingType.SDK_POJO)
                                            .constructor(GameSessionQueueDestination::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateGameSessionQueueRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            TIMEOUT_IN_SECONDS_FIELD, PLAYER_LATENCY_POLICIES_FIELD, DESTINATIONS_FIELD, TAGS_FIELD));

    private final String name;

    private final Integer timeoutInSeconds;

    private final List<PlayerLatencyPolicy> playerLatencyPolicies;

    private final List<GameSessionQueueDestination> destinations;

    private final List<Tag> tags;

    private CreateGameSessionQueueRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.timeoutInSeconds = builder.timeoutInSeconds;
        this.playerLatencyPolicies = builder.playerLatencyPolicies;
        this.destinations = builder.destinations;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A descriptive label that is associated with game session queue. Queue names must be unique within each Region.
     * </p>
     * 
     * @return A descriptive label that is associated with game session queue. Queue names must be unique within each
     *         Region.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The maximum time, in seconds, that a new game session placement request remains in the queue. When a request
     * exceeds this time, the game session placement changes to a <code>TIMED_OUT</code> status.
     * </p>
     * 
     * @return The maximum time, in seconds, that a new game session placement request remains in the queue. When a
     *         request exceeds this time, the game session placement changes to a <code>TIMED_OUT</code> status.
     */
    public Integer timeoutInSeconds() {
        return timeoutInSeconds;
    }

    /**
     * Returns true if the PlayerLatencyPolicies property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasPlayerLatencyPolicies() {
        return playerLatencyPolicies != null && !(playerLatencyPolicies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A collection of latency policies to apply when processing game sessions placement requests with player latency
     * information. Multiple policies are evaluated in order of the maximum latency value, starting with the lowest
     * latency values. With just one policy, the policy is enforced at the start of the game session placement for the
     * duration period. With multiple policies, each policy is enforced consecutively for its duration period. For
     * example, a queue might enforce a 60-second policy followed by a 120-second policy, and then no policy for the
     * remainder of the placement. A player latency policy must set a value for
     * <code>MaximumIndividualPlayerLatencyMilliseconds</code>. If none is set, this API request fails.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPlayerLatencyPolicies()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A collection of latency policies to apply when processing game sessions placement requests with player
     *         latency information. Multiple policies are evaluated in order of the maximum latency value, starting with
     *         the lowest latency values. With just one policy, the policy is enforced at the start of the game session
     *         placement for the duration period. With multiple policies, each policy is enforced consecutively for its
     *         duration period. For example, a queue might enforce a 60-second policy followed by a 120-second policy,
     *         and then no policy for the remainder of the placement. A player latency policy must set a value for
     *         <code>MaximumIndividualPlayerLatencyMilliseconds</code>. If none is set, this API request fails.
     */
    public List<PlayerLatencyPolicy> playerLatencyPolicies() {
        return playerLatencyPolicies;
    }

    /**
     * Returns true if the Destinations property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasDestinations() {
        return destinations != null && !(destinations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of fleets that can be used to fulfill game session placement requests in the queue. Fleets are identified
     * by either a fleet ARN or a fleet alias ARN. Destinations are listed in default preference order.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDestinations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of fleets that can be used to fulfill game session placement requests in the queue. Fleets are
     *         identified by either a fleet ARN or a fleet alias ARN. Destinations are listed in default preference
     *         order.
     */
    public List<GameSessionQueueDestination> destinations() {
        return destinations;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of labels to assign to the new game session queue resource. Tags are developer-defined key-value pairs.
     * Tagging AWS resources are useful for resource management, access management and cost allocation. For more
     * information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging AWS
     * Resources</a> in the <i>AWS General Reference</i>. Once the resource is created, you can use <a>TagResource</a>,
     * <a>UntagResource</a>, and <a>ListTagsForResource</a> to add, remove, and view tags. The maximum tag limit may be
     * lower than stated. See the AWS General Reference for actual tagging limits.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of labels to assign to the new game session queue resource. Tags are developer-defined key-value
     *         pairs. Tagging AWS resources are useful for resource management, access management and cost allocation.
     *         For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">
     *         Tagging AWS Resources</a> in the <i>AWS General Reference</i>. Once the resource is created, you can use
     *         <a>TagResource</a>, <a>UntagResource</a>, and <a>ListTagsForResource</a> to add, remove, and view tags.
     *         The maximum tag limit may be lower than stated. See the AWS General Reference for actual tagging limits.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(timeoutInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(playerLatencyPolicies());
        hashCode = 31 * hashCode + Objects.hashCode(destinations());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGameSessionQueueRequest)) {
            return false;
        }
        CreateGameSessionQueueRequest other = (CreateGameSessionQueueRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(timeoutInSeconds(), other.timeoutInSeconds())
                && Objects.equals(playerLatencyPolicies(), other.playerLatencyPolicies())
                && Objects.equals(destinations(), other.destinations()) && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateGameSessionQueueRequest").add("Name", name()).add("TimeoutInSeconds", timeoutInSeconds())
                .add("PlayerLatencyPolicies", playerLatencyPolicies()).add("Destinations", destinations()).add("Tags", tags())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "TimeoutInSeconds":
            return Optional.ofNullable(clazz.cast(timeoutInSeconds()));
        case "PlayerLatencyPolicies":
            return Optional.ofNullable(clazz.cast(playerLatencyPolicies()));
        case "Destinations":
            return Optional.ofNullable(clazz.cast(destinations()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateGameSessionQueueRequest, T> g) {
        return obj -> g.apply((CreateGameSessionQueueRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateGameSessionQueueRequest> {
        /**
         * <p>
         * A descriptive label that is associated with game session queue. Queue names must be unique within each
         * Region.
         * </p>
         * 
         * @param name
         *        A descriptive label that is associated with game session queue. Queue names must be unique within each
         *        Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The maximum time, in seconds, that a new game session placement request remains in the queue. When a request
         * exceeds this time, the game session placement changes to a <code>TIMED_OUT</code> status.
         * </p>
         * 
         * @param timeoutInSeconds
         *        The maximum time, in seconds, that a new game session placement request remains in the queue. When a
         *        request exceeds this time, the game session placement changes to a <code>TIMED_OUT</code> status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutInSeconds(Integer timeoutInSeconds);

        /**
         * <p>
         * A collection of latency policies to apply when processing game sessions placement requests with player
         * latency information. Multiple policies are evaluated in order of the maximum latency value, starting with the
         * lowest latency values. With just one policy, the policy is enforced at the start of the game session
         * placement for the duration period. With multiple policies, each policy is enforced consecutively for its
         * duration period. For example, a queue might enforce a 60-second policy followed by a 120-second policy, and
         * then no policy for the remainder of the placement. A player latency policy must set a value for
         * <code>MaximumIndividualPlayerLatencyMilliseconds</code>. If none is set, this API request fails.
         * </p>
         * 
         * @param playerLatencyPolicies
         *        A collection of latency policies to apply when processing game sessions placement requests with player
         *        latency information. Multiple policies are evaluated in order of the maximum latency value, starting
         *        with the lowest latency values. With just one policy, the policy is enforced at the start of the game
         *        session placement for the duration period. With multiple policies, each policy is enforced
         *        consecutively for its duration period. For example, a queue might enforce a 60-second policy followed
         *        by a 120-second policy, and then no policy for the remainder of the placement. A player latency policy
         *        must set a value for <code>MaximumIndividualPlayerLatencyMilliseconds</code>. If none is set, this API
         *        request fails.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder playerLatencyPolicies(Collection<PlayerLatencyPolicy> playerLatencyPolicies);

        /**
         * <p>
         * A collection of latency policies to apply when processing game sessions placement requests with player
         * latency information. Multiple policies are evaluated in order of the maximum latency value, starting with the
         * lowest latency values. With just one policy, the policy is enforced at the start of the game session
         * placement for the duration period. With multiple policies, each policy is enforced consecutively for its
         * duration period. For example, a queue might enforce a 60-second policy followed by a 120-second policy, and
         * then no policy for the remainder of the placement. A player latency policy must set a value for
         * <code>MaximumIndividualPlayerLatencyMilliseconds</code>. If none is set, this API request fails.
         * </p>
         * 
         * @param playerLatencyPolicies
         *        A collection of latency policies to apply when processing game sessions placement requests with player
         *        latency information. Multiple policies are evaluated in order of the maximum latency value, starting
         *        with the lowest latency values. With just one policy, the policy is enforced at the start of the game
         *        session placement for the duration period. With multiple policies, each policy is enforced
         *        consecutively for its duration period. For example, a queue might enforce a 60-second policy followed
         *        by a 120-second policy, and then no policy for the remainder of the placement. A player latency policy
         *        must set a value for <code>MaximumIndividualPlayerLatencyMilliseconds</code>. If none is set, this API
         *        request fails.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder playerLatencyPolicies(PlayerLatencyPolicy... playerLatencyPolicies);

        /**
         * <p>
         * A collection of latency policies to apply when processing game sessions placement requests with player
         * latency information. Multiple policies are evaluated in order of the maximum latency value, starting with the
         * lowest latency values. With just one policy, the policy is enforced at the start of the game session
         * placement for the duration period. With multiple policies, each policy is enforced consecutively for its
         * duration period. For example, a queue might enforce a 60-second policy followed by a 120-second policy, and
         * then no policy for the remainder of the placement. A player latency policy must set a value for
         * <code>MaximumIndividualPlayerLatencyMilliseconds</code>. If none is set, this API request fails.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PlayerLatencyPolicy>.Builder} avoiding the
         * need to create one manually via {@link List<PlayerLatencyPolicy>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PlayerLatencyPolicy>.Builder#build()} is called immediately
         * and its result is passed to {@link #playerLatencyPolicies(List<PlayerLatencyPolicy>)}.
         * 
         * @param playerLatencyPolicies
         *        a consumer that will call methods on {@link List<PlayerLatencyPolicy>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #playerLatencyPolicies(List<PlayerLatencyPolicy>)
         */
        Builder playerLatencyPolicies(Consumer<PlayerLatencyPolicy.Builder>... playerLatencyPolicies);

        /**
         * <p>
         * A list of fleets that can be used to fulfill game session placement requests in the queue. Fleets are
         * identified by either a fleet ARN or a fleet alias ARN. Destinations are listed in default preference order.
         * </p>
         * 
         * @param destinations
         *        A list of fleets that can be used to fulfill game session placement requests in the queue. Fleets are
         *        identified by either a fleet ARN or a fleet alias ARN. Destinations are listed in default preference
         *        order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinations(Collection<GameSessionQueueDestination> destinations);

        /**
         * <p>
         * A list of fleets that can be used to fulfill game session placement requests in the queue. Fleets are
         * identified by either a fleet ARN or a fleet alias ARN. Destinations are listed in default preference order.
         * </p>
         * 
         * @param destinations
         *        A list of fleets that can be used to fulfill game session placement requests in the queue. Fleets are
         *        identified by either a fleet ARN or a fleet alias ARN. Destinations are listed in default preference
         *        order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinations(GameSessionQueueDestination... destinations);

        /**
         * <p>
         * A list of fleets that can be used to fulfill game session placement requests in the queue. Fleets are
         * identified by either a fleet ARN or a fleet alias ARN. Destinations are listed in default preference order.
         * </p>
         * This is a convenience that creates an instance of the {@link List<GameSessionQueueDestination>.Builder}
         * avoiding the need to create one manually via {@link List<GameSessionQueueDestination>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<GameSessionQueueDestination>.Builder#build()} is called
         * immediately and its result is passed to {@link #destinations(List<GameSessionQueueDestination>)}.
         * 
         * @param destinations
         *        a consumer that will call methods on {@link List<GameSessionQueueDestination>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinations(List<GameSessionQueueDestination>)
         */
        Builder destinations(Consumer<GameSessionQueueDestination.Builder>... destinations);

        /**
         * <p>
         * A list of labels to assign to the new game session queue resource. Tags are developer-defined key-value
         * pairs. Tagging AWS resources are useful for resource management, access management and cost allocation. For
         * more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging AWS
         * Resources</a> in the <i>AWS General Reference</i>. Once the resource is created, you can use
         * <a>TagResource</a>, <a>UntagResource</a>, and <a>ListTagsForResource</a> to add, remove, and view tags. The
         * maximum tag limit may be lower than stated. See the AWS General Reference for actual tagging limits.
         * </p>
         * 
         * @param tags
         *        A list of labels to assign to the new game session queue resource. Tags are developer-defined
         *        key-value pairs. Tagging AWS resources are useful for resource management, access management and cost
         *        allocation. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging AWS Resources</a> in
         *        the <i>AWS General Reference</i>. Once the resource is created, you can use <a>TagResource</a>,
         *        <a>UntagResource</a>, and <a>ListTagsForResource</a> to add, remove, and view tags. The maximum tag
         *        limit may be lower than stated. See the AWS General Reference for actual tagging limits.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of labels to assign to the new game session queue resource. Tags are developer-defined key-value
         * pairs. Tagging AWS resources are useful for resource management, access management and cost allocation. For
         * more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging AWS
         * Resources</a> in the <i>AWS General Reference</i>. Once the resource is created, you can use
         * <a>TagResource</a>, <a>UntagResource</a>, and <a>ListTagsForResource</a> to add, remove, and view tags. The
         * maximum tag limit may be lower than stated. See the AWS General Reference for actual tagging limits.
         * </p>
         * 
         * @param tags
         *        A list of labels to assign to the new game session queue resource. Tags are developer-defined
         *        key-value pairs. Tagging AWS resources are useful for resource management, access management and cost
         *        allocation. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging AWS Resources</a> in
         *        the <i>AWS General Reference</i>. Once the resource is created, you can use <a>TagResource</a>,
         *        <a>UntagResource</a>, and <a>ListTagsForResource</a> to add, remove, and view tags. The maximum tag
         *        limit may be lower than stated. See the AWS General Reference for actual tagging limits.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of labels to assign to the new game session queue resource. Tags are developer-defined key-value
         * pairs. Tagging AWS resources are useful for resource management, access management and cost allocation. For
         * more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging AWS
         * Resources</a> in the <i>AWS General Reference</i>. Once the resource is created, you can use
         * <a>TagResource</a>, <a>UntagResource</a>, and <a>ListTagsForResource</a> to add, remove, and view tags. The
         * maximum tag limit may be lower than stated. See the AWS General Reference for actual tagging limits.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GameLiftRequest.BuilderImpl implements Builder {
        private String name;

        private Integer timeoutInSeconds;

        private List<PlayerLatencyPolicy> playerLatencyPolicies = DefaultSdkAutoConstructList.getInstance();

        private List<GameSessionQueueDestination> destinations = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGameSessionQueueRequest model) {
            super(model);
            name(model.name);
            timeoutInSeconds(model.timeoutInSeconds);
            playerLatencyPolicies(model.playerLatencyPolicies);
            destinations(model.destinations);
            tags(model.tags);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Integer getTimeoutInSeconds() {
            return timeoutInSeconds;
        }

        @Override
        public final Builder timeoutInSeconds(Integer timeoutInSeconds) {
            this.timeoutInSeconds = timeoutInSeconds;
            return this;
        }

        public final void setTimeoutInSeconds(Integer timeoutInSeconds) {
            this.timeoutInSeconds = timeoutInSeconds;
        }

        public final Collection<PlayerLatencyPolicy.Builder> getPlayerLatencyPolicies() {
            return playerLatencyPolicies != null ? playerLatencyPolicies.stream().map(PlayerLatencyPolicy::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder playerLatencyPolicies(Collection<PlayerLatencyPolicy> playerLatencyPolicies) {
            this.playerLatencyPolicies = PlayerLatencyPolicyListCopier.copy(playerLatencyPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder playerLatencyPolicies(PlayerLatencyPolicy... playerLatencyPolicies) {
            playerLatencyPolicies(Arrays.asList(playerLatencyPolicies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder playerLatencyPolicies(Consumer<PlayerLatencyPolicy.Builder>... playerLatencyPolicies) {
            playerLatencyPolicies(Stream.of(playerLatencyPolicies)
                    .map(c -> PlayerLatencyPolicy.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPlayerLatencyPolicies(Collection<PlayerLatencyPolicy.BuilderImpl> playerLatencyPolicies) {
            this.playerLatencyPolicies = PlayerLatencyPolicyListCopier.copyFromBuilder(playerLatencyPolicies);
        }

        public final Collection<GameSessionQueueDestination.Builder> getDestinations() {
            return destinations != null ? destinations.stream().map(GameSessionQueueDestination::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder destinations(Collection<GameSessionQueueDestination> destinations) {
            this.destinations = GameSessionQueueDestinationListCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(GameSessionQueueDestination... destinations) {
            destinations(Arrays.asList(destinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(Consumer<GameSessionQueueDestination.Builder>... destinations) {
            destinations(Stream.of(destinations).map(c -> GameSessionQueueDestination.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDestinations(Collection<GameSessionQueueDestination.BuilderImpl> destinations) {
            this.destinations = GameSessionQueueDestinationListCopier.copyFromBuilder(destinations);
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateGameSessionQueueRequest build() {
            return new CreateGameSessionQueueRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
