/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the returned data in response to a request operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeEc2InstanceLimitsResponse extends GameLiftResponse implements
        ToCopyableBuilder<DescribeEc2InstanceLimitsResponse.Builder, DescribeEc2InstanceLimitsResponse> {
    private static final SdkField<List<EC2InstanceLimit>> EC2_INSTANCE_LIMITS_FIELD = SdkField
            .<List<EC2InstanceLimit>> builder(MarshallingType.LIST)
            .memberName("EC2InstanceLimits")
            .getter(getter(DescribeEc2InstanceLimitsResponse::ec2InstanceLimits))
            .setter(setter(Builder::ec2InstanceLimits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EC2InstanceLimits").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EC2InstanceLimit> builder(MarshallingType.SDK_POJO)
                                            .constructor(EC2InstanceLimit::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EC2_INSTANCE_LIMITS_FIELD));

    private final List<EC2InstanceLimit> ec2InstanceLimits;

    private DescribeEc2InstanceLimitsResponse(BuilderImpl builder) {
        super(builder);
        this.ec2InstanceLimits = builder.ec2InstanceLimits;
    }

    /**
     * Returns true if the EC2InstanceLimits property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasEc2InstanceLimits() {
        return ec2InstanceLimits != null && !(ec2InstanceLimits instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The maximum number of instances for the specified instance type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEc2InstanceLimits()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The maximum number of instances for the specified instance type.
     */
    public List<EC2InstanceLimit> ec2InstanceLimits() {
        return ec2InstanceLimits;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ec2InstanceLimits());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEc2InstanceLimitsResponse)) {
            return false;
        }
        DescribeEc2InstanceLimitsResponse other = (DescribeEc2InstanceLimitsResponse) obj;
        return Objects.equals(ec2InstanceLimits(), other.ec2InstanceLimits());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeEc2InstanceLimitsResponse").add("EC2InstanceLimits", ec2InstanceLimits()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EC2InstanceLimits":
            return Optional.ofNullable(clazz.cast(ec2InstanceLimits()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEc2InstanceLimitsResponse, T> g) {
        return obj -> g.apply((DescribeEc2InstanceLimitsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeEc2InstanceLimitsResponse> {
        /**
         * <p>
         * The maximum number of instances for the specified instance type.
         * </p>
         * 
         * @param ec2InstanceLimits
         *        The maximum number of instances for the specified instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2InstanceLimits(Collection<EC2InstanceLimit> ec2InstanceLimits);

        /**
         * <p>
         * The maximum number of instances for the specified instance type.
         * </p>
         * 
         * @param ec2InstanceLimits
         *        The maximum number of instances for the specified instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2InstanceLimits(EC2InstanceLimit... ec2InstanceLimits);

        /**
         * <p>
         * The maximum number of instances for the specified instance type.
         * </p>
         * This is a convenience that creates an instance of the {@link List<EC2InstanceLimit>.Builder} avoiding the
         * need to create one manually via {@link List<EC2InstanceLimit>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EC2InstanceLimit>.Builder#build()} is called immediately and
         * its result is passed to {@link #ec2InstanceLimits(List<EC2InstanceLimit>)}.
         * 
         * @param ec2InstanceLimits
         *        a consumer that will call methods on {@link List<EC2InstanceLimit>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ec2InstanceLimits(List<EC2InstanceLimit>)
         */
        Builder ec2InstanceLimits(Consumer<EC2InstanceLimit.Builder>... ec2InstanceLimits);
    }

    static final class BuilderImpl extends GameLiftResponse.BuilderImpl implements Builder {
        private List<EC2InstanceLimit> ec2InstanceLimits = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEc2InstanceLimitsResponse model) {
            super(model);
            ec2InstanceLimits(model.ec2InstanceLimits);
        }

        public final Collection<EC2InstanceLimit.Builder> getEc2InstanceLimits() {
            return ec2InstanceLimits != null ? ec2InstanceLimits.stream().map(EC2InstanceLimit::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ec2InstanceLimits(Collection<EC2InstanceLimit> ec2InstanceLimits) {
            this.ec2InstanceLimits = EC2InstanceLimitListCopier.copy(ec2InstanceLimits);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2InstanceLimits(EC2InstanceLimit... ec2InstanceLimits) {
            ec2InstanceLimits(Arrays.asList(ec2InstanceLimits));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2InstanceLimits(Consumer<EC2InstanceLimit.Builder>... ec2InstanceLimits) {
            ec2InstanceLimits(Stream.of(ec2InstanceLimits).map(c -> EC2InstanceLimit.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setEc2InstanceLimits(Collection<EC2InstanceLimit.BuilderImpl> ec2InstanceLimits) {
            this.ec2InstanceLimits = EC2InstanceLimitListCopier.copyFromBuilder(ec2InstanceLimits);
        }

        @Override
        public DescribeEc2InstanceLimitsResponse build() {
            return new DescribeEc2InstanceLimitsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
