/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the returned data in response to a request operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeMatchmakingResponse extends GameLiftResponse implements
        ToCopyableBuilder<DescribeMatchmakingResponse.Builder, DescribeMatchmakingResponse> {
    private static final SdkField<List<MatchmakingTicket>> TICKET_LIST_FIELD = SdkField
            .<List<MatchmakingTicket>> builder(MarshallingType.LIST)
            .memberName("TicketList")
            .getter(getter(DescribeMatchmakingResponse::ticketList))
            .setter(setter(Builder::ticketList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TicketList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MatchmakingTicket> builder(MarshallingType.SDK_POJO)
                                            .constructor(MatchmakingTicket::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TICKET_LIST_FIELD));

    private final List<MatchmakingTicket> ticketList;

    private DescribeMatchmakingResponse(BuilderImpl builder) {
        super(builder);
        this.ticketList = builder.ticketList;
    }

    /**
     * Returns true if the TicketList property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTicketList() {
        return ticketList != null && !(ticketList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A collection of existing matchmaking ticket objects matching the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTicketList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A collection of existing matchmaking ticket objects matching the request.
     */
    public List<MatchmakingTicket> ticketList() {
        return ticketList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTicketList() ? ticketList() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMatchmakingResponse)) {
            return false;
        }
        DescribeMatchmakingResponse other = (DescribeMatchmakingResponse) obj;
        return hasTicketList() == other.hasTicketList() && Objects.equals(ticketList(), other.ticketList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeMatchmakingResponse").add("TicketList", hasTicketList() ? ticketList() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TicketList":
            return Optional.ofNullable(clazz.cast(ticketList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeMatchmakingResponse, T> g) {
        return obj -> g.apply((DescribeMatchmakingResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeMatchmakingResponse> {
        /**
         * <p>
         * A collection of existing matchmaking ticket objects matching the request.
         * </p>
         * 
         * @param ticketList
         *        A collection of existing matchmaking ticket objects matching the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ticketList(Collection<MatchmakingTicket> ticketList);

        /**
         * <p>
         * A collection of existing matchmaking ticket objects matching the request.
         * </p>
         * 
         * @param ticketList
         *        A collection of existing matchmaking ticket objects matching the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ticketList(MatchmakingTicket... ticketList);

        /**
         * <p>
         * A collection of existing matchmaking ticket objects matching the request.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MatchmakingTicket>.Builder} avoiding the
         * need to create one manually via {@link List<MatchmakingTicket>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MatchmakingTicket>.Builder#build()} is called immediately
         * and its result is passed to {@link #ticketList(List<MatchmakingTicket>)}.
         * 
         * @param ticketList
         *        a consumer that will call methods on {@link List<MatchmakingTicket>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ticketList(List<MatchmakingTicket>)
         */
        Builder ticketList(Consumer<MatchmakingTicket.Builder>... ticketList);
    }

    static final class BuilderImpl extends GameLiftResponse.BuilderImpl implements Builder {
        private List<MatchmakingTicket> ticketList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMatchmakingResponse model) {
            super(model);
            ticketList(model.ticketList);
        }

        public final Collection<MatchmakingTicket.Builder> getTicketList() {
            if (ticketList instanceof SdkAutoConstructList) {
                return null;
            }
            return ticketList != null ? ticketList.stream().map(MatchmakingTicket::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ticketList(Collection<MatchmakingTicket> ticketList) {
            this.ticketList = MatchmakingTicketListCopier.copy(ticketList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ticketList(MatchmakingTicket... ticketList) {
            ticketList(Arrays.asList(ticketList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ticketList(Consumer<MatchmakingTicket.Builder>... ticketList) {
            ticketList(Stream.of(ticketList).map(c -> MatchmakingTicket.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setTicketList(Collection<MatchmakingTicket.BuilderImpl> ticketList) {
            this.ticketList = MatchmakingTicketListCopier.copyFromBuilder(ticketList);
        }

        @Override
        public DescribeMatchmakingResponse build() {
            return new DescribeMatchmakingResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
