/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input for a request operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeScalingPoliciesRequest extends GameLiftRequest implements
        ToCopyableBuilder<DescribeScalingPoliciesRequest.Builder, DescribeScalingPoliciesRequest> {
    private static final SdkField<String> FLEET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FleetId").getter(getter(DescribeScalingPoliciesRequest::fleetId)).setter(setter(Builder::fleetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId").build()).build();

    private static final SdkField<String> STATUS_FILTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusFilter").getter(getter(DescribeScalingPoliciesRequest::statusFilterAsString))
            .setter(setter(Builder::statusFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusFilter").build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Limit")
            .getter(getter(DescribeScalingPoliciesRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeScalingPoliciesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ID_FIELD,
            STATUS_FILTER_FIELD, LIMIT_FIELD, NEXT_TOKEN_FIELD));

    private final String fleetId;

    private final String statusFilter;

    private final Integer limit;

    private final String nextToken;

    private DescribeScalingPoliciesRequest(BuilderImpl builder) {
        super(builder);
        this.fleetId = builder.fleetId;
        this.statusFilter = builder.statusFilter;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A unique identifier for a fleet to retrieve scaling policies for. You can use either the fleet ID or ARN value.
     * </p>
     * 
     * @return A unique identifier for a fleet to retrieve scaling policies for. You can use either the fleet ID or ARN
     *         value.
     */
    public String fleetId() {
        return fleetId;
    }

    /**
     * <p>
     * Scaling policy status to filter results on. A scaling policy is only in force when in an <code>ACTIVE</code>
     * status.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>ACTIVE</b> -- The scaling policy is currently in force.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>UPDATEREQUESTED</b> -- A request to update the scaling policy has been received.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>UPDATING</b> -- A change is being made to the scaling policy.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>DELETEREQUESTED</b> -- A request to delete the scaling policy has been received.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>DELETING</b> -- The scaling policy is being deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>DELETED</b> -- The scaling policy has been deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>ERROR</b> -- An error occurred in creating the policy. It should be removed and recreated.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusFilter} will
     * return {@link ScalingStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusFilterAsString}.
     * </p>
     * 
     * @return Scaling policy status to filter results on. A scaling policy is only in force when in an
     *         <code>ACTIVE</code> status.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>ACTIVE</b> -- The scaling policy is currently in force.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>UPDATEREQUESTED</b> -- A request to update the scaling policy has been received.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>UPDATING</b> -- A change is being made to the scaling policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>DELETEREQUESTED</b> -- A request to delete the scaling policy has been received.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>DELETING</b> -- The scaling policy is being deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>DELETED</b> -- The scaling policy has been deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>ERROR</b> -- An error occurred in creating the policy. It should be removed and recreated.
     *         </p>
     *         </li>
     * @see ScalingStatusType
     */
    public ScalingStatusType statusFilter() {
        return ScalingStatusType.fromValue(statusFilter);
    }

    /**
     * <p>
     * Scaling policy status to filter results on. A scaling policy is only in force when in an <code>ACTIVE</code>
     * status.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>ACTIVE</b> -- The scaling policy is currently in force.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>UPDATEREQUESTED</b> -- A request to update the scaling policy has been received.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>UPDATING</b> -- A change is being made to the scaling policy.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>DELETEREQUESTED</b> -- A request to delete the scaling policy has been received.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>DELETING</b> -- The scaling policy is being deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>DELETED</b> -- The scaling policy has been deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>ERROR</b> -- An error occurred in creating the policy. It should be removed and recreated.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusFilter} will
     * return {@link ScalingStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusFilterAsString}.
     * </p>
     * 
     * @return Scaling policy status to filter results on. A scaling policy is only in force when in an
     *         <code>ACTIVE</code> status.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>ACTIVE</b> -- The scaling policy is currently in force.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>UPDATEREQUESTED</b> -- A request to update the scaling policy has been received.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>UPDATING</b> -- A change is being made to the scaling policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>DELETEREQUESTED</b> -- A request to delete the scaling policy has been received.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>DELETING</b> -- The scaling policy is being deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>DELETED</b> -- The scaling policy has been deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>ERROR</b> -- An error occurred in creating the policy. It should be removed and recreated.
     *         </p>
     *         </li>
     * @see ScalingStatusType
     */
    public String statusFilterAsString() {
        return statusFilter;
    }

    /**
     * <p>
     * The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set
     * of sequential pages.
     * </p>
     * 
     * @return The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as
     *         a set of sequential pages.
     */
    public Integer limit() {
        return limit;
    }

    /**
     * <p>
     * Token that indicates the start of the next sequential page of results. Use the token that is returned with a
     * previous call to this operation. To start at the beginning of the result set, do not specify a value.
     * </p>
     * 
     * @return Token that indicates the start of the next sequential page of results. Use the token that is returned
     *         with a previous call to this operation. To start at the beginning of the result set, do not specify a
     *         value.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(statusFilterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScalingPoliciesRequest)) {
            return false;
        }
        DescribeScalingPoliciesRequest other = (DescribeScalingPoliciesRequest) obj;
        return Objects.equals(fleetId(), other.fleetId()) && Objects.equals(statusFilterAsString(), other.statusFilterAsString())
                && Objects.equals(limit(), other.limit()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeScalingPoliciesRequest").add("FleetId", fleetId())
                .add("StatusFilter", statusFilterAsString()).add("Limit", limit()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FleetId":
            return Optional.ofNullable(clazz.cast(fleetId()));
        case "StatusFilter":
            return Optional.ofNullable(clazz.cast(statusFilterAsString()));
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeScalingPoliciesRequest, T> g) {
        return obj -> g.apply((DescribeScalingPoliciesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeScalingPoliciesRequest> {
        /**
         * <p>
         * A unique identifier for a fleet to retrieve scaling policies for. You can use either the fleet ID or ARN
         * value.
         * </p>
         * 
         * @param fleetId
         *        A unique identifier for a fleet to retrieve scaling policies for. You can use either the fleet ID or
         *        ARN value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetId(String fleetId);

        /**
         * <p>
         * Scaling policy status to filter results on. A scaling policy is only in force when in an <code>ACTIVE</code>
         * status.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>ACTIVE</b> -- The scaling policy is currently in force.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>UPDATEREQUESTED</b> -- A request to update the scaling policy has been received.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>UPDATING</b> -- A change is being made to the scaling policy.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>DELETEREQUESTED</b> -- A request to delete the scaling policy has been received.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>DELETING</b> -- The scaling policy is being deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>DELETED</b> -- The scaling policy has been deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>ERROR</b> -- An error occurred in creating the policy. It should be removed and recreated.
         * </p>
         * </li>
         * </ul>
         * 
         * @param statusFilter
         *        Scaling policy status to filter results on. A scaling policy is only in force when in an
         *        <code>ACTIVE</code> status.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>ACTIVE</b> -- The scaling policy is currently in force.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>UPDATEREQUESTED</b> -- A request to update the scaling policy has been received.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>UPDATING</b> -- A change is being made to the scaling policy.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>DELETEREQUESTED</b> -- A request to delete the scaling policy has been received.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>DELETING</b> -- The scaling policy is being deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>DELETED</b> -- The scaling policy has been deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>ERROR</b> -- An error occurred in creating the policy. It should be removed and recreated.
         *        </p>
         *        </li>
         * @see ScalingStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScalingStatusType
         */
        Builder statusFilter(String statusFilter);

        /**
         * <p>
         * Scaling policy status to filter results on. A scaling policy is only in force when in an <code>ACTIVE</code>
         * status.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>ACTIVE</b> -- The scaling policy is currently in force.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>UPDATEREQUESTED</b> -- A request to update the scaling policy has been received.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>UPDATING</b> -- A change is being made to the scaling policy.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>DELETEREQUESTED</b> -- A request to delete the scaling policy has been received.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>DELETING</b> -- The scaling policy is being deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>DELETED</b> -- The scaling policy has been deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>ERROR</b> -- An error occurred in creating the policy. It should be removed and recreated.
         * </p>
         * </li>
         * </ul>
         * 
         * @param statusFilter
         *        Scaling policy status to filter results on. A scaling policy is only in force when in an
         *        <code>ACTIVE</code> status.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>ACTIVE</b> -- The scaling policy is currently in force.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>UPDATEREQUESTED</b> -- A request to update the scaling policy has been received.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>UPDATING</b> -- A change is being made to the scaling policy.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>DELETEREQUESTED</b> -- A request to delete the scaling policy has been received.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>DELETING</b> -- The scaling policy is being deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>DELETED</b> -- The scaling policy has been deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>ERROR</b> -- An error occurred in creating the policy. It should be removed and recreated.
         *        </p>
         *        </li>
         * @see ScalingStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScalingStatusType
         */
        Builder statusFilter(ScalingStatusType statusFilter);

        /**
         * <p>
         * The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a
         * set of sequential pages.
         * </p>
         * 
         * @param limit
         *        The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results
         *        as a set of sequential pages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * Token that indicates the start of the next sequential page of results. Use the token that is returned with a
         * previous call to this operation. To start at the beginning of the result set, do not specify a value.
         * </p>
         * 
         * @param nextToken
         *        Token that indicates the start of the next sequential page of results. Use the token that is returned
         *        with a previous call to this operation. To start at the beginning of the result set, do not specify a
         *        value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GameLiftRequest.BuilderImpl implements Builder {
        private String fleetId;

        private String statusFilter;

        private Integer limit;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScalingPoliciesRequest model) {
            super(model);
            fleetId(model.fleetId);
            statusFilter(model.statusFilter);
            limit(model.limit);
            nextToken(model.nextToken);
        }

        public final String getFleetId() {
            return fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        public final String getStatusFilter() {
            return statusFilter;
        }

        @Override
        public final Builder statusFilter(String statusFilter) {
            this.statusFilter = statusFilter;
            return this;
        }

        @Override
        public final Builder statusFilter(ScalingStatusType statusFilter) {
            this.statusFilter(statusFilter == null ? null : statusFilter.toString());
            return this;
        }

        public final void setStatusFilter(String statusFilter) {
            this.statusFilter = statusFilter;
        }

        public final Integer getLimit() {
            return limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeScalingPoliciesRequest build() {
            return new DescribeScalingPoliciesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
