/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Properties describing a Realtime script.
 * </p>
 * <p>
 * <b>Related operations</b>
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a>CreateScript</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>ListScripts</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>DescribeScript</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>UpdateScript</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>DeleteScript</a>
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Script implements SdkPojo, Serializable, ToCopyableBuilder<Script.Builder, Script> {
    private static final SdkField<String> SCRIPT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScriptId").getter(getter(Script::scriptId)).setter(setter(Builder::scriptId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScriptId").build()).build();

    private static final SdkField<String> SCRIPT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScriptArn").getter(getter(Script::scriptArn)).setter(setter(Builder::scriptArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScriptArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Script::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Version")
            .getter(getter(Script::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final SdkField<Long> SIZE_ON_DISK_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("SizeOnDisk").getter(getter(Script::sizeOnDisk)).setter(setter(Builder::sizeOnDisk))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizeOnDisk").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(Script::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<S3Location> STORAGE_LOCATION_FIELD = SdkField.<S3Location> builder(MarshallingType.SDK_POJO)
            .memberName("StorageLocation").getter(getter(Script::storageLocation)).setter(setter(Builder::storageLocation))
            .constructor(S3Location::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageLocation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCRIPT_ID_FIELD,
            SCRIPT_ARN_FIELD, NAME_FIELD, VERSION_FIELD, SIZE_ON_DISK_FIELD, CREATION_TIME_FIELD, STORAGE_LOCATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String scriptId;

    private final String scriptArn;

    private final String name;

    private final String version;

    private final Long sizeOnDisk;

    private final Instant creationTime;

    private final S3Location storageLocation;

    private Script(BuilderImpl builder) {
        this.scriptId = builder.scriptId;
        this.scriptArn = builder.scriptArn;
        this.name = builder.name;
        this.version = builder.version;
        this.sizeOnDisk = builder.sizeOnDisk;
        this.creationTime = builder.creationTime;
        this.storageLocation = builder.storageLocation;
    }

    /**
     * <p>
     * A unique identifier for a Realtime script
     * </p>
     * 
     * @return A unique identifier for a Realtime script
     */
    public String scriptId() {
        return scriptId;
    }

    /**
     * <p>
     * Amazon Resource Name (<a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a>) that is assigned to a
     * GameLift script resource and uniquely identifies it. ARNs are unique across all Regions. In a GameLift script
     * ARN, the resource ID matches the <i>ScriptId</i> value.
     * </p>
     * 
     * @return Amazon Resource Name (<a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a>) that is
     *         assigned to a GameLift script resource and uniquely identifies it. ARNs are unique across all Regions. In
     *         a GameLift script ARN, the resource ID matches the <i>ScriptId</i> value.
     */
    public String scriptArn() {
        return scriptArn;
    }

    /**
     * <p>
     * A descriptive label that is associated with a script. Script names do not need to be unique.
     * </p>
     * 
     * @return A descriptive label that is associated with a script. Script names do not need to be unique.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The version that is associated with a build or script. Version strings do not need to be unique.
     * </p>
     * 
     * @return The version that is associated with a build or script. Version strings do not need to be unique.
     */
    public String version() {
        return version;
    }

    /**
     * <p>
     * The file size of the uploaded Realtime script, expressed in bytes. When files are uploaded from an S3 location,
     * this value remains at "0".
     * </p>
     * 
     * @return The file size of the uploaded Realtime script, expressed in bytes. When files are uploaded from an S3
     *         location, this value remains at "0".
     */
    public Long sizeOnDisk() {
        return sizeOnDisk;
    }

    /**
     * <p>
     * A time stamp indicating when this data object was created. The format is a number expressed in Unix time as
     * milliseconds (for example "1469498468.057").
     * </p>
     * 
     * @return A time stamp indicating when this data object was created. The format is a number expressed in Unix time
     *         as milliseconds (for example "1469498468.057").
     */
    public Instant creationTime() {
        return creationTime;
    }

    /**
     * Returns the value of the StorageLocation property for this object.
     * 
     * @return The value of the StorageLocation property for this object.
     */
    public S3Location storageLocation() {
        return storageLocation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scriptId());
        hashCode = 31 * hashCode + Objects.hashCode(scriptArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(sizeOnDisk());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(storageLocation());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Script)) {
            return false;
        }
        Script other = (Script) obj;
        return Objects.equals(scriptId(), other.scriptId()) && Objects.equals(scriptArn(), other.scriptArn())
                && Objects.equals(name(), other.name()) && Objects.equals(version(), other.version())
                && Objects.equals(sizeOnDisk(), other.sizeOnDisk()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(storageLocation(), other.storageLocation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Script").add("ScriptId", scriptId()).add("ScriptArn", scriptArn()).add("Name", name())
                .add("Version", version()).add("SizeOnDisk", sizeOnDisk()).add("CreationTime", creationTime())
                .add("StorageLocation", storageLocation()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScriptId":
            return Optional.ofNullable(clazz.cast(scriptId()));
        case "ScriptArn":
            return Optional.ofNullable(clazz.cast(scriptArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        case "SizeOnDisk":
            return Optional.ofNullable(clazz.cast(sizeOnDisk()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "StorageLocation":
            return Optional.ofNullable(clazz.cast(storageLocation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Script, T> g) {
        return obj -> g.apply((Script) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Script> {
        /**
         * <p>
         * A unique identifier for a Realtime script
         * </p>
         * 
         * @param scriptId
         *        A unique identifier for a Realtime script
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scriptId(String scriptId);

        /**
         * <p>
         * Amazon Resource Name (<a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a>) that is assigned
         * to a GameLift script resource and uniquely identifies it. ARNs are unique across all Regions. In a GameLift
         * script ARN, the resource ID matches the <i>ScriptId</i> value.
         * </p>
         * 
         * @param scriptArn
         *        Amazon Resource Name (<a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a>) that is
         *        assigned to a GameLift script resource and uniquely identifies it. ARNs are unique across all Regions.
         *        In a GameLift script ARN, the resource ID matches the <i>ScriptId</i> value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scriptArn(String scriptArn);

        /**
         * <p>
         * A descriptive label that is associated with a script. Script names do not need to be unique.
         * </p>
         * 
         * @param name
         *        A descriptive label that is associated with a script. Script names do not need to be unique.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The version that is associated with a build or script. Version strings do not need to be unique.
         * </p>
         * 
         * @param version
         *        The version that is associated with a build or script. Version strings do not need to be unique.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The file size of the uploaded Realtime script, expressed in bytes. When files are uploaded from an S3
         * location, this value remains at "0".
         * </p>
         * 
         * @param sizeOnDisk
         *        The file size of the uploaded Realtime script, expressed in bytes. When files are uploaded from an S3
         *        location, this value remains at "0".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizeOnDisk(Long sizeOnDisk);

        /**
         * <p>
         * A time stamp indicating when this data object was created. The format is a number expressed in Unix time as
         * milliseconds (for example "1469498468.057").
         * </p>
         * 
         * @param creationTime
         *        A time stamp indicating when this data object was created. The format is a number expressed in Unix
         *        time as milliseconds (for example "1469498468.057").
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * Sets the value of the StorageLocation property for this object.
         *
         * @param storageLocation
         *        The new value for the StorageLocation property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageLocation(S3Location storageLocation);

        /**
         * Sets the value of the StorageLocation property for this object.
         *
         * This is a convenience that creates an instance of the {@link S3Location.Builder} avoiding the need to create
         * one manually via {@link S3Location#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3Location.Builder#build()} is called immediately and its result
         * is passed to {@link #storageLocation(S3Location)}.
         * 
         * @param storageLocation
         *        a consumer that will call methods on {@link S3Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storageLocation(S3Location)
         */
        default Builder storageLocation(Consumer<S3Location.Builder> storageLocation) {
            return storageLocation(S3Location.builder().applyMutation(storageLocation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String scriptId;

        private String scriptArn;

        private String name;

        private String version;

        private Long sizeOnDisk;

        private Instant creationTime;

        private S3Location storageLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(Script model) {
            scriptId(model.scriptId);
            scriptArn(model.scriptArn);
            name(model.name);
            version(model.version);
            sizeOnDisk(model.sizeOnDisk);
            creationTime(model.creationTime);
            storageLocation(model.storageLocation);
        }

        public final String getScriptId() {
            return scriptId;
        }

        @Override
        public final Builder scriptId(String scriptId) {
            this.scriptId = scriptId;
            return this;
        }

        public final void setScriptId(String scriptId) {
            this.scriptId = scriptId;
        }

        public final String getScriptArn() {
            return scriptArn;
        }

        @Override
        public final Builder scriptArn(String scriptArn) {
            this.scriptArn = scriptArn;
            return this;
        }

        public final void setScriptArn(String scriptArn) {
            this.scriptArn = scriptArn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getVersion() {
            return version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final Long getSizeOnDisk() {
            return sizeOnDisk;
        }

        @Override
        public final Builder sizeOnDisk(Long sizeOnDisk) {
            this.sizeOnDisk = sizeOnDisk;
            return this;
        }

        public final void setSizeOnDisk(Long sizeOnDisk) {
            this.sizeOnDisk = sizeOnDisk;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final S3Location.Builder getStorageLocation() {
            return storageLocation != null ? storageLocation.toBuilder() : null;
        }

        @Override
        public final Builder storageLocation(S3Location storageLocation) {
            this.storageLocation = storageLocation;
            return this;
        }

        public final void setStorageLocation(S3Location.BuilderImpl storageLocation) {
            this.storageLocation = storageLocation != null ? storageLocation.build() : null;
        }

        @Override
        public Script build() {
            return new Script(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
