/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SuspendGameServerGroupResponse extends GameLiftResponse implements
        ToCopyableBuilder<SuspendGameServerGroupResponse.Builder, SuspendGameServerGroupResponse> {
    private static final SdkField<GameServerGroup> GAME_SERVER_GROUP_FIELD = SdkField
            .<GameServerGroup> builder(MarshallingType.SDK_POJO).memberName("GameServerGroup")
            .getter(getter(SuspendGameServerGroupResponse::gameServerGroup)).setter(setter(Builder::gameServerGroup))
            .constructor(GameServerGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameServerGroup").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GAME_SERVER_GROUP_FIELD));

    private final GameServerGroup gameServerGroup;

    private SuspendGameServerGroupResponse(BuilderImpl builder) {
        super(builder);
        this.gameServerGroup = builder.gameServerGroup;
    }

    /**
     * <p>
     * An object that describes the game server group resource, with the <code>SuspendedActions</code> property updated
     * to reflect the suspended activity.
     * </p>
     * 
     * @return An object that describes the game server group resource, with the <code>SuspendedActions</code> property
     *         updated to reflect the suspended activity.
     */
    public GameServerGroup gameServerGroup() {
        return gameServerGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gameServerGroup());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SuspendGameServerGroupResponse)) {
            return false;
        }
        SuspendGameServerGroupResponse other = (SuspendGameServerGroupResponse) obj;
        return Objects.equals(gameServerGroup(), other.gameServerGroup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SuspendGameServerGroupResponse").add("GameServerGroup", gameServerGroup()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GameServerGroup":
            return Optional.ofNullable(clazz.cast(gameServerGroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SuspendGameServerGroupResponse, T> g) {
        return obj -> g.apply((SuspendGameServerGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftResponse.Builder, SdkPojo, CopyableBuilder<Builder, SuspendGameServerGroupResponse> {
        /**
         * <p>
         * An object that describes the game server group resource, with the <code>SuspendedActions</code> property
         * updated to reflect the suspended activity.
         * </p>
         * 
         * @param gameServerGroup
         *        An object that describes the game server group resource, with the <code>SuspendedActions</code>
         *        property updated to reflect the suspended activity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameServerGroup(GameServerGroup gameServerGroup);

        /**
         * <p>
         * An object that describes the game server group resource, with the <code>SuspendedActions</code> property
         * updated to reflect the suspended activity.
         * </p>
         * This is a convenience that creates an instance of the {@link GameServerGroup.Builder} avoiding the need to
         * create one manually via {@link GameServerGroup#builder()}.
         *
         * When the {@link Consumer} completes, {@link GameServerGroup.Builder#build()} is called immediately and its
         * result is passed to {@link #gameServerGroup(GameServerGroup)}.
         * 
         * @param gameServerGroup
         *        a consumer that will call methods on {@link GameServerGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gameServerGroup(GameServerGroup)
         */
        default Builder gameServerGroup(Consumer<GameServerGroup.Builder> gameServerGroup) {
            return gameServerGroup(GameServerGroup.builder().applyMutation(gameServerGroup).build());
        }
    }

    static final class BuilderImpl extends GameLiftResponse.BuilderImpl implements Builder {
        private GameServerGroup gameServerGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(SuspendGameServerGroupResponse model) {
            super(model);
            gameServerGroup(model.gameServerGroup);
        }

        public final GameServerGroup.Builder getGameServerGroup() {
            return gameServerGroup != null ? gameServerGroup.toBuilder() : null;
        }

        @Override
        public final Builder gameServerGroup(GameServerGroup gameServerGroup) {
            this.gameServerGroup = gameServerGroup;
            return this;
        }

        public final void setGameServerGroup(GameServerGroup.BuilderImpl gameServerGroup) {
            this.gameServerGroup = gameServerGroup != null ? gameServerGroup.build() : null;
        }

        @Override
        public SuspendGameServerGroupResponse build() {
            return new SuspendGameServerGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
