/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * <b>This data type is used with the Amazon GameLift FleetIQ and game server groups.</b>
 * </p>
 * <p>
 * Settings for a target-based scaling policy as part of a <a>GameServerGroupAutoScalingPolicy</a>. These settings are
 * used to create a target-based policy that tracks the GameLift FleetIQ metric
 * <code>"PercentUtilizedGameServers"</code> and specifies a target value for the metric. As player usage changes, the
 * policy triggers to adjust the game server group capacity so that the metric returns to the target value.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TargetTrackingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<TargetTrackingConfiguration.Builder, TargetTrackingConfiguration> {
    private static final SdkField<Double> TARGET_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("TargetValue").getter(getter(TargetTrackingConfiguration::targetValue))
            .setter(setter(Builder::targetValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Double targetValue;

    private TargetTrackingConfiguration(BuilderImpl builder) {
        this.targetValue = builder.targetValue;
    }

    /**
     * <p>
     * Desired value to use with a game server group target-based scaling policy.
     * </p>
     * 
     * @return Desired value to use with a game server group target-based scaling policy.
     */
    public Double targetValue() {
        return targetValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(targetValue());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetTrackingConfiguration)) {
            return false;
        }
        TargetTrackingConfiguration other = (TargetTrackingConfiguration) obj;
        return Objects.equals(targetValue(), other.targetValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TargetTrackingConfiguration").add("TargetValue", targetValue()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TargetValue":
            return Optional.ofNullable(clazz.cast(targetValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TargetTrackingConfiguration, T> g) {
        return obj -> g.apply((TargetTrackingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TargetTrackingConfiguration> {
        /**
         * <p>
         * Desired value to use with a game server group target-based scaling policy.
         * </p>
         * 
         * @param targetValue
         *        Desired value to use with a game server group target-based scaling policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetValue(Double targetValue);
    }

    static final class BuilderImpl implements Builder {
        private Double targetValue;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetTrackingConfiguration model) {
            targetValue(model.targetValue);
        }

        public final Double getTargetValue() {
            return targetValue;
        }

        @Override
        public final Builder targetValue(Double targetValue) {
            this.targetValue = targetValue;
            return this;
        }

        public final void setTargetValue(Double targetValue) {
            this.targetValue = targetValue;
        }

        @Override
        public TargetTrackingConfiguration build() {
            return new TargetTrackingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
