/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input for a request operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAliasRequest extends GameLiftRequest implements
        ToCopyableBuilder<UpdateAliasRequest.Builder, UpdateAliasRequest> {
    private static final SdkField<String> ALIAS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AliasId").getter(getter(UpdateAliasRequest::aliasId)).setter(setter(Builder::aliasId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AliasId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateAliasRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateAliasRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<RoutingStrategy> ROUTING_STRATEGY_FIELD = SdkField
            .<RoutingStrategy> builder(MarshallingType.SDK_POJO).memberName("RoutingStrategy")
            .getter(getter(UpdateAliasRequest::routingStrategy)).setter(setter(Builder::routingStrategy))
            .constructor(RoutingStrategy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingStrategy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALIAS_ID_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, ROUTING_STRATEGY_FIELD));

    private final String aliasId;

    private final String name;

    private final String description;

    private final RoutingStrategy routingStrategy;

    private UpdateAliasRequest(BuilderImpl builder) {
        super(builder);
        this.aliasId = builder.aliasId;
        this.name = builder.name;
        this.description = builder.description;
        this.routingStrategy = builder.routingStrategy;
    }

    /**
     * <p>
     * A unique identifier for the alias that you want to update. You can use either the alias ID or ARN value.
     * </p>
     * 
     * @return A unique identifier for the alias that you want to update. You can use either the alias ID or ARN value.
     */
    public String aliasId() {
        return aliasId;
    }

    /**
     * <p>
     * A descriptive label that is associated with an alias. Alias names do not need to be unique.
     * </p>
     * 
     * @return A descriptive label that is associated with an alias. Alias names do not need to be unique.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * A human-readable description of the alias.
     * </p>
     * 
     * @return A human-readable description of the alias.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The routing configuration, including routing type and fleet target, for the alias.
     * </p>
     * 
     * @return The routing configuration, including routing type and fleet target, for the alias.
     */
    public RoutingStrategy routingStrategy() {
        return routingStrategy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(aliasId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(routingStrategy());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAliasRequest)) {
            return false;
        }
        UpdateAliasRequest other = (UpdateAliasRequest) obj;
        return Objects.equals(aliasId(), other.aliasId()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description())
                && Objects.equals(routingStrategy(), other.routingStrategy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateAliasRequest").add("AliasId", aliasId()).add("Name", name())
                .add("Description", description()).add("RoutingStrategy", routingStrategy()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AliasId":
            return Optional.ofNullable(clazz.cast(aliasId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "RoutingStrategy":
            return Optional.ofNullable(clazz.cast(routingStrategy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAliasRequest, T> g) {
        return obj -> g.apply((UpdateAliasRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateAliasRequest> {
        /**
         * <p>
         * A unique identifier for the alias that you want to update. You can use either the alias ID or ARN value.
         * </p>
         * 
         * @param aliasId
         *        A unique identifier for the alias that you want to update. You can use either the alias ID or ARN
         *        value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliasId(String aliasId);

        /**
         * <p>
         * A descriptive label that is associated with an alias. Alias names do not need to be unique.
         * </p>
         * 
         * @param name
         *        A descriptive label that is associated with an alias. Alias names do not need to be unique.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A human-readable description of the alias.
         * </p>
         * 
         * @param description
         *        A human-readable description of the alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The routing configuration, including routing type and fleet target, for the alias.
         * </p>
         * 
         * @param routingStrategy
         *        The routing configuration, including routing type and fleet target, for the alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingStrategy(RoutingStrategy routingStrategy);

        /**
         * <p>
         * The routing configuration, including routing type and fleet target, for the alias.
         * </p>
         * This is a convenience that creates an instance of the {@link RoutingStrategy.Builder} avoiding the need to
         * create one manually via {@link RoutingStrategy#builder()}.
         *
         * When the {@link Consumer} completes, {@link RoutingStrategy.Builder#build()} is called immediately and its
         * result is passed to {@link #routingStrategy(RoutingStrategy)}.
         * 
         * @param routingStrategy
         *        a consumer that will call methods on {@link RoutingStrategy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #routingStrategy(RoutingStrategy)
         */
        default Builder routingStrategy(Consumer<RoutingStrategy.Builder> routingStrategy) {
            return routingStrategy(RoutingStrategy.builder().applyMutation(routingStrategy).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GameLiftRequest.BuilderImpl implements Builder {
        private String aliasId;

        private String name;

        private String description;

        private RoutingStrategy routingStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAliasRequest model) {
            super(model);
            aliasId(model.aliasId);
            name(model.name);
            description(model.description);
            routingStrategy(model.routingStrategy);
        }

        public final String getAliasId() {
            return aliasId;
        }

        @Override
        public final Builder aliasId(String aliasId) {
            this.aliasId = aliasId;
            return this;
        }

        public final void setAliasId(String aliasId) {
            this.aliasId = aliasId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final RoutingStrategy.Builder getRoutingStrategy() {
            return routingStrategy != null ? routingStrategy.toBuilder() : null;
        }

        @Override
        public final Builder routingStrategy(RoutingStrategy routingStrategy) {
            this.routingStrategy = routingStrategy;
            return this;
        }

        public final void setRoutingStrategy(RoutingStrategy.BuilderImpl routingStrategy) {
            this.routingStrategy = routingStrategy != null ? routingStrategy.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAliasRequest build() {
            return new UpdateAliasRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
