/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeGameServerInstancesRequest extends GameLiftRequest implements
        ToCopyableBuilder<DescribeGameServerInstancesRequest.Builder, DescribeGameServerInstancesRequest> {
    private static final SdkField<String> GAME_SERVER_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GameServerGroupName").getter(getter(DescribeGameServerInstancesRequest::gameServerGroupName))
            .setter(setter(Builder::gameServerGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameServerGroupName").build())
            .build();

    private static final SdkField<List<String>> INSTANCE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("InstanceIds")
            .getter(getter(DescribeGameServerInstancesRequest::instanceIds))
            .setter(setter(Builder::instanceIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Limit")
            .getter(getter(DescribeGameServerInstancesRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeGameServerInstancesRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GAME_SERVER_GROUP_NAME_FIELD,
            INSTANCE_IDS_FIELD, LIMIT_FIELD, NEXT_TOKEN_FIELD));

    private final String gameServerGroupName;

    private final List<String> instanceIds;

    private final Integer limit;

    private final String nextToken;

    private DescribeGameServerInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.gameServerGroupName = builder.gameServerGroupName;
        this.instanceIds = builder.instanceIds;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A unique identifier for the game server group. Use either the <a>GameServerGroup</a> name or ARN value.
     * </p>
     * 
     * @return A unique identifier for the game server group. Use either the <a>GameServerGroup</a> name or ARN value.
     */
    public String gameServerGroupName() {
        return gameServerGroupName;
    }

    /**
     * Returns true if the InstanceIds property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasInstanceIds() {
        return instanceIds != null && !(instanceIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The EC2 instance IDs that you want to retrieve status on. EC2 instance IDs use a 17-character format, for
     * example: <code>i-1234567890abcdef0</code>. To retrieve all instances in the game server group, leave this
     * parameter empty.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInstanceIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The EC2 instance IDs that you want to retrieve status on. EC2 instance IDs use a 17-character format, for
     *         example: <code>i-1234567890abcdef0</code>. To retrieve all instances in the game server group, leave this
     *         parameter empty.
     */
    public List<String> instanceIds() {
        return instanceIds;
    }

    /**
     * <p>
     * The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set
     * of sequential segments.
     * </p>
     * 
     * @return The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as
     *         a set of sequential segments.
     */
    public Integer limit() {
        return limit;
    }

    /**
     * <p>
     * A token that indicates the start of the next sequential segment of results. Use the token returned with the
     * previous call to this operation. To start at the beginning of the result set, do not specify a value.
     * </p>
     * 
     * @return A token that indicates the start of the next sequential segment of results. Use the token returned with
     *         the previous call to this operation. To start at the beginning of the result set, do not specify a value.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gameServerGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(hasInstanceIds() ? instanceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeGameServerInstancesRequest)) {
            return false;
        }
        DescribeGameServerInstancesRequest other = (DescribeGameServerInstancesRequest) obj;
        return Objects.equals(gameServerGroupName(), other.gameServerGroupName()) && hasInstanceIds() == other.hasInstanceIds()
                && Objects.equals(instanceIds(), other.instanceIds()) && Objects.equals(limit(), other.limit())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeGameServerInstancesRequest").add("GameServerGroupName", gameServerGroupName())
                .add("InstanceIds", hasInstanceIds() ? instanceIds() : null).add("Limit", limit()).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GameServerGroupName":
            return Optional.ofNullable(clazz.cast(gameServerGroupName()));
        case "InstanceIds":
            return Optional.ofNullable(clazz.cast(instanceIds()));
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeGameServerInstancesRequest, T> g) {
        return obj -> g.apply((DescribeGameServerInstancesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeGameServerInstancesRequest> {
        /**
         * <p>
         * A unique identifier for the game server group. Use either the <a>GameServerGroup</a> name or ARN value.
         * </p>
         * 
         * @param gameServerGroupName
         *        A unique identifier for the game server group. Use either the <a>GameServerGroup</a> name or ARN
         *        value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameServerGroupName(String gameServerGroupName);

        /**
         * <p>
         * The EC2 instance IDs that you want to retrieve status on. EC2 instance IDs use a 17-character format, for
         * example: <code>i-1234567890abcdef0</code>. To retrieve all instances in the game server group, leave this
         * parameter empty.
         * </p>
         * 
         * @param instanceIds
         *        The EC2 instance IDs that you want to retrieve status on. EC2 instance IDs use a 17-character format,
         *        for example: <code>i-1234567890abcdef0</code>. To retrieve all instances in the game server group,
         *        leave this parameter empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceIds(Collection<String> instanceIds);

        /**
         * <p>
         * The EC2 instance IDs that you want to retrieve status on. EC2 instance IDs use a 17-character format, for
         * example: <code>i-1234567890abcdef0</code>. To retrieve all instances in the game server group, leave this
         * parameter empty.
         * </p>
         * 
         * @param instanceIds
         *        The EC2 instance IDs that you want to retrieve status on. EC2 instance IDs use a 17-character format,
         *        for example: <code>i-1234567890abcdef0</code>. To retrieve all instances in the game server group,
         *        leave this parameter empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceIds(String... instanceIds);

        /**
         * <p>
         * The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a
         * set of sequential segments.
         * </p>
         * 
         * @param limit
         *        The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results
         *        as a set of sequential segments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * A token that indicates the start of the next sequential segment of results. Use the token returned with the
         * previous call to this operation. To start at the beginning of the result set, do not specify a value.
         * </p>
         * 
         * @param nextToken
         *        A token that indicates the start of the next sequential segment of results. Use the token returned
         *        with the previous call to this operation. To start at the beginning of the result set, do not specify
         *        a value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GameLiftRequest.BuilderImpl implements Builder {
        private String gameServerGroupName;

        private List<String> instanceIds = DefaultSdkAutoConstructList.getInstance();

        private Integer limit;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeGameServerInstancesRequest model) {
            super(model);
            gameServerGroupName(model.gameServerGroupName);
            instanceIds(model.instanceIds);
            limit(model.limit);
            nextToken(model.nextToken);
        }

        public final String getGameServerGroupName() {
            return gameServerGroupName;
        }

        @Override
        public final Builder gameServerGroupName(String gameServerGroupName) {
            this.gameServerGroupName = gameServerGroupName;
            return this;
        }

        public final void setGameServerGroupName(String gameServerGroupName) {
            this.gameServerGroupName = gameServerGroupName;
        }

        public final Collection<String> getInstanceIds() {
            if (instanceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return instanceIds;
        }

        @Override
        public final Builder instanceIds(Collection<String> instanceIds) {
            this.instanceIds = GameServerInstanceIdsCopier.copy(instanceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceIds(String... instanceIds) {
            instanceIds(Arrays.asList(instanceIds));
            return this;
        }

        public final void setInstanceIds(Collection<String> instanceIds) {
            this.instanceIds = GameServerInstanceIdsCopier.copy(instanceIds);
        }

        public final Integer getLimit() {
            return limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeGameServerInstancesRequest build() {
            return new DescribeGameServerInstancesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
