/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Player information for use when creating player sessions using a game session placement request with
 * <a>StartGameSessionPlacement</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DesiredPlayerSession implements SdkPojo, Serializable,
        ToCopyableBuilder<DesiredPlayerSession.Builder, DesiredPlayerSession> {
    private static final SdkField<String> PLAYER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlayerId").getter(getter(DesiredPlayerSession::playerId)).setter(setter(Builder::playerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlayerId").build()).build();

    private static final SdkField<String> PLAYER_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlayerData").getter(getter(DesiredPlayerSession::playerData)).setter(setter(Builder::playerData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlayerData").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLAYER_ID_FIELD,
            PLAYER_DATA_FIELD));

    private static final long serialVersionUID = 1L;

    private final String playerId;

    private final String playerData;

    private DesiredPlayerSession(BuilderImpl builder) {
        this.playerId = builder.playerId;
        this.playerData = builder.playerData;
    }

    /**
     * <p>
     * A unique identifier for a player to associate with the player session.
     * </p>
     * 
     * @return A unique identifier for a player to associate with the player session.
     */
    public String playerId() {
        return playerId;
    }

    /**
     * <p>
     * Developer-defined information related to a player. Amazon GameLift does not use this data, so it can be formatted
     * as needed for use in the game.
     * </p>
     * 
     * @return Developer-defined information related to a player. Amazon GameLift does not use this data, so it can be
     *         formatted as needed for use in the game.
     */
    public String playerData() {
        return playerData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(playerId());
        hashCode = 31 * hashCode + Objects.hashCode(playerData());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DesiredPlayerSession)) {
            return false;
        }
        DesiredPlayerSession other = (DesiredPlayerSession) obj;
        return Objects.equals(playerId(), other.playerId()) && Objects.equals(playerData(), other.playerData());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DesiredPlayerSession").add("PlayerId", playerId()).add("PlayerData", playerData()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PlayerId":
            return Optional.ofNullable(clazz.cast(playerId()));
        case "PlayerData":
            return Optional.ofNullable(clazz.cast(playerData()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DesiredPlayerSession, T> g) {
        return obj -> g.apply((DesiredPlayerSession) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DesiredPlayerSession> {
        /**
         * <p>
         * A unique identifier for a player to associate with the player session.
         * </p>
         * 
         * @param playerId
         *        A unique identifier for a player to associate with the player session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder playerId(String playerId);

        /**
         * <p>
         * Developer-defined information related to a player. Amazon GameLift does not use this data, so it can be
         * formatted as needed for use in the game.
         * </p>
         * 
         * @param playerData
         *        Developer-defined information related to a player. Amazon GameLift does not use this data, so it can
         *        be formatted as needed for use in the game.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder playerData(String playerData);
    }

    static final class BuilderImpl implements Builder {
        private String playerId;

        private String playerData;

        private BuilderImpl() {
        }

        private BuilderImpl(DesiredPlayerSession model) {
            playerId(model.playerId);
            playerData(model.playerData);
        }

        public final String getPlayerId() {
            return playerId;
        }

        @Override
        public final Builder playerId(String playerId) {
            this.playerId = playerId;
            return this;
        }

        public final void setPlayerId(String playerId) {
            this.playerId = playerId;
        }

        public final String getPlayerData() {
            return playerData;
        }

        @Override
        public final Builder playerData(String playerData) {
            this.playerData = playerData;
            return this;
        }

        public final void setPlayerData(String playerData) {
            this.playerData = playerData;
        }

        @Override
        public DesiredPlayerSession build() {
            return new DesiredPlayerSession(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
