/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the returned data in response to a request operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchGameSessionsResponse extends GameLiftResponse implements
        ToCopyableBuilder<SearchGameSessionsResponse.Builder, SearchGameSessionsResponse> {
    private static final SdkField<List<GameSession>> GAME_SESSIONS_FIELD = SdkField
            .<List<GameSession>> builder(MarshallingType.LIST)
            .memberName("GameSessions")
            .getter(getter(SearchGameSessionsResponse::gameSessions))
            .setter(setter(Builder::gameSessions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameSessions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GameSession> builder(MarshallingType.SDK_POJO)
                                            .constructor(GameSession::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(SearchGameSessionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GAME_SESSIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<GameSession> gameSessions;

    private final String nextToken;

    private SearchGameSessionsResponse(BuilderImpl builder) {
        super(builder);
        this.gameSessions = builder.gameSessions;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the GameSessions property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasGameSessions() {
        return gameSessions != null && !(gameSessions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A collection of objects containing game session properties for each session matching the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasGameSessions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A collection of objects containing game session properties for each session matching the request.
     */
    public List<GameSession> gameSessions() {
        return gameSessions;
    }

    /**
     * <p>
     * Token that indicates where to resume retrieving results on the next call to this operation. If no token is
     * returned, these results represent the end of the list.
     * </p>
     * 
     * @return Token that indicates where to resume retrieving results on the next call to this operation. If no token
     *         is returned, these results represent the end of the list.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasGameSessions() ? gameSessions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchGameSessionsResponse)) {
            return false;
        }
        SearchGameSessionsResponse other = (SearchGameSessionsResponse) obj;
        return hasGameSessions() == other.hasGameSessions() && Objects.equals(gameSessions(), other.gameSessions())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SearchGameSessionsResponse").add("GameSessions", hasGameSessions() ? gameSessions() : null)
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GameSessions":
            return Optional.ofNullable(clazz.cast(gameSessions()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchGameSessionsResponse, T> g) {
        return obj -> g.apply((SearchGameSessionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftResponse.Builder, SdkPojo, CopyableBuilder<Builder, SearchGameSessionsResponse> {
        /**
         * <p>
         * A collection of objects containing game session properties for each session matching the request.
         * </p>
         * 
         * @param gameSessions
         *        A collection of objects containing game session properties for each session matching the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameSessions(Collection<GameSession> gameSessions);

        /**
         * <p>
         * A collection of objects containing game session properties for each session matching the request.
         * </p>
         * 
         * @param gameSessions
         *        A collection of objects containing game session properties for each session matching the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameSessions(GameSession... gameSessions);

        /**
         * <p>
         * A collection of objects containing game session properties for each session matching the request.
         * </p>
         * This is a convenience that creates an instance of the {@link List<GameSession>.Builder} avoiding the need to
         * create one manually via {@link List<GameSession>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<GameSession>.Builder#build()} is called immediately and its
         * result is passed to {@link #gameSessions(List<GameSession>)}.
         * 
         * @param gameSessions
         *        a consumer that will call methods on {@link List<GameSession>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gameSessions(List<GameSession>)
         */
        Builder gameSessions(Consumer<GameSession.Builder>... gameSessions);

        /**
         * <p>
         * Token that indicates where to resume retrieving results on the next call to this operation. If no token is
         * returned, these results represent the end of the list.
         * </p>
         * 
         * @param nextToken
         *        Token that indicates where to resume retrieving results on the next call to this operation. If no
         *        token is returned, these results represent the end of the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GameLiftResponse.BuilderImpl implements Builder {
        private List<GameSession> gameSessions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchGameSessionsResponse model) {
            super(model);
            gameSessions(model.gameSessions);
            nextToken(model.nextToken);
        }

        public final Collection<GameSession.Builder> getGameSessions() {
            if (gameSessions instanceof SdkAutoConstructList) {
                return null;
            }
            return gameSessions != null ? gameSessions.stream().map(GameSession::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder gameSessions(Collection<GameSession> gameSessions) {
            this.gameSessions = GameSessionListCopier.copy(gameSessions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gameSessions(GameSession... gameSessions) {
            gameSessions(Arrays.asList(gameSessions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gameSessions(Consumer<GameSession.Builder>... gameSessions) {
            gameSessions(Stream.of(gameSessions).map(c -> GameSession.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setGameSessions(Collection<GameSession.BuilderImpl> gameSessions) {
            this.gameSessions = GameSessionListCopier.copyFromBuilder(gameSessions);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public SearchGameSessionsResponse build() {
            return new SearchGameSessionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
