/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input for a request operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetInstanceAccessRequest extends GameLiftRequest implements
        ToCopyableBuilder<GetInstanceAccessRequest.Builder, GetInstanceAccessRequest> {
    private static final SdkField<String> FLEET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FleetId").getter(getter(GetInstanceAccessRequest::fleetId)).setter(setter(Builder::fleetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(GetInstanceAccessRequest::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ID_FIELD,
            INSTANCE_ID_FIELD));

    private final String fleetId;

    private final String instanceId;

    private GetInstanceAccessRequest(BuilderImpl builder) {
        super(builder);
        this.fleetId = builder.fleetId;
        this.instanceId = builder.instanceId;
    }

    /**
     * <p>
     * A unique identifier for a fleet that contains the instance you want access to. You can use either the fleet ID or
     * ARN value. The fleet can be in any of the following statuses: <code>ACTIVATING</code>, <code>ACTIVE</code>, or
     * <code>ERROR</code>. Fleets with an <code>ERROR</code> status may be accessible for a short time before they are
     * deleted.
     * </p>
     * 
     * @return A unique identifier for a fleet that contains the instance you want access to. You can use either the
     *         fleet ID or ARN value. The fleet can be in any of the following statuses: <code>ACTIVATING</code>,
     *         <code>ACTIVE</code>, or <code>ERROR</code>. Fleets with an <code>ERROR</code> status may be accessible
     *         for a short time before they are deleted.
     */
    public final String fleetId() {
        return fleetId;
    }

    /**
     * <p>
     * A unique identifier for an instance you want to get access to. You can access an instance in any status.
     * </p>
     * 
     * @return A unique identifier for an instance you want to get access to. You can access an instance in any status.
     */
    public final String instanceId() {
        return instanceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInstanceAccessRequest)) {
            return false;
        }
        GetInstanceAccessRequest other = (GetInstanceAccessRequest) obj;
        return Objects.equals(fleetId(), other.fleetId()) && Objects.equals(instanceId(), other.instanceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetInstanceAccessRequest").add("FleetId", fleetId()).add("InstanceId", instanceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FleetId":
            return Optional.ofNullable(clazz.cast(fleetId()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetInstanceAccessRequest, T> g) {
        return obj -> g.apply((GetInstanceAccessRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetInstanceAccessRequest> {
        /**
         * <p>
         * A unique identifier for a fleet that contains the instance you want access to. You can use either the fleet
         * ID or ARN value. The fleet can be in any of the following statuses: <code>ACTIVATING</code>,
         * <code>ACTIVE</code>, or <code>ERROR</code>. Fleets with an <code>ERROR</code> status may be accessible for a
         * short time before they are deleted.
         * </p>
         * 
         * @param fleetId
         *        A unique identifier for a fleet that contains the instance you want access to. You can use either the
         *        fleet ID or ARN value. The fleet can be in any of the following statuses: <code>ACTIVATING</code>,
         *        <code>ACTIVE</code>, or <code>ERROR</code>. Fleets with an <code>ERROR</code> status may be accessible
         *        for a short time before they are deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetId(String fleetId);

        /**
         * <p>
         * A unique identifier for an instance you want to get access to. You can access an instance in any status.
         * </p>
         * 
         * @param instanceId
         *        A unique identifier for an instance you want to get access to. You can access an instance in any
         *        status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GameLiftRequest.BuilderImpl implements Builder {
        private String fleetId;

        private String instanceId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInstanceAccessRequest model) {
            super(model);
            fleetId(model.fleetId);
            instanceId(model.instanceId);
        }

        public final String getFleetId() {
            return fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetInstanceAccessRequest build() {
            return new GetInstanceAccessRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
