/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input for a request operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFleetsRequest extends GameLiftRequest implements
        ToCopyableBuilder<ListFleetsRequest.Builder, ListFleetsRequest> {
    private static final SdkField<String> BUILD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BuildId").getter(getter(ListFleetsRequest::buildId)).setter(setter(Builder::buildId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BuildId").build()).build();

    private static final SdkField<String> SCRIPT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScriptId").getter(getter(ListFleetsRequest::scriptId)).setter(setter(Builder::scriptId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScriptId").build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Limit")
            .getter(getter(ListFleetsRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListFleetsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUILD_ID_FIELD,
            SCRIPT_ID_FIELD, LIMIT_FIELD, NEXT_TOKEN_FIELD));

    private final String buildId;

    private final String scriptId;

    private final Integer limit;

    private final String nextToken;

    private ListFleetsRequest(BuilderImpl builder) {
        super(builder);
        this.buildId = builder.buildId;
        this.scriptId = builder.scriptId;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A unique identifier for the build to request fleets for. Use this parameter to return only fleets using a
     * specified build. Use either the build ID or ARN value.
     * </p>
     * 
     * @return A unique identifier for the build to request fleets for. Use this parameter to return only fleets using a
     *         specified build. Use either the build ID or ARN value.
     */
    public final String buildId() {
        return buildId;
    }

    /**
     * <p>
     * A unique identifier for the Realtime script to request fleets for. Use this parameter to return only fleets using
     * a specified script. Use either the script ID or ARN value.
     * </p>
     * 
     * @return A unique identifier for the Realtime script to request fleets for. Use this parameter to return only
     *         fleets using a specified script. Use either the script ID or ARN value.
     */
    public final String scriptId() {
        return scriptId;
    }

    /**
     * <p>
     * The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set
     * of sequential pages.
     * </p>
     * 
     * @return The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as
     *         a set of sequential pages.
     */
    public final Integer limit() {
        return limit;
    }

    /**
     * <p>
     * A token that indicates the start of the next sequential page of results. Use the token that is returned with a
     * previous call to this operation. To start at the beginning of the result set, do not specify a value.
     * </p>
     * 
     * @return A token that indicates the start of the next sequential page of results. Use the token that is returned
     *         with a previous call to this operation. To start at the beginning of the result set, do not specify a
     *         value.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(buildId());
        hashCode = 31 * hashCode + Objects.hashCode(scriptId());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFleetsRequest)) {
            return false;
        }
        ListFleetsRequest other = (ListFleetsRequest) obj;
        return Objects.equals(buildId(), other.buildId()) && Objects.equals(scriptId(), other.scriptId())
                && Objects.equals(limit(), other.limit()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListFleetsRequest").add("BuildId", buildId()).add("ScriptId", scriptId()).add("Limit", limit())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BuildId":
            return Optional.ofNullable(clazz.cast(buildId()));
        case "ScriptId":
            return Optional.ofNullable(clazz.cast(scriptId()));
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFleetsRequest, T> g) {
        return obj -> g.apply((ListFleetsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListFleetsRequest> {
        /**
         * <p>
         * A unique identifier for the build to request fleets for. Use this parameter to return only fleets using a
         * specified build. Use either the build ID or ARN value.
         * </p>
         * 
         * @param buildId
         *        A unique identifier for the build to request fleets for. Use this parameter to return only fleets
         *        using a specified build. Use either the build ID or ARN value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder buildId(String buildId);

        /**
         * <p>
         * A unique identifier for the Realtime script to request fleets for. Use this parameter to return only fleets
         * using a specified script. Use either the script ID or ARN value.
         * </p>
         * 
         * @param scriptId
         *        A unique identifier for the Realtime script to request fleets for. Use this parameter to return only
         *        fleets using a specified script. Use either the script ID or ARN value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scriptId(String scriptId);

        /**
         * <p>
         * The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a
         * set of sequential pages.
         * </p>
         * 
         * @param limit
         *        The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results
         *        as a set of sequential pages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * A token that indicates the start of the next sequential page of results. Use the token that is returned with
         * a previous call to this operation. To start at the beginning of the result set, do not specify a value.
         * </p>
         * 
         * @param nextToken
         *        A token that indicates the start of the next sequential page of results. Use the token that is
         *        returned with a previous call to this operation. To start at the beginning of the result set, do not
         *        specify a value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GameLiftRequest.BuilderImpl implements Builder {
        private String buildId;

        private String scriptId;

        private Integer limit;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFleetsRequest model) {
            super(model);
            buildId(model.buildId);
            scriptId(model.scriptId);
            limit(model.limit);
            nextToken(model.nextToken);
        }

        public final String getBuildId() {
            return buildId;
        }

        @Override
        public final Builder buildId(String buildId) {
            this.buildId = buildId;
            return this;
        }

        public final void setBuildId(String buildId) {
            this.buildId = buildId;
        }

        public final String getScriptId() {
            return scriptId;
        }

        @Override
        public final Builder scriptId(String scriptId) {
            this.scriptId = scriptId;
            return this;
        }

        public final void setScriptId(String scriptId) {
            this.scriptId = scriptId;
        }

        public final Integer getLimit() {
            return limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListFleetsRequest build() {
            return new ListFleetsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
