/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A fleet location and its life-cycle state. A location state object might be used to describe a fleet's remote
 * location or home Region. Life-cycle state tracks the progress of launching the first instance in a new location and
 * preparing it for game hosting, and then removing all instances and deleting the location from the fleet.
 * </p>
 * <p>
 * <b>Related actions</b>
 * </p>
 * <p>
 * <a>CreateFleet</a> | <a>CreateFleetLocations</a> | <a>DeleteFleetLocations</a>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LocationState implements SdkPojo, Serializable, ToCopyableBuilder<LocationState.Builder, LocationState> {
    private static final SdkField<String> LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Location").getter(getter(LocationState::location)).setter(setter(Builder::location))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(LocationState::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATION_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String location;

    private final String status;

    private LocationState(BuilderImpl builder) {
        this.location = builder.location;
        this.status = builder.status;
    }

    /**
     * <p>
     * The fleet location, expressed as an AWS Region code such as <code>us-west-2</code>.
     * </p>
     * 
     * @return The fleet location, expressed as an AWS Region code such as <code>us-west-2</code>.
     */
    public final String location() {
        return location;
    }

    /**
     * <p>
     * The life-cycle status of a fleet location.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FleetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The life-cycle status of a fleet location.
     * @see FleetStatus
     */
    public final FleetStatus status() {
        return FleetStatus.fromValue(status);
    }

    /**
     * <p>
     * The life-cycle status of a fleet location.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FleetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The life-cycle status of a fleet location.
     * @see FleetStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LocationState)) {
            return false;
        }
        LocationState other = (LocationState) obj;
        return Objects.equals(location(), other.location()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LocationState").add("Location", location()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Location":
            return Optional.ofNullable(clazz.cast(location()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LocationState, T> g) {
        return obj -> g.apply((LocationState) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LocationState> {
        /**
         * <p>
         * The fleet location, expressed as an AWS Region code such as <code>us-west-2</code>.
         * </p>
         * 
         * @param location
         *        The fleet location, expressed as an AWS Region code such as <code>us-west-2</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);

        /**
         * <p>
         * The life-cycle status of a fleet location.
         * </p>
         * 
         * @param status
         *        The life-cycle status of a fleet location.
         * @see FleetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The life-cycle status of a fleet location.
         * </p>
         * 
         * @param status
         *        The life-cycle status of a fleet location.
         * @see FleetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetStatus
         */
        Builder status(FleetStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String location;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(LocationState model) {
            location(model.location);
            status(model.status);
        }

        public final String getLocation() {
            return location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FleetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public LocationState build() {
            return new LocationState(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
