/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input for a request operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateFleetLocationsRequest extends GameLiftRequest implements
        ToCopyableBuilder<CreateFleetLocationsRequest.Builder, CreateFleetLocationsRequest> {
    private static final SdkField<String> FLEET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FleetId").getter(getter(CreateFleetLocationsRequest::fleetId)).setter(setter(Builder::fleetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId").build()).build();

    private static final SdkField<List<LocationConfiguration>> LOCATIONS_FIELD = SdkField
            .<List<LocationConfiguration>> builder(MarshallingType.LIST)
            .memberName("Locations")
            .getter(getter(CreateFleetLocationsRequest::locations))
            .setter(setter(Builder::locations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Locations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LocationConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(LocationConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ID_FIELD,
            LOCATIONS_FIELD));

    private final String fleetId;

    private final List<LocationConfiguration> locations;

    private CreateFleetLocationsRequest(BuilderImpl builder) {
        super(builder);
        this.fleetId = builder.fleetId;
        this.locations = builder.locations;
    }

    /**
     * <p>
     * A unique identifier for the fleet to add locations to. You can use either the fleet ID or ARN value.
     * </p>
     * 
     * @return A unique identifier for the fleet to add locations to. You can use either the fleet ID or ARN value.
     */
    public final String fleetId() {
        return fleetId;
    }

    /**
     * Returns true if the Locations property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasLocations() {
        return locations != null && !(locations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of locations to deploy additional instances to and manage as part of the fleet. You can add any
     * GameLift-supported AWS Region as a remote location, in the form of an AWS Region code such as
     * <code>us-west-2</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLocations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of locations to deploy additional instances to and manage as part of the fleet. You can add any
     *         GameLift-supported AWS Region as a remote location, in the form of an AWS Region code such as
     *         <code>us-west-2</code>.
     */
    public final List<LocationConfiguration> locations() {
        return locations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(hasLocations() ? locations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFleetLocationsRequest)) {
            return false;
        }
        CreateFleetLocationsRequest other = (CreateFleetLocationsRequest) obj;
        return Objects.equals(fleetId(), other.fleetId()) && hasLocations() == other.hasLocations()
                && Objects.equals(locations(), other.locations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateFleetLocationsRequest").add("FleetId", fleetId())
                .add("Locations", hasLocations() ? locations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FleetId":
            return Optional.ofNullable(clazz.cast(fleetId()));
        case "Locations":
            return Optional.ofNullable(clazz.cast(locations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateFleetLocationsRequest, T> g) {
        return obj -> g.apply((CreateFleetLocationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateFleetLocationsRequest> {
        /**
         * <p>
         * A unique identifier for the fleet to add locations to. You can use either the fleet ID or ARN value.
         * </p>
         * 
         * @param fleetId
         *        A unique identifier for the fleet to add locations to. You can use either the fleet ID or ARN value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetId(String fleetId);

        /**
         * <p>
         * A list of locations to deploy additional instances to and manage as part of the fleet. You can add any
         * GameLift-supported AWS Region as a remote location, in the form of an AWS Region code such as
         * <code>us-west-2</code>.
         * </p>
         * 
         * @param locations
         *        A list of locations to deploy additional instances to and manage as part of the fleet. You can add any
         *        GameLift-supported AWS Region as a remote location, in the form of an AWS Region code such as
         *        <code>us-west-2</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locations(Collection<LocationConfiguration> locations);

        /**
         * <p>
         * A list of locations to deploy additional instances to and manage as part of the fleet. You can add any
         * GameLift-supported AWS Region as a remote location, in the form of an AWS Region code such as
         * <code>us-west-2</code>.
         * </p>
         * 
         * @param locations
         *        A list of locations to deploy additional instances to and manage as part of the fleet. You can add any
         *        GameLift-supported AWS Region as a remote location, in the form of an AWS Region code such as
         *        <code>us-west-2</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locations(LocationConfiguration... locations);

        /**
         * <p>
         * A list of locations to deploy additional instances to and manage as part of the fleet. You can add any
         * GameLift-supported AWS Region as a remote location, in the form of an AWS Region code such as
         * <code>us-west-2</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LocationConfiguration>.Builder} avoiding
         * the need to create one manually via {@link List<LocationConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LocationConfiguration>.Builder#build()} is called
         * immediately and its result is passed to {@link #locations(List<LocationConfiguration>)}.
         * 
         * @param locations
         *        a consumer that will call methods on {@link List<LocationConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #locations(List<LocationConfiguration>)
         */
        Builder locations(Consumer<LocationConfiguration.Builder>... locations);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GameLiftRequest.BuilderImpl implements Builder {
        private String fleetId;

        private List<LocationConfiguration> locations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFleetLocationsRequest model) {
            super(model);
            fleetId(model.fleetId);
            locations(model.locations);
        }

        public final String getFleetId() {
            return fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        public final List<LocationConfiguration.Builder> getLocations() {
            List<LocationConfiguration.Builder> result = LocationConfigurationListCopier.copyToBuilder(this.locations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder locations(Collection<LocationConfiguration> locations) {
            this.locations = LocationConfigurationListCopier.copy(locations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder locations(LocationConfiguration... locations) {
            locations(Arrays.asList(locations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder locations(Consumer<LocationConfiguration.Builder>... locations) {
            locations(Stream.of(locations).map(c -> LocationConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setLocations(Collection<LocationConfiguration.BuilderImpl> locations) {
            this.locations = LocationConfigurationListCopier.copyFromBuilder(locations);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFleetLocationsRequest build() {
            return new CreateFleetLocationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
