/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A set of instructions for launching server processes on each instance in a fleet. Server processes run either an
 * executable in a custom game build or a Realtime Servers script. Server process configurations are part of a fleet's
 * <a>RuntimeConfiguration</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServerProcess implements SdkPojo, Serializable, ToCopyableBuilder<ServerProcess.Builder, ServerProcess> {
    private static final SdkField<String> LAUNCH_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LaunchPath").getter(getter(ServerProcess::launchPath)).setter(setter(Builder::launchPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchPath").build()).build();

    private static final SdkField<String> PARAMETERS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Parameters").getter(getter(ServerProcess::parameters)).setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build()).build();

    private static final SdkField<Integer> CONCURRENT_EXECUTIONS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ConcurrentExecutions").getter(getter(ServerProcess::concurrentExecutions))
            .setter(setter(Builder::concurrentExecutions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConcurrentExecutions").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAUNCH_PATH_FIELD,
            PARAMETERS_FIELD, CONCURRENT_EXECUTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String launchPath;

    private final String parameters;

    private final Integer concurrentExecutions;

    private ServerProcess(BuilderImpl builder) {
        this.launchPath = builder.launchPath;
        this.parameters = builder.parameters;
        this.concurrentExecutions = builder.concurrentExecutions;
    }

    /**
     * <p>
     * The location of a game build executable or the Realtime script file that contains the <code>Init()</code>
     * function. Game builds and Realtime scripts are installed on instances at the root:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Windows (custom game builds only): <code>C:\game</code>. Example: "<code>C:\game\MyGame\server.exe</code>"
     * </p>
     * </li>
     * <li>
     * <p>
     * Linux: <code>/local/game</code>. Examples: "<code>/local/game/MyGame/server.exe</code>" or "
     * <code>/local/game/MyRealtimeScript.js</code>"
     * </p>
     * </li>
     * </ul>
     * 
     * @return The location of a game build executable or the Realtime script file that contains the <code>Init()</code>
     *         function. Game builds and Realtime scripts are installed on instances at the root: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Windows (custom game builds only): <code>C:\game</code>. Example: "<code>C:\game\MyGame\server.exe</code>
     *         "
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Linux: <code>/local/game</code>. Examples: "<code>/local/game/MyGame/server.exe</code>" or "
     *         <code>/local/game/MyRealtimeScript.js</code>"
     *         </p>
     *         </li>
     */
    public final String launchPath() {
        return launchPath;
    }

    /**
     * <p>
     * An optional list of parameters to pass to the server executable or Realtime script on launch.
     * </p>
     * 
     * @return An optional list of parameters to pass to the server executable or Realtime script on launch.
     */
    public final String parameters() {
        return parameters;
    }

    /**
     * <p>
     * The number of server processes using this configuration that run concurrently on each instance.
     * </p>
     * 
     * @return The number of server processes using this configuration that run concurrently on each instance.
     */
    public final Integer concurrentExecutions() {
        return concurrentExecutions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(launchPath());
        hashCode = 31 * hashCode + Objects.hashCode(parameters());
        hashCode = 31 * hashCode + Objects.hashCode(concurrentExecutions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServerProcess)) {
            return false;
        }
        ServerProcess other = (ServerProcess) obj;
        return Objects.equals(launchPath(), other.launchPath()) && Objects.equals(parameters(), other.parameters())
                && Objects.equals(concurrentExecutions(), other.concurrentExecutions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServerProcess").add("LaunchPath", launchPath()).add("Parameters", parameters())
                .add("ConcurrentExecutions", concurrentExecutions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LaunchPath":
            return Optional.ofNullable(clazz.cast(launchPath()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "ConcurrentExecutions":
            return Optional.ofNullable(clazz.cast(concurrentExecutions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServerProcess, T> g) {
        return obj -> g.apply((ServerProcess) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServerProcess> {
        /**
         * <p>
         * The location of a game build executable or the Realtime script file that contains the <code>Init()</code>
         * function. Game builds and Realtime scripts are installed on instances at the root:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Windows (custom game builds only): <code>C:\game</code>. Example: "<code>C:\game\MyGame\server.exe</code>"
         * </p>
         * </li>
         * <li>
         * <p>
         * Linux: <code>/local/game</code>. Examples: "<code>/local/game/MyGame/server.exe</code>" or "
         * <code>/local/game/MyRealtimeScript.js</code>"
         * </p>
         * </li>
         * </ul>
         * 
         * @param launchPath
         *        The location of a game build executable or the Realtime script file that contains the
         *        <code>Init()</code> function. Game builds and Realtime scripts are installed on instances at the root:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Windows (custom game builds only): <code>C:\game</code>. Example: "
         *        <code>C:\game\MyGame\server.exe</code>"
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Linux: <code>/local/game</code>. Examples: "<code>/local/game/MyGame/server.exe</code>" or "
         *        <code>/local/game/MyRealtimeScript.js</code>"
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchPath(String launchPath);

        /**
         * <p>
         * An optional list of parameters to pass to the server executable or Realtime script on launch.
         * </p>
         * 
         * @param parameters
         *        An optional list of parameters to pass to the server executable or Realtime script on launch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(String parameters);

        /**
         * <p>
         * The number of server processes using this configuration that run concurrently on each instance.
         * </p>
         * 
         * @param concurrentExecutions
         *        The number of server processes using this configuration that run concurrently on each instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder concurrentExecutions(Integer concurrentExecutions);
    }

    static final class BuilderImpl implements Builder {
        private String launchPath;

        private String parameters;

        private Integer concurrentExecutions;

        private BuilderImpl() {
        }

        private BuilderImpl(ServerProcess model) {
            launchPath(model.launchPath);
            parameters(model.parameters);
            concurrentExecutions(model.concurrentExecutions);
        }

        public final String getLaunchPath() {
            return launchPath;
        }

        @Override
        public final Builder launchPath(String launchPath) {
            this.launchPath = launchPath;
            return this;
        }

        public final void setLaunchPath(String launchPath) {
            this.launchPath = launchPath;
        }

        public final String getParameters() {
            return parameters;
        }

        @Override
        public final Builder parameters(String parameters) {
            this.parameters = parameters;
            return this;
        }

        public final void setParameters(String parameters) {
            this.parameters = parameters;
        }

        public final Integer getConcurrentExecutions() {
            return concurrentExecutions;
        }

        @Override
        public final Builder concurrentExecutions(Integer concurrentExecutions) {
            this.concurrentExecutions = concurrentExecutions;
            return this;
        }

        public final void setConcurrentExecutions(Integer concurrentExecutions) {
            this.concurrentExecutions = concurrentExecutions;
        }

        @Override
        public ServerProcess build() {
            return new ServerProcess(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
