/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the returned data in response to a request operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeMatchmakingConfigurationsResponse extends GameLiftResponse implements
        ToCopyableBuilder<DescribeMatchmakingConfigurationsResponse.Builder, DescribeMatchmakingConfigurationsResponse> {
    private static final SdkField<List<MatchmakingConfiguration>> CONFIGURATIONS_FIELD = SdkField
            .<List<MatchmakingConfiguration>> builder(MarshallingType.LIST)
            .memberName("Configurations")
            .getter(getter(DescribeMatchmakingConfigurationsResponse::configurations))
            .setter(setter(Builder::configurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MatchmakingConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(MatchmakingConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeMatchmakingConfigurationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<MatchmakingConfiguration> configurations;

    private final String nextToken;

    private DescribeMatchmakingConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.configurations = builder.configurations;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Configurations property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasConfigurations() {
        return configurations != null && !(configurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A collection of requested matchmaking configurations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasConfigurations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A collection of requested matchmaking configurations.
     */
    public final List<MatchmakingConfiguration> configurations() {
        return configurations;
    }

    /**
     * <p>
     * A token that indicates where to resume retrieving results on the next call to this operation. If no token is
     * returned, these results represent the end of the list.
     * </p>
     * 
     * @return A token that indicates where to resume retrieving results on the next call to this operation. If no token
     *         is returned, these results represent the end of the list.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasConfigurations() ? configurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMatchmakingConfigurationsResponse)) {
            return false;
        }
        DescribeMatchmakingConfigurationsResponse other = (DescribeMatchmakingConfigurationsResponse) obj;
        return hasConfigurations() == other.hasConfigurations() && Objects.equals(configurations(), other.configurations())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeMatchmakingConfigurationsResponse")
                .add("Configurations", hasConfigurations() ? configurations() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Configurations":
            return Optional.ofNullable(clazz.cast(configurations()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeMatchmakingConfigurationsResponse, T> g) {
        return obj -> g.apply((DescribeMatchmakingConfigurationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeMatchmakingConfigurationsResponse> {
        /**
         * <p>
         * A collection of requested matchmaking configurations.
         * </p>
         * 
         * @param configurations
         *        A collection of requested matchmaking configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurations(Collection<MatchmakingConfiguration> configurations);

        /**
         * <p>
         * A collection of requested matchmaking configurations.
         * </p>
         * 
         * @param configurations
         *        A collection of requested matchmaking configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurations(MatchmakingConfiguration... configurations);

        /**
         * <p>
         * A collection of requested matchmaking configurations.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MatchmakingConfiguration>.Builder} avoiding
         * the need to create one manually via {@link List<MatchmakingConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MatchmakingConfiguration>.Builder#build()} is called
         * immediately and its result is passed to {@link #configurations(List<MatchmakingConfiguration>)}.
         * 
         * @param configurations
         *        a consumer that will call methods on {@link List<MatchmakingConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configurations(List<MatchmakingConfiguration>)
         */
        Builder configurations(Consumer<MatchmakingConfiguration.Builder>... configurations);

        /**
         * <p>
         * A token that indicates where to resume retrieving results on the next call to this operation. If no token is
         * returned, these results represent the end of the list.
         * </p>
         * 
         * @param nextToken
         *        A token that indicates where to resume retrieving results on the next call to this operation. If no
         *        token is returned, these results represent the end of the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GameLiftResponse.BuilderImpl implements Builder {
        private List<MatchmakingConfiguration> configurations = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMatchmakingConfigurationsResponse model) {
            super(model);
            configurations(model.configurations);
            nextToken(model.nextToken);
        }

        public final List<MatchmakingConfiguration.Builder> getConfigurations() {
            List<MatchmakingConfiguration.Builder> result = MatchmakingConfigurationListCopier.copyToBuilder(this.configurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder configurations(Collection<MatchmakingConfiguration> configurations) {
            this.configurations = MatchmakingConfigurationListCopier.copy(configurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurations(MatchmakingConfiguration... configurations) {
            configurations(Arrays.asList(configurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurations(Consumer<MatchmakingConfiguration.Builder>... configurations) {
            configurations(Stream.of(configurations).map(c -> MatchmakingConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setConfigurations(Collection<MatchmakingConfiguration.BuilderImpl> configurations) {
            this.configurations = MatchmakingConfigurationListCopier.copyFromBuilder(configurations);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeMatchmakingConfigurationsResponse build() {
            return new DescribeMatchmakingConfigurationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
