/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the returned data in response to a request operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeFleetLocationAttributesResponse extends GameLiftResponse implements
        ToCopyableBuilder<DescribeFleetLocationAttributesResponse.Builder, DescribeFleetLocationAttributesResponse> {
    private static final SdkField<String> FLEET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FleetId").getter(getter(DescribeFleetLocationAttributesResponse::fleetId))
            .setter(setter(Builder::fleetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId").build()).build();

    private static final SdkField<String> FLEET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FleetArn").getter(getter(DescribeFleetLocationAttributesResponse::fleetArn))
            .setter(setter(Builder::fleetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetArn").build()).build();

    private static final SdkField<List<LocationAttributes>> LOCATION_ATTRIBUTES_FIELD = SdkField
            .<List<LocationAttributes>> builder(MarshallingType.LIST)
            .memberName("LocationAttributes")
            .getter(getter(DescribeFleetLocationAttributesResponse::locationAttributes))
            .setter(setter(Builder::locationAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LocationAttributes> builder(MarshallingType.SDK_POJO)
                                            .constructor(LocationAttributes::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeFleetLocationAttributesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ID_FIELD,
            FLEET_ARN_FIELD, LOCATION_ATTRIBUTES_FIELD, NEXT_TOKEN_FIELD));

    private final String fleetId;

    private final String fleetArn;

    private final List<LocationAttributes> locationAttributes;

    private final String nextToken;

    private DescribeFleetLocationAttributesResponse(BuilderImpl builder) {
        super(builder);
        this.fleetId = builder.fleetId;
        this.fleetArn = builder.fleetArn;
        this.locationAttributes = builder.locationAttributes;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A unique identifier for the fleet that location attributes were requested for.
     * </p>
     * 
     * @return A unique identifier for the fleet that location attributes were requested for.
     */
    public final String fleetId() {
        return fleetId;
    }

    /**
     * <p>
     * The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>)
     * that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions.
     * Format is <code>arn:aws:gamelift:&lt;region&gt;::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912</code>.
     * </p>
     * 
     * @return The Amazon Resource Name (<a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a
     *         GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is
     *         <code>arn:aws:gamelift:&lt;region&gt;::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912</code>.
     */
    public final String fleetArn() {
        return fleetArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the LocationAttributes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLocationAttributes() {
        return locationAttributes != null && !(locationAttributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Location-specific information on the requested fleet's remote locations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLocationAttributes} method.
     * </p>
     * 
     * @return Location-specific information on the requested fleet's remote locations.
     */
    public final List<LocationAttributes> locationAttributes() {
        return locationAttributes;
    }

    /**
     * <p>
     * A token that indicates where to resume retrieving results on the next call to this operation. If no token is
     * returned, these results represent the end of the list.
     * </p>
     * 
     * @return A token that indicates where to resume retrieving results on the next call to this operation. If no token
     *         is returned, these results represent the end of the list.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(fleetArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasLocationAttributes() ? locationAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFleetLocationAttributesResponse)) {
            return false;
        }
        DescribeFleetLocationAttributesResponse other = (DescribeFleetLocationAttributesResponse) obj;
        return Objects.equals(fleetId(), other.fleetId()) && Objects.equals(fleetArn(), other.fleetArn())
                && hasLocationAttributes() == other.hasLocationAttributes()
                && Objects.equals(locationAttributes(), other.locationAttributes())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeFleetLocationAttributesResponse").add("FleetId", fleetId()).add("FleetArn", fleetArn())
                .add("LocationAttributes", hasLocationAttributes() ? locationAttributes() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FleetId":
            return Optional.ofNullable(clazz.cast(fleetId()));
        case "FleetArn":
            return Optional.ofNullable(clazz.cast(fleetArn()));
        case "LocationAttributes":
            return Optional.ofNullable(clazz.cast(locationAttributes()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeFleetLocationAttributesResponse, T> g) {
        return obj -> g.apply((DescribeFleetLocationAttributesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeFleetLocationAttributesResponse> {
        /**
         * <p>
         * A unique identifier for the fleet that location attributes were requested for.
         * </p>
         * 
         * @param fleetId
         *        A unique identifier for the fleet that location attributes were requested for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetId(String fleetId);

        /**
         * <p>
         * The Amazon Resource Name (<a
         * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a
         * GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is
         * <code>arn:aws:gamelift:&lt;region&gt;::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912</code>.
         * </p>
         * 
         * @param fleetArn
         *        The Amazon Resource Name (<a
         *        href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to
         *        a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is
         *        <code>arn:aws:gamelift:&lt;region&gt;::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetArn(String fleetArn);

        /**
         * <p>
         * Location-specific information on the requested fleet's remote locations.
         * </p>
         * 
         * @param locationAttributes
         *        Location-specific information on the requested fleet's remote locations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locationAttributes(Collection<LocationAttributes> locationAttributes);

        /**
         * <p>
         * Location-specific information on the requested fleet's remote locations.
         * </p>
         * 
         * @param locationAttributes
         *        Location-specific information on the requested fleet's remote locations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locationAttributes(LocationAttributes... locationAttributes);

        /**
         * <p>
         * Location-specific information on the requested fleet's remote locations.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<LocationAttributes>.Builder}
         * avoiding the need to create one manually via {@link List<LocationAttributes>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LocationAttributes>.Builder#build()} is called immediately
         * and its result is passed to {@link #locationAttributes(List<LocationAttributes>)}.
         * 
         * @param locationAttributes
         *        a consumer that will call methods on {@link List<LocationAttributes>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #locationAttributes(List<LocationAttributes>)
         */
        Builder locationAttributes(Consumer<LocationAttributes.Builder>... locationAttributes);

        /**
         * <p>
         * A token that indicates where to resume retrieving results on the next call to this operation. If no token is
         * returned, these results represent the end of the list.
         * </p>
         * 
         * @param nextToken
         *        A token that indicates where to resume retrieving results on the next call to this operation. If no
         *        token is returned, these results represent the end of the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GameLiftResponse.BuilderImpl implements Builder {
        private String fleetId;

        private String fleetArn;

        private List<LocationAttributes> locationAttributes = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFleetLocationAttributesResponse model) {
            super(model);
            fleetId(model.fleetId);
            fleetArn(model.fleetArn);
            locationAttributes(model.locationAttributes);
            nextToken(model.nextToken);
        }

        public final String getFleetId() {
            return fleetId;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final String getFleetArn() {
            return fleetArn;
        }

        public final void setFleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
        }

        @Override
        public final Builder fleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
            return this;
        }

        public final List<LocationAttributes.Builder> getLocationAttributes() {
            List<LocationAttributes.Builder> result = LocationAttributesListCopier.copyToBuilder(this.locationAttributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLocationAttributes(Collection<LocationAttributes.BuilderImpl> locationAttributes) {
            this.locationAttributes = LocationAttributesListCopier.copyFromBuilder(locationAttributes);
        }

        @Override
        public final Builder locationAttributes(Collection<LocationAttributes> locationAttributes) {
            this.locationAttributes = LocationAttributesListCopier.copy(locationAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder locationAttributes(LocationAttributes... locationAttributes) {
            locationAttributes(Arrays.asList(locationAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder locationAttributes(Consumer<LocationAttributes.Builder>... locationAttributes) {
            locationAttributes(Stream.of(locationAttributes).map(c -> LocationAttributes.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeFleetLocationAttributesResponse build() {
            return new DescribeFleetLocationAttributesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
