/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Current resource capacity settings in a specified fleet or location. The location value might refer to a fleet's
 * remote location or its home Region.
 * </p>
 * <p>
 * <b>Related actions</b>
 * </p>
 * <p>
 * <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetCapacity.html">
 * DescribeFleetCapacity</a> | <a
 * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetLocationCapacity.html"
 * >DescribeFleetLocationCapacity</a> | <a
 * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateFleetCapacity.html">UpdateFleetCapacity</a>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FleetCapacity implements SdkPojo, Serializable, ToCopyableBuilder<FleetCapacity.Builder, FleetCapacity> {
    private static final SdkField<String> FLEET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FleetId").getter(getter(FleetCapacity::fleetId)).setter(setter(Builder::fleetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId").build()).build();

    private static final SdkField<String> FLEET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FleetArn").getter(getter(FleetCapacity::fleetArn)).setter(setter(Builder::fleetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetArn").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceType").getter(getter(FleetCapacity::instanceTypeAsString)).setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()).build();

    private static final SdkField<EC2InstanceCounts> INSTANCE_COUNTS_FIELD = SdkField
            .<EC2InstanceCounts> builder(MarshallingType.SDK_POJO).memberName("InstanceCounts")
            .getter(getter(FleetCapacity::instanceCounts)).setter(setter(Builder::instanceCounts))
            .constructor(EC2InstanceCounts::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCounts").build()).build();

    private static final SdkField<String> LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Location").getter(getter(FleetCapacity::location)).setter(setter(Builder::location))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ID_FIELD,
            FLEET_ARN_FIELD, INSTANCE_TYPE_FIELD, INSTANCE_COUNTS_FIELD, LOCATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String fleetId;

    private final String fleetArn;

    private final String instanceType;

    private final EC2InstanceCounts instanceCounts;

    private final String location;

    private FleetCapacity(BuilderImpl builder) {
        this.fleetId = builder.fleetId;
        this.fleetArn = builder.fleetArn;
        this.instanceType = builder.instanceType;
        this.instanceCounts = builder.instanceCounts;
        this.location = builder.location;
    }

    /**
     * <p>
     * A unique identifier for the fleet associated with the location.
     * </p>
     * 
     * @return A unique identifier for the fleet associated with the location.
     */
    public final String fleetId() {
        return fleetId;
    }

    /**
     * <p>
     * The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>)
     * that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions.
     * Format is <code>arn:aws:gamelift:&lt;region&gt;::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912</code>.
     * </p>
     * 
     * @return The Amazon Resource Name (<a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a
     *         GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is
     *         <code>arn:aws:gamelift:&lt;region&gt;::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912</code>.
     */
    public final String fleetArn() {
        return fleetArn;
    }

    /**
     * <p>
     * The Amazon EC2 instance type that is used for all instances in a fleet. The instance type determines the
     * computing resources in use, including CPU, memory, storage, and networking capacity. See <a
     * href="http://aws.amazon.com/ec2/instance-types/">Amazon Elastic Compute Cloud Instance Types</a> for detailed
     * descriptions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link EC2InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The Amazon EC2 instance type that is used for all instances in a fleet. The instance type determines the
     *         computing resources in use, including CPU, memory, storage, and networking capacity. See <a
     *         href="http://aws.amazon.com/ec2/instance-types/">Amazon Elastic Compute Cloud Instance Types</a> for
     *         detailed descriptions.
     * @see EC2InstanceType
     */
    public final EC2InstanceType instanceType() {
        return EC2InstanceType.fromValue(instanceType);
    }

    /**
     * <p>
     * The Amazon EC2 instance type that is used for all instances in a fleet. The instance type determines the
     * computing resources in use, including CPU, memory, storage, and networking capacity. See <a
     * href="http://aws.amazon.com/ec2/instance-types/">Amazon Elastic Compute Cloud Instance Types</a> for detailed
     * descriptions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link EC2InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The Amazon EC2 instance type that is used for all instances in a fleet. The instance type determines the
     *         computing resources in use, including CPU, memory, storage, and networking capacity. See <a
     *         href="http://aws.amazon.com/ec2/instance-types/">Amazon Elastic Compute Cloud Instance Types</a> for
     *         detailed descriptions.
     * @see EC2InstanceType
     */
    public final String instanceTypeAsString() {
        return instanceType;
    }

    /**
     * <p>
     * The current instance count and capacity settings for the fleet location.
     * </p>
     * 
     * @return The current instance count and capacity settings for the fleet location.
     */
    public final EC2InstanceCounts instanceCounts() {
        return instanceCounts;
    }

    /**
     * <p>
     * The fleet location for the instance count information, expressed as an Amazon Web Services Region code, such as
     * <code>us-west-2</code>.
     * </p>
     * 
     * @return The fleet location for the instance count information, expressed as an Amazon Web Services Region code,
     *         such as <code>us-west-2</code>.
     */
    public final String location() {
        return location;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(fleetArn());
        hashCode = 31 * hashCode + Objects.hashCode(instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(instanceCounts());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FleetCapacity)) {
            return false;
        }
        FleetCapacity other = (FleetCapacity) obj;
        return Objects.equals(fleetId(), other.fleetId()) && Objects.equals(fleetArn(), other.fleetArn())
                && Objects.equals(instanceTypeAsString(), other.instanceTypeAsString())
                && Objects.equals(instanceCounts(), other.instanceCounts()) && Objects.equals(location(), other.location());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FleetCapacity").add("FleetId", fleetId()).add("FleetArn", fleetArn())
                .add("InstanceType", instanceTypeAsString()).add("InstanceCounts", instanceCounts()).add("Location", location())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FleetId":
            return Optional.ofNullable(clazz.cast(fleetId()));
        case "FleetArn":
            return Optional.ofNullable(clazz.cast(fleetArn()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceTypeAsString()));
        case "InstanceCounts":
            return Optional.ofNullable(clazz.cast(instanceCounts()));
        case "Location":
            return Optional.ofNullable(clazz.cast(location()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FleetCapacity, T> g) {
        return obj -> g.apply((FleetCapacity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FleetCapacity> {
        /**
         * <p>
         * A unique identifier for the fleet associated with the location.
         * </p>
         * 
         * @param fleetId
         *        A unique identifier for the fleet associated with the location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetId(String fleetId);

        /**
         * <p>
         * The Amazon Resource Name (<a
         * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a
         * GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is
         * <code>arn:aws:gamelift:&lt;region&gt;::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912</code>.
         * </p>
         * 
         * @param fleetArn
         *        The Amazon Resource Name (<a
         *        href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to
         *        a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is
         *        <code>arn:aws:gamelift:&lt;region&gt;::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetArn(String fleetArn);

        /**
         * <p>
         * The Amazon EC2 instance type that is used for all instances in a fleet. The instance type determines the
         * computing resources in use, including CPU, memory, storage, and networking capacity. See <a
         * href="http://aws.amazon.com/ec2/instance-types/">Amazon Elastic Compute Cloud Instance Types</a> for detailed
         * descriptions.
         * </p>
         * 
         * @param instanceType
         *        The Amazon EC2 instance type that is used for all instances in a fleet. The instance type determines
         *        the computing resources in use, including CPU, memory, storage, and networking capacity. See <a
         *        href="http://aws.amazon.com/ec2/instance-types/">Amazon Elastic Compute Cloud Instance Types</a> for
         *        detailed descriptions.
         * @see EC2InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EC2InstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The Amazon EC2 instance type that is used for all instances in a fleet. The instance type determines the
         * computing resources in use, including CPU, memory, storage, and networking capacity. See <a
         * href="http://aws.amazon.com/ec2/instance-types/">Amazon Elastic Compute Cloud Instance Types</a> for detailed
         * descriptions.
         * </p>
         * 
         * @param instanceType
         *        The Amazon EC2 instance type that is used for all instances in a fleet. The instance type determines
         *        the computing resources in use, including CPU, memory, storage, and networking capacity. See <a
         *        href="http://aws.amazon.com/ec2/instance-types/">Amazon Elastic Compute Cloud Instance Types</a> for
         *        detailed descriptions.
         * @see EC2InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EC2InstanceType
         */
        Builder instanceType(EC2InstanceType instanceType);

        /**
         * <p>
         * The current instance count and capacity settings for the fleet location.
         * </p>
         * 
         * @param instanceCounts
         *        The current instance count and capacity settings for the fleet location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCounts(EC2InstanceCounts instanceCounts);

        /**
         * <p>
         * The current instance count and capacity settings for the fleet location.
         * </p>
         * This is a convenience method that creates an instance of the {@link EC2InstanceCounts.Builder} avoiding the
         * need to create one manually via {@link EC2InstanceCounts#builder()}.
         *
         * When the {@link Consumer} completes, {@link EC2InstanceCounts.Builder#build()} is called immediately and its
         * result is passed to {@link #instanceCounts(EC2InstanceCounts)}.
         * 
         * @param instanceCounts
         *        a consumer that will call methods on {@link EC2InstanceCounts.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceCounts(EC2InstanceCounts)
         */
        default Builder instanceCounts(Consumer<EC2InstanceCounts.Builder> instanceCounts) {
            return instanceCounts(EC2InstanceCounts.builder().applyMutation(instanceCounts).build());
        }

        /**
         * <p>
         * The fleet location for the instance count information, expressed as an Amazon Web Services Region code, such
         * as <code>us-west-2</code>.
         * </p>
         * 
         * @param location
         *        The fleet location for the instance count information, expressed as an Amazon Web Services Region
         *        code, such as <code>us-west-2</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);
    }

    static final class BuilderImpl implements Builder {
        private String fleetId;

        private String fleetArn;

        private String instanceType;

        private EC2InstanceCounts instanceCounts;

        private String location;

        private BuilderImpl() {
        }

        private BuilderImpl(FleetCapacity model) {
            fleetId(model.fleetId);
            fleetArn(model.fleetArn);
            instanceType(model.instanceType);
            instanceCounts(model.instanceCounts);
            location(model.location);
        }

        public final String getFleetId() {
            return fleetId;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final String getFleetArn() {
            return fleetArn;
        }

        public final void setFleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
        }

        @Override
        public final Builder fleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(EC2InstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final EC2InstanceCounts.Builder getInstanceCounts() {
            return instanceCounts != null ? instanceCounts.toBuilder() : null;
        }

        public final void setInstanceCounts(EC2InstanceCounts.BuilderImpl instanceCounts) {
            this.instanceCounts = instanceCounts != null ? instanceCounts.build() : null;
        }

        @Override
        public final Builder instanceCounts(EC2InstanceCounts instanceCounts) {
            this.instanceCounts = instanceCounts;
            return this;
        }

        public final String getLocation() {
            return location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        @Override
        public FleetCapacity build() {
            return new FleetCapacity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
