/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a peering connection between a VPC on one of your Amazon Web Services accounts and the VPC for your Amazon
 * GameLift fleets. This record may be for an active peering connection or a pending connection that has not yet been
 * established.
 * </p>
 * <p>
 * <b>Related actions</b>
 * </p>
 * <p>
 * <a>CreateVpcPeeringAuthorization</a> | <a>DescribeVpcPeeringAuthorizations</a> | <a>DeleteVpcPeeringAuthorization</a>
 * | <a>CreateVpcPeeringConnection</a> | <a>DescribeVpcPeeringConnections</a> | <a>DeleteVpcPeeringConnection</a> | <a
 * href=
 * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
 * >All APIs by task</a>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VpcPeeringConnection implements SdkPojo, Serializable,
        ToCopyableBuilder<VpcPeeringConnection.Builder, VpcPeeringConnection> {
    private static final SdkField<String> FLEET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FleetId").getter(getter(VpcPeeringConnection::fleetId)).setter(setter(Builder::fleetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId").build()).build();

    private static final SdkField<String> FLEET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FleetArn").getter(getter(VpcPeeringConnection::fleetArn)).setter(setter(Builder::fleetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetArn").build()).build();

    private static final SdkField<String> IP_V4_CIDR_BLOCK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IpV4CidrBlock").getter(getter(VpcPeeringConnection::ipV4CidrBlock))
            .setter(setter(Builder::ipV4CidrBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpV4CidrBlock").build()).build();

    private static final SdkField<String> VPC_PEERING_CONNECTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VpcPeeringConnectionId").getter(getter(VpcPeeringConnection::vpcPeeringConnectionId))
            .setter(setter(Builder::vpcPeeringConnectionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcPeeringConnectionId").build())
            .build();

    private static final SdkField<VpcPeeringConnectionStatus> STATUS_FIELD = SdkField
            .<VpcPeeringConnectionStatus> builder(MarshallingType.SDK_POJO).memberName("Status")
            .getter(getter(VpcPeeringConnection::status)).setter(setter(Builder::status))
            .constructor(VpcPeeringConnectionStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> PEER_VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PeerVpcId").getter(getter(VpcPeeringConnection::peerVpcId)).setter(setter(Builder::peerVpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerVpcId").build()).build();

    private static final SdkField<String> GAME_LIFT_VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GameLiftVpcId").getter(getter(VpcPeeringConnection::gameLiftVpcId))
            .setter(setter(Builder::gameLiftVpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameLiftVpcId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ID_FIELD,
            FLEET_ARN_FIELD, IP_V4_CIDR_BLOCK_FIELD, VPC_PEERING_CONNECTION_ID_FIELD, STATUS_FIELD, PEER_VPC_ID_FIELD,
            GAME_LIFT_VPC_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String fleetId;

    private final String fleetArn;

    private final String ipV4CidrBlock;

    private final String vpcPeeringConnectionId;

    private final VpcPeeringConnectionStatus status;

    private final String peerVpcId;

    private final String gameLiftVpcId;

    private VpcPeeringConnection(BuilderImpl builder) {
        this.fleetId = builder.fleetId;
        this.fleetArn = builder.fleetArn;
        this.ipV4CidrBlock = builder.ipV4CidrBlock;
        this.vpcPeeringConnectionId = builder.vpcPeeringConnectionId;
        this.status = builder.status;
        this.peerVpcId = builder.peerVpcId;
        this.gameLiftVpcId = builder.gameLiftVpcId;
    }

    /**
     * <p>
     * A unique identifier for the fleet. This ID determines the ID of the Amazon GameLift VPC for your fleet.
     * </p>
     * 
     * @return A unique identifier for the fleet. This ID determines the ID of the Amazon GameLift VPC for your fleet.
     */
    public final String fleetId() {
        return fleetId;
    }

    /**
     * <p>
     * The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>)
     * associated with the GameLift fleet resource for this connection.
     * </p>
     * 
     * @return The Amazon Resource Name (<a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) associated with the
     *         GameLift fleet resource for this connection.
     */
    public final String fleetArn() {
        return fleetArn;
    }

    /**
     * <p>
     * CIDR block of IPv4 addresses assigned to the VPC peering connection for the GameLift VPC. The peered VPC also has
     * an IPv4 CIDR block associated with it; these blocks cannot overlap or the peering connection cannot be created.
     * </p>
     * 
     * @return CIDR block of IPv4 addresses assigned to the VPC peering connection for the GameLift VPC. The peered VPC
     *         also has an IPv4 CIDR block associated with it; these blocks cannot overlap or the peering connection
     *         cannot be created.
     */
    public final String ipV4CidrBlock() {
        return ipV4CidrBlock;
    }

    /**
     * <p>
     * A unique identifier that is automatically assigned to the connection record. This ID is referenced in VPC peering
     * connection events, and is used when deleting a connection with <a>DeleteVpcPeeringConnection</a>.
     * </p>
     * 
     * @return A unique identifier that is automatically assigned to the connection record. This ID is referenced in VPC
     *         peering connection events, and is used when deleting a connection with <a>DeleteVpcPeeringConnection</a>.
     */
    public final String vpcPeeringConnectionId() {
        return vpcPeeringConnectionId;
    }

    /**
     * <p>
     * The status information about the connection. Status indicates if a connection is pending, successful, or failed.
     * </p>
     * 
     * @return The status information about the connection. Status indicates if a connection is pending, successful, or
     *         failed.
     */
    public final VpcPeeringConnectionStatus status() {
        return status;
    }

    /**
     * <p>
     * A unique identifier for a VPC with resources to be accessed by your GameLift fleet. The VPC must be in the same
     * Region as your fleet. To look up a VPC ID, use the <a href="https://console.aws.amazon.com/vpc/">VPC
     * Dashboard</a> in the Amazon Web Services Management Console. Learn more about VPC peering in <a
     * href="https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html">VPC Peering with GameLift
     * Fleets</a>.
     * </p>
     * 
     * @return A unique identifier for a VPC with resources to be accessed by your GameLift fleet. The VPC must be in
     *         the same Region as your fleet. To look up a VPC ID, use the <a
     *         href="https://console.aws.amazon.com/vpc/">VPC Dashboard</a> in the Amazon Web Services Management
     *         Console. Learn more about VPC peering in <a
     *         href="https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html">VPC Peering with
     *         GameLift Fleets</a>.
     */
    public final String peerVpcId() {
        return peerVpcId;
    }

    /**
     * <p>
     * A unique identifier for the VPC that contains the Amazon GameLift fleet for this connection. This VPC is managed
     * by Amazon GameLift and does not appear in your Amazon Web Services account.
     * </p>
     * 
     * @return A unique identifier for the VPC that contains the Amazon GameLift fleet for this connection. This VPC is
     *         managed by Amazon GameLift and does not appear in your Amazon Web Services account.
     */
    public final String gameLiftVpcId() {
        return gameLiftVpcId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(fleetArn());
        hashCode = 31 * hashCode + Objects.hashCode(ipV4CidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(vpcPeeringConnectionId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(peerVpcId());
        hashCode = 31 * hashCode + Objects.hashCode(gameLiftVpcId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcPeeringConnection)) {
            return false;
        }
        VpcPeeringConnection other = (VpcPeeringConnection) obj;
        return Objects.equals(fleetId(), other.fleetId()) && Objects.equals(fleetArn(), other.fleetArn())
                && Objects.equals(ipV4CidrBlock(), other.ipV4CidrBlock())
                && Objects.equals(vpcPeeringConnectionId(), other.vpcPeeringConnectionId())
                && Objects.equals(status(), other.status()) && Objects.equals(peerVpcId(), other.peerVpcId())
                && Objects.equals(gameLiftVpcId(), other.gameLiftVpcId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VpcPeeringConnection").add("FleetId", fleetId()).add("FleetArn", fleetArn())
                .add("IpV4CidrBlock", ipV4CidrBlock()).add("VpcPeeringConnectionId", vpcPeeringConnectionId())
                .add("Status", status()).add("PeerVpcId", peerVpcId()).add("GameLiftVpcId", gameLiftVpcId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FleetId":
            return Optional.ofNullable(clazz.cast(fleetId()));
        case "FleetArn":
            return Optional.ofNullable(clazz.cast(fleetArn()));
        case "IpV4CidrBlock":
            return Optional.ofNullable(clazz.cast(ipV4CidrBlock()));
        case "VpcPeeringConnectionId":
            return Optional.ofNullable(clazz.cast(vpcPeeringConnectionId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "PeerVpcId":
            return Optional.ofNullable(clazz.cast(peerVpcId()));
        case "GameLiftVpcId":
            return Optional.ofNullable(clazz.cast(gameLiftVpcId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VpcPeeringConnection, T> g) {
        return obj -> g.apply((VpcPeeringConnection) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VpcPeeringConnection> {
        /**
         * <p>
         * A unique identifier for the fleet. This ID determines the ID of the Amazon GameLift VPC for your fleet.
         * </p>
         * 
         * @param fleetId
         *        A unique identifier for the fleet. This ID determines the ID of the Amazon GameLift VPC for your
         *        fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetId(String fleetId);

        /**
         * <p>
         * The Amazon Resource Name (<a
         * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) associated with the
         * GameLift fleet resource for this connection.
         * </p>
         * 
         * @param fleetArn
         *        The Amazon Resource Name (<a
         *        href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) associated with the
         *        GameLift fleet resource for this connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetArn(String fleetArn);

        /**
         * <p>
         * CIDR block of IPv4 addresses assigned to the VPC peering connection for the GameLift VPC. The peered VPC also
         * has an IPv4 CIDR block associated with it; these blocks cannot overlap or the peering connection cannot be
         * created.
         * </p>
         * 
         * @param ipV4CidrBlock
         *        CIDR block of IPv4 addresses assigned to the VPC peering connection for the GameLift VPC. The peered
         *        VPC also has an IPv4 CIDR block associated with it; these blocks cannot overlap or the peering
         *        connection cannot be created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipV4CidrBlock(String ipV4CidrBlock);

        /**
         * <p>
         * A unique identifier that is automatically assigned to the connection record. This ID is referenced in VPC
         * peering connection events, and is used when deleting a connection with <a>DeleteVpcPeeringConnection</a>.
         * </p>
         * 
         * @param vpcPeeringConnectionId
         *        A unique identifier that is automatically assigned to the connection record. This ID is referenced in
         *        VPC peering connection events, and is used when deleting a connection with
         *        <a>DeleteVpcPeeringConnection</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcPeeringConnectionId(String vpcPeeringConnectionId);

        /**
         * <p>
         * The status information about the connection. Status indicates if a connection is pending, successful, or
         * failed.
         * </p>
         * 
         * @param status
         *        The status information about the connection. Status indicates if a connection is pending, successful,
         *        or failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(VpcPeeringConnectionStatus status);

        /**
         * <p>
         * The status information about the connection. Status indicates if a connection is pending, successful, or
         * failed.
         * </p>
         * This is a convenience method that creates an instance of the {@link VpcPeeringConnectionStatus.Builder}
         * avoiding the need to create one manually via {@link VpcPeeringConnectionStatus#builder()}.
         *
         * When the {@link Consumer} completes, {@link VpcPeeringConnectionStatus.Builder#build()} is called immediately
         * and its result is passed to {@link #status(VpcPeeringConnectionStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link VpcPeeringConnectionStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(VpcPeeringConnectionStatus)
         */
        default Builder status(Consumer<VpcPeeringConnectionStatus.Builder> status) {
            return status(VpcPeeringConnectionStatus.builder().applyMutation(status).build());
        }

        /**
         * <p>
         * A unique identifier for a VPC with resources to be accessed by your GameLift fleet. The VPC must be in the
         * same Region as your fleet. To look up a VPC ID, use the <a href="https://console.aws.amazon.com/vpc/">VPC
         * Dashboard</a> in the Amazon Web Services Management Console. Learn more about VPC peering in <a
         * href="https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html">VPC Peering with GameLift
         * Fleets</a>.
         * </p>
         * 
         * @param peerVpcId
         *        A unique identifier for a VPC with resources to be accessed by your GameLift fleet. The VPC must be in
         *        the same Region as your fleet. To look up a VPC ID, use the <a
         *        href="https://console.aws.amazon.com/vpc/">VPC Dashboard</a> in the Amazon Web Services Management
         *        Console. Learn more about VPC peering in <a
         *        href="https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html">VPC Peering with
         *        GameLift Fleets</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peerVpcId(String peerVpcId);

        /**
         * <p>
         * A unique identifier for the VPC that contains the Amazon GameLift fleet for this connection. This VPC is
         * managed by Amazon GameLift and does not appear in your Amazon Web Services account.
         * </p>
         * 
         * @param gameLiftVpcId
         *        A unique identifier for the VPC that contains the Amazon GameLift fleet for this connection. This VPC
         *        is managed by Amazon GameLift and does not appear in your Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameLiftVpcId(String gameLiftVpcId);
    }

    static final class BuilderImpl implements Builder {
        private String fleetId;

        private String fleetArn;

        private String ipV4CidrBlock;

        private String vpcPeeringConnectionId;

        private VpcPeeringConnectionStatus status;

        private String peerVpcId;

        private String gameLiftVpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcPeeringConnection model) {
            fleetId(model.fleetId);
            fleetArn(model.fleetArn);
            ipV4CidrBlock(model.ipV4CidrBlock);
            vpcPeeringConnectionId(model.vpcPeeringConnectionId);
            status(model.status);
            peerVpcId(model.peerVpcId);
            gameLiftVpcId(model.gameLiftVpcId);
        }

        public final String getFleetId() {
            return fleetId;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final String getFleetArn() {
            return fleetArn;
        }

        public final void setFleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
        }

        @Override
        public final Builder fleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
            return this;
        }

        public final String getIpV4CidrBlock() {
            return ipV4CidrBlock;
        }

        public final void setIpV4CidrBlock(String ipV4CidrBlock) {
            this.ipV4CidrBlock = ipV4CidrBlock;
        }

        @Override
        public final Builder ipV4CidrBlock(String ipV4CidrBlock) {
            this.ipV4CidrBlock = ipV4CidrBlock;
            return this;
        }

        public final String getVpcPeeringConnectionId() {
            return vpcPeeringConnectionId;
        }

        public final void setVpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
        }

        @Override
        public final Builder vpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
            return this;
        }

        public final VpcPeeringConnectionStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(VpcPeeringConnectionStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(VpcPeeringConnectionStatus status) {
            this.status = status;
            return this;
        }

        public final String getPeerVpcId() {
            return peerVpcId;
        }

        public final void setPeerVpcId(String peerVpcId) {
            this.peerVpcId = peerVpcId;
        }

        @Override
        public final Builder peerVpcId(String peerVpcId) {
            this.peerVpcId = peerVpcId;
            return this;
        }

        public final String getGameLiftVpcId() {
            return gameLiftVpcId;
        }

        public final void setGameLiftVpcId(String gameLiftVpcId) {
            this.gameLiftVpcId = gameLiftVpcId;
        }

        @Override
        public final Builder gameLiftVpcId(String gameLiftVpcId) {
            this.gameLiftVpcId = gameLiftVpcId;
            return this;
        }

        @Override
        public VpcPeeringConnection build() {
            return new VpcPeeringConnection(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
