/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateGameServerGroupRequest extends GameLiftRequest implements
        ToCopyableBuilder<UpdateGameServerGroupRequest.Builder, UpdateGameServerGroupRequest> {
    private static final SdkField<String> GAME_SERVER_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GameServerGroupName").getter(getter(UpdateGameServerGroupRequest::gameServerGroupName))
            .setter(setter(Builder::gameServerGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameServerGroupName").build())
            .build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(UpdateGameServerGroupRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<List<InstanceDefinition>> INSTANCE_DEFINITIONS_FIELD = SdkField
            .<List<InstanceDefinition>> builder(MarshallingType.LIST)
            .memberName("InstanceDefinitions")
            .getter(getter(UpdateGameServerGroupRequest::instanceDefinitions))
            .setter(setter(Builder::instanceDefinitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceDefinitions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InstanceDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> GAME_SERVER_PROTECTION_POLICY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("GameServerProtectionPolicy")
            .getter(getter(UpdateGameServerGroupRequest::gameServerProtectionPolicyAsString))
            .setter(setter(Builder::gameServerProtectionPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameServerProtectionPolicy").build())
            .build();

    private static final SdkField<String> BALANCING_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BalancingStrategy").getter(getter(UpdateGameServerGroupRequest::balancingStrategyAsString))
            .setter(setter(Builder::balancingStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BalancingStrategy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GAME_SERVER_GROUP_NAME_FIELD,
            ROLE_ARN_FIELD, INSTANCE_DEFINITIONS_FIELD, GAME_SERVER_PROTECTION_POLICY_FIELD, BALANCING_STRATEGY_FIELD));

    private final String gameServerGroupName;

    private final String roleArn;

    private final List<InstanceDefinition> instanceDefinitions;

    private final String gameServerProtectionPolicy;

    private final String balancingStrategy;

    private UpdateGameServerGroupRequest(BuilderImpl builder) {
        super(builder);
        this.gameServerGroupName = builder.gameServerGroupName;
        this.roleArn = builder.roleArn;
        this.instanceDefinitions = builder.instanceDefinitions;
        this.gameServerProtectionPolicy = builder.gameServerProtectionPolicy;
        this.balancingStrategy = builder.balancingStrategy;
    }

    /**
     * <p>
     * A unique identifier for the game server group. Use either the <a>GameServerGroup</a> name or ARN value.
     * </p>
     * 
     * @return A unique identifier for the game server group. Use either the <a>GameServerGroup</a> name or ARN value.
     */
    public final String gameServerGroupName() {
        return gameServerGroupName;
    }

    /**
     * <p>
     * The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>)
     * for an IAM role that allows Amazon GameLift to access your Amazon EC2 Auto Scaling groups.
     * </p>
     * 
     * @return The Amazon Resource Name (<a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) for an IAM role that
     *         allows Amazon GameLift to access your Amazon EC2 Auto Scaling groups.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the InstanceDefinitions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInstanceDefinitions() {
        return instanceDefinitions != null && !(instanceDefinitions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An updated list of Amazon EC2 instance types to use in the Auto Scaling group. The instance definitions must
     * specify at least two different instance types that are supported by GameLift FleetIQ. This updated list replaces
     * the entire current list of instance definitions for the game server group. For more information on instance
     * types, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">EC2 Instance
     * Types</a> in the <i>Amazon EC2 User Guide</i>. You can optionally specify capacity weighting for each instance
     * type. If no weight value is specified for an instance type, it is set to the default value "1". For more
     * information about capacity weighting, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-weighting.html"> Instance Weighting for
     * Amazon EC2 Auto Scaling</a> in the Amazon EC2 Auto Scaling User Guide.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstanceDefinitions} method.
     * </p>
     * 
     * @return An updated list of Amazon EC2 instance types to use in the Auto Scaling group. The instance definitions
     *         must specify at least two different instance types that are supported by GameLift FleetIQ. This updated
     *         list replaces the entire current list of instance definitions for the game server group. For more
     *         information on instance types, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">EC2 Instance Types</a> in
     *         the <i>Amazon EC2 User Guide</i>. You can optionally specify capacity weighting for each instance type.
     *         If no weight value is specified for an instance type, it is set to the default value "1". For more
     *         information about capacity weighting, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-weighting.html"> Instance
     *         Weighting for Amazon EC2 Auto Scaling</a> in the Amazon EC2 Auto Scaling User Guide.
     */
    public final List<InstanceDefinition> instanceDefinitions() {
        return instanceDefinitions;
    }

    /**
     * <p>
     * A flag that indicates whether instances in the game server group are protected from early termination.
     * Unprotected instances that have active game servers running might be terminated during a scale-down event,
     * causing players to be dropped from the game. Protected instances cannot be terminated while there are active game
     * servers running except in the event of a forced game server group deletion (see ). An exception to this is with
     * Spot Instances, which can be terminated by Amazon Web Services regardless of protection status. This property is
     * set to <code>NO_PROTECTION</code> by default.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #gameServerProtectionPolicy} will return {@link GameServerProtectionPolicy#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #gameServerProtectionPolicyAsString}.
     * </p>
     * 
     * @return A flag that indicates whether instances in the game server group are protected from early termination.
     *         Unprotected instances that have active game servers running might be terminated during a scale-down
     *         event, causing players to be dropped from the game. Protected instances cannot be terminated while there
     *         are active game servers running except in the event of a forced game server group deletion (see ). An
     *         exception to this is with Spot Instances, which can be terminated by Amazon Web Services regardless of
     *         protection status. This property is set to <code>NO_PROTECTION</code> by default.
     * @see GameServerProtectionPolicy
     */
    public final GameServerProtectionPolicy gameServerProtectionPolicy() {
        return GameServerProtectionPolicy.fromValue(gameServerProtectionPolicy);
    }

    /**
     * <p>
     * A flag that indicates whether instances in the game server group are protected from early termination.
     * Unprotected instances that have active game servers running might be terminated during a scale-down event,
     * causing players to be dropped from the game. Protected instances cannot be terminated while there are active game
     * servers running except in the event of a forced game server group deletion (see ). An exception to this is with
     * Spot Instances, which can be terminated by Amazon Web Services regardless of protection status. This property is
     * set to <code>NO_PROTECTION</code> by default.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #gameServerProtectionPolicy} will return {@link GameServerProtectionPolicy#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #gameServerProtectionPolicyAsString}.
     * </p>
     * 
     * @return A flag that indicates whether instances in the game server group are protected from early termination.
     *         Unprotected instances that have active game servers running might be terminated during a scale-down
     *         event, causing players to be dropped from the game. Protected instances cannot be terminated while there
     *         are active game servers running except in the event of a forced game server group deletion (see ). An
     *         exception to this is with Spot Instances, which can be terminated by Amazon Web Services regardless of
     *         protection status. This property is set to <code>NO_PROTECTION</code> by default.
     * @see GameServerProtectionPolicy
     */
    public final String gameServerProtectionPolicyAsString() {
        return gameServerProtectionPolicy;
    }

    /**
     * <p>
     * Indicates how GameLift FleetIQ balances the use of Spot Instances and On-Demand Instances in the game server
     * group. Method options include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SPOT_ONLY</code> - Only Spot Instances are used in the game server group. If Spot Instances are unavailable
     * or not viable for game hosting, the game server group provides no hosting capacity until Spot Instances can again
     * be used. Until then, no new instances are started, and the existing nonviable Spot Instances are terminated
     * (after current gameplay ends) and are not replaced.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SPOT_PREFERRED</code> - (default value) Spot Instances are used whenever available in the game server
     * group. If Spot Instances are unavailable, the game server group continues to provide hosting capacity by falling
     * back to On-Demand Instances. Existing nonviable Spot Instances are terminated (after current gameplay ends) and
     * are replaced with new On-Demand Instances.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ON_DEMAND_ONLY</code> - Only On-Demand Instances are used in the game server group. No Spot Instances are
     * used, even when available, while this balancing strategy is in force.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #balancingStrategy}
     * will return {@link BalancingStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #balancingStrategyAsString}.
     * </p>
     * 
     * @return Indicates how GameLift FleetIQ balances the use of Spot Instances and On-Demand Instances in the game
     *         server group. Method options include the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SPOT_ONLY</code> - Only Spot Instances are used in the game server group. If Spot Instances are
     *         unavailable or not viable for game hosting, the game server group provides no hosting capacity until Spot
     *         Instances can again be used. Until then, no new instances are started, and the existing nonviable Spot
     *         Instances are terminated (after current gameplay ends) and are not replaced.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SPOT_PREFERRED</code> - (default value) Spot Instances are used whenever available in the game
     *         server group. If Spot Instances are unavailable, the game server group continues to provide hosting
     *         capacity by falling back to On-Demand Instances. Existing nonviable Spot Instances are terminated (after
     *         current gameplay ends) and are replaced with new On-Demand Instances.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ON_DEMAND_ONLY</code> - Only On-Demand Instances are used in the game server group. No Spot
     *         Instances are used, even when available, while this balancing strategy is in force.
     *         </p>
     *         </li>
     * @see BalancingStrategy
     */
    public final BalancingStrategy balancingStrategy() {
        return BalancingStrategy.fromValue(balancingStrategy);
    }

    /**
     * <p>
     * Indicates how GameLift FleetIQ balances the use of Spot Instances and On-Demand Instances in the game server
     * group. Method options include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SPOT_ONLY</code> - Only Spot Instances are used in the game server group. If Spot Instances are unavailable
     * or not viable for game hosting, the game server group provides no hosting capacity until Spot Instances can again
     * be used. Until then, no new instances are started, and the existing nonviable Spot Instances are terminated
     * (after current gameplay ends) and are not replaced.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SPOT_PREFERRED</code> - (default value) Spot Instances are used whenever available in the game server
     * group. If Spot Instances are unavailable, the game server group continues to provide hosting capacity by falling
     * back to On-Demand Instances. Existing nonviable Spot Instances are terminated (after current gameplay ends) and
     * are replaced with new On-Demand Instances.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ON_DEMAND_ONLY</code> - Only On-Demand Instances are used in the game server group. No Spot Instances are
     * used, even when available, while this balancing strategy is in force.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #balancingStrategy}
     * will return {@link BalancingStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #balancingStrategyAsString}.
     * </p>
     * 
     * @return Indicates how GameLift FleetIQ balances the use of Spot Instances and On-Demand Instances in the game
     *         server group. Method options include the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SPOT_ONLY</code> - Only Spot Instances are used in the game server group. If Spot Instances are
     *         unavailable or not viable for game hosting, the game server group provides no hosting capacity until Spot
     *         Instances can again be used. Until then, no new instances are started, and the existing nonviable Spot
     *         Instances are terminated (after current gameplay ends) and are not replaced.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SPOT_PREFERRED</code> - (default value) Spot Instances are used whenever available in the game
     *         server group. If Spot Instances are unavailable, the game server group continues to provide hosting
     *         capacity by falling back to On-Demand Instances. Existing nonviable Spot Instances are terminated (after
     *         current gameplay ends) and are replaced with new On-Demand Instances.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ON_DEMAND_ONLY</code> - Only On-Demand Instances are used in the game server group. No Spot
     *         Instances are used, even when available, while this balancing strategy is in force.
     *         </p>
     *         </li>
     * @see BalancingStrategy
     */
    public final String balancingStrategyAsString() {
        return balancingStrategy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gameServerGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasInstanceDefinitions() ? instanceDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(gameServerProtectionPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(balancingStrategyAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGameServerGroupRequest)) {
            return false;
        }
        UpdateGameServerGroupRequest other = (UpdateGameServerGroupRequest) obj;
        return Objects.equals(gameServerGroupName(), other.gameServerGroupName()) && Objects.equals(roleArn(), other.roleArn())
                && hasInstanceDefinitions() == other.hasInstanceDefinitions()
                && Objects.equals(instanceDefinitions(), other.instanceDefinitions())
                && Objects.equals(gameServerProtectionPolicyAsString(), other.gameServerProtectionPolicyAsString())
                && Objects.equals(balancingStrategyAsString(), other.balancingStrategyAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateGameServerGroupRequest").add("GameServerGroupName", gameServerGroupName())
                .add("RoleArn", roleArn()).add("InstanceDefinitions", hasInstanceDefinitions() ? instanceDefinitions() : null)
                .add("GameServerProtectionPolicy", gameServerProtectionPolicyAsString())
                .add("BalancingStrategy", balancingStrategyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GameServerGroupName":
            return Optional.ofNullable(clazz.cast(gameServerGroupName()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "InstanceDefinitions":
            return Optional.ofNullable(clazz.cast(instanceDefinitions()));
        case "GameServerProtectionPolicy":
            return Optional.ofNullable(clazz.cast(gameServerProtectionPolicyAsString()));
        case "BalancingStrategy":
            return Optional.ofNullable(clazz.cast(balancingStrategyAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateGameServerGroupRequest, T> g) {
        return obj -> g.apply((UpdateGameServerGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateGameServerGroupRequest> {
        /**
         * <p>
         * A unique identifier for the game server group. Use either the <a>GameServerGroup</a> name or ARN value.
         * </p>
         * 
         * @param gameServerGroupName
         *        A unique identifier for the game server group. Use either the <a>GameServerGroup</a> name or ARN
         *        value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameServerGroupName(String gameServerGroupName);

        /**
         * <p>
         * The Amazon Resource Name (<a
         * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) for an IAM role that
         * allows Amazon GameLift to access your Amazon EC2 Auto Scaling groups.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (<a
         *        href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) for an IAM role
         *        that allows Amazon GameLift to access your Amazon EC2 Auto Scaling groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * An updated list of Amazon EC2 instance types to use in the Auto Scaling group. The instance definitions must
         * specify at least two different instance types that are supported by GameLift FleetIQ. This updated list
         * replaces the entire current list of instance definitions for the game server group. For more information on
         * instance types, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">EC2
         * Instance Types</a> in the <i>Amazon EC2 User Guide</i>. You can optionally specify capacity weighting for
         * each instance type. If no weight value is specified for an instance type, it is set to the default value "1".
         * For more information about capacity weighting, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-weighting.html"> Instance Weighting
         * for Amazon EC2 Auto Scaling</a> in the Amazon EC2 Auto Scaling User Guide.
         * </p>
         * 
         * @param instanceDefinitions
         *        An updated list of Amazon EC2 instance types to use in the Auto Scaling group. The instance
         *        definitions must specify at least two different instance types that are supported by GameLift FleetIQ.
         *        This updated list replaces the entire current list of instance definitions for the game server group.
         *        For more information on instance types, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">EC2 Instance Types</a>
         *        in the <i>Amazon EC2 User Guide</i>. You can optionally specify capacity weighting for each instance
         *        type. If no weight value is specified for an instance type, it is set to the default value "1". For
         *        more information about capacity weighting, see <a
         *        href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-weighting.html"> Instance
         *        Weighting for Amazon EC2 Auto Scaling</a> in the Amazon EC2 Auto Scaling User Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceDefinitions(Collection<InstanceDefinition> instanceDefinitions);

        /**
         * <p>
         * An updated list of Amazon EC2 instance types to use in the Auto Scaling group. The instance definitions must
         * specify at least two different instance types that are supported by GameLift FleetIQ. This updated list
         * replaces the entire current list of instance definitions for the game server group. For more information on
         * instance types, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">EC2
         * Instance Types</a> in the <i>Amazon EC2 User Guide</i>. You can optionally specify capacity weighting for
         * each instance type. If no weight value is specified for an instance type, it is set to the default value "1".
         * For more information about capacity weighting, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-weighting.html"> Instance Weighting
         * for Amazon EC2 Auto Scaling</a> in the Amazon EC2 Auto Scaling User Guide.
         * </p>
         * 
         * @param instanceDefinitions
         *        An updated list of Amazon EC2 instance types to use in the Auto Scaling group. The instance
         *        definitions must specify at least two different instance types that are supported by GameLift FleetIQ.
         *        This updated list replaces the entire current list of instance definitions for the game server group.
         *        For more information on instance types, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">EC2 Instance Types</a>
         *        in the <i>Amazon EC2 User Guide</i>. You can optionally specify capacity weighting for each instance
         *        type. If no weight value is specified for an instance type, it is set to the default value "1". For
         *        more information about capacity weighting, see <a
         *        href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-weighting.html"> Instance
         *        Weighting for Amazon EC2 Auto Scaling</a> in the Amazon EC2 Auto Scaling User Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceDefinitions(InstanceDefinition... instanceDefinitions);

        /**
         * <p>
         * An updated list of Amazon EC2 instance types to use in the Auto Scaling group. The instance definitions must
         * specify at least two different instance types that are supported by GameLift FleetIQ. This updated list
         * replaces the entire current list of instance definitions for the game server group. For more information on
         * instance types, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">EC2
         * Instance Types</a> in the <i>Amazon EC2 User Guide</i>. You can optionally specify capacity weighting for
         * each instance type. If no weight value is specified for an instance type, it is set to the default value "1".
         * For more information about capacity weighting, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-weighting.html"> Instance Weighting
         * for Amazon EC2 Auto Scaling</a> in the Amazon EC2 Auto Scaling User Guide.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.gamelift.model.InstanceDefinition.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.gamelift.model.InstanceDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.gamelift.model.InstanceDefinition.Builder#build()} is called
         * immediately and its result is passed to {@link #instanceDefinitions(List<InstanceDefinition>)}.
         * 
         * @param instanceDefinitions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.gamelift.model.InstanceDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceDefinitions(java.util.Collection<InstanceDefinition>)
         */
        Builder instanceDefinitions(Consumer<InstanceDefinition.Builder>... instanceDefinitions);

        /**
         * <p>
         * A flag that indicates whether instances in the game server group are protected from early termination.
         * Unprotected instances that have active game servers running might be terminated during a scale-down event,
         * causing players to be dropped from the game. Protected instances cannot be terminated while there are active
         * game servers running except in the event of a forced game server group deletion (see ). An exception to this
         * is with Spot Instances, which can be terminated by Amazon Web Services regardless of protection status. This
         * property is set to <code>NO_PROTECTION</code> by default.
         * </p>
         * 
         * @param gameServerProtectionPolicy
         *        A flag that indicates whether instances in the game server group are protected from early termination.
         *        Unprotected instances that have active game servers running might be terminated during a scale-down
         *        event, causing players to be dropped from the game. Protected instances cannot be terminated while
         *        there are active game servers running except in the event of a forced game server group deletion (see
         *        ). An exception to this is with Spot Instances, which can be terminated by Amazon Web Services
         *        regardless of protection status. This property is set to <code>NO_PROTECTION</code> by default.
         * @see GameServerProtectionPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GameServerProtectionPolicy
         */
        Builder gameServerProtectionPolicy(String gameServerProtectionPolicy);

        /**
         * <p>
         * A flag that indicates whether instances in the game server group are protected from early termination.
         * Unprotected instances that have active game servers running might be terminated during a scale-down event,
         * causing players to be dropped from the game. Protected instances cannot be terminated while there are active
         * game servers running except in the event of a forced game server group deletion (see ). An exception to this
         * is with Spot Instances, which can be terminated by Amazon Web Services regardless of protection status. This
         * property is set to <code>NO_PROTECTION</code> by default.
         * </p>
         * 
         * @param gameServerProtectionPolicy
         *        A flag that indicates whether instances in the game server group are protected from early termination.
         *        Unprotected instances that have active game servers running might be terminated during a scale-down
         *        event, causing players to be dropped from the game. Protected instances cannot be terminated while
         *        there are active game servers running except in the event of a forced game server group deletion (see
         *        ). An exception to this is with Spot Instances, which can be terminated by Amazon Web Services
         *        regardless of protection status. This property is set to <code>NO_PROTECTION</code> by default.
         * @see GameServerProtectionPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GameServerProtectionPolicy
         */
        Builder gameServerProtectionPolicy(GameServerProtectionPolicy gameServerProtectionPolicy);

        /**
         * <p>
         * Indicates how GameLift FleetIQ balances the use of Spot Instances and On-Demand Instances in the game server
         * group. Method options include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SPOT_ONLY</code> - Only Spot Instances are used in the game server group. If Spot Instances are
         * unavailable or not viable for game hosting, the game server group provides no hosting capacity until Spot
         * Instances can again be used. Until then, no new instances are started, and the existing nonviable Spot
         * Instances are terminated (after current gameplay ends) and are not replaced.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SPOT_PREFERRED</code> - (default value) Spot Instances are used whenever available in the game server
         * group. If Spot Instances are unavailable, the game server group continues to provide hosting capacity by
         * falling back to On-Demand Instances. Existing nonviable Spot Instances are terminated (after current gameplay
         * ends) and are replaced with new On-Demand Instances.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ON_DEMAND_ONLY</code> - Only On-Demand Instances are used in the game server group. No Spot Instances
         * are used, even when available, while this balancing strategy is in force.
         * </p>
         * </li>
         * </ul>
         * 
         * @param balancingStrategy
         *        Indicates how GameLift FleetIQ balances the use of Spot Instances and On-Demand Instances in the game
         *        server group. Method options include the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SPOT_ONLY</code> - Only Spot Instances are used in the game server group. If Spot Instances are
         *        unavailable or not viable for game hosting, the game server group provides no hosting capacity until
         *        Spot Instances can again be used. Until then, no new instances are started, and the existing nonviable
         *        Spot Instances are terminated (after current gameplay ends) and are not replaced.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SPOT_PREFERRED</code> - (default value) Spot Instances are used whenever available in the game
         *        server group. If Spot Instances are unavailable, the game server group continues to provide hosting
         *        capacity by falling back to On-Demand Instances. Existing nonviable Spot Instances are terminated
         *        (after current gameplay ends) and are replaced with new On-Demand Instances.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ON_DEMAND_ONLY</code> - Only On-Demand Instances are used in the game server group. No Spot
         *        Instances are used, even when available, while this balancing strategy is in force.
         *        </p>
         *        </li>
         * @see BalancingStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BalancingStrategy
         */
        Builder balancingStrategy(String balancingStrategy);

        /**
         * <p>
         * Indicates how GameLift FleetIQ balances the use of Spot Instances and On-Demand Instances in the game server
         * group. Method options include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SPOT_ONLY</code> - Only Spot Instances are used in the game server group. If Spot Instances are
         * unavailable or not viable for game hosting, the game server group provides no hosting capacity until Spot
         * Instances can again be used. Until then, no new instances are started, and the existing nonviable Spot
         * Instances are terminated (after current gameplay ends) and are not replaced.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SPOT_PREFERRED</code> - (default value) Spot Instances are used whenever available in the game server
         * group. If Spot Instances are unavailable, the game server group continues to provide hosting capacity by
         * falling back to On-Demand Instances. Existing nonviable Spot Instances are terminated (after current gameplay
         * ends) and are replaced with new On-Demand Instances.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ON_DEMAND_ONLY</code> - Only On-Demand Instances are used in the game server group. No Spot Instances
         * are used, even when available, while this balancing strategy is in force.
         * </p>
         * </li>
         * </ul>
         * 
         * @param balancingStrategy
         *        Indicates how GameLift FleetIQ balances the use of Spot Instances and On-Demand Instances in the game
         *        server group. Method options include the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SPOT_ONLY</code> - Only Spot Instances are used in the game server group. If Spot Instances are
         *        unavailable or not viable for game hosting, the game server group provides no hosting capacity until
         *        Spot Instances can again be used. Until then, no new instances are started, and the existing nonviable
         *        Spot Instances are terminated (after current gameplay ends) and are not replaced.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SPOT_PREFERRED</code> - (default value) Spot Instances are used whenever available in the game
         *        server group. If Spot Instances are unavailable, the game server group continues to provide hosting
         *        capacity by falling back to On-Demand Instances. Existing nonviable Spot Instances are terminated
         *        (after current gameplay ends) and are replaced with new On-Demand Instances.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ON_DEMAND_ONLY</code> - Only On-Demand Instances are used in the game server group. No Spot
         *        Instances are used, even when available, while this balancing strategy is in force.
         *        </p>
         *        </li>
         * @see BalancingStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BalancingStrategy
         */
        Builder balancingStrategy(BalancingStrategy balancingStrategy);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GameLiftRequest.BuilderImpl implements Builder {
        private String gameServerGroupName;

        private String roleArn;

        private List<InstanceDefinition> instanceDefinitions = DefaultSdkAutoConstructList.getInstance();

        private String gameServerProtectionPolicy;

        private String balancingStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGameServerGroupRequest model) {
            super(model);
            gameServerGroupName(model.gameServerGroupName);
            roleArn(model.roleArn);
            instanceDefinitions(model.instanceDefinitions);
            gameServerProtectionPolicy(model.gameServerProtectionPolicy);
            balancingStrategy(model.balancingStrategy);
        }

        public final String getGameServerGroupName() {
            return gameServerGroupName;
        }

        public final void setGameServerGroupName(String gameServerGroupName) {
            this.gameServerGroupName = gameServerGroupName;
        }

        @Override
        public final Builder gameServerGroupName(String gameServerGroupName) {
            this.gameServerGroupName = gameServerGroupName;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final List<InstanceDefinition.Builder> getInstanceDefinitions() {
            List<InstanceDefinition.Builder> result = InstanceDefinitionsCopier.copyToBuilder(this.instanceDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceDefinitions(Collection<InstanceDefinition.BuilderImpl> instanceDefinitions) {
            this.instanceDefinitions = InstanceDefinitionsCopier.copyFromBuilder(instanceDefinitions);
        }

        @Override
        public final Builder instanceDefinitions(Collection<InstanceDefinition> instanceDefinitions) {
            this.instanceDefinitions = InstanceDefinitionsCopier.copy(instanceDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceDefinitions(InstanceDefinition... instanceDefinitions) {
            instanceDefinitions(Arrays.asList(instanceDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceDefinitions(Consumer<InstanceDefinition.Builder>... instanceDefinitions) {
            instanceDefinitions(Stream.of(instanceDefinitions).map(c -> InstanceDefinition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getGameServerProtectionPolicy() {
            return gameServerProtectionPolicy;
        }

        public final void setGameServerProtectionPolicy(String gameServerProtectionPolicy) {
            this.gameServerProtectionPolicy = gameServerProtectionPolicy;
        }

        @Override
        public final Builder gameServerProtectionPolicy(String gameServerProtectionPolicy) {
            this.gameServerProtectionPolicy = gameServerProtectionPolicy;
            return this;
        }

        @Override
        public final Builder gameServerProtectionPolicy(GameServerProtectionPolicy gameServerProtectionPolicy) {
            this.gameServerProtectionPolicy(gameServerProtectionPolicy == null ? null : gameServerProtectionPolicy.toString());
            return this;
        }

        public final String getBalancingStrategy() {
            return balancingStrategy;
        }

        public final void setBalancingStrategy(String balancingStrategy) {
            this.balancingStrategy = balancingStrategy;
        }

        @Override
        public final Builder balancingStrategy(String balancingStrategy) {
            this.balancingStrategy = balancingStrategy;
            return this;
        }

        @Override
        public final Builder balancingStrategy(BalancingStrategy balancingStrategy) {
            this.balancingStrategy(balancingStrategy == null ? null : balancingStrategy.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateGameServerGroupRequest build() {
            return new UpdateGameServerGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
