/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateGameServerGroupResponse extends GameLiftResponse implements
        ToCopyableBuilder<CreateGameServerGroupResponse.Builder, CreateGameServerGroupResponse> {
    private static final SdkField<GameServerGroup> GAME_SERVER_GROUP_FIELD = SdkField
            .<GameServerGroup> builder(MarshallingType.SDK_POJO).memberName("GameServerGroup")
            .getter(getter(CreateGameServerGroupResponse::gameServerGroup)).setter(setter(Builder::gameServerGroup))
            .constructor(GameServerGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameServerGroup").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GAME_SERVER_GROUP_FIELD));

    private final GameServerGroup gameServerGroup;

    private CreateGameServerGroupResponse(BuilderImpl builder) {
        super(builder);
        this.gameServerGroup = builder.gameServerGroup;
    }

    /**
     * <p>
     * The newly created game server group object, including the new ARN value for the GameLift FleetIQ game server
     * group and the object's status. The EC2 Auto Scaling group ARN is initially null, since the group has not yet been
     * created. This value is added once the game server group status reaches <code>ACTIVE</code>.
     * </p>
     * 
     * @return The newly created game server group object, including the new ARN value for the GameLift FleetIQ game
     *         server group and the object's status. The EC2 Auto Scaling group ARN is initially null, since the group
     *         has not yet been created. This value is added once the game server group status reaches
     *         <code>ACTIVE</code>.
     */
    public final GameServerGroup gameServerGroup() {
        return gameServerGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gameServerGroup());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGameServerGroupResponse)) {
            return false;
        }
        CreateGameServerGroupResponse other = (CreateGameServerGroupResponse) obj;
        return Objects.equals(gameServerGroup(), other.gameServerGroup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateGameServerGroupResponse").add("GameServerGroup", gameServerGroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GameServerGroup":
            return Optional.ofNullable(clazz.cast(gameServerGroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateGameServerGroupResponse, T> g) {
        return obj -> g.apply((CreateGameServerGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateGameServerGroupResponse> {
        /**
         * <p>
         * The newly created game server group object, including the new ARN value for the GameLift FleetIQ game server
         * group and the object's status. The EC2 Auto Scaling group ARN is initially null, since the group has not yet
         * been created. This value is added once the game server group status reaches <code>ACTIVE</code>.
         * </p>
         * 
         * @param gameServerGroup
         *        The newly created game server group object, including the new ARN value for the GameLift FleetIQ game
         *        server group and the object's status. The EC2 Auto Scaling group ARN is initially null, since the
         *        group has not yet been created. This value is added once the game server group status reaches
         *        <code>ACTIVE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameServerGroup(GameServerGroup gameServerGroup);

        /**
         * <p>
         * The newly created game server group object, including the new ARN value for the GameLift FleetIQ game server
         * group and the object's status. The EC2 Auto Scaling group ARN is initially null, since the group has not yet
         * been created. This value is added once the game server group status reaches <code>ACTIVE</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link GameServerGroup.Builder} avoiding the need to
         * create one manually via {@link GameServerGroup#builder()}.
         *
         * When the {@link Consumer} completes, {@link GameServerGroup.Builder#build()} is called immediately and its
         * result is passed to {@link #gameServerGroup(GameServerGroup)}.
         * 
         * @param gameServerGroup
         *        a consumer that will call methods on {@link GameServerGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gameServerGroup(GameServerGroup)
         */
        default Builder gameServerGroup(Consumer<GameServerGroup.Builder> gameServerGroup) {
            return gameServerGroup(GameServerGroup.builder().applyMutation(gameServerGroup).build());
        }
    }

    static final class BuilderImpl extends GameLiftResponse.BuilderImpl implements Builder {
        private GameServerGroup gameServerGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGameServerGroupResponse model) {
            super(model);
            gameServerGroup(model.gameServerGroup);
        }

        public final GameServerGroup.Builder getGameServerGroup() {
            return gameServerGroup != null ? gameServerGroup.toBuilder() : null;
        }

        public final void setGameServerGroup(GameServerGroup.BuilderImpl gameServerGroup) {
            this.gameServerGroup = gameServerGroup != null ? gameServerGroup.build() : null;
        }

        @Override
        @Transient
        public final Builder gameServerGroup(GameServerGroup gameServerGroup) {
            this.gameServerGroup = gameServerGroup;
            return this;
        }

        @Override
        public CreateGameServerGroupResponse build() {
            return new CreateGameServerGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
