/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Sets a latency cap for individual players when placing a game session. With a latency policy in force, a game session
 * cannot be placed in a fleet location where a player reports latency higher than the cap. Latency policies are used
 * only with placement request that provide player latency information. Player latency policies can be stacked to
 * gradually relax latency requirements over time.
 * </p>
 * <p>
 * Latency policies are part of a <a>GameSessionQueue</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PlayerLatencyPolicy implements SdkPojo, Serializable,
        ToCopyableBuilder<PlayerLatencyPolicy.Builder, PlayerLatencyPolicy> {
    private static final SdkField<Integer> MAXIMUM_INDIVIDUAL_PLAYER_LATENCY_MILLISECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaximumIndividualPlayerLatencyMilliseconds")
            .getter(getter(PlayerLatencyPolicy::maximumIndividualPlayerLatencyMilliseconds))
            .setter(setter(Builder::maximumIndividualPlayerLatencyMilliseconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("MaximumIndividualPlayerLatencyMilliseconds").build()).build();

    private static final SdkField<Integer> POLICY_DURATION_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PolicyDurationSeconds").getter(getter(PlayerLatencyPolicy::policyDurationSeconds))
            .setter(setter(Builder::policyDurationSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyDurationSeconds").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MAXIMUM_INDIVIDUAL_PLAYER_LATENCY_MILLISECONDS_FIELD, POLICY_DURATION_SECONDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer maximumIndividualPlayerLatencyMilliseconds;

    private final Integer policyDurationSeconds;

    private PlayerLatencyPolicy(BuilderImpl builder) {
        this.maximumIndividualPlayerLatencyMilliseconds = builder.maximumIndividualPlayerLatencyMilliseconds;
        this.policyDurationSeconds = builder.policyDurationSeconds;
    }

    /**
     * <p>
     * The maximum latency value that is allowed for any player, in milliseconds. All policies must have a value set for
     * this property.
     * </p>
     * 
     * @return The maximum latency value that is allowed for any player, in milliseconds. All policies must have a value
     *         set for this property.
     */
    public final Integer maximumIndividualPlayerLatencyMilliseconds() {
        return maximumIndividualPlayerLatencyMilliseconds;
    }

    /**
     * <p>
     * The length of time, in seconds, that the policy is enforced while placing a new game session. A null value for
     * this property means that the policy is enforced until the queue times out.
     * </p>
     * 
     * @return The length of time, in seconds, that the policy is enforced while placing a new game session. A null
     *         value for this property means that the policy is enforced until the queue times out.
     */
    public final Integer policyDurationSeconds() {
        return policyDurationSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maximumIndividualPlayerLatencyMilliseconds());
        hashCode = 31 * hashCode + Objects.hashCode(policyDurationSeconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PlayerLatencyPolicy)) {
            return false;
        }
        PlayerLatencyPolicy other = (PlayerLatencyPolicy) obj;
        return Objects.equals(maximumIndividualPlayerLatencyMilliseconds(), other.maximumIndividualPlayerLatencyMilliseconds())
                && Objects.equals(policyDurationSeconds(), other.policyDurationSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PlayerLatencyPolicy")
                .add("MaximumIndividualPlayerLatencyMilliseconds", maximumIndividualPlayerLatencyMilliseconds())
                .add("PolicyDurationSeconds", policyDurationSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaximumIndividualPlayerLatencyMilliseconds":
            return Optional.ofNullable(clazz.cast(maximumIndividualPlayerLatencyMilliseconds()));
        case "PolicyDurationSeconds":
            return Optional.ofNullable(clazz.cast(policyDurationSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PlayerLatencyPolicy, T> g) {
        return obj -> g.apply((PlayerLatencyPolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PlayerLatencyPolicy> {
        /**
         * <p>
         * The maximum latency value that is allowed for any player, in milliseconds. All policies must have a value set
         * for this property.
         * </p>
         * 
         * @param maximumIndividualPlayerLatencyMilliseconds
         *        The maximum latency value that is allowed for any player, in milliseconds. All policies must have a
         *        value set for this property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumIndividualPlayerLatencyMilliseconds(Integer maximumIndividualPlayerLatencyMilliseconds);

        /**
         * <p>
         * The length of time, in seconds, that the policy is enforced while placing a new game session. A null value
         * for this property means that the policy is enforced until the queue times out.
         * </p>
         * 
         * @param policyDurationSeconds
         *        The length of time, in seconds, that the policy is enforced while placing a new game session. A null
         *        value for this property means that the policy is enforced until the queue times out.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyDurationSeconds(Integer policyDurationSeconds);
    }

    static final class BuilderImpl implements Builder {
        private Integer maximumIndividualPlayerLatencyMilliseconds;

        private Integer policyDurationSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(PlayerLatencyPolicy model) {
            maximumIndividualPlayerLatencyMilliseconds(model.maximumIndividualPlayerLatencyMilliseconds);
            policyDurationSeconds(model.policyDurationSeconds);
        }

        public final Integer getMaximumIndividualPlayerLatencyMilliseconds() {
            return maximumIndividualPlayerLatencyMilliseconds;
        }

        public final void setMaximumIndividualPlayerLatencyMilliseconds(Integer maximumIndividualPlayerLatencyMilliseconds) {
            this.maximumIndividualPlayerLatencyMilliseconds = maximumIndividualPlayerLatencyMilliseconds;
        }

        @Override
        @Transient
        public final Builder maximumIndividualPlayerLatencyMilliseconds(Integer maximumIndividualPlayerLatencyMilliseconds) {
            this.maximumIndividualPlayerLatencyMilliseconds = maximumIndividualPlayerLatencyMilliseconds;
            return this;
        }

        public final Integer getPolicyDurationSeconds() {
            return policyDurationSeconds;
        }

        public final void setPolicyDurationSeconds(Integer policyDurationSeconds) {
            this.policyDurationSeconds = policyDurationSeconds;
        }

        @Override
        @Transient
        public final Builder policyDurationSeconds(Integer policyDurationSeconds) {
            this.policyDurationSeconds = policyDurationSeconds;
            return this;
        }

        @Override
        public PlayerLatencyPolicy build() {
            return new PlayerLatencyPolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
