/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.gamelift.GameLiftAsyncClient;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetAttributesRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetAttributesResponse;
import software.amazon.awssdk.services.gamelift.model.FleetAttributes;

public class DescribeFleetAttributesPublisher
implements SdkPublisher<DescribeFleetAttributesResponse> {
    private final GameLiftAsyncClient client;
    private final DescribeFleetAttributesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeFleetAttributesPublisher(GameLiftAsyncClient client, DescribeFleetAttributesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeFleetAttributesPublisher(GameLiftAsyncClient client, DescribeFleetAttributesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeFleetAttributesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeFleetAttributesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<FleetAttributes> fleetAttributes() {
        Function<DescribeFleetAttributesResponse, Iterator> getIterator = response -> {
            if (response != null && response.fleetAttributes() != null) {
                return response.fleetAttributes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeFleetAttributesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeFleetAttributesResponseFetcher
    implements AsyncPageFetcher<DescribeFleetAttributesResponse> {
        private DescribeFleetAttributesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeFleetAttributesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeFleetAttributesResponse> nextPage(DescribeFleetAttributesResponse previousPage) {
            if (previousPage == null) {
                return DescribeFleetAttributesPublisher.this.client.describeFleetAttributes(DescribeFleetAttributesPublisher.this.firstRequest);
            }
            return DescribeFleetAttributesPublisher.this.client.describeFleetAttributes((DescribeFleetAttributesRequest)((Object)DescribeFleetAttributesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

