/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeGameServerResponse extends GameLiftResponse implements
        ToCopyableBuilder<DescribeGameServerResponse.Builder, DescribeGameServerResponse> {
    private static final SdkField<GameServer> GAME_SERVER_FIELD = SdkField.<GameServer> builder(MarshallingType.SDK_POJO)
            .memberName("GameServer").getter(getter(DescribeGameServerResponse::gameServer)).setter(setter(Builder::gameServer))
            .constructor(GameServer::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameServer").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GAME_SERVER_FIELD));

    private final GameServer gameServer;

    private DescribeGameServerResponse(BuilderImpl builder) {
        super(builder);
        this.gameServer = builder.gameServer;
    }

    /**
     * <p>
     * Object that describes the requested game server.
     * </p>
     * 
     * @return Object that describes the requested game server.
     */
    public final GameServer gameServer() {
        return gameServer;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gameServer());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeGameServerResponse)) {
            return false;
        }
        DescribeGameServerResponse other = (DescribeGameServerResponse) obj;
        return Objects.equals(gameServer(), other.gameServer());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeGameServerResponse").add("GameServer", gameServer()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GameServer":
            return Optional.ofNullable(clazz.cast(gameServer()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeGameServerResponse, T> g) {
        return obj -> g.apply((DescribeGameServerResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeGameServerResponse> {
        /**
         * <p>
         * Object that describes the requested game server.
         * </p>
         * 
         * @param gameServer
         *        Object that describes the requested game server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameServer(GameServer gameServer);

        /**
         * <p>
         * Object that describes the requested game server.
         * </p>
         * This is a convenience that creates an instance of the {@link GameServer.Builder} avoiding the need to create
         * one manually via {@link GameServer#builder()}.
         *
         * When the {@link Consumer} completes, {@link GameServer.Builder#build()} is called immediately and its result
         * is passed to {@link #gameServer(GameServer)}.
         * 
         * @param gameServer
         *        a consumer that will call methods on {@link GameServer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gameServer(GameServer)
         */
        default Builder gameServer(Consumer<GameServer.Builder> gameServer) {
            return gameServer(GameServer.builder().applyMutation(gameServer).build());
        }
    }

    static final class BuilderImpl extends GameLiftResponse.BuilderImpl implements Builder {
        private GameServer gameServer;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeGameServerResponse model) {
            super(model);
            gameServer(model.gameServer);
        }

        public final GameServer.Builder getGameServer() {
            return gameServer != null ? gameServer.toBuilder() : null;
        }

        public final void setGameServer(GameServer.BuilderImpl gameServer) {
            this.gameServer = gameServer != null ? gameServer.build() : null;
        }

        @Override
        @Transient
        public final Builder gameServer(GameServer gameServer) {
            this.gameServer = gameServer;
            return this;
        }

        @Override
        public DescribeGameServerResponse build() {
            return new DescribeGameServerResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
