/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The location in Amazon S3 where build or script files are stored for access by Amazon GameLift. This location is
 * specified in <a>CreateBuild</a>, <a>CreateScript</a>, and <a>UpdateScript</a> requests.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3Location implements SdkPojo, Serializable, ToCopyableBuilder<S3Location.Builder, S3Location> {
    private static final SdkField<String> BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Bucket")
            .getter(getter(S3Location::bucket)).setter(setter(Builder::bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bucket").build()).build();

    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Key")
            .getter(getter(S3Location::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(S3Location::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> OBJECT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ObjectVersion").getter(getter(S3Location::objectVersion)).setter(setter(Builder::objectVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_FIELD, KEY_FIELD,
            ROLE_ARN_FIELD, OBJECT_VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String bucket;

    private final String key;

    private final String roleArn;

    private final String objectVersion;

    private S3Location(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.key = builder.key;
        this.roleArn = builder.roleArn;
        this.objectVersion = builder.objectVersion;
    }

    /**
     * <p>
     * An Amazon S3 bucket identifier. This is the name of the S3 bucket.
     * </p>
     * <note>
     * <p>
     * GameLift currently does not support uploading from Amazon S3 buckets with names that contain a dot (.).
     * </p>
     * </note>
     * 
     * @return An Amazon S3 bucket identifier. This is the name of the S3 bucket.</p> <note>
     *         <p>
     *         GameLift currently does not support uploading from Amazon S3 buckets with names that contain a dot (.).
     *         </p>
     */
    public final String bucket() {
        return bucket;
    }

    /**
     * <p>
     * The name of the zip file that contains the build files or script files.
     * </p>
     * 
     * @return The name of the zip file that contains the build files or script files.
     */
    public final String key() {
        return key;
    }

    /**
     * <p>
     * The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>)
     * for an IAM role that allows Amazon GameLift to access the S3 bucket.
     * </p>
     * 
     * @return The Amazon Resource Name (<a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) for an IAM role that
     *         allows Amazon GameLift to access the S3 bucket.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The version of the file, if object versioning is turned on for the bucket. Amazon GameLift uses this information
     * when retrieving files from an S3 bucket that you own. Use this parameter to specify a specific version of the
     * file. If not set, the latest version of the file is retrieved.
     * </p>
     * 
     * @return The version of the file, if object versioning is turned on for the bucket. Amazon GameLift uses this
     *         information when retrieving files from an S3 bucket that you own. Use this parameter to specify a
     *         specific version of the file. If not set, the latest version of the file is retrieved.
     */
    public final String objectVersion() {
        return objectVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bucket());
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(objectVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Location)) {
            return false;
        }
        S3Location other = (S3Location) obj;
        return Objects.equals(bucket(), other.bucket()) && Objects.equals(key(), other.key())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(objectVersion(), other.objectVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3Location").add("Bucket", bucket()).add("Key", key()).add("RoleArn", roleArn())
                .add("ObjectVersion", objectVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Bucket":
            return Optional.ofNullable(clazz.cast(bucket()));
        case "Key":
            return Optional.ofNullable(clazz.cast(key()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "ObjectVersion":
            return Optional.ofNullable(clazz.cast(objectVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3Location, T> g) {
        return obj -> g.apply((S3Location) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3Location> {
        /**
         * <p>
         * An Amazon S3 bucket identifier. This is the name of the S3 bucket.
         * </p>
         * <note>
         * <p>
         * GameLift currently does not support uploading from Amazon S3 buckets with names that contain a dot (.).
         * </p>
         * </note>
         * 
         * @param bucket
         *        An Amazon S3 bucket identifier. This is the name of the S3 bucket.</p> <note>
         *        <p>
         *        GameLift currently does not support uploading from Amazon S3 buckets with names that contain a dot
         *        (.).
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * <p>
         * The name of the zip file that contains the build files or script files.
         * </p>
         * 
         * @param key
         *        The name of the zip file that contains the build files or script files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * The Amazon Resource Name (<a
         * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) for an IAM role that
         * allows Amazon GameLift to access the S3 bucket.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (<a
         *        href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) for an IAM role
         *        that allows Amazon GameLift to access the S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The version of the file, if object versioning is turned on for the bucket. Amazon GameLift uses this
         * information when retrieving files from an S3 bucket that you own. Use this parameter to specify a specific
         * version of the file. If not set, the latest version of the file is retrieved.
         * </p>
         * 
         * @param objectVersion
         *        The version of the file, if object versioning is turned on for the bucket. Amazon GameLift uses this
         *        information when retrieving files from an S3 bucket that you own. Use this parameter to specify a
         *        specific version of the file. If not set, the latest version of the file is retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectVersion(String objectVersion);
    }

    static final class BuilderImpl implements Builder {
        private String bucket;

        private String key;

        private String roleArn;

        private String objectVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Location model) {
            bucket(model.bucket);
            key(model.key);
            roleArn(model.roleArn);
            objectVersion(model.objectVersion);
        }

        public final String getBucket() {
            return bucket;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        @Override
        @Transient
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final String getKey() {
            return key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        @Transient
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        @Transient
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getObjectVersion() {
            return objectVersion;
        }

        public final void setObjectVersion(String objectVersion) {
            this.objectVersion = objectVersion;
        }

        @Override
        @Transient
        public final Builder objectVersion(String objectVersion) {
            this.objectVersion = objectVersion;
            return this;
        }

        @Override
        public S3Location build() {
            return new S3Location(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
