/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the returned data in response to a request operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateGameSessionResponse extends GameLiftResponse implements
        ToCopyableBuilder<UpdateGameSessionResponse.Builder, UpdateGameSessionResponse> {
    private static final SdkField<GameSession> GAME_SESSION_FIELD = SdkField.<GameSession> builder(MarshallingType.SDK_POJO)
            .memberName("GameSession").getter(getter(UpdateGameSessionResponse::gameSession))
            .setter(setter(Builder::gameSession)).constructor(GameSession::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameSession").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GAME_SESSION_FIELD));

    private final GameSession gameSession;

    private UpdateGameSessionResponse(BuilderImpl builder) {
        super(builder);
        this.gameSession = builder.gameSession;
    }

    /**
     * <p>
     * The updated game session properties.
     * </p>
     * 
     * @return The updated game session properties.
     */
    public final GameSession gameSession() {
        return gameSession;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gameSession());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGameSessionResponse)) {
            return false;
        }
        UpdateGameSessionResponse other = (UpdateGameSessionResponse) obj;
        return Objects.equals(gameSession(), other.gameSession());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateGameSessionResponse").add("GameSession", gameSession()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GameSession":
            return Optional.ofNullable(clazz.cast(gameSession()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateGameSessionResponse, T> g) {
        return obj -> g.apply((UpdateGameSessionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateGameSessionResponse> {
        /**
         * <p>
         * The updated game session properties.
         * </p>
         * 
         * @param gameSession
         *        The updated game session properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameSession(GameSession gameSession);

        /**
         * <p>
         * The updated game session properties.
         * </p>
         * This is a convenience that creates an instance of the {@link GameSession.Builder} avoiding the need to create
         * one manually via {@link GameSession#builder()}.
         *
         * When the {@link Consumer} completes, {@link GameSession.Builder#build()} is called immediately and its result
         * is passed to {@link #gameSession(GameSession)}.
         * 
         * @param gameSession
         *        a consumer that will call methods on {@link GameSession.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gameSession(GameSession)
         */
        default Builder gameSession(Consumer<GameSession.Builder> gameSession) {
            return gameSession(GameSession.builder().applyMutation(gameSession).build());
        }
    }

    static final class BuilderImpl extends GameLiftResponse.BuilderImpl implements Builder {
        private GameSession gameSession;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGameSessionResponse model) {
            super(model);
            gameSession(model.gameSession);
        }

        public final GameSession.Builder getGameSession() {
            return gameSession != null ? gameSession.toBuilder() : null;
        }

        public final void setGameSession(GameSession.BuilderImpl gameSession) {
            this.gameSession = gameSession != null ? gameSession.build() : null;
        }

        @Override
        @Transient
        public final Builder gameSession(GameSession gameSession) {
            this.gameSession = gameSession;
            return this;
        }

        @Override
        public UpdateGameSessionResponse build() {
            return new UpdateGameSessionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
