/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input for a request operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateVpcPeeringConnectionRequest extends GameLiftRequest implements
        ToCopyableBuilder<CreateVpcPeeringConnectionRequest.Builder, CreateVpcPeeringConnectionRequest> {
    private static final SdkField<String> FLEET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FleetId").getter(getter(CreateVpcPeeringConnectionRequest::fleetId)).setter(setter(Builder::fleetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId").build()).build();

    private static final SdkField<String> PEER_VPC_AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PeerVpcAwsAccountId").getter(getter(CreateVpcPeeringConnectionRequest::peerVpcAwsAccountId))
            .setter(setter(Builder::peerVpcAwsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerVpcAwsAccountId").build())
            .build();

    private static final SdkField<String> PEER_VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PeerVpcId").getter(getter(CreateVpcPeeringConnectionRequest::peerVpcId))
            .setter(setter(Builder::peerVpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerVpcId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ID_FIELD,
            PEER_VPC_AWS_ACCOUNT_ID_FIELD, PEER_VPC_ID_FIELD));

    private final String fleetId;

    private final String peerVpcAwsAccountId;

    private final String peerVpcId;

    private CreateVpcPeeringConnectionRequest(BuilderImpl builder) {
        super(builder);
        this.fleetId = builder.fleetId;
        this.peerVpcAwsAccountId = builder.peerVpcAwsAccountId;
        this.peerVpcId = builder.peerVpcId;
    }

    /**
     * <p>
     * A unique identifier for the fleet. You can use either the fleet ID or ARN value. This tells Amazon GameLift which
     * GameLift VPC to peer with.
     * </p>
     * 
     * @return A unique identifier for the fleet. You can use either the fleet ID or ARN value. This tells Amazon
     *         GameLift which GameLift VPC to peer with.
     */
    public final String fleetId() {
        return fleetId;
    }

    /**
     * <p>
     * A unique identifier for the Amazon Web Services account with the VPC that you want to peer your Amazon GameLift
     * fleet with. You can find your Account ID in the Amazon Web Services Management Console under account settings.
     * </p>
     * 
     * @return A unique identifier for the Amazon Web Services account with the VPC that you want to peer your Amazon
     *         GameLift fleet with. You can find your Account ID in the Amazon Web Services Management Console under
     *         account settings.
     */
    public final String peerVpcAwsAccountId() {
        return peerVpcAwsAccountId;
    }

    /**
     * <p>
     * A unique identifier for a VPC with resources to be accessed by your GameLift fleet. The VPC must be in the same
     * Region as your fleet. To look up a VPC ID, use the <a href="https://console.aws.amazon.com/vpc/">VPC
     * Dashboard</a> in the Amazon Web Services Management Console. Learn more about VPC peering in <a
     * href="https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html">VPC Peering with GameLift
     * Fleets</a>.
     * </p>
     * 
     * @return A unique identifier for a VPC with resources to be accessed by your GameLift fleet. The VPC must be in
     *         the same Region as your fleet. To look up a VPC ID, use the <a
     *         href="https://console.aws.amazon.com/vpc/">VPC Dashboard</a> in the Amazon Web Services Management
     *         Console. Learn more about VPC peering in <a
     *         href="https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html">VPC Peering with
     *         GameLift Fleets</a>.
     */
    public final String peerVpcId() {
        return peerVpcId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(peerVpcAwsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(peerVpcId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpcPeeringConnectionRequest)) {
            return false;
        }
        CreateVpcPeeringConnectionRequest other = (CreateVpcPeeringConnectionRequest) obj;
        return Objects.equals(fleetId(), other.fleetId()) && Objects.equals(peerVpcAwsAccountId(), other.peerVpcAwsAccountId())
                && Objects.equals(peerVpcId(), other.peerVpcId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateVpcPeeringConnectionRequest").add("FleetId", fleetId())
                .add("PeerVpcAwsAccountId", peerVpcAwsAccountId()).add("PeerVpcId", peerVpcId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FleetId":
            return Optional.ofNullable(clazz.cast(fleetId()));
        case "PeerVpcAwsAccountId":
            return Optional.ofNullable(clazz.cast(peerVpcAwsAccountId()));
        case "PeerVpcId":
            return Optional.ofNullable(clazz.cast(peerVpcId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateVpcPeeringConnectionRequest, T> g) {
        return obj -> g.apply((CreateVpcPeeringConnectionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateVpcPeeringConnectionRequest> {
        /**
         * <p>
         * A unique identifier for the fleet. You can use either the fleet ID or ARN value. This tells Amazon GameLift
         * which GameLift VPC to peer with.
         * </p>
         * 
         * @param fleetId
         *        A unique identifier for the fleet. You can use either the fleet ID or ARN value. This tells Amazon
         *        GameLift which GameLift VPC to peer with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetId(String fleetId);

        /**
         * <p>
         * A unique identifier for the Amazon Web Services account with the VPC that you want to peer your Amazon
         * GameLift fleet with. You can find your Account ID in the Amazon Web Services Management Console under account
         * settings.
         * </p>
         * 
         * @param peerVpcAwsAccountId
         *        A unique identifier for the Amazon Web Services account with the VPC that you want to peer your Amazon
         *        GameLift fleet with. You can find your Account ID in the Amazon Web Services Management Console under
         *        account settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peerVpcAwsAccountId(String peerVpcAwsAccountId);

        /**
         * <p>
         * A unique identifier for a VPC with resources to be accessed by your GameLift fleet. The VPC must be in the
         * same Region as your fleet. To look up a VPC ID, use the <a href="https://console.aws.amazon.com/vpc/">VPC
         * Dashboard</a> in the Amazon Web Services Management Console. Learn more about VPC peering in <a
         * href="https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html">VPC Peering with GameLift
         * Fleets</a>.
         * </p>
         * 
         * @param peerVpcId
         *        A unique identifier for a VPC with resources to be accessed by your GameLift fleet. The VPC must be in
         *        the same Region as your fleet. To look up a VPC ID, use the <a
         *        href="https://console.aws.amazon.com/vpc/">VPC Dashboard</a> in the Amazon Web Services Management
         *        Console. Learn more about VPC peering in <a
         *        href="https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html">VPC Peering with
         *        GameLift Fleets</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peerVpcId(String peerVpcId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GameLiftRequest.BuilderImpl implements Builder {
        private String fleetId;

        private String peerVpcAwsAccountId;

        private String peerVpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpcPeeringConnectionRequest model) {
            super(model);
            fleetId(model.fleetId);
            peerVpcAwsAccountId(model.peerVpcAwsAccountId);
            peerVpcId(model.peerVpcId);
        }

        public final String getFleetId() {
            return fleetId;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final String getPeerVpcAwsAccountId() {
            return peerVpcAwsAccountId;
        }

        public final void setPeerVpcAwsAccountId(String peerVpcAwsAccountId) {
            this.peerVpcAwsAccountId = peerVpcAwsAccountId;
        }

        @Override
        public final Builder peerVpcAwsAccountId(String peerVpcAwsAccountId) {
            this.peerVpcAwsAccountId = peerVpcAwsAccountId;
            return this;
        }

        public final String getPeerVpcId() {
            return peerVpcId;
        }

        public final void setPeerVpcId(String peerVpcId) {
            this.peerVpcId = peerVpcId;
        }

        @Override
        public final Builder peerVpcId(String peerVpcId) {
            this.peerVpcId = peerVpcId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateVpcPeeringConnectionRequest build() {
            return new CreateVpcPeeringConnectionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
