/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input for a request operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePlayerSessionRequest extends GameLiftRequest implements
        ToCopyableBuilder<CreatePlayerSessionRequest.Builder, CreatePlayerSessionRequest> {
    private static final SdkField<String> GAME_SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GameSessionId").getter(getter(CreatePlayerSessionRequest::gameSessionId))
            .setter(setter(Builder::gameSessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameSessionId").build()).build();

    private static final SdkField<String> PLAYER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlayerId").getter(getter(CreatePlayerSessionRequest::playerId)).setter(setter(Builder::playerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlayerId").build()).build();

    private static final SdkField<String> PLAYER_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlayerData").getter(getter(CreatePlayerSessionRequest::playerData)).setter(setter(Builder::playerData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlayerData").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GAME_SESSION_ID_FIELD,
            PLAYER_ID_FIELD, PLAYER_DATA_FIELD));

    private final String gameSessionId;

    private final String playerId;

    private final String playerData;

    private CreatePlayerSessionRequest(BuilderImpl builder) {
        super(builder);
        this.gameSessionId = builder.gameSessionId;
        this.playerId = builder.playerId;
        this.playerData = builder.playerData;
    }

    /**
     * <p>
     * A unique identifier for the game session to add a player to.
     * </p>
     * 
     * @return A unique identifier for the game session to add a player to.
     */
    public final String gameSessionId() {
        return gameSessionId;
    }

    /**
     * <p>
     * A unique identifier for a player. Player IDs are developer-defined.
     * </p>
     * 
     * @return A unique identifier for a player. Player IDs are developer-defined.
     */
    public final String playerId() {
        return playerId;
    }

    /**
     * <p>
     * Developer-defined information related to a player. GameLift does not use this data, so it can be formatted as
     * needed for use in the game.
     * </p>
     * 
     * @return Developer-defined information related to a player. GameLift does not use this data, so it can be
     *         formatted as needed for use in the game.
     */
    public final String playerData() {
        return playerData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gameSessionId());
        hashCode = 31 * hashCode + Objects.hashCode(playerId());
        hashCode = 31 * hashCode + Objects.hashCode(playerData());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePlayerSessionRequest)) {
            return false;
        }
        CreatePlayerSessionRequest other = (CreatePlayerSessionRequest) obj;
        return Objects.equals(gameSessionId(), other.gameSessionId()) && Objects.equals(playerId(), other.playerId())
                && Objects.equals(playerData(), other.playerData());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreatePlayerSessionRequest").add("GameSessionId", gameSessionId()).add("PlayerId", playerId())
                .add("PlayerData", playerData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GameSessionId":
            return Optional.ofNullable(clazz.cast(gameSessionId()));
        case "PlayerId":
            return Optional.ofNullable(clazz.cast(playerId()));
        case "PlayerData":
            return Optional.ofNullable(clazz.cast(playerData()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePlayerSessionRequest, T> g) {
        return obj -> g.apply((CreatePlayerSessionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreatePlayerSessionRequest> {
        /**
         * <p>
         * A unique identifier for the game session to add a player to.
         * </p>
         * 
         * @param gameSessionId
         *        A unique identifier for the game session to add a player to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameSessionId(String gameSessionId);

        /**
         * <p>
         * A unique identifier for a player. Player IDs are developer-defined.
         * </p>
         * 
         * @param playerId
         *        A unique identifier for a player. Player IDs are developer-defined.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder playerId(String playerId);

        /**
         * <p>
         * Developer-defined information related to a player. GameLift does not use this data, so it can be formatted as
         * needed for use in the game.
         * </p>
         * 
         * @param playerData
         *        Developer-defined information related to a player. GameLift does not use this data, so it can be
         *        formatted as needed for use in the game.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder playerData(String playerData);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GameLiftRequest.BuilderImpl implements Builder {
        private String gameSessionId;

        private String playerId;

        private String playerData;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePlayerSessionRequest model) {
            super(model);
            gameSessionId(model.gameSessionId);
            playerId(model.playerId);
            playerData(model.playerData);
        }

        public final String getGameSessionId() {
            return gameSessionId;
        }

        public final void setGameSessionId(String gameSessionId) {
            this.gameSessionId = gameSessionId;
        }

        @Override
        public final Builder gameSessionId(String gameSessionId) {
            this.gameSessionId = gameSessionId;
            return this;
        }

        public final String getPlayerId() {
            return playerId;
        }

        public final void setPlayerId(String playerId) {
            this.playerId = playerId;
        }

        @Override
        public final Builder playerId(String playerId) {
            this.playerId = playerId;
            return this;
        }

        public final String getPlayerData() {
            return playerData;
        }

        public final void setPlayerData(String playerData) {
            this.playerData = playerData;
        }

        @Override
        public final Builder playerData(String playerData) {
            this.playerData = playerData;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePlayerSessionRequest build() {
            return new CreatePlayerSessionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
