/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.gamelift.GameLiftClient;
import software.amazon.awssdk.services.gamelift.model.DescribeGameSessionsRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeGameSessionsResponse;
import software.amazon.awssdk.services.gamelift.model.GameSession;

public class DescribeGameSessionsIterable
implements SdkIterable<DescribeGameSessionsResponse> {
    private final GameLiftClient client;
    private final DescribeGameSessionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeGameSessionsIterable(GameLiftClient client, DescribeGameSessionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeGameSessionsResponseFetcher();
    }

    public Iterator<DescribeGameSessionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<GameSession> gameSessions() {
        Function<DescribeGameSessionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.gameSessions() != null) {
                return response.gameSessions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeGameSessionsResponseFetcher
    implements SyncPageFetcher<DescribeGameSessionsResponse> {
        private DescribeGameSessionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeGameSessionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeGameSessionsResponse nextPage(DescribeGameSessionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeGameSessionsIterable.this.client.describeGameSessions(DescribeGameSessionsIterable.this.firstRequest);
            }
            return DescribeGameSessionsIterable.this.client.describeGameSessions((DescribeGameSessionsRequest)((Object)DescribeGameSessionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

